/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan.optionCards;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionModule;
import com.tridium.platHwScan.ports.BPort;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="description", type="String", defaultValue="", flags=1), @NiagaraProperty(name="optionCodes", type="String", defaultValue="FF FF", flags=1), @NiagaraProperty(name="usesCom", type="boolean", defaultValue="false", flags=1), @NiagaraProperty(name="unknownCardType", type="boolean", defaultValue="true", flags=5), @NiagaraProperty(name="portCount", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="connectors", type="int", defaultValue="0", flags=5), @NiagaraProperty(name="sideViewImage", type="String", defaultValue="", flags=1), @NiagaraProperty(name="topViewImage", type="String", defaultValue="", flags=1)})
public class BOptionCard
extends BComponent {
    @Generated
    public static final Property description = BOptionCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property optionCodes = BOptionCard.newProperty((int)1, (String)"FF FF", null);
    @Generated
    public static final Property usesCom = BOptionCard.newProperty((int)1, (boolean)false, null);
    @Generated
    public static final Property unknownCardType = BOptionCard.newProperty((int)5, (boolean)true, null);
    @Generated
    public static final Property portCount = BOptionCard.newProperty((int)5, (int)0, null);
    @Generated
    public static final Property connectors = BOptionCard.newProperty((int)5, (int)0, null);
    @Generated
    public static final Property sideViewImage = BOptionCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Property topViewImage = BOptionCard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BOptionCard.class);
    private static ConcurrentHashMap<String, BOptionCard> cardCatalog = null;
    private static final String[] CARD_FILES = new String[]{"module://platHwScan/rc/platHwScanOptionCards.xml"};

    @Generated
    public String getDescription() {
        return this.getString(description);
    }

    @Generated
    public void setDescription(String v) {
        this.setString(description, v, null);
    }

    @Generated
    public String getOptionCodes() {
        return this.getString(optionCodes);
    }

    @Generated
    public void setOptionCodes(String v) {
        this.setString(optionCodes, v, null);
    }

    @Generated
    public boolean getUsesCom() {
        return this.getBoolean(usesCom);
    }

    @Generated
    public void setUsesCom(boolean v) {
        this.setBoolean(usesCom, v, null);
    }

    @Generated
    public boolean getUnknownCardType() {
        return this.getBoolean(unknownCardType);
    }

    @Generated
    public void setUnknownCardType(boolean v) {
        this.setBoolean(unknownCardType, v, null);
    }

    @Generated
    public int getPortCount() {
        return this.getInt(portCount);
    }

    @Generated
    public void setPortCount(int v) {
        this.setInt(portCount, v, null);
    }

    @Generated
    public int getConnectors() {
        return this.getInt(connectors);
    }

    @Generated
    public void setConnectors(int v) {
        this.setInt(connectors, v, null);
    }

    @Generated
    public String getSideViewImage() {
        return this.getString(sideViewImage);
    }

    @Generated
    public void setSideViewImage(String v) {
        this.setString(sideViewImage, v, null);
    }

    @Generated
    public String getTopViewImage() {
        return this.getString(topViewImage);
    }

    @Generated
    public void setTopViewImage(String v) {
        this.setString(topViewImage, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOptionCard() {
    }

    public BOptionCard(String description) {
        this.setDescription(description);
    }

    public BOptionCard(String description, String optionCodes) {
        this.setDescription(description);
        this.setOptionCodes(optionCodes);
    }

    public static String[] getCardFiles() {
        return CARD_FILES;
    }

    protected String getCardKey() {
        return this.getOptionCodes();
    }

    public static void addOptionCardReference(BOptionCard optionCard) {
        if (!optionCard.getOptionCodes().isEmpty()) {
            cardCatalog.put(optionCard.getOptionCodes(), optionCard);
        }
    }

    private static void buildCardCatalog() {
        cardCatalog = new ConcurrentHashMap();
        for (String cardFile : CARD_FILES) {
            try {
                ConcurrentHashMap<String, BOptionCard> optionCardsByCode = BOptionCard.parseCardFile(cardFile);
                if (optionCardsByCode == null) continue;
                Enumeration<String> keys = optionCardsByCode.keys();
                while (keys.hasMoreElements()) {
                    String key = keys.nextElement();
                    if (cardCatalog.get(key) != null) {
                        BHardwareScanService.LOG.warning(BHardwareScanService.LEX.getText("OptionCard.duplicateOptCode", new Object[]{key}));
                    }
                    cardCatalog.put(key, optionCardsByCode.get(key));
                }
            }
            catch (Exception exception) {
                if (!BHardwareScanService.LOG.isLoggable(Level.FINE)) continue;
                BHardwareScanService.LOG.log(Level.FINE, BHardwareScanService.LEX.getText("parsingError", new Object[]{exception.getClass().getName(), cardFile}), exception);
            }
        }
    }

    public static ConcurrentHashMap<String, BOptionCard> getCardCatalog() {
        if (cardCatalog == null) {
            BOptionCard.buildCardCatalog();
        }
        return cardCatalog;
    }

    public static BOptionCard lookup(String optionCardCode) {
        if (cardCatalog == null) {
            BOptionCard.buildCardCatalog();
        }
        return cardCatalog.get(optionCardCode);
    }

    protected static ConcurrentHashMap<String, BOptionCard> parseCardFile(String filePath) throws Exception {
        XElem[] elements;
        XElem root;
        if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
            BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("parsingNotification", new Object[]{filePath}));
        }
        try {
            BOrd fileOrd = BOrd.make((String)filePath);
            BIFile file = (BIFile)fileOrd.get();
            root = XParser.make((InputStream)file.getInputStream()).parse();
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedException) {
                if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
                    BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("fileDoesNotExist", new Object[]{filePath}));
                }
                return null;
            }
            if (exception instanceof EOFException) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("unexpectedEof", new Object[]{filePath}), exception);
                return null;
            }
            throw exception;
        }
        if (!root.name().equalsIgnoreCase("optionCards")) {
            BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("fileFormatError", new Object[]{filePath, root.name(), "optionCards"}));
            return null;
        }
        ConcurrentHashMap<String, BOptionCard> optionCardsByCode = new ConcurrentHashMap<String, BOptionCard>();
        for (XElem nextElement : elements = root.elems()) {
            String name = nextElement.name();
            if (!name.equalsIgnoreCase("optionCard") && !name.equalsIgnoreCase("optionModule")) continue;
            try {
                XElem[] cardProps;
                BOptionCard optionCard = name.equalsIgnoreCase("optionModule") ? new BOptionModule() : new BOptionCard();
                optionCard.setDescription(BHardwareScanService.LEX.getText(nextElement.get("description")));
                optionCard.setOptionCodes(nextElement.get("optionCodes"));
                optionCard.setUsesCom(nextElement.getb("usesCom", false));
                optionCard.setUnknownCardType(false);
                int ports = 0;
                int connectors = 0;
                for (XElem nextCardProp : cardProps = nextElement.elems()) {
                    String cardPropName = nextCardProp.name();
                    if (!cardPropName.equalsIgnoreCase("port")) continue;
                    BPort port = new BPort();
                    port.setPortType(BPortTypeEnum.make(nextCardProp.get("portType", BPortTypeEnum.noPort.getTag())));
                    port.setHasConnector(nextCardProp.get("hasConnector", "true").equalsIgnoreCase("true"));
                    if (port.getHasConnector()) {
                        ++connectors;
                    }
                    if (port.getPortType().equals((Object)BPortTypeEnum.future) || port.getPortType().equals((Object)BPortTypeEnum.noPort)) continue;
                    port.setRequiredFeatures(nextCardProp.get("requiredFeatures"));
                    port.setPrefix(nextCardProp.get("prefix"));
                    port.setStatus(BHwScanStatusEnum.make(nextCardProp.get("status", BHwScanStatusEnum.available.getTag())));
                    optionCard.setSideViewImage(nextElement.get("sideViewImage", ""));
                    optionCard.setTopViewImage(nextElement.get("topViewImage", ""));
                    port.checkLicense();
                    port.add("portIndex", (BValue)BInteger.make((String)nextCardProp.get("index")), 5);
                    optionCard.add("Port" + nextCardProp.get("index"), (BValue)port);
                    ++ports;
                }
                optionCard.setPortCount(ports);
                optionCard.setConnectors(connectors);
                optionCardsByCode.put(optionCard.getOptionCodes(), optionCard);
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("parsingError", new Object[]{exception.getClass().getName(), nextElement.toString()}), exception);
            }
        }
        return optionCardsByCode;
    }

    public BPort[] getPorts() {
        return (BPort[])this.getChildren(BPort.class);
    }

    public BPort getPort(int portNumber) {
        BPort[] ports;
        for (BPort port : ports = this.getPorts()) {
            BValue portIndex = port.get("portIndex");
            if (portIndex == null || ((BInteger)portIndex).getInt() != portNumber) continue;
            return port;
        }
        return null;
    }
}

