/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan;

import com.tridium.nre.platform.OperatingSystemEnum;
import com.tridium.nre.platform.PlatformUtil;
import com.tridium.platHwScan.BBaseBoard;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.pciCards.BPciCard;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.UsbInfoNpsdk;
import com.tridium.platHwScan.util.UsbInfoQnx;
import com.tridium.platform.BPlatformService;
import com.tridium.sys.Nre;
import com.tridium.sys.service.BServiceEvent;
import com.tridium.sys.service.ServiceListener;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.AccessController;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BString;
import javax.baja.sys.BStruct;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperty(name="baseBoardType", type="BBaseBoard", defaultValue="new BBaseBoard()", flags=3)
@NiagaraActions(value={@NiagaraAction(name="scan", flags=4), @NiagaraAction(name="simulateQnxCodes", parameterType="BString", defaultValue="BString.make(\"01 FF FF FF FF FF FF FF FF\")", flags=4), @NiagaraAction(name="simulateNpsdkCodes", parameterType="BString", defaultValue="BString.make(\"01 FF FF FF FF FF FF FF FF\")", flags=4)})
public class BHardwareScanService
extends BPlatformService {
    @Generated
    public static final Property baseBoardType = BHardwareScanService.newProperty((int)3, (BValue)new BBaseBoard(), null);
    @Generated
    public static final Action scan = BHardwareScanService.newAction((int)4, null);
    @Generated
    public static final Action simulateQnxCodes = BHardwareScanService.newAction((int)4, (BValue)BString.make((String)"01 FF FF FF FF FF FF FF FF"), null);
    @Generated
    public static final Action simulateNpsdkCodes = BHardwareScanService.newAction((int)4, (BValue)BString.make((String)"01 FF FF FF FF FF FF FF FF"), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHardwareScanService.class);
    private final Subscriber lonListener = new Subscriber(){

        public void event(BComponentEvent event) {
            BComponent network;
            BStruct lonCommConfig;
            String deviceName;
            BPort port;
            String slotName = event.getSlotName();
            if (slotName.equals("lonCommConfig")) {
                BComponent network2 = event.getSourceComponent();
                if (((BBoolean)network2.get("enabled")).getBoolean() && !((BStatus)network2.get("status")).isFault()) {
                    BPort[] allPorts;
                    String networkName = network2.getName();
                    BStruct lonCommConfig2 = (BStruct)network2.get("lonCommConfig");
                    String deviceName2 = lonCommConfig2.get("deviceName").toString();
                    for (BPort nextPort : allPorts = BHardwareScanService.this.getAllPorts()) {
                        if (nextPort == null) continue;
                        if (nextPort.getName().equals(deviceName2)) {
                            nextPort.updateOwnerAndStatus(networkName);
                            continue;
                        }
                        if (!nextPort.getOwner().equals(networkName)) continue;
                        nextPort.updateOwnerAndStatus("none");
                    }
                }
            } else if (slotName.equals("enabled") && (port = BHardwareScanService.this.getPort(deviceName = (lonCommConfig = (BStruct)(network = event.getSourceComponent()).get("lonCommConfig")).get("deviceName").toString())) != null) {
                if (((BBoolean)event.getValue()).getBoolean() && !((BStatus)network.get("status")).isFault()) {
                    port.updateOwnerAndStatus(network.getName());
                } else {
                    port.updateOwnerAndStatus("none");
                }
            }
        }
    };
    private final Subscriber lonNameChangeListener = new Subscriber(){

        public void event(BComponentEvent event) {
            BComponent network;
            if (event.getId() == 3 && event.getSlot().asProperty().getType().getTypeSpec().equals((Object)LON_TYPE_SPEC) && ((BBoolean)(network = (BComponent)event.getSourceComponent().get(event.getSlotName())).get("enabled")).getBoolean() && !((BStatus)network.get("status")).isFault()) {
                network.lease(2);
                BStruct lonCommConfig = (BStruct)network.get("lonCommConfig");
                BPort port = BHardwareScanService.this.getPort(((BString)lonCommConfig.get("deviceName")).getString());
                if (port != null) {
                    port.updateOwnerAndStatus(network.getName());
                }
            }
        }
    };
    private final Subscriber serialPortServiceListener = new Subscriber(){

        public void event(BComponentEvent event) {
            BPort port;
            if (event.getId() == 1 && event.getSlotName().startsWith("COM")) {
                this.subscribe((BComponent)event.getSourceComponent().get(event.getSlotName()));
            } else if (event.getId() == 0 && event.getSlotName().equals("owner") && (port = BHardwareScanService.this.getPort(event.getSourceComponent().getName())) != null) {
                port.updateOwnerAndStatus(((BString)event.getValue()).getString());
            }
        }
    };
    private final ServiceListener serviceListener = new ServiceListener(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void serviceEvent(BServiceEvent event) {
            if (event.getServiceType().getTypeSpec().equals((Object)LON_TYPE_SPEC)) {
                ServiceListener serviceListener = BHardwareScanService.this.serviceListener;
                synchronized (serviceListener) {
                    BComponent lonNetwork = (BComponent)event.getService();
                    if (event.getId() == 0) {
                        BHardwareScanService.this.lonListener.subscribe(lonNetwork);
                        BHardwareScanService.this.lonNameChangeListener.subscribe((BComponent)lonNetwork.getParent());
                    } else if (event.getId() == 1) {
                        BStruct lonCommConfig = (BStruct)lonNetwork.get("lonCommConfig");
                        String deviceName = lonCommConfig.get("deviceName").toString();
                        BPort port = BHardwareScanService.this.getPort(deviceName);
                        if (port != null) {
                            port.updateOwnerAndStatus("none");
                        }
                        BHardwareScanService.this.lonListener.unsubscribe(lonNetwork);
                    }
                }
            }
        }
    };
    private static final BIcon ICON = BIcon.std((String)"magnifyingGlass.png");
    public static final Lexicon LEX = Lexicon.make(BHardwareScanService.class);
    public static final Logger LOG = Logger.getLogger("plat.scan");
    public static final BTypeSpec LON_TYPE_SPEC = BTypeSpec.make((String)"lonworks:LonNetwork");
    public static final BTypeSpec SERIAL_PORT_SVC_TYPE_SPEC = BTypeSpec.make((String)"platSerial:SerialPortPlatformService");
    public static final BTypeSpec TCP_PLATFORM_SVC_TYPE_SPEC = BTypeSpec.make((String)"platform:TcpIpPlatformService");
    private String simulationString;
    private OperatingSystemEnum operatingSystem;
    private static final String LEGACY_OPTION_CARD_CODES_PATH = "/tmp/optcardcodes";

    @Generated
    public BBaseBoard getBaseBoardType() {
        return (BBaseBoard)this.get(baseBoardType);
    }

    @Generated
    public void setBaseBoardType(BBaseBoard v) {
        this.set(baseBoardType, (BValue)v, null);
    }

    @Generated
    public void scan() {
        this.invoke(scan, null, null);
    }

    @Generated
    public void simulateQnxCodes(BString parameter) {
        this.invoke(simulateQnxCodes, (BValue)parameter, null);
    }

    @Generated
    public void simulateNpsdkCodes(BString parameter) {
        this.invoke(simulateNpsdkCodes, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BHardwareScanService() {
        this.setPlatformServiceDescription(LEX.getText("HardwareScanService.description"));
    }

    public void serviceStarted() throws Exception {
        super.serviceStarted();
        this.doScan();
        AccessController.doPrivileged(Nre::getServiceManager).addServiceListener(this.serviceListener);
        try {
            BPlatformService serialService = (BPlatformService)Sys.getService((Type)SERIAL_PORT_SVC_TYPE_SPEC.getResolvedType());
            serialService.checkPropertiesLoaded();
            serialService.lease(Integer.MAX_VALUE);
            this.serialPortServiceListener.subscribe((BComponent)serialService, 2);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, LEX.getText("HardwareScanService.serialPortPlatformServiceNotFound"), exception);
        }
        try {
            BComponent[] lonNetworks;
            for (BComponent lonNetwork : lonNetworks = Sys.getServices((Type)LON_TYPE_SPEC.getResolvedType())) {
                this.lonListener.subscribe(lonNetwork);
                this.lonNameChangeListener.subscribe((BComponent)lonNetwork.getParent());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Type[] getServiceTypes() {
        return new Type[]{TYPE};
    }

    public void doPoll(Context cx) {
        super.doPoll(cx);
        this.init();
    }

    public int getSlotFlags() {
        return 0;
    }

    public boolean isValidPlatform() {
        boolean isValid = false;
        if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            isValid = true;
        } else if ("ATLAS".equalsIgnoreCase(Nre.getHostModel())) {
            isValid = true;
        }
        return isValid;
    }

    public void scanHardware(boolean simulation) {
        this.removeAll();
        if (PlatformUtil.isTridiumPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.qnx)) {
            this.scanPlatform(simulation);
        } else if (PlatformUtil.isNpsdkPlatform() && OperatingSystemEnum.isOS((OperatingSystemEnum)OperatingSystemEnum.linux)) {
            this.scanPlatform(simulation);
        } else {
            String operatingSystemString = AccessController.doPrivileged(() -> System.getProperty("os.name"));
            LOG.warning(LEX.getText("HardwareScanService.operatingSystemNotSupported", new Object[]{TextUtil.capitalize((String)operatingSystemString), this.getTypeDisplayName(null)}));
        }
    }

    public void doScan() {
        this.init();
        this.scanHardware(false);
    }

    public void doSimulateQnxCodes(BString codes) {
        if (!PlatformUtil.isTridiumPlatform()) {
            return;
        }
        this.doSimulation(codes, OperatingSystemEnum.qnx);
    }

    public void doSimulateNpsdkCodes(BString codes) {
        if (!PlatformUtil.isNpsdkPlatform()) {
            return;
        }
        this.doSimulation(codes, OperatingSystemEnum.linux);
    }

    private void doSimulation(BString simString, OperatingSystemEnum os) {
        this.simulationString = simString.getString();
        this.operatingSystem = os;
        this.scanHardware(true);
    }

    protected BPort filterPortsByName(BPort[] ports, String mask) {
        for (BPort port : ports) {
            if (!port.getName().equalsIgnoreCase(mask) || port.getStatus().equals((Object)BHwScanStatusEnum.unavailable)) continue;
            return port;
        }
        return null;
    }

    public BPort[] getAllPorts() {
        this.lease(5);
        Array ports = new Array(BPort.class);
        BBaseBoard board = this.getBaseBoardType();
        ports.addAll(board.getChildren(BPort.class));
        for (BOptionSlot slot : (BOptionSlot[])board.getChildren(BOptionSlot.class)) {
            if (!(slot.getContents() instanceof BOptionCard)) continue;
            ports.addAll((Object[])((BOptionCard)slot.getContents()).getPorts());
        }
        return (BPort[])ports.trim();
    }

    public BPort getPort(String name) {
        BPort[] ports = this.getAllPorts();
        return this.filterPortsByName(ports, name);
    }

    private String readOptionCardCodes(boolean simulation) {
        if (simulation) {
            return this.simulationString;
        }
        return AccessController.doPrivileged(() -> {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("Reading option card codes file '/tmp/optcardcodes'...");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(Files.newInputStream(Paths.get(LEGACY_OPTION_CARD_CODES_PATH, new String[0]), new OpenOption[0]), StandardCharsets.UTF_8));){
                String string = reader.readLine();
                return string;
            }
            catch (Exception ioException) {
                try {
                    if (PlatformUtil.isTridiumPlatform()) {
                        LOG.fine("Enumerating option card codes from UsbInfoQnx...");
                        UsbInfoQnx info = new UsbInfoQnx();
                        return info.toOptionCardCodes();
                    }
                    if (!PlatformUtil.isNpsdkPlatform()) return null;
                    LOG.fine("Enumerating option card codes from UsbInfoNpsdk...");
                    UsbInfoNpsdk info = new UsbInfoNpsdk();
                    return info.toOptionCardCodes();
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, "Exception occurred parsing option card codes", exception);
                    LOG.log(Level.SEVERE, "IOException occurred reading '/tmp/optcardcodes'", ioException);
                }
                return null;
            }
        });
    }

    private void scanPlatform(boolean simulation) {
        try {
            StringTokenizer optionCardCodes = new StringTokenizer(this.readOptionCardCodes(simulation));
            String platformCode = optionCardCodes.nextToken();
            BBaseBoard boardTemplate = BBaseBoard.lookup(platformCode);
            if (boardTemplate == null) {
                this.addBasicPlatform(platformCode);
                return;
            }
            try {
                BBaseBoard baseBoard = (BBaseBoard)boardTemplate.newCopy(true);
                this.setBaseBoardType(baseBoard);
                Array codeArray = new Array(String.class);
                while (optionCardCodes.hasMoreTokens()) {
                    codeArray.add((Object)optionCardCodes.nextToken().trim());
                }
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine(LEX.getText("HardwareScanService.optCodeArray", new Object[]{codeArray}));
                }
                baseBoard.autoConfig((Array<String>)codeArray, simulation);
            }
            catch (Exception exception) {
                LOG.log(Level.FINE, "Exception occurred when scanning platform", exception);
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to scan platform", exception);
        }
    }

    private void addBasicPlatform(String platformCode) {
        Object modelJar;
        if (!this.getBaseBoardType().getType().equals(BBaseBoard.TYPE)) {
            this.setBaseBoardType(new BBaseBoard());
        }
        if ((modelJar = BBaseBoard.lookupModelJar(platformCode)) != null) {
            this.getBaseBoardType().setProductModel(LEX.getText("HardwareScanService.jarRequired", new Object[]{modelJar}));
        } else {
            this.getBaseBoardType().setProductModel(LEX.getText("HardwareScanService.baseboardNotRecognized", new Object[]{platformCode, this.getName()}));
        }
        LOG.warning(this.getBaseBoardType().getProductModel());
    }

    private void init() {
        BOptionCard.getCardCatalog();
        BPciCard.getCardCatalog();
        this.operatingSystem = OperatingSystemEnum.getOS();
    }

    public BIcon getIcon() {
        return ICON;
    }
}

