/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platHwScan;

import com.tridium.platHwScan.BHardwareScanService;
import com.tridium.platHwScan.enums.BHwScanStatusEnum;
import com.tridium.platHwScan.enums.BPortTypeEnum;
import com.tridium.platHwScan.optionCards.BOptionCard;
import com.tridium.platHwScan.optionCards.BOptionSlot;
import com.tridium.platHwScan.ports.BPort;
import com.tridium.platHwScan.util.BHardwareRef;
import com.tridium.platform.BPlatformService;
import com.tridium.platform.BPlatformServiceContainer;
import com.tridium.sys.Nre;
import java.io.EOFException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.naming.UnresolvedException;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

@NiagaraType
@NiagaraProperty(name="productModel", type="String", defaultValue="", flags=1)
public class BBaseBoard
extends BComponent {
    @Generated
    public static final Property productModel = BBaseBoard.newProperty((int)1, (String)"", null);
    @Generated
    public static final Type TYPE = Sys.loadType(BBaseBoard.class);
    private static ConcurrentHashMap<String, BBaseBoard> boardTypes = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> PLAT_JARS = new ConcurrentHashMap();
    private static final String[] JAR_FILES = new String[]{"module://platHwScan/rc/platHwScanPlatformJars.xml"};
    protected static final int FLAGS = 3;
    protected Array<String> configParams = null;
    protected boolean simulation = false;
    protected int nextLanPort;
    protected int nextLonPort;
    protected int nextSerialPort;

    @Generated
    public String getProductModel() {
        return this.getString(productModel);
    }

    @Generated
    public void setProductModel(String v) {
        this.setString(productModel, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void autoConfig(Array<String> configParams, boolean simulation) {
        this.simulation = simulation;
        this.configParams = configParams;
        this.setProductModel(BHardwareScanService.LEX.getText(Nre.getHostModel().toUpperCase(Locale.ENGLISH)));
    }

    public String getBoardCode() {
        return null;
    }

    public Vector<BHardwareRef> getHardwareRefs() {
        return new Vector<BHardwareRef>();
    }

    public String getView(BObject v) {
        return BHardwareScanService.LEX.getText("pxView");
    }

    public String getImagesDirectory() {
        return null;
    }

    public static BBaseBoard lookup(String boardCode) {
        if (boardTypes.isEmpty()) {
            BBaseBoard.queryRegistry();
        }
        return boardTypes.get(boardCode.toUpperCase(Locale.ENGLISH));
    }

    private static void queryRegistry() {
        TypeInfo[] types;
        boardTypes = new ConcurrentHashMap();
        for (TypeInfo type : types = Sys.getRegistry().getConcreteTypes(TYPE.getTypeInfo())) {
            BBaseBoard instance = (BBaseBoard)type.getInstance();
            try {
                String boardCode = instance.getBoardCode();
                if (boardCode == null) continue;
                boardTypes.put(boardCode.toUpperCase(Locale.ENGLISH), instance);
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("BaseBoard.registrationError", new Object[]{instance}), exception);
            }
        }
    }

    public static Object lookupModelJar(String code) {
        if (PLAT_JARS.isEmpty()) {
            for (String jarFile : JAR_FILES) {
                try {
                    ConcurrentHashMap<String, String> optionModuleByCode = BBaseBoard.parsePlatformJarsFile(jarFile);
                    if (optionModuleByCode == null) continue;
                    Enumeration<String> keys = optionModuleByCode.keys();
                    while (keys.hasMoreElements()) {
                        String key = keys.nextElement().toUpperCase(Locale.ENGLISH);
                        if (PLAT_JARS.get(key) != null) {
                            BHardwareScanService.LOG.warning(BHardwareScanService.LEX.getText("BaseBoard.duplicatePlatformCode", new Object[]{key, jarFile}));
                        }
                        PLAT_JARS.put(key, optionModuleByCode.get(key));
                    }
                }
                catch (Exception exception) {
                    BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("parsingError", new Object[]{exception.getClass().getName(), jarFile}), exception);
                }
            }
        }
        return PLAT_JARS.get(code.toUpperCase(Locale.ENGLISH));
    }

    private static ConcurrentHashMap<String, String> parsePlatformJarsFile(String filePath) throws Exception {
        XElem[] elements;
        XElem root;
        if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
            BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("parsingNotification", new Object[]{filePath}));
        }
        try {
            BOrd fileOrd = BOrd.make((String)filePath);
            BIFile file = (BIFile)fileOrd.get();
            root = XParser.make((InputStream)file.getInputStream()).parse();
        }
        catch (Exception exception) {
            if (exception instanceof UnresolvedException) {
                if (BHardwareScanService.LOG.isLoggable(Level.FINE)) {
                    BHardwareScanService.LOG.fine(BHardwareScanService.LEX.getText("fileDoesNotExist", new Object[]{filePath}));
                }
                return null;
            }
            if (exception instanceof EOFException) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("unexpectedEof", new Object[]{filePath}), exception);
                return null;
            }
            throw exception;
        }
        if (!root.name().equalsIgnoreCase("hwScanPlatformJars")) {
            BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("fileFormatError", new Object[]{filePath, root.name(), "hwScanPlatformJars"}));
            return null;
        }
        ConcurrentHashMap<String, String> optionModuleByCode = new ConcurrentHashMap<String, String>();
        for (XElem nextElement : elements = root.elems()) {
            String name = nextElement.name();
            if (!name.equalsIgnoreCase("platform")) continue;
            try {
                optionModuleByCode.put(nextElement.get("code").toUpperCase(Locale.ENGLISH), nextElement.get("module"));
            }
            catch (Exception exception) {
                BHardwareScanService.LOG.log(Level.SEVERE, BHardwareScanService.LEX.getText("parsingError", new Object[]{nextElement.toString()}), exception);
            }
        }
        return optionModuleByCode;
    }

    protected String buildPortRefDescription(BPort port) {
        StringBuilder sb = new StringBuilder(port.getName());
        if (!port.getHasConnector()) {
            sb.append(" ").append(BHardwareScanService.LEX.getText("HardwareRef.noConnector"));
        }
        return sb.toString();
    }

    protected String getBaseUnitText() {
        return BHardwareScanService.LEX.getText("HardwareRef.baseUnit");
    }

    public boolean isSerialShellJumperPresent() {
        try {
            BComplex parent = this.getParent();
            while (!(parent instanceof BPlatformServiceContainer)) {
                parent = parent.getParent();
            }
            BPlatformServiceContainer container = (BPlatformServiceContainer)parent;
            container.lease();
            BPlatformService[] platformServices = (BPlatformService[])container.getChildren(BHardwareScanService.SERIAL_PORT_SVC_TYPE_SPEC.getResolvedType().getTypeClass());
            platformServices[0].checkPropertiesLoaded();
            platformServices[0].lease(Integer.MAX_VALUE);
            BComponent com1 = (BComponent)platformServices[0].get("COM1");
            return "dbgjmpr".equalsIgnoreCase(((BString)com1.get("owner")).getString().trim());
        }
        catch (Exception exception) {
            BHardwareScanService.LOG.log(Level.WARNING, BHardwareScanService.LEX.getText("BaseBoard.serialShellError"), exception);
            return false;
        }
    }

    public boolean isSimulation() {
        return this.simulation;
    }

    public void setSimulation(boolean simulation) {
        this.simulation = simulation;
    }

    protected BHardwareRef makeBaseboardCommRef(int refNo, BPort port) {
        return new BHardwareRef(refNo, this.getBaseUnitText(), this.buildPortRefDescription(port), port.getPortType(), port.getStatus());
    }

    protected BHardwareRef makeJumperRef(int refNo) {
        return new BHardwareRef(refNo, this.getBaseUnitText(), BHardwareScanService.LEX.getText("HardwareRef.serialShellJumper"), BPortTypeEnum.noPort, this.isSerialShellJumperPresent() ? BHwScanStatusEnum.serialShell : BHwScanStatusEnum.normalOperation);
    }

    protected String makePortName(int index, String portPrefix) {
        int portIndex = index;
        if (portPrefix.startsWith("COM")) {
            portIndex = this.nextSerialPort++;
        } else if (portPrefix.startsWith("LON")) {
            portIndex = this.nextLonPort++;
        } else if (portPrefix.startsWith("LAN")) {
            portIndex = this.nextLanPort++;
        }
        return portPrefix + portIndex;
    }

    protected BHardwareRef makePortRef(int refNo, int portNo, BPort port) {
        return this.makePortRef(String.valueOf(refNo), portNo, port);
    }

    protected BHardwareRef makePortRef(String ref, int portNo, BPort port) {
        String location = this.getBaseUnitText();
        for (BComplex parent = port.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof BOptionSlot)) continue;
            location = parent.getDisplayName(null);
            break;
        }
        return new BHardwareRef(ref + "-" + portNo, location, this.buildPortRefDescription(port), port.getPortType(), port.getStatus());
    }

    protected BHardwareRef makeSlotRef(int refNo, BOptionSlot slot) {
        BHardwareRef ref = new BHardwareRef();
        ref.setReference(String.valueOf(refNo));
        ref.setLocation(slot.getDisplayName(null));
        if (slot.isEmpty()) {
            ref.setDescription(BHardwareScanService.LEX.getText(BHwScanStatusEnum.empty.getTag()));
        } else {
            ref.setDescription(((BOptionCard)slot.getContents()).getDescription());
        }
        return ref;
    }
}

