/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.migrator;

import com.tridium.bql.FunctionQuery;
import com.tridium.migrator.MigConst;
import com.tridium.migrator.MigReportUtil;
import com.tridium.migrator.MigrationUtils;
import com.tridium.util.CompUtil;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.bql.BqlQuery;
import javax.baja.migration.BIBogElementConverter;
import javax.baja.migration.ConverterRegistry;
import javax.baja.migration.IOrdConverter;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Type;
import javax.baja.util.Version;

public class MigratorOrdConverter
implements IOrdConverter,
MigConst {
    BComponent base;
    HashMap<Object, BComponent> map = new HashMap();

    public MigratorOrdConverter(BComponent base) {
        BComponent[] ca;
        this.base = base;
        this.map.put(base.getHandle(), base);
        for (BComponent c : ca = (BComponent[])CompUtil.getDescendants((BComponent)base, BComponent.class)) {
            this.map.put(c.getHandle(), c);
        }
    }

    public BComponent getBase() {
        return this.base;
    }

    public BOrd convertOrd(BOrd ord, BComplex relBase, Property prop, Version sourceVersion, Logger log) {
        List<BIBogElementConverter> cnvList = this.getConverterList(relBase.getType());
        if (!cnvList.isEmpty()) {
            for (BIBogElementConverter cnv : cnvList) {
                if (cnv.resolvableOrd(relBase, prop)) continue;
                return ord;
            }
        }
        String[] ordSa = ord.toString(null).split("\\|");
        boolean changed = false;
        for (int i = 0; i < ordSa.length; ++i) {
            String ordS = ordSa[i];
            if (ordS.startsWith("ip:") || ordS.startsWith("http:") || ordS.startsWith("https:")) {
                if (log != null && !ordS.contains("localhost") && log.isLoggable(Level.FINE)) {
                    log.fine("Ord to remote host - " + ordS);
                }
                return ord;
            }
            String newOrdS = this.convertOrdString(ordS, relBase, prop, sourceVersion, log);
            if (newOrdS == null) {
                return BOrd.NULL;
            }
            if (newOrdS.equals(ordS)) continue;
            changed = true;
            ordSa[i] = newOrdS;
        }
        if (!changed) {
            return ord;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ordSa.length; ++i) {
            if (i > 0) {
                sb.append("|");
            }
            sb.append(ordSa[i]);
        }
        String newOrdS = sb.toString();
        return BOrd.make((String)newOrdS);
    }

    private BComponent getByHandle(Object handle) {
        return this.map.get(handle);
    }

    private String convertOrdString(String ordS, BComplex relBase, Property prop, Version sourceVersion, Logger log) {
        String[] slotA;
        BComponent c = null;
        if (ordS.startsWith("h:")) {
            int ndx = ordS.indexOf("/");
            if (ndx < 2) {
                return ordS;
            }
            slotA = ordS.substring(ndx + 1).split("/");
            c = this.getByHandle(ordS.substring(2, ndx));
            if (c == null || slotA.length == 0) {
                return ordS;
            }
        } else if (ordS.startsWith("slot:/")) {
            slotA = ordS.substring(ordS.indexOf("slot:/") + 6).split("/");
            c = this.base;
        } else if (ordS.startsWith("slot:")) {
            if (ordS.length() == 5) {
                return ordS;
            }
            slotA = ordS.substring(5).split("/");
            List<BIBogElementConverter> cnvList = this.getConverterList(relBase.getType());
            if (!cnvList.isEmpty()) {
                ListIterator<BIBogElementConverter> it = cnvList.listIterator(cnvList.size());
                while (it.hasPrevious() && c == null) {
                    BIBogElementConverter cnv = it.previous();
                    BOrd absOrd = cnv.getOrdBase(relBase, prop);
                    if (absOrd.isNull()) continue;
                    c = this.findObj(absOrd);
                }
            }
            if (c == null) {
                c = relBase;
            }
        } else {
            if (ordS.startsWith("bql:")) {
                BIBogElementConverter cnv;
                String newTypeSpec;
                String tspec;
                List cnvList;
                BqlQuery bql = BqlQuery.make((String)ordS.substring(4));
                if (bql instanceof FunctionQuery && !(cnvList = ConverterRegistry.lookupConverters((String)(tspec = ((FunctionQuery)bql).spec.getTypeSpecString()))).isEmpty() && !tspec.equals(newTypeSpec = (cnv = (BIBogElementConverter)cnvList.get(cnvList.size() - 1)).newTypeSpec(tspec))) {
                    ordS = ordS.replace(tspec, newTypeSpec);
                }
                return ordS;
            }
            if (ordS.startsWith("file:")) {
                int major = sourceVersion.major();
                int build = sourceVersion.build();
                String newOrdS = ordS;
                if (major == 3) {
                    if (MigrationUtils.isProtected(ordS.substring(6), sourceVersion) && !(newOrdS = ordS.replaceFirst("file:\\^", "file:^^")).equals(ordS)) {
                        log.info("Convert ord in " + MigReportUtil.getReportName(relBase, prop) + " sourceVersion: " + sourceVersion + " to " + newOrdS);
                    }
                } else if (major == 4 && build < 10 && !(newOrdS = ordS.replaceFirst("file:\\$", "file:^^")).equals(ordS)) {
                    log.info("Convert ord in " + MigReportUtil.getReportName(relBase, prop) + " sourceVersion: " + sourceVersion + " to " + newOrdS);
                }
                return newOrdS;
            }
            return ordS;
        }
        for (String sltName : slotA) {
            BValue v;
            if (sltName.equals("..")) {
                if (c.getParent() != null) {
                    c = c.getParent();
                    continue;
                }
                log.warning(ordS + " was not processed. Left as is");
                return ordS;
            }
            Slot s = c.getSlot(sltName);
            if (s == null) {
                BOrd newOrd = null;
                List<BIBogElementConverter> cnvList = this.getConverterList(c.getType());
                if (!cnvList.isEmpty()) {
                    newOrd = BOrd.make((String)ordS);
                    for (BIBogElementConverter cnv : cnvList) {
                        newOrd = cnv.fixOrd(newOrd);
                    }
                }
                if (newOrd != null) {
                    return newOrd.toString(null);
                }
                return null;
            }
            if (!s.isProperty() || !(v = c.get(sltName)).isComplex()) break;
            c = v.asComplex();
        }
        return ordS;
    }

    private BComplex findObj(BOrd absOrd) {
        String ordS = absOrd.toString(null);
        if (!ordS.contains("slot:/")) {
            return null;
        }
        String[] slotA = ordS.substring(ordS.indexOf("slot:/") + 6).split("/");
        BComponent c = this.base;
        for (String sltName : slotA) {
            BValue v;
            Slot s = c.getSlot(sltName);
            if (s == null) {
                List<BIBogElementConverter> cnvList = this.getConverterList(c.getType());
                BOrd newOrd = null;
                if (!cnvList.isEmpty()) {
                    newOrd = absOrd;
                    for (BIBogElementConverter cnv : cnvList) {
                        newOrd = cnv.fixOrd(newOrd);
                    }
                }
                if (newOrd != null) {
                    return this.findObj(newOrd);
                }
                return null;
            }
            if (!s.isProperty() || !(v = c.get(sltName)).isComplex()) break;
            c = v.asComplex();
        }
        return c;
    }

    private List<BIBogElementConverter> getConverterList(Type t) {
        List cnvList = ConverterRegistry.lookupConverters((String)(t.getModule().getModuleName() + ":" + t.getTypeName()));
        if (cnvList.isEmpty()) {
            cnvList = ConverterRegistry.lookupConverters((String)t.getModule().getModuleName());
        }
        return cnvList;
    }
}

