/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.server.point;

import com.tridium.modbusCore.datatypes.BFlexAddress;
import com.tridium.modbusCore.enums.BDataByteOrderEnum;
import com.tridium.modbusCore.enums.BDataTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypeEnum;
import com.tridium.modbusCore.enums.BRegisterTypesEnum;
import com.tridium.modbusCore.messages.ModbusResponse;
import com.tridium.modbusCore.point.BIModbusNumericProxyExt;
import com.tridium.modbusCore.server.BModbusServerDevice;
import com.tridium.modbusCore.server.point.BModbusServerProxyExt;
import com.tridium.modbusCore.util.ByteConverterUtil;
import com.tridium.modbusCore.util.DataTypeUtil;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="regType", type="BRegisterTypeEnum", defaultValue="BRegisterTypeEnum.holding"), @NiagaraProperty(name="dataType", type="BDataTypeEnum", defaultValue="BDataTypeEnum.integerType")})
public class BModbusServerNumericProxyExt
extends BModbusServerProxyExt
implements BIModbusNumericProxyExt {
    @Generated
    public static final Property regType = BModbusServerNumericProxyExt.newProperty((int)0, (BValue)BRegisterTypeEnum.holding, null);
    @Generated
    public static final Property dataType = BModbusServerNumericProxyExt.newProperty((int)0, (BValue)BDataTypeEnum.integerType, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BModbusServerNumericProxyExt.class);

    @Override
    @Generated
    public BRegisterTypeEnum getRegType() {
        return (BRegisterTypeEnum)this.get(regType);
    }

    @Override
    @Generated
    public void setRegType(BRegisterTypeEnum v) {
        this.set(regType, (BValue)v, null);
    }

    @Override
    @Generated
    public BDataTypeEnum getDataType() {
        return (BDataTypeEnum)this.get(dataType);
    }

    @Override
    @Generated
    public void setDataType(BDataTypeEnum v) {
        this.set(dataType, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    public void read() {
        if (this.configFault) {
            return;
        }
        BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
        int numRegisters = DataTypeUtil.getRegisterCount(this.getDataType());
        ModbusResponse rsp = new ModbusResponse(this.modbusNet().getModbusMode(), device);
        int pointAddress = this.getDataAddress().getDataAddress();
        try {
            rsp.data = this.isHoldingRegisterType() ? device.getHoldingRegisterValues(pointAddress, numRegisters) : device.getInputRegisterValues(pointAddress, numRegisters);
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerNumericProxyExt.read() caught exception: ", (Throwable)e);
            }
            this.readFail("Exception during read (" + e + ")");
            return;
        }
        rsp.exceptionCode = 0;
        rsp.byteCount = (byte)rsp.data.length;
        rsp.numberPoints = numRegisters;
        this.setOutValues(rsp);
    }

    private void setOutValues(ModbusResponse rec) {
        if (!rec.isError()) {
            if (this.isDataTypeInteger()) {
                this.setIntegerOutValues(rec, 2);
            } else if (this.isDataTypeLong()) {
                this.setIntegerOutValues(rec, 4);
            } else if (this.isDataType48BitUnsignedLong()) {
                this.set48BitUnsignedLongOutValues(rec);
            } else if (this.isDataType64BitLong()) {
                this.set64BitLongOutValues(rec);
            } else if (this.isDataTypeDouble()) {
                this.setDoubleOutValues(rec);
            } else if (this.isDataTypeFloat()) {
                this.setFloatOutValues(rec, 4);
            }
        } else {
            this.readFail(rec.getExceptionString());
        }
    }

    private void setIntegerOutValues(ModbusResponse rec, int dataSize) {
        long regValue;
        try {
            regValue = rec.getRegister(0, dataSize, ((BModbusServerDevice)this.getDevice()).getLongDataByteOrder(), this.isDataTypeSigned());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing integer value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric((double)regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    private void set48BitUnsignedLongOutValues(ModbusResponse rec) {
        long regValue;
        try {
            regValue = rec.get48BitUnsignedLong(0);
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing 48-bit unsigned long value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric((double)regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    private void set64BitLongOutValues(ModbusResponse rec) {
        long regValue;
        try {
            regValue = rec.get64BitLong(0, ((BModbusServerDevice)this.getDevice()).getLong64BitDataByteOrder(), this.isDataTypeSigned());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing 64-bit long value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric((double)regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    private void setFloatOutValues(ModbusResponse rec, int dataSize) {
        float regValue;
        try {
            regValue = rec.getFloat(0, dataSize, ((BModbusServerDevice)this.getDevice()).getFloatDataByteOrder());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing float value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric((double)regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    private void setDoubleOutValues(ModbusResponse rec) {
        double regValue;
        try {
            regValue = rec.getDouble(0, ((BModbusServerDevice)this.getDevice()).getDouble64BitDataByteOrder());
        }
        catch (IllegalArgumentException e) {
            this.readFail("error parsing float value (" + e + ")");
            return;
        }
        BStatusNumeric val = new BStatusNumeric(regValue);
        if (this.getStatus().isValid() && this.lastReadValue != null && this.lastReadValue.equivalent((Object)val)) {
            this.getTuning().readOk();
        } else {
            this.readOk((BStatusValue)val);
        }
    }

    @Override
    public BRegisterTypesEnum determineRegisterType() {
        if (this.getRegType().equals((Object)BRegisterTypeEnum.holding)) {
            return BRegisterTypesEnum.holdingRegister;
        }
        return BRegisterTypesEnum.inputRegister;
    }

    @Override
    public void changed(Property prop, Context context) {
        super.changed(prop, context);
        if (!this.isRunning()) {
            return;
        }
        if (prop.equals(dataType)) {
            this.setStale(true, null);
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        } else if (prop.equals(regType) && context != noAddressCheck) {
            this.setStale(true, null);
            if (this.getDataAddress().isModbusFormat()) {
                if (this.getDataAddress().isModbusHoldingAddress()) {
                    if (!this.isHoldingRegisterType()) {
                        this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
                    }
                } else if (this.isHoldingRegisterType()) {
                    this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                }
            }
            this.checkConfiguration();
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
        }
    }

    @Override
    protected boolean isValidAddress(BFlexAddress addr) {
        if (!addr.isModbusFormat()) {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = DataTypeUtil.getRegisterCount(this.getDataType());
            if (this.isHoldingRegisterType()) {
                return device.isHoldingRegisterAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isInputRegisterAddressValid(addr.getDataAddress(), numRegs);
        }
        if (addr.isModbusAnalogAddress()) {
            BRegisterTypeEnum rType = BRegisterTypeEnum.holding;
            if (addr.isModbusHoldingAddress()) {
                this.set(regType, (BValue)BRegisterTypeEnum.holding, noAddressCheck);
            } else {
                this.set(regType, (BValue)BRegisterTypeEnum.input, noAddressCheck);
                rType = BRegisterTypeEnum.input;
            }
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int numRegs = DataTypeUtil.getRegisterCount(this.getDataType());
            if (rType.equals((Object)BRegisterTypeEnum.holding)) {
                return device.isHoldingRegisterAddressValid(addr.getDataAddress(), numRegs);
            }
            return device.isInputRegisterAddressValid(addr.getDataAddress(), numRegs);
        }
        return false;
    }

    private boolean isHoldingRegisterType() {
        return this.getRegType().equals((Object)BRegisterTypeEnum.holding);
    }

    private boolean isDataTypeInteger() {
        if (this.getDataType().equals((Object)BDataTypeEnum.integerType)) {
            return true;
        }
        return this.getDataType().equals((Object)BDataTypeEnum.signedInteger);
    }

    public boolean isDataType48BitUnsignedLong() {
        return DataTypeUtil.is48BitUnsignedLong(this.getDataType());
    }

    public boolean isDataTypeLong() {
        return DataTypeUtil.is32BitLong(this.getDataType());
    }

    public boolean isDataTypeSignedLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.longType);
    }

    public boolean isDataTypeUnsignedLong() {
        return this.getDataType().equals((Object)BDataTypeEnum.unsignedLong);
    }

    public boolean isDataTypeFloat() {
        return DataTypeUtil.isFloat(this.getDataType());
    }

    public void doWrite(BStatusValue out) {
        if (this.getParentPoint().isWritablePoint() && !this.configFault) {
            if (this.modbusNet() != null) {
                if (out == null) {
                    this.updateOutput(this.getWriteValue());
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                } else {
                    this.updateOutput(out);
                    if (this.getParentPoint().isSubscribed()) {
                        this.read();
                    }
                }
            }
        } else if (!this.getParentPoint().isWritablePoint() && this.modbusNet().getModbusLog().isTraceOn()) {
            this.modbusNet().getModbusLog().trace(this.getParent().getName() + "- This ModbusServer float point is not writable, disregarding write request.");
        }
        super.doWrite(out);
    }

    private boolean updateOutput(BStatusValue out) {
        double fValue = ((BStatusNumeric)out).getValue();
        if (!this.isValidAddress(this.getDataAddress())) {
            this.writeFail("Illegal Modbus address");
            return false;
        }
        try {
            BModbusServerDevice device = (BModbusServerDevice)this.getDevice();
            int pointAddress = this.getDataAddress().getDataAddress();
            byte[] dataOut = this.isDataTypeInteger() ? this.setIntegerByteArray(fValue) : (this.isDataTypeLong() ? this.setLongByteArray(fValue) : (this.isDataType48BitUnsignedLong() ? ByteConverterUtil.to6ByteUnsignedLongArray(fValue) : (this.isDataType64BitLong() ? ByteConverterUtil.to8ByteLongArray(fValue, device.getLong64BitDataByteOrder(), this.isDataTypeSigned()) : (this.isDataTypeDouble() ? ByteConverterUtil.to8ByteDoubleArray(fValue, device.getDouble64BitDataByteOrder()) : this.setFloatByteArray(fValue)))));
            if (this.isHoldingRegisterType()) {
                device.setHoldingRegisterValues(pointAddress, dataOut);
            } else {
                device.setInputRegisterValues(pointAddress, dataOut);
            }
        }
        catch (Exception e) {
            if (this.modbusNet() != null && this.modbusNet().getModbusLog().isTraceOn()) {
                this.modbusNet().getModbusLog().trace(this.getParent().getName() + ": BModbusServerNumericWritableProxyExt.updateOutput() caught exception: ", (Throwable)e);
            }
            this.writeFail("Error when writing (" + e + ")");
            return false;
        }
        this.writeOk(out);
        return true;
    }

    private boolean isDataType64BitLong() {
        return DataTypeUtil.is64BitLong(this.getDataType());
    }

    private boolean isDataTypeDouble() {
        return DataTypeUtil.isDouble(this.getDataType());
    }

    private boolean isDataTypeSigned() {
        return DataTypeUtil.isSigned(this.getDataType());
    }

    private byte[] setIntegerByteArray(double fValue) {
        return ByteConverterUtil.to2ByteIntArray(fValue, this.isDataTypeSigned());
    }

    private byte[] setLongByteArray(double fValue) {
        BDataByteOrderEnum byteOrder = ((BModbusServerDevice)this.getDevice()).getLongDataByteOrder();
        return ByteConverterUtil.to4ByteLongArray(fValue, byteOrder, this.isDataTypeSigned());
    }

    private byte[] setFloatByteArray(double fValue) {
        BDataByteOrderEnum byteOrder = ((BModbusServerDevice)this.getDevice()).getFloatDataByteOrder();
        return ByteConverterUtil.to4ByteFloatArray((float)fValue, byteOrder);
    }
}

