/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.modbusCore.messages;

import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.modbusCore.BModbusDevice;
import com.tridium.modbusCore.messages.ModbusInputStream;
import com.tridium.modbusCore.messages.ModbusMessageConst;
import com.tridium.modbusCore.messages.ModbusReceivedMessage;
import com.tridium.modbusCore.messages.ModbusResponse;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.nre.util.ByteArrayUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BBoolean;
import javax.baja.sys.Property;

public class ModbusMessage
extends Message
implements ModbusMessageConst {
    static final char[] constCRCHi = new char[]{'\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@', '\u0001', '\u00c0', '\u0080', 'A', '\u0001', '\u00c0', '\u0080', 'A', '\u0000', '\u00c1', '\u0081', '@'};
    static final char[] constCRCLo = new char[]{'\u0000', '\u00c0', '\u00c1', '\u0001', '\u00c3', '\u0003', '\u0002', '\u00c2', '\u00c6', '\u0006', '\u0007', '\u00c7', '\u0005', '\u00c5', '\u00c4', '\u0004', '\u00cc', '\f', '\r', '\u00cd', '\u000f', '\u00cf', '\u00ce', '\u000e', '\n', '\u00ca', '\u00cb', '\u000b', '\u00c9', '\t', '\b', '\u00c8', '\u00d8', '\u0018', '\u0019', '\u00d9', '\u001b', '\u00db', '\u00da', '\u001a', '\u001e', '\u00de', '\u00df', '\u001f', '\u00dd', '\u001d', '\u001c', '\u00dc', '\u0014', '\u00d4', '\u00d5', '\u0015', '\u00d7', '\u0017', '\u0016', '\u00d6', '\u00d2', '\u0012', '\u0013', '\u00d3', '\u0011', '\u00d1', '\u00d0', '\u0010', '\u00f0', '0', '1', '\u00f1', '3', '\u00f3', '\u00f2', '2', '6', '\u00f6', '\u00f7', '7', '\u00f5', '5', '4', '\u00f4', '<', '\u00fc', '\u00fd', '=', '\u00ff', '?', '>', '\u00fe', '\u00fa', ':', ';', '\u00fb', '9', '\u00f9', '\u00f8', '8', '(', '\u00e8', '\u00e9', ')', '\u00eb', '+', '*', '\u00ea', '\u00ee', '.', '/', '\u00ef', '-', '\u00ed', '\u00ec', ',', '\u00e4', '$', '%', '\u00e5', '\'', '\u00e7', '\u00e6', '&', '\"', '\u00e2', '\u00e3', '#', '\u00e1', '!', ' ', '\u00e0', '\u00a0', '`', 'a', '\u00a1', 'c', '\u00a3', '\u00a2', 'b', 'f', '\u00a6', '\u00a7', 'g', '\u00a5', 'e', 'd', '\u00a4', 'l', '\u00ac', '\u00ad', 'm', '\u00af', 'o', 'n', '\u00ae', '\u00aa', 'j', 'k', '\u00ab', 'i', '\u00a9', '\u00a8', 'h', 'x', '\u00b8', '\u00b9', 'y', '\u00bb', '{', 'z', '\u00ba', '\u00be', '~', '\u007f', '\u00bf', '}', '\u00bd', '\u00bc', '|', '\u00b4', 't', 'u', '\u00b5', 'w', '\u00b7', '\u00b6', 'v', 'r', '\u00b2', '\u00b3', 's', '\u00b1', 'q', 'p', '\u00b0', 'P', '\u0090', '\u0091', 'Q', '\u0093', 'S', 'R', '\u0092', '\u0096', 'V', 'W', '\u0097', 'U', '\u0095', '\u0094', 'T', '\u009c', '\\', ']', '\u009d', '_', '\u009f', '\u009e', '^', 'Z', '\u009a', '\u009b', '[', '\u0099', 'Y', 'X', '\u0098', '\u0088', 'H', 'I', '\u0089', 'K', '\u008b', '\u008a', 'J', 'N', '\u008e', '\u008f', 'O', '\u008d', 'M', 'L', '\u008c', 'D', '\u0084', '\u0085', 'E', '\u0087', 'G', 'F', '\u0086', '\u0082', 'B', 'C', '\u0083', 'A', '\u0081', '\u0080', '@'};
    private static Object idLock = new Object();
    private static int nextId = 0;
    public int deviceAddress = -1;
    public int functionCode;
    public int startAddress;
    public int numberPoints;
    public int comType;
    public BModbusDevice modbusDevice;
    public int transactionIdentifier = -1;

    public ModbusMessage(int comType, BModbusDevice modbusDevice) {
        int deviceComType;
        this.comType = comType;
        this.modbusDevice = modbusDevice;
        this.comType = deviceComType = modbusDevice.getModbusMode();
    }

    public void writeRtu(OutputStream out) throws IOException {
    }

    public void writeAscii(OutputStream out) throws IOException {
    }

    public void writeTcp(OutputStream out) throws IOException {
    }

    public void write(OutputStream out) {
        try {
            switch (this.comType) {
                case 0: {
                    this.writeAscii(out);
                    return;
                }
                case 1: {
                    this.writeRtu(out);
                    return;
                }
                case 2: {
                    this.writeTcp(out);
                    return;
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception writing Modbus Message: ");
            e.printStackTrace();
        }
    }

    public int getResponseMsgSize() {
        switch (this.functionCode) {
            case 3: 
            case 4: {
                return 5 + this.numberPoints * 2;
            }
            case 1: 
            case 2: {
                if (this.numberPoints % 8 == 0) {
                    return 5 + this.numberPoints / 8;
                }
                return 6 + this.numberPoints / 8;
            }
            case 16: {
                return 8;
            }
            case 6: {
                return 8;
            }
            case 5: {
                return 8;
            }
            case 15: {
                return 8;
            }
        }
        return 5;
    }

    protected Message toResponseAscii(ReceivedMessage response) {
        ModbusReceivedMessage modResp = (ModbusReceivedMessage)response;
        byte[] resp = modResp.getBytes();
        ModbusInputStream in = new ModbusInputStream(resp);
        ModbusResponse respMessage = new ModbusResponse(this.comType, this.modbusDevice);
        if (in.read() != 58) {
            respMessage.exceptionCode = -4;
            return respMessage;
        }
        int respSize = modResp.getLength();
        if (respSize <= 4) {
            respMessage.exceptionCode = -4;
            return respMessage;
        }
        byte[] noLRCBits = new byte[respSize - 4];
        System.arraycopy(resp, 0, noLRCBits, 0, respSize - 4);
        int lrc = ModbusMessage.calcLRC(ModbusInputStream.convertAscii2Rtu(noLRCBits));
        byte[] lrcArray = new byte[]{resp[respSize - 4], resp[respSize - 3]};
        ModbusInputStream lrcIn = new ModbusInputStream(lrcArray);
        int readLRC = lrcIn.readHexByte();
        if (lrc != readLRC) {
            System.out.println("*** LRC ERROR: " + ByteArrayUtil.toHexString((byte[])resp, (int)0, (int)respSize));
            System.out.println("readLRC = 0x" + Integer.toHexString(readLRC));
            System.out.println("lrc     = 0x" + Integer.toHexString(lrc));
            respMessage.exceptionCode = -5;
            if (this.modbusDevice != null) {
                this.modbusDevice.incrementLrcErrors();
            }
            return respMessage;
        }
        respMessage.deviceAddress = in.readHexByte() & 0xFF;
        respMessage.functionCode = in.readHexByte() & 0xFF;
        respMessage.startAddress = this.startAddress;
        respMessage.numberPoints = this.numberPoints;
        if ((respMessage.functionCode & 0x80) != 0) {
            respMessage.exceptionCode = in.readHexByte();
            return respMessage;
        }
        if (respMessage.functionCode != this.functionCode || respMessage.deviceAddress != this.deviceAddress) {
            respMessage.exceptionCode = -4;
            return respMessage;
        }
        respMessage.exceptionCode = 0;
        switch (respMessage.functionCode) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 23: {
                respMessage.byteCount = in.readHexByte() & 0xFF;
                for (int i = 0; i < respMessage.byteCount; ++i) {
                    respMessage.data[i] = (byte)(in.readHexByte() & 0xFF);
                }
                break;
            }
        }
        return respMessage;
    }

    public Message toResponse(ReceivedMessage response) {
        if (this.comType == 0) {
            return this.toResponseAscii(response);
        }
        ModbusReceivedMessage modResp = (ModbusReceivedMessage)response;
        byte[] resp = modResp.getBytes();
        ModbusResponse respMessage = new ModbusResponse(this.comType, this.modbusDevice);
        respMessage.deviceAddress = resp[0] & 0xFF;
        respMessage.functionCode = resp[1] & 0xFF;
        respMessage.startAddress = this.startAddress;
        respMessage.numberPoints = this.numberPoints;
        if (this.comType == 1) {
            int respSize = modResp.getLength();
            if (respSize <= 2) {
                respMessage.exceptionCode = -4;
                return respMessage;
            }
            byte[] noCRCBits = new byte[respSize - 2];
            System.arraycopy(resp, 0, noCRCBits, 0, respSize - 2);
            int crc = ModbusMessage.calcCRC(noCRCBits);
            int readCRC = (resp[respSize - 2] & 0xFF) << 8;
            if (crc != (readCRC |= resp[respSize - 1] & 0xFF)) {
                respMessage.exceptionCode = -1;
                if (this.modbusDevice != null) {
                    this.modbusDevice.incrementCrcErrors();
                }
                return respMessage;
            }
        } else if (this.comType == 2) {
            boolean disableTransactionIdCheck = false;
            try {
                if (this.modbusDevice != null) {
                    disableTransactionIdCheck = ((BBoolean)this.modbusDevice.get("disableTransactionIdCheck")).getBoolean();
                }
            }
            catch (Exception noCRCBits) {
                // empty catch block
            }
            if (!disableTransactionIdCheck && this.transactionIdentifier != modResp.getTransactionId()) {
                respMessage.exceptionCode = -4;
                if (this.modbusDevice != null) {
                    this.modbusDevice.incrementTransactionIdErrors();
                    if (this.modbusDevice.modbusNet() != null && this.modbusDevice.modbusNet().getModbusLog().isTraceOn()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Received invalid transaction ID in response (expected ");
                        sb.append(this.transactionIdentifier).append(", received ");
                        sb.append(modResp.getTransactionId()).append(")");
                        this.modbusDevice.modbusNet().getModbusLog().trace(sb.toString());
                    }
                }
                return respMessage;
            }
            respMessage.transactionIdentifier = this.transactionIdentifier;
        }
        try {
            if (resp[1] < 0) {
                respMessage.exceptionCode = resp[2];
                return respMessage;
            }
            if (respMessage.functionCode != this.functionCode || respMessage.deviceAddress != this.deviceAddress) {
                respMessage.exceptionCode = -4;
                return respMessage;
            }
            respMessage.exceptionCode = 0;
            switch (resp[1]) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 23: {
                    respMessage.byteCount = resp[2] & 0xFF;
                    for (int i = 0; i < respMessage.byteCount; ++i) {
                        respMessage.data[i] = resp[3 + i];
                    }
                    break;
                }
            }
            return respMessage;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            respMessage.exceptionCode = -4;
            return respMessage;
        }
    }

    public String toDebugString() {
        StringBuilder sb = new StringBuilder();
        String comTypeString = "RTU";
        if (this.comType == 0) {
            comTypeString = "ASCII";
        } else if (this.comType == 2) {
            comTypeString = "TCP";
        }
        sb.append("Modbus " + comTypeString + " Message = " + TextUtil.getClassName(this.getClass()));
        sb.append("\n  Tag = " + this.getTag());
        sb.append("\n  Modbus Device Address = " + (this.deviceAddress & 0xFF));
        sb.append("\n  Modbus Function Code = " + this.functionCode);
        sb.append("\n  Modbus Data Starting Address = " + this.startAddress);
        sb.append("\n  Modbus Number of Data Points = " + this.numberPoints);
        return sb.toString();
    }

    public static int calcLRC(byte[] msg) {
        int lrc = 0;
        for (int i = 0; i < msg.length; ++i) {
            lrc += msg[i] & 0xFF;
        }
        lrc &= 0xFF;
        lrc = 255 - lrc & 0xFF;
        ++lrc;
        return lrc &= 0xFF;
    }

    public static boolean verifyLRC(byte[] msg) {
        int lrc = 0;
        for (int i = 0; i < msg.length - 2; ++i) {
            lrc += msg[i] & 0xFF;
        }
        lrc &= 0xFF;
        lrc = 255 - lrc & 0xFF;
        return (++lrc & 0xFF) == (msg[msg.length - 2] & 0xFF);
    }

    public static int calcCRC(byte[] msg) {
        int hiCRC = 255;
        int loCRC = 255;
        for (int i = 0; i < msg.length; ++i) {
            int byteValue = msg[i] & 0xFF;
            int index = hiCRC ^ byteValue;
            hiCRC = loCRC ^ constCRCHi[index];
            loCRC = constCRCLo[index];
        }
        return hiCRC * 256 + loCRC;
    }

    public static boolean verifyCRC(byte[] msg) {
        int hiCRC = 255;
        int loCRC = 255;
        for (int i = 0; i < msg.length - 2; ++i) {
            int byteValue = msg[i] & 0xFF;
            int index = hiCRC ^ byteValue;
            hiCRC = loCRC ^ constCRCHi[index];
            loCRC = constCRCLo[index];
        }
        return (msg[msg.length - 2] & 0xFF) == hiCRC && (msg[msg.length - 1] & 0xFF) == loCRC;
    }

    protected int getMaxTransactionId() {
        int maxId = 65535;
        try {
            Property p = this.modbusDevice.getProperty("maxTransactionId");
            if (p != null) {
                maxId = this.modbusDevice.getInt(p);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return maxId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static int getNextTransactionId(int maxId) {
        Object object = idLock;
        synchronized (object) {
            if (nextId >= maxId) {
                nextId = 0;
            }
            return ++nextId;
        }
    }
}

