/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.platOnyxx;

import com.lynxspring.platOnyxx.BOnyxxPlatformService;
import java.io.File;
import java.io.FileInputStream;
import java.io.Writer;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.Sys;
import org.owasp.encoder.Encode;

public class OnyxxSystemLogSpyDir
extends SpyDir {
    private BOnyxxPlatformService platOnyxx;

    public OnyxxSystemLogSpyDir(BOnyxxPlatformService platOnyxx) {
        File[] serviceLogFiles;
        this.platOnyxx = platOnyxx;
        if (Sys.getProtectedStationHome() != null && (serviceLogFiles = new File("/home/niagara/shared/log").listFiles()) != null) {
            for (File f : serviceLogFiles) {
                if (f == null) continue;
                this.add(f.getName(), new OnyxxSystemLogSpy(f));
            }
        }
    }

    public void write(SpyWriter out) throws Exception {
        super.write(out);
        if (this.list().length == 0) {
            out.write("<p>No System Logs Found.</p>");
        }
    }

    class OnyxxSystemLogSpy
    extends Spy {
        private File systemLogFile;

        OnyxxSystemLogSpy(File f) {
            this.systemLogFile = f;
        }

        public void write(SpyWriter out) throws Exception {
            byte[] bytes;
            out.w((Object)"<pre>\n");
            try (FileInputStream in = new FileInputStream(this.systemLogFile);){
                bytes = new byte[(int)this.systemLogFile.length()];
                in.read(bytes);
            }
            Encode.forHtml((Writer)out, (String)new String(bytes));
            out.w((Object)"</pre>\n");
        }
    }
}

