/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.flexSerial.point;

import com.tridium.basicdriver.point.BBasicProxyExt;
import com.tridium.basicdriver.util.BIBasicPollable;
import com.tridium.flexSerial.BFlexSerialDevice;
import com.tridium.flexSerial.BFlexSerialNetwork;
import com.tridium.flexSerial.messages.BFlexMessageBlock;
import com.tridium.flexSerial.messages.BFlexMessageElement;
import com.tridium.flexSerial.messages.BFlexRequestResponse;
import com.tridium.flexSerial.messages.BFlexResponseMessage;
import com.tridium.flexSerial.point.BFlexPointDeviceExt;
import javax.baja.driver.point.BReadWriteMode;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusBoolean;
import javax.baja.status.BStatusEnum;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BFacets;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="address", type="String", defaultValue=""), @NiagaraProperty(name="address1", type="String", defaultValue=""), @NiagaraProperty(name="address2", type="String", defaultValue=""), @NiagaraProperty(name="pollMessage", type="BFlexRequestResponse", defaultValue="new BFlexRequestResponse()"), @NiagaraProperty(name="writeMessage", type="BFlexRequestResponse", defaultValue="new BFlexRequestResponse()")})
public class BFlexProxyExt
extends BBasicProxyExt
implements BIBasicPollable {
    @Generated
    public static final Property pollFrequency = BFlexProxyExt.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property address = BFlexProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property address1 = BFlexProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property address2 = BFlexProxyExt.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property pollMessage = BFlexProxyExt.newProperty((int)0, (BValue)new BFlexRequestResponse(), null);
    @Generated
    public static final Property writeMessage = BFlexProxyExt.newProperty((int)0, (BValue)new BFlexRequestResponse(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BFlexProxyExt.class);

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public String getAddress() {
        return this.getString(address);
    }

    @Generated
    public void setAddress(String v) {
        this.setString(address, v, null);
    }

    @Generated
    public String getAddress1() {
        return this.getString(address1);
    }

    @Generated
    public void setAddress1(String v) {
        this.setString(address1, v, null);
    }

    @Generated
    public String getAddress2() {
        return this.getString(address2);
    }

    @Generated
    public void setAddress2(String v) {
        this.setString(address2, v, null);
    }

    @Generated
    public BFlexRequestResponse getPollMessage() {
        return (BFlexRequestResponse)this.get(pollMessage);
    }

    @Generated
    public void setPollMessage(BFlexRequestResponse v) {
        this.set(pollMessage, (BValue)v, null);
    }

    @Generated
    public BFlexRequestResponse getWriteMessage() {
        return (BFlexRequestResponse)this.get(writeMessage);
    }

    @Generated
    public void setWriteMessage(BFlexRequestResponse v) {
        this.set(writeMessage, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public final BFlexSerialNetwork getFlexNetwork() {
        return (BFlexSerialNetwork)this.getNetwork();
    }

    public final BFlexSerialDevice getFlexDevice() {
        return (BFlexSerialDevice)this.getDevice();
    }

    public final String getFlexDeviceAddress() {
        return ((BFlexSerialDevice)this.getDevice()).getAddress();
    }

    public final BFlexPointDeviceExt getFlexPointDeviceExt() {
        return (BFlexPointDeviceExt)this.getDeviceExt();
    }

    public Type getDeviceExtType() {
        return BFlexPointDeviceExt.TYPE;
    }

    public BReadWriteMode getMode() {
        if (this.getParentPoint().isWritablePoint()) {
            return this.getPollMessage().isRequestDefined() ? BReadWriteMode.readWrite : BReadWriteMode.writeonly;
        }
        return BReadWriteMode.readonly;
    }

    public BFacets getSlotFacets(Slot slot) {
        if (slot.equals((Object)readValue) || slot.equals((Object)writeValue)) {
            return this.getPointFacets();
        }
        return super.getSlotFacets(slot);
    }

    public void poll() {
        if (this.isUnoperational()) {
            return;
        }
        BFlexSerialNetwork network = (BFlexSerialNetwork)this.getNetwork();
        if (network.getLog().isTraceOn()) {
            network.getLog().trace((Object)((Object)this) + ".poll()");
        }
        this.pollForData();
        network = null;
    }

    private void pollForData() {
        block9: {
            if (this.getMode().equals((Object)BReadWriteMode.writeonly)) {
                this.readOk(this.getWriteValue());
                return;
            }
            BFlexRequestResponse pMessage = this.getPollMessage();
            String results = pMessage.sendMessage(null);
            if (results.equalsIgnoreCase("OK")) {
                try {
                    if (!this.getPollMessage().isResponseDefined()) {
                        this.readFail("poll response message not defined!");
                        return;
                    }
                    BStatusValue newStatusValue = this.decodeResponseStatusValue(pMessage.getResponse());
                    if (newStatusValue != null) {
                        this.readOk(newStatusValue);
                        this.getDevice().pingOk();
                        break block9;
                    }
                    this.readFail("unable to convert response");
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.readFail(e.toString());
                }
            } else if (results.equals("response timeout")) {
                this.getDevice().pingFail(results);
            } else {
                this.readFail(results);
            }
        }
    }

    public void doWrite(BStatusValue value) {
        block8: {
            if (this.isUnoperational()) {
                return;
            }
            try {
                BFlexRequestResponse pMessage = this.getWriteMessage();
                String results = pMessage.sendMessage(null);
                if (results.equalsIgnoreCase("OK")) {
                    if (!this.getWriteMessage().isResponseDefined()) {
                        this.writeOk(value);
                        return;
                    }
                    try {
                        BStatusValue newStatusValue = this.decodeResponseStatusValue(pMessage.getResponse());
                        if (newStatusValue != null) {
                            this.writeOk(newStatusValue);
                            break block8;
                        }
                        this.writeOk(value);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.writeFail(e.toString());
                    }
                    break block8;
                }
                this.writeFail(results);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.writeFail(e.toString());
            }
        }
    }

    private BStatusValue decodeResponseStatusValue(BFlexResponseMessage rMessage) {
        BStatusNumeric newStatusValue = null;
        try {
            BFlexMessageElement msgElement;
            BFlexMessageBlock msgBlock = (BFlexMessageBlock)rMessage.get("instance");
            if (msgBlock == null) {
                rMessage.doCreateInstance();
                msgBlock = (BFlexMessageBlock)rMessage.get("instance");
            }
            if ((msgElement = msgBlock.getMessageElement(rMessage.getElementSelect().getElementSelect())) == null) {
                return null;
            }
            if (this.isNumeric()) {
                newStatusValue = new BStatusNumeric(msgElement.getDoubleValue());
            } else if (this.isBoolean()) {
                newStatusValue = new BStatusBoolean(msgElement.getBooleanValue());
            } else if (this.isString()) {
                newStatusValue = new BStatusString(msgElement.getStringValue());
            } else if (this.isEnum()) {
                newStatusValue = new BStatusEnum(msgElement.getEnumValue());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newStatusValue;
    }

    protected boolean isBoolean() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusBoolean;
    }

    protected boolean isNumeric() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusNumeric;
    }

    protected boolean isString() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusString;
    }

    protected boolean isEnum() {
        return this.getParentPoint().getOutStatusValue() instanceof BStatusEnum;
    }
}

