/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.ui;

import com.tridium.rdb.BRdbmsDiscoveredTable;
import com.tridium.rdb.BRdbmsOptionalColumnSelection;
import com.tridium.workbench.job.BJobBar;
import javax.baja.data.BIDataValue;
import javax.baja.driver.history.BIArchiveFolder;
import javax.baja.driver.ui.history.ArchiveManagerController;
import javax.baja.driver.ui.history.ArchiveModel;
import javax.baja.driver.ui.history.BArchiveManager;
import javax.baja.driver.ui.history.BHistoryImportManager;
import javax.baja.driver.ui.history.ImportModel;
import javax.baja.gx.BImage;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryId;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.rdb.history.BRdbmsColumnSelection;
import javax.baja.rdb.history.BRdbmsHistoryDeviceExt;
import javax.baja.rdb.history.BRdbmsHistoryImport;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.mgr.MgrTypeInfo;
import javax.baja.workbench.mgr.folder.FolderState;

@NiagaraType(agent={@AgentOn(types={"rdb:RdbmsHistoryDeviceExt"})})
public class BRdbmsHistoryImportManager
extends BHistoryImportManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsHistoryImportManager.class);
    static final Lexicon lex = Lexicon.make((String)"driver");
    private BRdbmsHistoryDeviceExt deviceExt;
    MgrColumn tableNameCol = new MgrColumn.Prop(BRdbmsHistoryImport.rdbTableName, 1);
    MgrColumn tableCatalogCol = new MgrColumn.Prop(BRdbmsHistoryImport.rdbCatalogName, 1);
    MgrColumn tableSchemaCol = new MgrColumn.Prop(BRdbmsHistoryImport.rdbSchemaName, 1);
    MgrColumn timestampCol = new RdbmsImportProp(BRdbmsHistoryImport.timestampColumn, 3);
    MgrColumn valueCol = new RdbmsImportProp(BRdbmsHistoryImport.valueColumn, 3);
    MgrColumn statusCol = new RdbmsImportProp(BRdbmsHistoryImport.statusColumn, 3);
    MgrColumn predicateCol = new MgrColumn.Prop(BRdbmsHistoryImport.queryPredicate, 3);
    MgrColumn fullImportCol = new MgrColumn.Prop(BRdbmsHistoryImport.fullImportOnExecute, 3);
    MgrColumn[] mcols = new MgrColumn[]{this.tableNameCol, this.tableCatalogCol, this.tableSchemaCol, this.timestampCol, this.valueCol, this.statusCol, this.predicateCol, this.fullImportCol};
    static BImage logIcon = BImage.make((BIcon)BIcon.std((String)"widgets/table.png"));
    MgrColumn dTableName = new MgrColumn.Prop(BRdbmsDiscoveredTable.tableName, 0);
    MgrColumn dCatalogName = new MgrColumn.Prop(BRdbmsDiscoveredTable.catalogName, 0);
    MgrColumn dSchemaName = new MgrColumn.Prop(BRdbmsDiscoveredTable.schemaName, 0);
    MgrColumn[] dcols = new MgrColumn[]{this.dTableName, this.dCatalogName, this.dSchemaName};

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void doLoadValue(BObject value, Context cx) {
        super.doLoadValue(value, cx);
    }

    protected ImportModel makeImportModel() {
        return new RdbmsImportModel(this);
    }

    protected MgrLearn makeLearn() {
        return new RdbmsImportLearn(this);
    }

    public MgrController makeController() {
        return new RdbmsImportController(this);
    }

    protected MgrState makeState() {
        return new RdbmsImportState();
    }

    private BRdbmsHistoryDeviceExt getDeviceExt() {
        if (this.deviceExt != null) {
            return this.deviceExt;
        }
        this.deviceExt = (BRdbmsHistoryDeviceExt)((BIArchiveFolder)this.getCurrentValue()).getDeviceExt();
        return this.deviceExt;
    }

    private BRdbms getDevice() {
        BRdbmsHistoryDeviceExt devExt = this.getDeviceExt();
        if (devExt == null) {
            return null;
        }
        return (BRdbms)devExt.getDevice();
    }

    private static class TimeZoneConfigColumn
    extends ImportModel.ConfigColumn {
        public TimeZoneConfigColumn(String propName, String displayName, int flags, BValue defaultValue) {
            super(propName, displayName, flags, defaultValue);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) throws Exception {
            BValue val = rows[0].getCell(colIndex);
            BFacets facets = BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE"));
            BWbFieldEditor editor = BWbFieldEditor.makeFor((BObject)val, (Context)facets);
            if (currentEditor != null && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)val, (Context)facets);
            return editor;
        }
    }

    private static class RdbmsImportProp
    extends MgrColumn.Prop {
        Property prop;

        public RdbmsImportProp(Property prop, int flags) {
            super(prop, flags);
            this.prop = prop;
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BComponent target = row.getTarget();
            BValue old = target.get(this.prop);
            target.set(this.prop, value.newCopy(), cx);
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            if (rows != null && rows.length > 1) {
                BValue val = rows[0].getCell(colIndex);
                for (MgrEditRow row : rows) {
                    if (val.equivalent((Object)row.getCell(colIndex))) continue;
                    return null;
                }
            }
            return super.toEditor(rows, colIndex, currentEditor);
        }
    }

    private class RdbmsImportState
    extends FolderState {
        Object[] lastLearn;
        BRdbms lastDevice;

        private RdbmsImportState() {
        }

        protected void saveForOrd(BAbstractManager m) {
            super.saveForOrd(m);
            BRdbmsHistoryImportManager mgr = (BRdbmsHistoryImportManager)m;
            RdbmsImportLearn lrn = (RdbmsImportLearn)mgr.getLearn();
            this.lastLearn = lrn.lastLearn;
            this.lastDevice = mgr.getDevice();
        }

        protected void restoreForOrd(BAbstractManager m) {
            super.restoreForOrd(m);
            BRdbmsHistoryImportManager mgr = (BRdbmsHistoryImportManager)m;
            RdbmsImportLearn lrn = (RdbmsImportLearn)mgr.getLearn();
            if (this.lastLearn != null && this.lastDevice != null && this.lastDevice.equals((Object)mgr.getDevice())) {
                lrn.updateRoots(this.lastLearn);
            }
        }
    }

    private class RdbmsImportController
    extends ArchiveManagerController {
        public RdbmsImportController(BHistoryImportManager manager) {
            super((BArchiveManager)manager);
            this.cancel.setFlags(7);
        }

        public CommandArtifact doDiscover(Context cx) throws Exception {
            super.doDiscover(cx);
            BOrd jobOrd = BRdbmsHistoryImportManager.this.getDeviceExt().submitRdbTableDiscoveryJob();
            if (jobOrd != null && !jobOrd.equals((Object)BOrd.DEFAULT)) {
                BRdbmsHistoryImportManager.this.getLearn().setJob(jobOrd);
            }
            return null;
        }
    }

    private class RdbmsImportLearn
    extends MgrLearn {
        BRdbmsDiscoveredTable[] lastLearn;

        public RdbmsImportLearn(BHistoryImportManager manager) {
            super((BAbstractManager)manager);
        }

        public BWidget makeJobBar() {
            return new BJobBar();
        }

        protected MgrColumn[] makeColumns() {
            return BRdbmsHistoryImportManager.this.dcols;
        }

        public BImage getIcon(Object d) {
            return logIcon;
        }

        public boolean isExisting(Object dis, BComponent db) {
            return db instanceof BRdbmsHistoryImport && ((BRdbmsHistoryImport)db).getRdbTableName().equals(((BRdbmsDiscoveredTable)dis).getTableName()) && ((BRdbmsHistoryImport)db).getRdbCatalogName().equals(((BRdbmsDiscoveredTable)dis).getCatalogName()) && ((BRdbmsHistoryImport)db).getRdbSchemaName().equals(((BRdbmsDiscoveredTable)dis).getSchemaName());
        }

        public boolean isMatchable(Object dis, BComponent db) {
            return db instanceof BRdbmsHistoryImport;
        }

        public MgrTypeInfo[] toTypes(Object dis) {
            return MgrTypeInfo.makeArray((Type)BRdbmsHistoryImport.TYPE);
        }

        public void toRow(Object dis, MgrEditRow row) throws Exception {
            String escTableName = SlotPath.escape((String)((BRdbmsDiscoveredTable)dis).getTableName());
            row.setDefaultName(escTableName);
            row.setCell(BRdbmsHistoryImportManager.this.tableNameCol, (BValue)BString.make((String)((BRdbmsDiscoveredTable)dis).getTableName()));
            row.setCell(BRdbmsHistoryImportManager.this.tableCatalogCol, (BValue)BString.make((String)((BRdbmsDiscoveredTable)dis).getCatalogName()));
            row.setCell(BRdbmsHistoryImportManager.this.tableSchemaCol, (BValue)BString.make((String)((BRdbmsDiscoveredTable)dis).getSchemaName()));
            BRdbmsColumnSelection tCol = new BRdbmsColumnSelection();
            tCol.setColumn(((BRdbmsDiscoveredTable)dis).getTimestampColumn());
            row.setCell(BRdbmsHistoryImportManager.this.timestampCol, (BValue)tCol);
            BRdbmsColumnSelection vCol = new BRdbmsColumnSelection();
            vCol.setColumn(((BRdbmsDiscoveredTable)dis).getValueColumn());
            row.setCell(BRdbmsHistoryImportManager.this.valueCol, (BValue)vCol);
            BRdbmsOptionalColumnSelection sCol = new BRdbmsOptionalColumnSelection();
            sCol.setUnspecified(true);
            sCol.setColumn(((BRdbmsDiscoveredTable)dis).getStatusColumn());
            row.setCell(BRdbmsHistoryImportManager.this.statusCol, (BValue)sCol);
            row.setCell(((ArchiveModel)this.getManager().getModel()).idCol, (BValue)BHistoryId.make((String)BRdbmsHistoryImportManager.this.getDevice().getName(), (String)escTableName));
        }

        public void jobComplete(BJob job) {
            super.jobComplete(job);
            this.updateDiscoveryRows((BComponent)job);
        }

        private void updateDiscoveryRows(BComponent event) {
            Object[] rows = (BRdbmsDiscoveredTable[])event.getChildren(BRdbmsDiscoveredTable.class);
            this.lastLearn = rows;
            this.updateRoots(rows);
        }
    }

    private class RdbmsImportModel
    extends ImportModel {
        public RdbmsImportModel(BHistoryImportManager manager) {
            super(manager);
        }

        public Type[] getIncludeTypes() {
            BObject val = this.getManager().getCurrentValue();
            if (val instanceof BIArchiveFolder) {
                BIArchiveFolder folder = (BIArchiveFolder)val;
                Type folderType = folder.getArchiveFolderType();
                return new Type[]{BRdbmsHistoryImport.TYPE, folderType};
            }
            return new Type[]{BRdbmsHistoryImport.TYPE};
        }

        public MgrTypeInfo[] getNewTypes() {
            return MgrTypeInfo.makeArray((Type)BRdbmsHistoryImport.TYPE);
        }

        public BComponent newInstance(MgrTypeInfo type) throws Exception {
            BRdbmsHistoryImport result = (BRdbmsHistoryImport)super.newInstance(type);
            BComponent overrides = result.getConfigOverrides();
            overrides.add("interval", (BValue)BCollectionInterval.IRREGULAR, 0);
            overrides.add("valueFacets", (BValue)BFacets.make((String)"units", (BIDataValue)BUnit.NULL), 0);
            BTimeZone tz = BTimeZone.getLocal();
            overrides.add("timeZone", (BValue)tz, 0, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"driver:TimeZoneSelectionFE")), null);
            return result;
        }

        protected MgrColumn[] makeColumns() {
            int n;
            MgrColumn[] superCols = super.makeColumns();
            int resultSize = superCols.length + BRdbmsHistoryImportManager.this.mcols.length + 3;
            MgrColumn[] result = new MgrColumn[resultSize];
            int index = 0;
            MgrColumn[] mgrColumnArray = superCols;
            int n2 = mgrColumnArray.length;
            for (n = 0; n < n2; ++n) {
                MgrColumn superCol;
                result[index] = superCol = mgrColumnArray[n];
                ++index;
            }
            result[index] = new ImportModel.ConfigColumn("interval", lex.getText("HistoryConfig.interval"), 3, (BValue)BCollectionInterval.IRREGULAR);
            result[++index] = new ImportModel.ConfigColumn("valueFacets", lex.getText("HistoryConfig.valueFacets"), 3, (BValue)BFacets.DEFAULT);
            result[++index] = new TimeZoneConfigColumn("timeZone", lex.getText("HistoryConfig.timeZone"), 3, (BValue)BTimeZone.DEFAULT);
            ++index;
            mgrColumnArray = BRdbmsHistoryImportManager.this.mcols;
            n2 = mgrColumnArray.length;
            for (n = 0; n < n2; ++n) {
                MgrColumn mcol;
                result[index] = mcol = mgrColumnArray[n];
                ++index;
            }
            return result;
        }
    }
}

