/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.rdb.ui;

import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import javax.baja.driver.BDevice;
import javax.baja.driver.ui.device.BDeviceManager;
import javax.baja.driver.ui.device.DeviceModel;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.rdb.BRdbms;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;

@NiagaraType(agent={@AgentOn(types={"rdb:RdbmsNetwork"}, requiredPermissions="W")})
public class BRdbmsDeviceManager
extends BDeviceManager {
    @Generated
    public static final Type TYPE = Sys.loadType(BRdbmsDeviceManager.class);
    private static final LexiconModule LEX = LexiconModule.make(BRdbmsDeviceManager.class);
    private static final String PROP_NAME_NON_PRIV_CONNECTION_POOL = "nonPrivilegedConnectionPool";
    private static final String PROP_NAME_CONNECTIONS_ENABLED = "enabled";
    private static final String PROP_NAME_USERNAME = "username";
    private static final String PROP_NAME_PASSWORD = "password";
    private final MgrColumn columnName = new MgrColumn.Name();
    private final MgrColumn columnType = new MgrColumn.Type();
    private final MgrColumn columnStatus = new MgrColumn.Prop(BDevice.status);
    private final MgrColumn columnEnabled = new MgrColumn.Prop(BDevice.enabled, 3);
    private final MgrColumn columnHealth = new MgrColumn.Prop(BDevice.health, 0);
    private final MgrColumn columnPrivilegedUsername = new MgrColumn.Prop(LEX.get("rdbms.privileged.username", null), BRdbms.userName, 1);
    private final MgrColumn columnPrivilegedPassword = new MgrColumn.Prop(LEX.get("rdbms.privileged.password", null), BRdbms.password, 3);
    private final MgrColumn columnNonPrivilegedConnectionsEnabled = new NonPrivilegedConnectionsEnabledColumn();
    private final MgrColumn columnNonPrivilegedUsername = new NonPrivilegedUsernameColumn();
    private final MgrColumn columnNonPrivilegedPassword = new NonPrivilegedPasswordColumn();
    private final MgrColumn[] columns = new MgrColumn[]{this.columnName, this.columnType, this.columnStatus, this.columnEnabled, this.columnHealth, this.columnPrivilegedUsername, this.columnPrivilegedPassword, this.columnNonPrivilegedConnectionsEnabled, this.columnNonPrivilegedUsername, this.columnNonPrivilegedPassword};

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected MgrModel makeModel() {
        return new RdbmsModel(this);
    }

    private static class NonPrivilegedColumn
    extends MgrColumn {
        private final String targetPropertyName;

        private NonPrivilegedColumn(String targetPropertyName, String displayName, int flags) {
            super(displayName, flags);
            this.targetPropertyName = targetPropertyName;
        }

        public Object get(Object row) {
            BValue property = this.getProperty(row);
            return property != null ? property : BString.make((String)LEX.get("rdbms.nonprivileged.notApplicable", null));
        }

        public BValue load(MgrEditRow row) {
            BValue property = this.getProperty(row);
            return property != null ? property.newCopy() : BString.make((String)LEX.get("rdbms.nonprivileged.notApplicable", null));
        }

        public void save(MgrEditRow row, BValue value, Context cx) {
            BValue old;
            BComponent connectionPool = this.getConnectionPool(row);
            if (connectionPool != null && (old = connectionPool.get(this.targetPropertyName)) != null && !old.equivalent((Object)value)) {
                connectionPool.set(this.targetPropertyName, value.newCopy(), cx);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] rows, int colIndex, BWbEditor currentEditor) {
            BWbFieldEditor editor;
            BComponent connectionPool;
            if (rows.length < 1) {
                return null;
            }
            BValue propertyValue = null;
            for (MgrEditRow row : rows) {
                propertyValue = this.getProperty(row);
                if (propertyValue != null) continue;
                return null;
            }
            BFacets facets = BFacets.DEFAULT;
            if (rows.length == 1 && (connectionPool = this.getConnectionPool((BComplex)rows[0].getTarget())) != null) {
                facets = connectionPool.getSlotFacets(connectionPool.getSlot(this.targetPropertyName));
            }
            BAbstractManager manager = rows[0].getManager();
            Context context = null;
            if (manager != null) {
                context = manager.getCurrentContext();
                if (!facets.isNull()) {
                    context = new BasicContext(context, facets);
                }
            }
            if ((editor = BWbFieldEditor.makeFor((BObject)propertyValue, (Context)context)) instanceof BStringFE) {
                editor = new BStringMgrColFE(colIndex);
            }
            if (currentEditor instanceof BWbFieldEditor && currentEditor.getClass() == editor.getClass()) {
                editor = (BWbFieldEditor)currentEditor;
            }
            editor.loadValue((BObject)rows[0].getCell(colIndex), context);
            return editor;
        }

        public void fromEditor(MgrEditRow[] rows, int colIndex, BWbEditor editor) throws Exception {
            NonPrivilegedColumn.fromFieldEditor((MgrEditRow[])rows, (int)colIndex, (BWbEditor)editor, null);
        }

        private BValue getProperty(Object rdbmsDevice) {
            return this.getProperty(this.getConnectionPool(rdbmsDevice));
        }

        private BValue getProperty(MgrEditRow rdbmsDeviceRow) {
            return this.getProperty(this.getConnectionPool(rdbmsDeviceRow));
        }

        private BValue getProperty(BComponent connectionPool) {
            if (connectionPool != null) {
                connectionPool.lease(1);
                return connectionPool.get(this.targetPropertyName);
            }
            return null;
        }

        private BComponent getConnectionPool(Object rdbmsDevice) {
            if (rdbmsDevice instanceof BComplex) {
                return this.getConnectionPool((BComplex)rdbmsDevice);
            }
            return null;
        }

        private BComponent getConnectionPool(MgrEditRow rdbmsDeviceRow) {
            return this.getConnectionPool((BComplex)rdbmsDeviceRow.getTarget());
        }

        private BComponent getConnectionPool(BComplex rdbmsDevice) {
            BValue connectionPool = rdbmsDevice.get(BRdbmsDeviceManager.PROP_NAME_NON_PRIV_CONNECTION_POOL);
            if (connectionPool instanceof BComponent) {
                return (BComponent)connectionPool;
            }
            return null;
        }
    }

    private static class NonPrivilegedPasswordColumn
    extends NonPrivilegedColumn {
        private NonPrivilegedPasswordColumn() {
            super(BRdbmsDeviceManager.PROP_NAME_PASSWORD, LEX.get("rdbms.nonprivileged.password", null), 3);
        }
    }

    private static class NonPrivilegedUsernameColumn
    extends NonPrivilegedColumn {
        private NonPrivilegedUsernameColumn() {
            super(BRdbmsDeviceManager.PROP_NAME_USERNAME, LEX.get("rdbms.nonprivileged.username", null), 1);
        }
    }

    private static class NonPrivilegedConnectionsEnabledColumn
    extends NonPrivilegedColumn {
        private NonPrivilegedConnectionsEnabledColumn() {
            super(BRdbmsDeviceManager.PROP_NAME_CONNECTIONS_ENABLED, LEX.get("rdbms.nonprivileged.connections.enabled", null), 1);
        }
    }

    private class RdbmsModel
    extends DeviceModel {
        RdbmsModel(BDeviceManager manager) {
            super(manager);
        }

        protected MgrColumn[] makeColumns() {
            return BRdbmsDeviceManager.this.columns;
        }
    }
}

