/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.security;

import com.tridium.platwifi.security.BWifiAuthenticationMethod;
import com.tridium.platwifi.security.BWifiKeyManagementEnum;
import java.util.Objects;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="none", ordinal=0), @Range(value="wep", ordinal=1), @Range(value="wpa", ordinal=2), @Range(value="wpa_psk", ordinal=3), @Range(value="wpa_2", ordinal=4), @Range(value="wpa_2_psk", ordinal=5), @Range(value="wpapsk_wpa2psk", ordinal=6), @Range(value="unsupported", ordinal=7), @Range(value="wpa_3_sae", ordinal=8)})
public final class BWifiSecurityPolicy
extends BFrozenEnum {
    @Generated
    public static final int NONE = 0;
    @Generated
    public static final int WEP = 1;
    @Generated
    public static final int WPA = 2;
    @Generated
    public static final int WPA_PSK = 3;
    @Generated
    public static final int WPA_2 = 4;
    @Generated
    public static final int WPA_2_PSK = 5;
    @Generated
    public static final int WPAPSK_WPA_2PSK = 6;
    @Generated
    public static final int UNSUPPORTED = 7;
    @Generated
    public static final int WPA_3_SAE = 8;
    @Generated
    public static final BWifiSecurityPolicy none = new BWifiSecurityPolicy(0);
    @Generated
    public static final BWifiSecurityPolicy wep = new BWifiSecurityPolicy(1);
    @Generated
    public static final BWifiSecurityPolicy wpa = new BWifiSecurityPolicy(2);
    @Generated
    public static final BWifiSecurityPolicy wpa_psk = new BWifiSecurityPolicy(3);
    @Generated
    public static final BWifiSecurityPolicy wpa_2 = new BWifiSecurityPolicy(4);
    @Generated
    public static final BWifiSecurityPolicy wpa_2_psk = new BWifiSecurityPolicy(5);
    @Generated
    public static final BWifiSecurityPolicy wpapsk_wpa2psk = new BWifiSecurityPolicy(6);
    @Generated
    public static final BWifiSecurityPolicy unsupported = new BWifiSecurityPolicy(7);
    @Generated
    public static final BWifiSecurityPolicy wpa_3_sae = new BWifiSecurityPolicy(8);
    @Generated
    public static final BWifiSecurityPolicy DEFAULT = none;
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiSecurityPolicy.class);

    @Generated
    public static BWifiSecurityPolicy make(int ordinal) {
        return (BWifiSecurityPolicy)none.getRange().get(ordinal, false);
    }

    @Generated
    public static BWifiSecurityPolicy make(String tag) {
        return (BWifiSecurityPolicy)none.getRange().get(tag);
    }

    @Generated
    private BWifiSecurityPolicy(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BWifiSecurityPolicy toSecurityPolicy(String wifiProtocol, BWifiAuthenticationMethod wifiAuthenticationMethod, BWifiKeyManagementEnum wifiKeyManagementEnum) {
        Objects.requireNonNull(wifiProtocol, "wifiProtocol argument cannot be null");
        Objects.requireNonNull(wifiAuthenticationMethod, "wifiAuthenticationMethod argument cannot be null");
        Objects.requireNonNull(wifiKeyManagementEnum, "wifiKeyManagementEnum argument cannot be null");
        if (wifiAuthenticationMethod != BWifiAuthenticationMethod.open) {
            return unsupported;
        }
        if (wifiKeyManagementEnum == BWifiKeyManagementEnum.none || wifiKeyManagementEnum == BWifiKeyManagementEnum.wpaEap || wifiKeyManagementEnum == BWifiKeyManagementEnum.ieee8021x) {
            return unsupported;
        }
        switch (wifiProtocol) {
            case "WPA": {
                return wpa_psk;
            }
            case "RSN": 
            case "WPA2": {
                if (wifiKeyManagementEnum == BWifiKeyManagementEnum.wpaPsk || wifiKeyManagementEnum == BWifiKeyManagementEnum.wpaPsk_wpaEap) {
                    return wpa_2_psk;
                }
                if (wifiKeyManagementEnum != BWifiKeyManagementEnum.sae) break;
                return wpa_3_sae;
            }
            case "WPA RSN": 
            case "WPA WPA2": 
            case "RSN WPA": 
            case "WPA2 WPA": {
                return wpapsk_wpa2psk;
            }
        }
        return wpapsk_wpa2psk;
    }
}

