/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.security;

import java.util.Objects;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="none", ordinal=1), @Range(value="tkip", ordinal=2), @Range(value="ccmp", ordinal=4), @Range(value="ccmpTkip", ordinal=6), @Range(value="wep104", ordinal=8), @Range(value="wep40", ordinal=16), @Range(value="ccmpTkipWep104Wep40", ordinal=30)})
public final class BWifiEncryptionMethod
extends BFrozenEnum {
    @Generated
    public static final int NONE = 1;
    @Generated
    public static final int TKIP = 2;
    @Generated
    public static final int CCMP = 4;
    @Generated
    public static final int CCMP_TKIP = 6;
    @Generated
    public static final int WEP_104 = 8;
    @Generated
    public static final int WEP_40 = 16;
    @Generated
    public static final int CCMP_TKIP_WEP_104WEP_40 = 30;
    @Generated
    public static final BWifiEncryptionMethod none = new BWifiEncryptionMethod(1);
    @Generated
    public static final BWifiEncryptionMethod tkip = new BWifiEncryptionMethod(2);
    @Generated
    public static final BWifiEncryptionMethod ccmp = new BWifiEncryptionMethod(4);
    @Generated
    public static final BWifiEncryptionMethod ccmpTkip = new BWifiEncryptionMethod(6);
    @Generated
    public static final BWifiEncryptionMethod wep104 = new BWifiEncryptionMethod(8);
    @Generated
    public static final BWifiEncryptionMethod wep40 = new BWifiEncryptionMethod(16);
    @Generated
    public static final BWifiEncryptionMethod ccmpTkipWep104Wep40 = new BWifiEncryptionMethod(30);
    @Generated
    public static final BWifiEncryptionMethod DEFAULT = none;
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiEncryptionMethod.class);

    @Generated
    public static BWifiEncryptionMethod make(int ordinal) {
        return (BWifiEncryptionMethod)none.getRange().get(ordinal, false);
    }

    @Generated
    public static BWifiEncryptionMethod make(String tag) {
        return (BWifiEncryptionMethod)none.getRange().get(tag);
    }

    @Generated
    private BWifiEncryptionMethod(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String toCipherString(BWifiEncryptionMethod wifiEncryptionMethod) {
        Objects.requireNonNull(wifiEncryptionMethod, "wifiEncryptionMethod argument cannot be null");
        switch (wifiEncryptionMethod.getOrdinal()) {
            case 2: {
                return "TKIP";
            }
            case 4: {
                return "CCMP";
            }
            case 6: {
                return "CCMP TKIP";
            }
        }
        return "CCMP TKIP";
    }

    public static BWifiEncryptionMethod toWifiEncryptionMethod(String cipher) {
        Objects.requireNonNull(cipher, "cipher argument cannot be null");
        switch (cipher) {
            case "CCMP TKIP": 
            case "TKIP CCMP": {
                return ccmpTkip;
            }
            case "CCMP": {
                return ccmp;
            }
            case "TKIP": {
                return tkip;
            }
        }
        return ccmpTkip;
    }
}

