/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi.security;

import java.util.Objects;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraEnum;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.annotations.Range;
import javax.baja.sys.BFrozenEnum;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraEnum(range={@Range(value="open", ordinal=1), @Range(value="shared", ordinal=2), @Range(value="leap", ordinal=3), @Range(value="auto", ordinal=4)}, defaultValue="auto")
public final class BWifiAuthenticationMethod
extends BFrozenEnum {
    @Generated
    public static final int OPEN = 1;
    @Generated
    public static final int SHARED = 2;
    @Generated
    public static final int LEAP = 3;
    @Generated
    public static final int AUTO = 4;
    @Generated
    public static final BWifiAuthenticationMethod open = new BWifiAuthenticationMethod(1);
    @Generated
    public static final BWifiAuthenticationMethod shared = new BWifiAuthenticationMethod(2);
    @Generated
    public static final BWifiAuthenticationMethod leap = new BWifiAuthenticationMethod(3);
    @Generated
    public static final BWifiAuthenticationMethod auto;
    @Generated
    public static final BWifiAuthenticationMethod DEFAULT;
    @Generated
    public static final Type TYPE;

    @Generated
    public static BWifiAuthenticationMethod make(int ordinal) {
        return (BWifiAuthenticationMethod)open.getRange().get(ordinal, false);
    }

    @Generated
    public static BWifiAuthenticationMethod make(String tag) {
        return (BWifiAuthenticationMethod)open.getRange().get(tag);
    }

    @Generated
    private BWifiAuthenticationMethod(int ordinal) {
        super(ordinal);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static String toAuthAlgorithmString(BWifiAuthenticationMethod wifiAuthenticationMethod) {
        Objects.requireNonNull(wifiAuthenticationMethod, "wifiAuthenticationMethod argument cannot be null");
        switch (wifiAuthenticationMethod.getOrdinal()) {
            case 1: {
                return "OPEN";
            }
            case 2: {
                return "SHARED";
            }
            case 3: {
                return "LEAP";
            }
        }
        return "";
    }

    public static BWifiAuthenticationMethod toWifiAuthenticationMethod(String authAlgorithm) {
        Objects.requireNonNull(authAlgorithm, "authAlgorithm argument cannot be null");
        switch (authAlgorithm) {
            case "OPEN": {
                return open;
            }
            case "SHARED": {
                return shared;
            }
            case "LEAP": {
                return leap;
            }
        }
        return auto;
    }

    static {
        DEFAULT = auto = new BWifiAuthenticationMethod(4);
        TYPE = Sys.loadType(BWifiAuthenticationMethod.class);
    }
}

