/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.nre.security.PBEDecryptingInputStream;
import com.tridium.nre.security.PBEEncodingKey;
import com.tridium.nre.util.IPAddressUtil;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.daemon.DaemonClientEncodingInfo;
import com.tridium.platform.daemon.DaemonFileUtil;
import com.tridium.platform.daemon.file.BCachedDaemonFileSpace;
import com.tridium.platform.daemon.file.BDaemonFileSpace;
import com.tridium.platform.daemon.message.DaemonMessage;
import com.tridium.platform.daemon.message.FileTransferMessage;
import com.tridium.platform.daemon.message.GetDirectoryMessage;
import com.tridium.platform.daemon.message.GetTcpIpMessage;
import com.tridium.platform.daemon.message.GetWiFiMonitorDataMessage;
import com.tridium.platform.daemon.message.GetWiFiSettingsMessage;
import com.tridium.platform.daemon.message.WiFiServletType;
import com.tridium.platform.tcpip.BTcpIpHostSettings;
import com.tridium.platform.tcpip.TcpUtil;
import com.tridium.platform.tcpip.dhcpd.BDhcpdAdapterSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdHostSettings;
import com.tridium.platform.tcpip.dhcpd.BDhcpdServerType;
import com.tridium.platform.tcpip.dhcpd.DhcpdUtil;
import com.tridium.platwifi.BHapdHwModeEnum;
import com.tridium.platwifi.BHtCapabilityEnum;
import com.tridium.platwifi.BSupplicantNetBlock;
import com.tridium.platwifi.BSupplicantNetBlockVector;
import com.tridium.platwifi.BWifiChannelListEntry;
import com.tridium.platwifi.BWifiChannelListVector;
import com.tridium.platwifi.BWifiClientListEntry;
import com.tridium.platwifi.BWifiClientListVector;
import com.tridium.platwifi.BWifiFreqBandEnum;
import com.tridium.platwifi.BWifiMacAddress;
import com.tridium.platwifi.BWifiMacAddressVector;
import com.tridium.platwifi.BWifiMonitorData;
import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.BWifiNetworkVector;
import com.tridium.platwifi.BWifiSettings;
import com.tridium.platwifi.BWifiSwitchTypeEnum;
import com.tridium.platwifi.daemon.message.ConnectNetworkMessage;
import com.tridium.platwifi.daemon.message.DisconnectNetworkMessage;
import com.tridium.platwifi.daemon.message.GetChannelListMessage;
import com.tridium.platwifi.daemon.message.GetClientListMessage;
import com.tridium.platwifi.daemon.message.GetCountryCodeMessage;
import com.tridium.platwifi.daemon.message.GetCountryListMessage;
import com.tridium.platwifi.daemon.message.GetScanResultsMessage;
import com.tridium.platwifi.daemon.message.GetWifiSkuMessage;
import com.tridium.platwifi.daemon.message.ReconfigureNetworksMessage;
import com.tridium.platwifi.daemon.message.ScanMessage;
import com.tridium.platwifi.daemon.message.SetCountryCodeMessage;
import com.tridium.platwifi.daemon.message.SetIPAddressMessage;
import com.tridium.platwifi.daemon.message.SetSapTimeoutMessage;
import com.tridium.platwifi.daemon.message.SetWiFiEnabledMessage;
import com.tridium.platwifi.daemon.message.SetWiFiSwitchPositionMessage;
import com.tridium.platwifi.security.BHapdEncryptionMethod;
import com.tridium.platwifi.security.BHapdKeyManagementEnum;
import com.tridium.platwifi.security.BHapdWpaConfigEnum;
import com.tridium.platwifi.status.BWifiSupplicantStateEnum;
import com.tridium.platwifi.status.BWifiSwitchEnum;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.naming.SlotPath;
import javax.baja.nre.util.FileUtil;
import javax.baja.nre.util.TextUtil;
import javax.baja.security.BPassword;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BVector;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.xml.XElem;
import javax.baja.xml.XParser;

public class WifiUtil {
    private static final String COMMENT = "#";
    private static final String SEMICOLON = ";";
    private static final String QUOTE = "\"";
    static final String EQUALS = "=";
    static final char EQUALS_CHAR = '=';
    private static final String NEGATIVE_ONE = "-1";
    private static final String ZERO = "0";
    private static final String ONE = "1";
    private static final String TWO = "2";
    static final String NEWLINE = "\n";
    private static final char NEWLINE_CHAR = '\n';
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final String SPACE = " ";
    private static final String TAB = "\t";
    private static final String EMPTY = "";
    private static final String BLANK = "";
    public static final long DEFAULT_SCAN_SLEEP_MS = 8000L;
    public static final long MAX_SCAN_SLEEP_MS = 10000L;
    public static final long MIN_SCAN_SLEEP_MS = 0L;
    private static final String STATUS_CODE = "statusCode";
    private static final Logger LOG = Logger.getLogger("plat.wifi");
    private static final String TRIDIUM_LEGACY_WIFI_WPA_SUPPLICANT_FILE_PATH = "/opt/niagara/platform/wifi/wpa_supplicant_ti18xx.conf";
    private static final String TRIDIUM_LEGACY_WIFI_HOSTAPD_FILE_PATH = "/opt/niagara/platform/wifi/hostapd_ti18xx.conf";
    private static final String TRIDIUM_LEGACY_WIFI_ALLOW_LIST_PATH = "/opt/niagara/platform/wifi/hostapd.accept";
    private static final String TRIDIUM_LEGACY_WIFI_WIFI_NET_CFG_FILE_PATH = "/opt/niagara/platform/wifi/wifi_net.cfg";
    private static final String TRIDIUM_LEGACY_WIFI_WPA_SUPPLICANT_CTRL_PATH = "/var/run/wpa_supplicant";
    private static final String TRIDIUM_LEGACY_WIFI_WPA_SUPPLICANT_UPDATE_CONFIG_VALUE = "1";
    private static final String TRIDIUM_LEGACY_WIFI_WPA_SUPPLICANT_P2P_DISABLED_VALUE = "1";
    private static final String TRIDIUM_LEGACY_WIFI_HOSTAPD_CTRL_PATH = "/var/run/hostapd";
    private static final String TRIDIUM_LEGACY_WIFI_HOSTAPD_CTRL_INTERFACE_GROUP = "0";
    private static final String TRIDIUM_LEGACY_WIFI_DRIVER = "wilink";
    private static final String TRIDIUM_LEGACY_WIFI_DEFAULT_IP = "192.168.11.1";
    private static final String TRIDIUM_LEGACY_WIFI_DEFAULT_SUBNET_MASK = "255.255.255.0";
    private static final String TRIDIUM_LEGACY_WIFI_STA_ADAPTER = "tiw_sta0";
    private static final String TRIDIUM_LEGACY_WIFI_SAP_ADAPTER = "tiw_sap0";
    private static final String TRIDIUM_LEGACY_WIFI_DUMP_PATH = "/tmp/hostapd.dump";
    private static final String TRIDIUM_LEGACY_WIFI_DEVICE_NAME = "TI_Wilink8";
    private static final String TRIDIUM_LEGACY_WIFI_MANUFACTURER = "TexasInstruments";
    private static final String TRIDIUM_LEGACY_WIFI_MODEL_NAME = "TI_Connectivity_module";
    private static final String TRIDIUM_LEGACY_WIFI_MODEL_NUMBER = "tiwlan_drv";
    private static final String TRIDIUM_LEGACY_WIFI_SERIAL_NUMBER = "12345";
    private static final String TRIDIUM_LEGACY_HOSTAPD_CONF_MAX_NUM_STA_VALUE = "16";
    private static final String TRIDIUM_LEGACY_WIFI_UNKNOWN = "unknown";
    private static final String TRIDIUM_LEGACY_WIFI_STOPPED = "stopped";
    private static final String TRIDIUM_LEGACY_WIFI_STOPPING = "stopping";
    private static final String TRIDIUM_LEGACY_WIFI_FAILED = "failed";
    public static final String TRIDIUM_LEGACY_WIFI_SAP_PREFIX = "sap_";
    private static final String TRIDIUM_LEGACY_WIFI_SAP_STARTING = "sap_starting";
    private static final String TRIDIUM_LEGACY_WIFI_SAP_RUNNING = "sap_running";
    private static final String TRIDIUM_LEGACY_WIFI_SAP_INACTIVITY = "sap_inactivity";
    public static final String TRIDIUM_LEGACY_WIFI_STA_PREFIX = "sta_";
    private static final String TRIDIUM_LEGACY_WIFI_STA_STARTING = "sta_starting";
    private static final String TRIDIUM_LEGACY_WIFI_STA_SUPPLICANT_RUNNING = "sta_supplicant_running";
    private static final String TRIDIUM_LEGACY_WIFI_STA_DISCONNECTED = "sta_disconnected";
    private static final String TRIDIUM_LEGACY_WIFI_STA_ASSOCIATING = "sta_associating";
    private static final String TRIDIUM_LEGACY_WIFI_STA_ASSOCIATED = "sta_associated";
    private static final String TRIDIUM_LEGACY_WIFI_STA_4WAY_HANDSHAKE = "sta_4way_handshake";
    private static final String TRIDIUM_LEGACY_WIFI_STA_SCANNING = "sta_scanning";
    private static final String TRIDIUM_LEGACY_WIFI_STA_RUNNING = "sta_running";
    private static final String TRIDIUM_LEGACY_WIFI_STA_NOTRUNNABLE = "sta_notRunnable";
    public static final String WIFI_DEFAULT_IP = "192.168.11.1";
    public static final String WIFI_DEFAULT_SUBNET_MASK = "255.255.255.0";
    public static final int WIFI_MIN_DHCP_CLIENTS = 1;
    public static final int WIFI_MAX_DHCP_CLIENTS = 8;
    private static final int WIFI_BAND_CONFIG_MAX_TOKEN_COUNT = 20;
    private static final int WIFI_BAND_CONFIG_REGION_FCC_ORDINAL = 1;
    private static final int WIFI_BAND_CONFIG_REGION_ETSI_ORDINAL = 2;
    private static final int WIFI_BAND_CONFIG_REGION_JP_ORDINAL = 3;
    private static final String WIFI_BAND_CONFIG_REGION_NONE_NAME = "NONE";
    private static final String WIFI_BAND_CONFIG_REGION_FCC_NAME = "FCC";
    private static final String WIFI_BAND_CONFIG_REGION_ETSI_NAME = "ETSI";
    private static final String WIFI_BAND_CONFIG_REGION_JP_NAME = "JP";
    private static final int WIFI_BAND_CONFIG_49GHZ_CHANNEL_START = 184;
    public static final String MAC_ADDRESS_SLOT_NAME_PREFIX = "mac";
    public static final String CHANNEL_SLOT_NAME_FORMAT = "b_%s_c_%s";
    public static final String ABSOLUTE_ALLOW_LIST_FILE_PATH_SLOT_NAME = "sapAllowListFileAbsolute";
    private static final String DHCPD_CONF_DEFAULT_LEASE_TIME = "default-lease-time";
    private static final String DHCPD_CONF_MAX_LEASE_TIME = "max-lease-time";
    private static final String DHCPD_CONF_SUBNET = "subnet";
    private static final String DESCRIPTION = "#Niagara Wi-Fi configuration file";
    private static final String MODIFY_WARNING = "#Do not modify, use the Wi-Fi Configuration UI to make changes to this file";
    private static final String CREATED = "#Created: ";
    private static final String WPA_SUPPLICANT_CONF_CTRL_INTERFACE = "ctrl_interface";
    private static final String WPA_SUPPLICANT_CONF_UPDATE_CONFIG = "update_config";
    private static final String WPA_SUPPLICANT_CONF_DEVICE_NAME = "device_name";
    private static final String WPA_SUPPLICANT_CONF_MANUFACTURER = "manufacturer";
    private static final String WPA_SUPPLICANT_CONF_MODEL_NAME = "model_name";
    private static final String WPA_SUPPLICANT_CONF_MODEL_NUMBER = "model_number";
    private static final String WPA_SUPPLICANT_CONF_SERIAL_NUMBER = "serial_number";
    private static final String WPA_SUPPLICANT_CONF_P2P_DISABLED = "p2p_disabled";
    private static final String WPA_SUPPLICANT_CONF_NETWORK = "network";
    private static final String WPA_SUPPLICANT_CONF_SSID = "ssid";
    private static final String WPA_SUPPLICANT_CONF_PROTO = "proto";
    private static final String WPA_SUPPLICANT_CONF_KEY_MGMT = "key_mgmt";
    private static final String WPA_SUPPLICANT_CONF_PAIRWISE = "pairwise";
    private static final String WPA_SUPPLICANT_CONF_GROUP = "group";
    private static final String WPA_SUPPLICANT_CONF_PSK = "psk";
    private static final String WPA_SUPPLICANT_CONF_SAE_PASSWORD = "sae_password";
    private static final String WPA_SUPPLICANT_CONF_SCAN_SSID = "scan_ssid";
    private static final String WPA_SUPPLICANT_CONF_PRIORITY = "priority";
    private static final String WPA_SUPPLICANT_CONF_DISABLED = "disabled";
    private static final String WPA_SUPPLICANT_CONF_AUTH_ALG = "auth_alg";
    private static final String WPA_SUPPLICANT_CONF_IEEE80211W = "ieee80211w";
    private static final String WPA_SUPPLICANT_CONF_AUTH_ALG_OPEN_VALUE = "OPEN";
    private static final String WPA_SUPPLICANT_CONF_KEY_MGMT_SAE_VALUE = "SAE";
    private static final String HOSTAPD_CONF_IEEE80211_COMMENT = "### IEEE 802.11";
    private static final String HOSTAPD_CONF_IEEE80211I_COMMENT = "### WPA/IEEE 802.11i";
    private static final String HOSTAPD_CONF_IEEE80211N_COMMENT = "### IEEE 802.11n";
    private static final String HOSTAPD_CONF_LOGGER_COMMENT = "### hostapd event logger configuration";
    private static final String HOSTAPD_CONF_MULTIMEDIA_COMMENT = "### WMM";
    private static final String HOSTAPD_CONF_ALLOW_LIST_COMMON = "### allow list/deny list";
    private static final String HOSTAPD_CONF_DFS_COMMENT = "### DFS";
    private static final String HOSTAPD_CONF_CTRL_INTERFACE = "ctrl_interface";
    private static final String HOSTAPD_CONF_CTRL_INTERFACE_GROUP = "ctrl_interface_group";
    private static final String HOSTAPD_CONF_INTERFACE = "interface";
    private static final String HOSTAPD_CONF_DRIVER = "driver";
    private static final String HOSTAPD_CONF_SSID = "ssid";
    static final String HOSTAPD_CONF_CHANNEL = "channel";
    private static final String HOSTAPD_CONF_MAX_NUM_STA = "max_num_sta";
    private static final String HOSTAPD_CONF_MAX_NUM_STA_VALUE = "8";
    private static final String HOSTAPD_CONF_AUTH_ALGS = "auth_algs";
    private static final String HOSTAPD_CONF_DISASSOC_LOW_ACK = "disassoc_low_ack";
    private static final String HOSTAPD_CONF_IGNORE_BROADCAST_SSID = "ignore_broadcast_ssid";
    private static final String HOSTAPD_CONF_PREAMBLE = "preamble";
    static final String HOSTAPD_CONF_HW_MODE = "hw_mode";
    static final String HOSTAPD_CONF_IEEE_802_11A = "a";
    static final String HOSTAPD_CONF_IEEE_802_11B = "b";
    static final String HOSTAPD_CONF_IEEE_802_11G = "g";
    private static final String HOSTAPD_CONF_IEEE_802_11N = "n";
    private static final String HOSTAPD_CONF_DTIM_PERIOD = "dtim_period";
    private static final String HOSTAPD_CONF_BEACON_INT = "beacon_int";
    private static final String HOSTAPD_CONF_BEACON_INT_VALUE = "100";
    private static final String HOSTAPD_CONF_IEEE8021D = "ieee80211d";
    private static final String HOSTAPD_CONF_IEEE8021H = "ieee80211h";
    private static final String HOSTAPD_CONF_COUNTRY_CODE = "country_code";
    private static final String HOSTAPD_CONF_IEEE8021N = "ieee80211n";
    private static final String HOSTAPD_CONF_BASIC_RATES = "basic_rates";
    private static final String HOSTAPD_CONF_SUPPORTED_RATES = "supported_rates";
    private static final String HOSTAPD_CONF_BASIC_RATES_IEEE80211A = "60 90 120 180 240 360 480 540";
    private static final String HOSTAPD_CONF_BASIC_RATES_IEEE80211B = "10 20 55 110";
    private static final String HOSTAPD_CONF_BASIC_RATES_IEEE80211G = "10 20 55 110 60 90 120 180 240 360 480 540";
    private static final String HOSTAPD_CONF_BASIC_RATES_IEEE80211N = "60 120 240";
    private static final String HOSTAPD_CONF_SUPPORTED_RATES_IEEE80211N = "60 90 120 180 240 360 480 540";
    private static final String HOSTAPD_CONF_WPA = "wpa";
    private static final String HOSTAPD_CONF_WPA_KEY_MGMT = "wpa_key_mgmt";
    private static final String HOSTAPD_CONF_IEEE80211W = "ieee80211w";
    private static final String HOSTAPD_CONF_KEY_MGMT_SAE_VALUE = "SAE";
    private static final String HOSTAPD_CONF_WPA_PAIRWISE = "wpa_pairwise";
    private static final String HOSTAPD_CONF_WPA_GROUP_REKEY = "wpa_group_rekey";
    private static final String HOSTAPD_CONF_WPA_STRICT_REKEY = "wpa_strict_rekey";
    private static final String HOSTAPD_CONF_WPA_GMK_REKEY = "wpa_gmk_rekey";
    private static final String HOSTAPD_CONF_WPA_PTK_REKEY = "wpa_ptk_rekey";
    private static final String HOSTAPD_CONF_WPA_PSK = "wpa_psk";
    private static final String HOSTAPD_CONF_WPA_PASSPHRASE = "wpa_passphrase";
    private static final String HOSTAPD_CONF_SAE_PASSWORD = "sae_password";
    private static final String HOSTAPD_CONF_LOGGER_SYSLOG = "logger_syslog";
    private static final String HOSTAPD_CONF_LOGGER_SYSLOG_LEVEL = "logger_syslog_level";
    private static final String HOSTAPD_CONF_LOGGER_STDOUT = "logger_stdout";
    private static final String HOSTAPD_CONF_LOGGER_STDOUT_LEVEL = "logger_stdout_level";
    private static final String HOSTAPD_CONF_DUMP_FILE = "dump_file";
    private static final String HOSTAPD_CONF_WMM_ENABLED = "wmm_enabled";
    private static final String HOSTAPD_CONF_UAPSD_ADVERTISEMENT_ENABLED = "uapsd_advertisement_enabled";
    private static final String HOSTAPD_CONF_MACADDR_ACL = "macaddr_acl";
    private static final String HOSTAPD_CONF_ACCEPT_MAC_FILE = "accept_mac_file";
    static final String HOSTAPD_CONF_HT_CAPAB = "ht_capab";
    static final String HOSTAPD_CONF_SHORT_GI_20 = "[SHORT-GI-20]";
    static final String HOSTAPD_CONF_HT_20 = "[HT20]";
    static final String HOSTAPD_CONF_SHORT_GI_40 = "[SHORT-GI-40]";
    static final String HOSTAPD_CONF_HT_40 = "[HT40-]";
    private static final String TRIDIUM_LEGACY_WIFI_CLIENT_ADAPTER_ID = "[en2]";
    private static final String TRIDIUM_LEGACY_WIFI_HOST_ADAPTER_ID = "[en3]";
    private static final String NET_CFG_SECTION_REGEX = "\\[\\S+\\]";
    private static final String NET_CFG_TYPE = "type";
    private static final String NET_CFG_MODE = "mode";
    private static final String NET_CFG_MODE6 = "mode6";
    private static final String NET_CFG_OSNAME = "osname";
    private static final String NET_CFG_MANUAL = "manual";
    private static final String NET_CFG_AUTO = "auto";
    private static final String NET_CFG_DHCP = "dhcp";
    private static final String NET_CFG_MANUAL_IP = "manual_ip";
    private static final String NET_CFG_MANUAL_NETMASK = "manual_netmask";
    private static final String NET_CFG_WIFI = "wifi";
    public static final String SAVE_TYPE_NONE = "wifiSaveNone";
    public static final String SAVE_TYPE_ALL = "wifiSaveAll";
    public static final String SAVE_TYPE_SUPPLICANT = "wifiSaveSupplicant";
    public static final String SAVE_TYPE_HOSTAPD = "wifiSaveHostapd";
    public static final String SAVE_TYPE_WIFINETCFG = "wifiSaveWifinetcfg";
    public static final String SAVE_TYPE_DHCPD = "wifiSaveDhcpd";

    private WifiUtil() {
    }

    public static void loadFromSession(BWifiSettings wifiSettings, BDaemonSession daemonSession) throws Exception {
        boolean isTridiumQNX;
        Object supplicantConfFilePath;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        if (!WifiUtil.supportsWiFi(daemonSession)) {
            throw new UnsupportedOperationException("Wi-Fi is not supported on platform");
        }
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading Wi-Fi XML settings from daemon session...");
            start = Clock.ticks();
        }
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetWiFiSettingsMessage(servletType));
        XElem wifiSettingsElem = XParser.make((InputStream)xmlStream).parse();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using Wi-Fi servlet XML:");
            wifiSettingsElem.dump();
        }
        wifiSettings.setWifiEnabled(wifiSettingsElem.getb("wifiEnabled", false));
        if (servletType == WiFiServletType.wifi) {
            wifiSettings.setWifiReadonly(wifiSettingsElem.getb("wifiReadonly", false));
            wifiSettings.setWifiRequiresReboot(wifiSettingsElem.getb("wifiRequiresReboot", false));
            wifiSettings.setWifiSwitchType(BWifiSwitchTypeEnum.make(wifiSettingsElem.geti("wifiSwitchType", 0)));
        } else {
            wifiSettings.setWifiReadonly(false);
            wifiSettings.setWifiRequiresReboot(false);
            wifiSettings.setWifiSwitchType(BWifiSwitchTypeEnum.hardware);
        }
        BWifiMonitorData wifiMonitorData = wifiSettings.getMonitorData();
        wifiMonitorData.setWifiSwitchPosition(BWifiSwitchEnum.make(wifiSettingsElem.geti("wifiSwitch", 0)));
        wifiMonitorData.setWifimonState(wifiSettingsElem.get("wifimonState"));
        wifiMonitorData.setWifiEnabled(wifiSettingsElem.getb("wifiEnabled", false));
        XElem stationSettingsElem = wifiSettingsElem.elem("stationSettings");
        if (stationSettingsElem == null) {
            throw new Exception("Missing stationSettings element");
        }
        wifiSettings.setStaAdapterName(stationSettingsElem.get("staAdapter"));
        if (servletType == WiFiServletType.wifi) {
            wifiSettings.setStaConfigurationFilePath(stationSettingsElem.get("staConfigurationFile"));
        } else {
            wifiSettings.setStaConfigurationFilePath(TRIDIUM_LEGACY_WIFI_WPA_SUPPLICANT_FILE_PATH);
        }
        wifiSettings.setStaWpaSupplicantState(BWifiSupplicantStateEnum.make(stationSettingsElem.geti("wpa_state", 0)));
        wifiSettings.setStaCurrentNetworkSsid(stationSettingsElem.get("ssid", ""));
        wifiSettings.setStaCurrentNetworkAddress(stationSettingsElem.get("address", ""));
        wifiSettings.setStaCurrentNetworkIpAddress(stationSettingsElem.get("ip_address", ""));
        wifiSettings.setStaSwitchDefaultGateway(stationSettingsElem.getb("gwswitch", false));
        XElem accessPointSettingsElem = wifiSettingsElem.elem("accessPointSettings");
        if (accessPointSettingsElem == null) {
            throw new Exception("Missing accessPointSettings element");
        }
        wifiSettings.setSapAdapterName(accessPointSettingsElem.get("sapAdapter", ""));
        if (servletType == WiFiServletType.wifi) {
            wifiSettings.setSapConfigurationFilePath(accessPointSettingsElem.get("sapConfigurationFile"));
            wifiSettings.setAllowListFilePath(accessPointSettingsElem.get("sapAllowListFile"));
        } else {
            wifiSettings.setSapConfigurationFilePath(TRIDIUM_LEGACY_WIFI_HOSTAPD_FILE_PATH);
            wifiSettings.setAllowListFilePath(TRIDIUM_LEGACY_WIFI_ALLOW_LIST_PATH);
        }
        wifiSettings.setSapTimeout(BRelTime.makeMinutes((int)accessPointSettingsElem.geti("sap_to", 10)));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of Wi-Fi XML settings from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
        try (PBEEncodingKey pbeEncodingKey = PBEEncodingKey.random();
             BCachedDaemonFileSpace space = BCachedDaemonFileSpace.make((BDaemonSession)daemonSession, (PBEEncodingKey)pbeEncodingKey);){
            BIFile hostapdFile;
            BIFile wpaSupplicantFile;
            supplicantConfFilePath = new FilePath(wifiSettings.getStaConfigurationFilePath());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Retrieving Wi-Fi client configuration file at '" + supplicantConfFilePath + "'");
                start = Clock.ticks();
            }
            if ((wpaSupplicantFile = space.findFile((FilePath)supplicantConfFilePath)) != null) {
                PBEDecryptingInputStream decryptedWpaSupplicantInputStream = new PBEDecryptingInputStream(wpaSupplicantFile.getInputStream(), pbeEncodingKey);
                BSupplicantNetBlockVector blocks = wifiSettings.getSupplicantNetworkBlocks();
                WifiUtil.wpaSupplicantConfToWifiSettings(blocks, (InputStream)decryptedWpaSupplicantInputStream);
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Wi-Fi client configuration file '" + supplicantConfFilePath + "' not found, using defaults");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Load of Wi-Fi client configuration file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
            }
            FilePath hostapdConfFilePath = new FilePath(wifiSettings.getSapConfigurationFilePath());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Retrieving Wi-Fi host configuration file at '" + hostapdConfFilePath + "'");
                start = Clock.ticks();
            }
            if ((hostapdFile = space.findFile(hostapdConfFilePath)) != null) {
                PBEDecryptingInputStream decryptedHostapdInputStream = new PBEDecryptingInputStream(hostapdFile.getInputStream(), pbeEncodingKey);
                WifiUtil.hostapdConfToWifiSettings(wifiSettings, (InputStream)decryptedHostapdInputStream);
                if (servletType == WiFiServletType.qnxwifi && wifiSettings.getSapWpaKeyMgmt() != BHapdKeyManagementEnum.wpaPsk) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Migrating unsupported access point key management scheme '" + (Object)((Object)wifiSettings.getSapWpaKeyMgmt()) + "' to '" + (Object)((Object)BHapdKeyManagementEnum.wpaPsk) + "' for legacy Wi-Fi environment");
                    }
                    wifiSettings.setSapWpaKeyMgmt(BHapdKeyManagementEnum.wpaPsk);
                }
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Wi-Fi host configuration file '" + supplicantConfFilePath + "' not found, using defaults");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Load of Wi-Fi host configuration file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
            }
            if (servletType == WiFiServletType.wifi) {
                String cidrFormat = accessPointSettingsElem.get("ip_address");
                String[] ipAddressAndSubnetMask = WifiUtil.cidrToIpAddressAndSubnetMask(cidrFormat);
                wifiSettings.setSapAdapterIp(ipAddressAndSubnetMask[0]);
                wifiSettings.setSapAdapterNetmask(ipAddressAndSubnetMask[1]);
            } else {
                BIFile wifiNetCfgFile;
                FilePath wifiNetCfgFilePath = new FilePath(TRIDIUM_LEGACY_WIFI_WIFI_NET_CFG_FILE_PATH);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Retrieving Wi-Fi network configuration file at '" + wifiNetCfgFilePath + "'");
                    start = Clock.ticks();
                }
                if ((wifiNetCfgFile = space.findFile(wifiNetCfgFilePath)) != null) {
                    PBEDecryptingInputStream decryptedWiFiNetworkConfInputStream = new PBEDecryptingInputStream(wifiNetCfgFile.getInputStream(), pbeEncodingKey);
                    WifiUtil.wifiNetCfgToWifiSettings(wifiSettings, (InputStream)decryptedWiFiNetworkConfInputStream);
                } else if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Wi-Fi network configuration file '" + supplicantConfFilePath + "' not found, using defaults");
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Load of Wi-Fi network configuration file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
                }
            }
        }
        xmlStream = daemonSession.getInputStream((DaemonMessage)new GetTcpIpMessage());
        TcpUtil.updateFields((BTcpIpHostSettings)wifiSettings.getTcpIpHostSettings(), (XElem)XParser.make((InputStream)xmlStream).parse());
        if (daemonSession.getHostProperties().supportsServlet("dhcpd")) {
            DhcpdUtil.loadFromSessionWiFi((BDhcpdHostSettings)wifiSettings.getDhcpdHostSettings(), (BDaemonSession)daemonSession);
        } else {
            if (servletType == WiFiServletType.wifi) {
                throw new UnsupportedOperationException("DHCP server is not supported on platform");
            }
            if (servletType == WiFiServletType.qnxwifi) {
                BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
                dhcpdHostSettings.getDhcpdSubnets().removeAll();
                BDhcpdAdapterSettings dhcpdAdapterSettings = new BDhcpdAdapterSettings();
                dhcpdAdapterSettings.setAdapterId(TRIDIUM_LEGACY_WIFI_SAP_ADAPTER);
                dhcpdAdapterSettings.setAdapterOsName(TRIDIUM_LEGACY_WIFI_SAP_ADAPTER);
                dhcpdAdapterSettings.setIsReadOnly(false);
                dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
                dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(true);
                dhcpdHostSettings.setDhcpdServerType(BDhcpdServerType.dhcpd);
                dhcpdHostSettings.setDhcpdConfPath("/opt/niagara/platform/wifi/dhcpd_ti18xx.conf");
                String propName = SlotPath.escape((String)TRIDIUM_LEGACY_WIFI_SAP_ADAPTER);
                dhcpdHostSettings.getDhcpdSubnets().add(propName, (BValue)dhcpdAdapterSettings, 3);
                PBEEncodingKey pbeEncodingKey = PBEEncodingKey.random();
                supplicantConfFilePath = null;
                try (BCachedDaemonFileSpace space2 = BCachedDaemonFileSpace.make((BDaemonSession)daemonSession, (PBEEncodingKey)pbeEncodingKey);){
                    BIFile wifiDhcpdConfFile;
                    FilePath wifiDhcpdConfFilePath = new FilePath("/opt/niagara/platform/wifi/dhcpd_ti18xx.conf");
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Retrieving legacy Wi-Fi dhcpd configuration file at '" + wifiDhcpdConfFilePath + "'");
                        start = Clock.ticks();
                    }
                    if ((wifiDhcpdConfFile = space2.findFile(wifiDhcpdConfFilePath)) != null) {
                        PBEDecryptingInputStream decryptedWiFiDhcpdConfInputStream = new PBEDecryptingInputStream(wifiDhcpdConfFile.getInputStream(), pbeEncodingKey);
                        WifiUtil.legacyDhcpdConfToDhcpdHostSettings(dhcpdHostSettings, propName, (InputStream)decryptedWiFiDhcpdConfInputStream);
                    } else if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Legacy Wi-Fi dhcpd configuration file '" + wifiDhcpdConfFilePath + "' not found, using defaults");
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("Load of legacy Wi-Fi dhcpd configuration file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
                    }
                }
                catch (Throwable space2) {
                    supplicantConfFilePath = space2;
                    throw space2;
                }
                finally {
                    if (pbeEncodingKey != null) {
                        if (supplicantConfFilePath != null) {
                            try {
                                pbeEncodingKey.close();
                            }
                            catch (Throwable space2) {
                                ((Throwable)supplicantConfFilePath).addSuppressed(space2);
                            }
                        } else {
                            pbeEncodingKey.close();
                        }
                    }
                }
            }
        }
        BFacets saveFacets = BFacets.NULL;
        String templateIpAddress = "192.168.11.1";
        String templateSubnetMask = "255.255.255.0";
        int templateMinDhcpClients = 1;
        int templateMaxDhcpClient = 8;
        boolean bl = isTridiumQNX = servletType == WiFiServletType.qnxwifi;
        if (isTridiumQNX) {
            templateIpAddress = "192.168.11.1";
            templateSubnetMask = "255.255.255.0";
            templateMinDhcpClients = 1;
            templateMaxDhcpClient = 16;
        }
        if (WifiUtil.fixSapIpAddress(wifiSettings, templateIpAddress, templateSubnetMask)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Detected access point network discrepancy during load, updating Wi-Fi access point network configuration");
            }
            saveFacets = BFacets.make((BFacets)saveFacets, (BFacets)BFacets.make((String)SAVE_TYPE_WIFINETCFG, (boolean)true));
        }
        if (WifiUtil.fixDhcpdWifiSettings(wifiSettings, templateMinDhcpClients, templateMaxDhcpClient, isTridiumQNX)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Detected access point DHCP server discrepancy during load, updating Wi-Fi DHCP server configuration");
            }
            saveFacets = BFacets.make((BFacets)saveFacets, (BFacets)BFacets.make((String)SAVE_TYPE_DHCPD, (boolean)true));
        }
        if (saveFacets != BFacets.NULL) {
            WifiUtil.saveToSession(wifiSettings, daemonSession, (Context)new BasicContext(null, saveFacets));
        }
    }

    public static void saveToSession(BWifiSettings wifiSettings, BDaemonSession daemonSession, Context context) throws Exception {
        BFacets saveFacets;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        if (!WifiUtil.supportsWiFi(daemonSession)) {
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Remote session '" + daemonSession.getHost() + "' does not support the Wi-Fi servlet, skipping save");
            }
            return;
        }
        BFacets bFacets = saveFacets = context != null ? context.getFacets() : BFacets.NULL;
        if (!WifiUtil.facetsHasWiFiSaveType(saveFacets)) {
            saveFacets = BFacets.make((BFacets)saveFacets, (BFacets)BFacets.make((String)SAVE_TYPE_ALL, (boolean)true));
        }
        boolean writeSupplicantFile = true;
        boolean writeHostapdFile = true;
        boolean writeWiFiNetcfgFile = true;
        boolean writeDhcpdFile = true;
        if (!saveFacets.getb(SAVE_TYPE_ALL, false)) {
            if (saveFacets.getb(SAVE_TYPE_NONE, false)) {
                writeSupplicantFile = false;
                writeHostapdFile = false;
                writeWiFiNetcfgFile = false;
                writeDhcpdFile = false;
            } else {
                writeSupplicantFile = saveFacets.getb(SAVE_TYPE_SUPPLICANT, false);
                writeHostapdFile = saveFacets.getb(SAVE_TYPE_HOSTAPD, false);
                writeWiFiNetcfgFile = saveFacets.getb(SAVE_TYPE_WIFINETCFG, false);
                writeDhcpdFile = saveFacets.getb(SAVE_TYPE_DHCPD, false);
            }
        }
        boolean writeAnyFile = writeSupplicantFile | writeHostapdFile | writeWiFiNetcfgFile | writeDhcpdFile;
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Saving Wi-Fi settings to daemon session...");
            start = Clock.ticks();
        }
        if (writeAnyFile) {
            try (PBEEncodingKey pbeEncodingKey = PBEEncodingKey.random();){
                Throwable throwable;
                FileTransferMessage fileTransferMessage = DaemonClientEncodingInfo.makeMessage((BDaemonSession)daemonSession, (PBEEncodingKey)pbeEncodingKey);
                if (writeSupplicantFile) {
                    String wpaSupplicantConf = WifiUtil.wifiSettingsToWpaSupplicantConf(wifiSettings, servletType);
                    throwable = null;
                    try (ByteArrayInputStream supplicantInputStream = new ByteArrayInputStream(wpaSupplicantConf.getBytes(StandardCharsets.UTF_8));){
                        FilePath wpaSupplicantConfFilePath = new FilePath(wifiSettings.getStaConfigurationFilePath());
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Saving Wi-Fi client configuration file to path '" + wpaSupplicantConfFilePath + "'");
                        }
                        fileTransferMessage.addPBEEncryptedElement((InputStream)supplicantInputStream, wpaSupplicantConfFilePath);
                    }
                    catch (Throwable wpaSupplicantConfFilePath) {
                        throwable = wpaSupplicantConfFilePath;
                        throw wpaSupplicantConfFilePath;
                    }
                }
                if (writeHostapdFile) {
                    String unresolvedAllowListFileString;
                    FilePath unresolvedAllowListFilePath;
                    InputStream xmlInputStream;
                    if (servletType == WiFiServletType.wifi && wifiSettings.get(ABSOLUTE_ALLOW_LIST_FILE_PATH_SLOT_NAME) == null && (xmlInputStream = daemonSession.getInputStream((DaemonMessage)new GetDirectoryMessage((unresolvedAllowListFilePath = new FilePath(unresolvedAllowListFileString = wifiSettings.getAllowListFilePath())).getParent(), false, false, true, (BDaemonFileSpace)daemonSession.getFileSpace()))) != null) {
                        String allowListParentFilePath;
                        XElem allowListParentPathElem = XParser.make((InputStream)xmlInputStream).parse();
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Using Wi-Fi directory in allow list file path creation:");
                            allowListParentPathElem.dump();
                        }
                        char remoteFileSeparatorChar = (allowListParentFilePath = allowListParentPathElem.get("path")).contains("\\") ? (char)'\\' : '/';
                        String resolvedAllowListFilePath = allowListParentFilePath + remoteFileSeparatorChar + unresolvedAllowListFilePath.getName();
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Using absolute path of allow list '" + resolvedAllowListFilePath + "'");
                        }
                        wifiSettings.add(ABSOLUTE_ALLOW_LIST_FILE_PATH_SLOT_NAME, (BValue)BString.make((String)resolvedAllowListFilePath));
                    }
                    String hostapdConf = WifiUtil.wifiSettingsToHostapdConf(wifiSettings, servletType);
                    throwable = null;
                    try (ByteArrayInputStream hostapdInputStream = new ByteArrayInputStream(hostapdConf.getBytes(StandardCharsets.UTF_8));){
                        FilePath hostapdConfFilePath = new FilePath(wifiSettings.getSapConfigurationFilePath());
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.finest("Saving Wi-Fi host configuration file to path '" + hostapdConfFilePath + "'");
                        }
                        fileTransferMessage.addPBEEncryptedElement((InputStream)hostapdInputStream, hostapdConfFilePath);
                    }
                    catch (Throwable hostapdConfFilePath) {
                        throwable = hostapdConfFilePath;
                        throw hostapdConfFilePath;
                    }
                }
                if (writeWiFiNetcfgFile) {
                    if (servletType == WiFiServletType.wifi) {
                        String cidrFormat = WifiUtil.ipAddressAndSubnetMaskToCIDR(wifiSettings.getSapAdapterIp(), wifiSettings.getSapAdapterNetmask());
                        if (!daemonSession.sendMessage((DaemonMessage)new SetIPAddressMessage(servletType, cidrFormat))) {
                            throw new BajaRuntimeException("Failed to update Wi-Fi access point IP address");
                        }
                    } else {
                        String wifiNetCfg = WifiUtil.wifiSettingsToWifiNetCfg(wifiSettings);
                        throwable = null;
                        try (ByteArrayInputStream dhcpdInputStream = new ByteArrayInputStream(wifiNetCfg.getBytes(StandardCharsets.UTF_8));){
                            FilePath wifiNetCfgFilePath = new FilePath(TRIDIUM_LEGACY_WIFI_WIFI_NET_CFG_FILE_PATH);
                            if (LOG.isLoggable(Level.FINEST)) {
                                LOG.finest("Saving Wi-Fi network configuration file to path '" + wifiNetCfgFilePath + "'");
                            }
                            fileTransferMessage.addPBEEncryptedElement((InputStream)dhcpdInputStream, wifiNetCfgFilePath);
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                    }
                }
                if (writeDhcpdFile) {
                    BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
                    if (LOG.isLoggable(Level.FINEST)) {
                        FilePath dhcpdConfPath = new FilePath(dhcpdHostSettings.getDhcpdConfPath());
                        LOG.finest("Saving Wi-Fi DHCP server configuration file to path '" + dhcpdConfPath + "'");
                    }
                    DhcpdUtil.saveToSessionNoTransfer((BDhcpdHostSettings)dhcpdHostSettings, (BDaemonSession)daemonSession, (FileTransferMessage)fileTransferMessage);
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Starting file transfer for host...");
                }
                if (!DaemonFileUtil.transfer((BDaemonSession)daemonSession, (FileTransferMessage)fileTransferMessage, null)) {
                    throw new BajaRuntimeException("Failed to save Wi-Fi settings");
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("File transfer for host complete");
                }
            }
        }
        if (!daemonSession.sendMessage((DaemonMessage)new SetSapTimeoutMessage(servletType, wifiSettings.getSapTimeout().getMinutes()))) {
            throw new BajaRuntimeException("Failed to update Wi-Fi access point timeout");
        }
        if (writeSupplicantFile && wifiSettings.getMonitorData().getWifiSwitchPosition() == BWifiSwitchEnum.station && !daemonSession.sendMessage((DaemonMessage)new ReconfigureNetworksMessage(servletType))) {
            throw new BajaRuntimeException("Failed to reconfigure Wi-Fi Host Settings");
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Save of Wi-Fi settings to daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static boolean supportsWiFi(BDaemonSession daemonSession) {
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        BHostProperties hostProperties = daemonSession.getHostProperties();
        return hostProperties.supportsServlet("qnxwifi") || hostProperties.supportsServlet(NET_CFG_WIFI);
    }

    public static WiFiServletType getWiFiServletType(BDaemonSession daemonSession) {
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        BVector remoteServlets = daemonSession.getHostProperties().getServletNames();
        if (remoteServlets.getProperty("qnxwifi") != null) {
            return WiFiServletType.qnxwifi;
        }
        if (remoteServlets.getProperty(NET_CFG_WIFI) != null) {
            return WiFiServletType.wifi;
        }
        throw new UnsupportedOperationException("Wi-Fi is not supported on platform");
    }

    public static void monitorDataFromSession(BWifiMonitorData wifiMonitorData, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(wifiMonitorData, "wifiMonitorData argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading Wi-Fi XML monitor data from daemon session...");
            start = Clock.ticks();
        }
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetWiFiMonitorDataMessage(servletType.name()));
        XElem monitorDataElem = XParser.make((InputStream)xmlStream).parse();
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Using Wi-Fi monitor XML:");
            monitorDataElem.dump();
        }
        wifiMonitorData.setWifiSwitchPosition(BWifiSwitchEnum.make(monitorDataElem.geti("wifiSwitch", 0)));
        wifiMonitorData.setWifimonState(monitorDataElem.get("wifimonState"));
        wifiMonitorData.setWifiEnabled(monitorDataElem.getb("wifiEnabled", false));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of Wi-Fi XML monitor data from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static BWifiNetworkVector discoverFromSession(String adapter, BDaemonSession daemonSession, long scanResultsPauseMs) throws Exception {
        Objects.requireNonNull(adapter, "adapter argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        if (scanResultsPauseMs < 0L || scanResultsPauseMs > 10000L) {
            throw new IllegalArgumentException("scanResultsPauseMs is not valid");
        }
        BWifiNetworkVector resultVector = new BWifiNetworkVector();
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new ScanMessage(servletType, adapter));
        XElem scanElem = XParser.make((InputStream)xmlStream).parse();
        int statusCode = scanElem.geti(STATUS_CODE, 400);
        if (statusCode != 200) {
            LOG.warning("Failed to send initial scan message, returning empty result (statusCode = " + statusCode + ")");
            return resultVector;
        }
        try {
            Thread.sleep(scanResultsPauseMs);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        xmlStream = daemonSession.getInputStream((DaemonMessage)new GetScanResultsMessage(servletType, adapter), 10000);
        XElem scanResultsElem = XParser.make((InputStream)xmlStream).parse();
        if (scanResultsElem.geti("wifiNetworks", 0) > 0) {
            XElem[] scanResultsElems;
            for (XElem scanResultElem : scanResultsElems = scanResultsElem.elems("wifiNetwork")) {
                String networkDescription = scanResultElem.get("description", null);
                try {
                    BWifiNetwork wifiNetwork = BWifiNetwork.makeNetwork(networkDescription);
                    resultVector.add(SlotPath.escape((String)wifiNetwork.getBssid()), (BValue)wifiNetwork, 3, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:WifiNetworkEditor")), null);
                }
                catch (Exception exception) {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.WARNING, "Failed to parse or add discovered network from scan_result '" + networkDescription + "', skipping result", exception);
                        continue;
                    }
                    LOG.log(Level.WARNING, "Failed to parse or add discovered network from scan_result '" + networkDescription + "', skipping result (" + exception + ")");
                }
            }
        }
        return resultVector;
    }

    public static void clientListFromSession(BWifiClientListVector wifiClientListVector, BDaemonSession daemonSession) throws Exception {
        XElem[] clientElems;
        Objects.requireNonNull(wifiClientListVector, "wifiClientListVector argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        wifiClientListVector.removeAll();
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetClientListMessage(servletType));
        XElem clientListElem = XParser.make((InputStream)xmlStream).parse();
        for (XElem clientElem : clientElems = clientListElem.elems("client")) {
            String mac = clientElem.get(MAC_ADDRESS_SLOT_NAME_PREFIX);
            String time = clientElem.get("time");
            BWifiClientListEntry entry = new BWifiClientListEntry(mac, time);
            wifiClientListVector.add("mac?", (BValue)entry);
        }
    }

    public static void channelListFromSession(BWifiChannelListVector wifiChannelListVector, BDaemonSession daemonSession, String countryCode) throws Exception {
        XElem[] entryElems;
        Objects.requireNonNull(wifiChannelListVector, "wifiChannelListVector argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        Objects.requireNonNull(countryCode, "countryCode argument cannot be null");
        wifiChannelListVector.removeAll();
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetChannelListMessage(servletType, countryCode));
        XElem channelListElem = XParser.make((InputStream)xmlStream).parse();
        String responseCountryCode = channelListElem.get("countryCode");
        for (XElem entryElem : entryElems = channelListElem.elems("entry")) {
            String bandConfigLine = entryElem.get("bandConfig");
            WifiUtil.channelListEntryFromString(wifiChannelListVector, bandConfigLine, responseCountryCode);
        }
    }

    public static void countryListFromSession(ArrayList<String> countryList, BDaemonSession daemonSession) throws Exception {
        XElem[] countryElems;
        Objects.requireNonNull(countryList, "countryList argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        countryList.clear();
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetCountryListMessage(servletType));
        XElem countryListElem = XParser.make((InputStream)xmlStream).parse();
        for (XElem countryElem : countryElems = countryListElem.elems("country")) {
            String code = countryElem.get("code");
            String name = countryElem.get("name");
            countryList.add(code + "-" + name);
        }
    }

    public static boolean wifiEnabledToSession(boolean wifiEnabled, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new SetWiFiEnabledMessage(servletType, wifiEnabled));
        XElem wifiEnabledElem = XParser.make((InputStream)xmlStream).parse();
        return wifiEnabledElem.geti(STATUS_CODE, 400) == 200;
    }

    public static boolean wifiSwitchPositionToSession(BWifiSwitchEnum wifiSwitchEnum, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(wifiSwitchEnum, "wifiSwitchEnum argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new SetWiFiSwitchPositionMessage(servletType, wifiSwitchEnum));
        XElem wifiSwitchPositionElem = XParser.make((InputStream)xmlStream).parse();
        return wifiSwitchPositionElem.geti(STATUS_CODE, 400) == 200;
    }

    public static String countryCodeFromSession(BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetCountryCodeMessage(servletType));
        XElem countryCodeElem = XParser.make((InputStream)xmlStream).parse();
        return countryCodeElem.get("cc");
    }

    public static boolean countryCodeToSession(String countryCode, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(countryCode, "countryCode argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new SetCountryCodeMessage(servletType, countryCode));
        XElem countryCodeElem = XParser.make((InputStream)xmlStream).parse();
        return countryCodeElem.geti(STATUS_CODE, 400) == 200;
    }

    public static String wifiSkuFromSession(BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new GetWifiSkuMessage(servletType));
        XElem skuElem = XParser.make((InputStream)xmlStream).parse();
        return skuElem.get("sku");
    }

    public static boolean connectFromSession(String adapter, String networkId, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(adapter, "adapter argument cannot be null");
        Objects.requireNonNull(networkId, "networkId argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new ConnectNetworkMessage(servletType, adapter, networkId));
        XElem connectNetworkElem = XParser.make((InputStream)xmlStream).parse();
        return connectNetworkElem.geti(STATUS_CODE, 400) == 200;
    }

    public static boolean disconnectFromSession(String adapter, BDaemonSession daemonSession) throws Exception {
        Objects.requireNonNull(adapter, "adapter argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        WiFiServletType servletType = WifiUtil.getWiFiServletType(daemonSession);
        InputStream xmlStream = daemonSession.getInputStream((DaemonMessage)new DisconnectNetworkMessage(servletType, adapter));
        XElem disconnectNetworkElem = XParser.make((InputStream)xmlStream).parse();
        return disconnectNetworkElem.geti(STATUS_CODE, 400) == 200;
    }

    public static void wpaSupplicantConfToWifiSettings(BSupplicantNetBlockVector supplicantNetBlockVector, InputStream inputStream) throws Exception {
        Objects.requireNonNull(supplicantNetBlockVector, "supplicantNetBlockVector argument cannot be null");
        Objects.requireNonNull(inputStream, "inputStream argument cannot be null");
        supplicantNetBlockVector.removeAll();
        String wpaSupplicantLinesAsString = FileUtil.readString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String[] wpaSupplicantLines = TextUtil.split((String)wpaSupplicantLinesAsString, (char)'\n');
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder obscuredSettingsBuilder = new StringBuilder();
            for (String settingToLog : wpaSupplicantLines) {
                if (settingToLog.contains("psk=") || settingToLog.contains("sae_password=")) {
                    obscuredSettingsBuilder.append(TAB);
                    if (settingToLog.contains(WPA_SUPPLICANT_CONF_PSK)) {
                        obscuredSettingsBuilder.append(WPA_SUPPLICANT_CONF_PSK);
                    } else if (settingToLog.contains("sae_password")) {
                        obscuredSettingsBuilder.append("sae_password");
                    }
                    obscuredSettingsBuilder.append(EQUALS).append("[obscured]").append(NEWLINE);
                    continue;
                }
                obscuredSettingsBuilder.append(settingToLog).append(NEWLINE);
            }
            LOG.finest("wpaSupplicantConfToWifiSettings creating Wi-Fi settings from string:\n" + obscuredSettingsBuilder);
        }
        int currentLineNumber = 0;
        while (currentLineNumber < wpaSupplicantLines.length) {
            String wpaSupplicantLine = wpaSupplicantLines[currentLineNumber].trim();
            if (!wpaSupplicantLine.startsWith("network={")) {
                ++currentLineNumber;
                continue;
            }
            BSupplicantNetBlock networkBlock = new BSupplicantNetBlock();
            ++currentLineNumber;
            while (currentLineNumber < wpaSupplicantLines.length && !(wpaSupplicantLine = wpaSupplicantLines[currentLineNumber].trim()).startsWith(CLOSE_BRACE)) {
                if (wpaSupplicantLine.isEmpty() || wpaSupplicantLine.startsWith(COMMENT)) {
                    ++currentLineNumber;
                    continue;
                }
                if (wpaSupplicantLine.endsWith(EQUALS)) {
                    ++currentLineNumber;
                    continue;
                }
                String[] keyValuePair = TextUtil.split((String)wpaSupplicantLine, (char)'=');
                switch (keyValuePair[0]) {
                    case "ssid": {
                        networkBlock.setSsid(WifiUtil.unquote(keyValuePair[1]));
                        break;
                    }
                    case "proto": {
                        networkBlock.setProto(keyValuePair[1]);
                        break;
                    }
                    case "key_mgmt": {
                        networkBlock.setKey_mgmt(keyValuePair[1]);
                        break;
                    }
                    case "pairwise": {
                        networkBlock.setPairwise(keyValuePair[1]);
                        break;
                    }
                    case "group": {
                        networkBlock.setGroup(keyValuePair[1]);
                        break;
                    }
                    case "psk": {
                        networkBlock.setPsk(BPassword.make((String)WifiUtil.unquote(keyValuePair[1])));
                        break;
                    }
                    case "scan_ssid": {
                        networkBlock.setScan_ssid(Integer.parseInt(keyValuePair[1]));
                        break;
                    }
                    case "priority": {
                        networkBlock.setPriority(Integer.parseInt(keyValuePair[1]));
                        break;
                    }
                    case "disabled": {
                        networkBlock.setDisabled(!"0".equals(keyValuePair[1]));
                    }
                }
                ++currentLineNumber;
            }
            ++currentLineNumber;
            String propName = SlotPath.escape((String)networkBlock.getSsid());
            if (supplicantNetBlockVector.get(propName) != null) continue;
            supplicantNetBlockVector.add(propName, (BValue)networkBlock, 3);
        }
    }

    public static String wifiSettingsToWpaSupplicantConf(BWifiSettings wifiSettings, WiFiServletType servletType) {
        BSupplicantNetBlock[] supplicantNetBlocks;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        Objects.requireNonNull(servletType, "servletType argument cannot be null");
        StringBuilder wpaSupplicantContents = new StringBuilder();
        wpaSupplicantContents.append(DESCRIPTION).append(NEWLINE);
        wpaSupplicantContents.append(MODIFY_WARNING).append(NEWLINE);
        wpaSupplicantContents.append(CREATED).append(BAbsTime.now()).append(NEWLINE);
        wpaSupplicantContents.append(NEWLINE);
        if (servletType == WiFiServletType.qnxwifi) {
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", "ctrl_interface", TRIDIUM_LEGACY_WIFI_WPA_SUPPLICANT_CTRL_PATH);
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_UPDATE_CONFIG, "1");
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_DEVICE_NAME, TRIDIUM_LEGACY_WIFI_DEVICE_NAME);
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_MANUFACTURER, TRIDIUM_LEGACY_WIFI_MANUFACTURER);
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_MODEL_NAME, TRIDIUM_LEGACY_WIFI_MODEL_NAME);
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_MODEL_NUMBER, TRIDIUM_LEGACY_WIFI_MODEL_NUMBER);
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_SERIAL_NUMBER, TRIDIUM_LEGACY_WIFI_SERIAL_NUMBER);
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_P2P_DISABLED, "1");
            wpaSupplicantContents.append(NEWLINE);
        }
        BSupplicantNetBlockVector supplicantNetBlockVector = wifiSettings.getSupplicantNetworkBlocks();
        for (BSupplicantNetBlock supplicantNetBlock : supplicantNetBlocks = (BSupplicantNetBlock[])supplicantNetBlockVector.getChildren(BSupplicantNetBlock.class)) {
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, "", WPA_SUPPLICANT_CONF_NETWORK, OPEN_BRACE);
            WifiUtil.writeLineQuoted(wpaSupplicantContents, TAB, "ssid", supplicantNetBlock.getSsid());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_PROTO, supplicantNetBlock.getProto());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_KEY_MGMT, supplicantNetBlock.getKey_mgmt());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_PAIRWISE, supplicantNetBlock.getPairwise());
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_GROUP, supplicantNetBlock.getGroup());
            WifiUtil.writeLineQuoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_PSK, supplicantNetBlock.getPsk().isDefault() ? "" : AccessController.doPrivileged(() -> ((BPassword)supplicantNetBlock.getPsk()).getValue()));
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_SCAN_SSID, String.valueOf(supplicantNetBlock.getScan_ssid()));
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_PRIORITY, String.valueOf(supplicantNetBlock.getPriority()));
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_AUTH_ALG, WPA_SUPPLICANT_CONF_AUTH_ALG_OPEN_VALUE);
            if ("SAE".equals(supplicantNetBlock.getKey_mgmt())) {
                WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, "ieee80211w", TWO);
            }
            WifiUtil.writeLineUnquoted(wpaSupplicantContents, TAB, WPA_SUPPLICANT_CONF_DISABLED, supplicantNetBlock.getDisabled() ? "1" : "0");
            wpaSupplicantContents.append(CLOSE_BRACE).append(NEWLINE);
            wpaSupplicantContents.append(NEWLINE);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            String[] settingsToLog = TextUtil.split((String)wpaSupplicantContents.toString(), (char)'\n');
            StringBuilder obscuredSettingsBuilder = new StringBuilder();
            for (String settingToLog : settingsToLog) {
                if (settingToLog.contains("psk=") || settingToLog.contains("sae_password=")) {
                    obscuredSettingsBuilder.append(TAB);
                    if (settingToLog.contains(WPA_SUPPLICANT_CONF_PSK)) {
                        obscuredSettingsBuilder.append(WPA_SUPPLICANT_CONF_PSK);
                    } else if (settingToLog.contains("sae_password")) {
                        obscuredSettingsBuilder.append("sae_password");
                    }
                    obscuredSettingsBuilder.append(EQUALS).append("[obscured]").append(NEWLINE);
                    continue;
                }
                obscuredSettingsBuilder.append(settingToLog).append(NEWLINE);
            }
            LOG.finest("wifiSettingsToWpaSupplicantConf created Wi-Fi client configuration string:\n" + obscuredSettingsBuilder);
        }
        return wpaSupplicantContents.toString();
    }

    public static void hostapdConfToWifiSettings(BWifiSettings wifiSettings, InputStream inputStream) throws Exception {
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        Objects.requireNonNull(inputStream, "inputStream argument cannot be null");
        boolean ieee80211n = false;
        String hw_mode = HOSTAPD_CONF_IEEE_802_11G;
        String hostapdLinesAsString = FileUtil.readString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String[] hostapdLines = TextUtil.split((String)hostapdLinesAsString, (char)'\n');
        if (LOG.isLoggable(Level.FINEST)) {
            StringBuilder obscuredSettingsBuilder = new StringBuilder();
            for (String settingToLog : hostapdLines) {
                if (settingToLog.contains("wpa_passphrase=") || settingToLog.contains("wpa_psk=") || settingToLog.contains("sae_password=")) {
                    obscuredSettingsBuilder.append("");
                    if (settingToLog.contains(HOSTAPD_CONF_WPA_PASSPHRASE)) {
                        obscuredSettingsBuilder.append(HOSTAPD_CONF_WPA_PASSPHRASE);
                    } else if (settingToLog.contains(HOSTAPD_CONF_WPA_PSK)) {
                        obscuredSettingsBuilder.append(HOSTAPD_CONF_WPA_PSK);
                    } else if (settingToLog.contains("sae_password")) {
                        obscuredSettingsBuilder.append("sae_password");
                    }
                    obscuredSettingsBuilder.append(EQUALS).append("[obscured]").append(NEWLINE);
                    continue;
                }
                obscuredSettingsBuilder.append(settingToLog).append(NEWLINE);
            }
            LOG.finest("hostapdConfToWifiSettings creating Wi-Fi settings from string:\n" + obscuredSettingsBuilder);
        }
        int currentLineNumber = 0;
        while (currentLineNumber < hostapdLines.length) {
            String hostapdLine = hostapdLines[currentLineNumber].trim();
            if (hostapdLine.isEmpty() || hostapdLine.startsWith(COMMENT) && !hostapdLine.contains(HOSTAPD_CONF_ACCEPT_MAC_FILE)) {
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.endsWith(EQUALS)) {
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("interface=")) {
                wifiSettings.setSapAdapterName(hostapdLine.split(EQUALS)[1]);
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("ssid=")) {
                wifiSettings.setSapSsid(hostapdLine.split(EQUALS)[1]);
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("channel=")) {
                wifiSettings.setSapChannel(Integer.parseInt(hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("hw_mode=")) {
                hw_mode = hostapdLine.split(EQUALS)[1].trim();
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("ignore_broadcast_ssid=")) {
                wifiSettings.setIgnoreBroadcastSsid(Integer.parseInt(hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("country_code=")) {
                wifiSettings.setCountryCode(hostapdLine.split(EQUALS)[1]);
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("ht_capab=")) {
                boolean ht20 = hostapdLine.contains(HOSTAPD_CONF_HT_20);
                boolean ht40 = hostapdLine.contains(HOSTAPD_CONF_HT_40);
                if (ht20 && ht40) {
                    wifiSettings.setSapHtCapab(BHtCapabilityEnum.ht20ht40);
                } else if (ht40) {
                    wifiSettings.setSapHtCapab(BHtCapabilityEnum.ht40);
                } else {
                    wifiSettings.setSapHtCapab(BHtCapabilityEnum.ht20);
                }
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("ieee80211n=")) {
                ieee80211n = !"0".equals(hostapdLine.split(EQUALS)[1]);
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("wpa=")) {
                wifiSettings.setSapWpa(BHapdWpaConfigEnum.toHapdWpaConfigEnum(hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("wpa_key_mgmt=")) {
                wifiSettings.setSapWpaKeyMgmt(BHapdKeyManagementEnum.toHapdKeyManagementEnum(hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("wpa_pairwise=")) {
                wifiSettings.setSapWpaPairwise(BHapdEncryptionMethod.toHapdEncryptionMethod(hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("wpa_passphrase=")) {
                wifiSettings.setSapWpaPassphrase(BPassword.make((String)hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("macaddr_acl=")) {
                wifiSettings.setUseAllowList(!"0".equals(hostapdLine.split(EQUALS)[1]));
                ++currentLineNumber;
                continue;
            }
            if (hostapdLine.startsWith("accept_mac_file=") || hostapdLine.startsWith("#accept_mac_file=")) {
                ++currentLineNumber;
                continue;
            }
            ++currentLineNumber;
        }
        if (ieee80211n) {
            wifiSettings.setSapHwMode(BHapdHwModeEnum.ieee802_11n);
            if (HOSTAPD_CONF_IEEE_802_11A.equalsIgnoreCase(hw_mode)) {
                if (wifiSettings.getSapChannel() >= 184) {
                    wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band49);
                } else {
                    wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band50);
                }
            } else {
                wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band24);
            }
        } else if (HOSTAPD_CONF_IEEE_802_11A.equalsIgnoreCase(hw_mode)) {
            wifiSettings.setSapHwMode(BHapdHwModeEnum.ieee802_11a);
            if (wifiSettings.getSapChannel() >= 184) {
                wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band49);
            } else {
                wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band50);
            }
        } else if (HOSTAPD_CONF_IEEE_802_11B.equalsIgnoreCase(hw_mode)) {
            wifiSettings.setSapHwMode(BHapdHwModeEnum.ieee802_11b);
            wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band24);
        } else {
            wifiSettings.setSapHwMode(BHapdHwModeEnum.ieee802_11g);
            wifiSettings.setSapFreqBand(BWifiFreqBandEnum.band24);
        }
    }

    public static String wifiSettingsToHostapdConf(BWifiSettings wifiSettings, WiFiServletType servletType) {
        BValue dynamicPropertyValue;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        Objects.requireNonNull(servletType, "servletType argument cannot be null");
        StringBuilder hostapdContents = new StringBuilder();
        hostapdContents.append(DESCRIPTION).append(NEWLINE);
        hostapdContents.append(MODIFY_WARNING).append(NEWLINE);
        hostapdContents.append(CREATED).append(BAbsTime.now()).append(NEWLINE);
        hostapdContents.append(NEWLINE);
        if (servletType == WiFiServletType.qnxwifi) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", "ctrl_interface", TRIDIUM_LEGACY_WIFI_HOSTAPD_CTRL_PATH);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_CTRL_INTERFACE_GROUP, "0");
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_DRIVER, TRIDIUM_LEGACY_WIFI_DRIVER);
        }
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_INTERFACE, wifiSettings.getSapAdapterName());
        hostapdContents.append(NEWLINE);
        hostapdContents.append(HOSTAPD_CONF_IEEE80211_COMMENT).append(NEWLINE);
        WifiUtil.writeLineUnquoted(hostapdContents, "", "ssid", wifiSettings.getSapSsid());
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_CHANNEL, String.valueOf(wifiSettings.getSapChannel()));
        hostapdContents.append(wifiSettings.getSapHwMode().makeConfFileLine(wifiSettings.getSapFreqBand()));
        if (servletType == WiFiServletType.qnxwifi) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_MAX_NUM_STA, TRIDIUM_LEGACY_HOSTAPD_CONF_MAX_NUM_STA_VALUE);
        } else {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_MAX_NUM_STA, HOSTAPD_CONF_MAX_NUM_STA_VALUE);
        }
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_AUTH_ALGS, "1");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_DISASSOC_LOW_ACK, "0");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IGNORE_BROADCAST_SSID, String.valueOf(wifiSettings.getIgnoreBroadcastSsid()));
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_PREAMBLE, "1");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_DTIM_PERIOD, TWO);
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_BEACON_INT, HOSTAPD_CONF_BEACON_INT_VALUE);
        hostapdContents.append(NEWLINE);
        hostapdContents.append(HOSTAPD_CONF_DFS_COMMENT).append(NEWLINE);
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021D, "1");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021H, "1");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_COUNTRY_CODE, wifiSettings.getCountryCode());
        hostapdContents.append(NEWLINE);
        hostapdContents.append(HOSTAPD_CONF_IEEE80211N_COMMENT).append(NEWLINE);
        if (BHapdHwModeEnum.ieee802_11a.equals((Object)wifiSettings.getSapHwMode())) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021N, "0");
        } else if (BHapdHwModeEnum.ieee802_11b.equals((Object)wifiSettings.getSapHwMode())) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021N, "0");
        } else if (BHapdHwModeEnum.ieee802_11g.equals((Object)wifiSettings.getSapHwMode())) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021N, "0");
        } else if (BHapdHwModeEnum.ieee802_11n.equals((Object)wifiSettings.getSapHwMode())) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021N, "1");
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_BASIC_RATES, HOSTAPD_CONF_BASIC_RATES_IEEE80211N);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_SUPPORTED_RATES, "60 90 120 180 240 360 480 540");
        } else {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_IEEE8021N, "0");
        }
        hostapdContents.append(wifiSettings.getSapHtCapab().makeConfFileLine());
        hostapdContents.append(NEWLINE);
        hostapdContents.append(HOSTAPD_CONF_IEEE80211I_COMMENT).append(NEWLINE);
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA, BHapdWpaConfigEnum.toWpaConfigString(wifiSettings.getSapWpa()));
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_KEY_MGMT, BHapdKeyManagementEnum.toKeyManagementString(wifiSettings.getSapWpaKeyMgmt()));
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_PAIRWISE, BHapdEncryptionMethod.toCipherString(wifiSettings.getSapWpaPairwise()));
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_GROUP_REKEY, "0");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_STRICT_REKEY, "0");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_GMK_REKEY, "0");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_PTK_REKEY, "0");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WPA_PASSPHRASE, wifiSettings.getSapWpaPassphrase().isDefault() ? "" : AccessController.doPrivileged(() -> ((BPassword)wifiSettings.getSapWpaPassphrase()).getValue()));
        if ("SAE".equals(BHapdKeyManagementEnum.toKeyManagementString(wifiSettings.getSapWpaKeyMgmt()))) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", "ieee80211w", TWO);
        }
        hostapdContents.append(NEWLINE);
        if (servletType == WiFiServletType.qnxwifi) {
            hostapdContents.append(HOSTAPD_CONF_LOGGER_COMMENT).append(NEWLINE);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_LOGGER_SYSLOG, NEGATIVE_ONE);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_LOGGER_SYSLOG_LEVEL, TWO);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_LOGGER_STDOUT, NEGATIVE_ONE);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_LOGGER_STDOUT_LEVEL, TWO);
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_DUMP_FILE, TRIDIUM_LEGACY_WIFI_DUMP_PATH);
            hostapdContents.append(NEWLINE);
        }
        hostapdContents.append(HOSTAPD_CONF_MULTIMEDIA_COMMENT).append(NEWLINE);
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_WMM_ENABLED, "1");
        WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_UAPSD_ADVERTISEMENT_ENABLED, "1");
        hostapdContents.append(NEWLINE);
        hostapdContents.append(HOSTAPD_CONF_ALLOW_LIST_COMMON).append(NEWLINE);
        String allowListAbsoluteFilePath = wifiSettings.getAllowListFilePath();
        if (servletType == WiFiServletType.wifi && (dynamicPropertyValue = wifiSettings.get(ABSOLUTE_ALLOW_LIST_FILE_PATH_SLOT_NAME)) != null) {
            allowListAbsoluteFilePath = ((BString)dynamicPropertyValue).getString();
        }
        if (wifiSettings.getUseAllowList()) {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_MACADDR_ACL, "1");
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_ACCEPT_MAC_FILE, allowListAbsoluteFilePath);
        } else {
            WifiUtil.writeLineUnquoted(hostapdContents, "", HOSTAPD_CONF_MACADDR_ACL, "0");
            WifiUtil.writeLineUnquoted(hostapdContents, "", "#accept_mac_file", allowListAbsoluteFilePath);
        }
        hostapdContents.append(NEWLINE);
        if (LOG.isLoggable(Level.FINEST)) {
            String[] settingsToLog = TextUtil.split((String)hostapdContents.toString(), (char)'\n');
            StringBuilder obscuredSettingsBuilder = new StringBuilder();
            for (String settingToLog : settingsToLog) {
                if (settingToLog.contains("wpa_passphrase=") || settingToLog.contains("wpa_psk=") || settingToLog.contains("sae_password=")) {
                    obscuredSettingsBuilder.append("");
                    if (settingToLog.contains(HOSTAPD_CONF_WPA_PASSPHRASE)) {
                        obscuredSettingsBuilder.append(HOSTAPD_CONF_WPA_PASSPHRASE);
                    } else if (settingToLog.contains(HOSTAPD_CONF_WPA_PSK)) {
                        obscuredSettingsBuilder.append(HOSTAPD_CONF_WPA_PSK);
                    } else if (settingToLog.contains("sae_password")) {
                        obscuredSettingsBuilder.append("sae_password");
                    }
                    obscuredSettingsBuilder.append(EQUALS).append("[obscured]").append(NEWLINE);
                    continue;
                }
                obscuredSettingsBuilder.append(settingToLog).append(NEWLINE);
            }
            LOG.finest("wifiSettingsToHostapdConf created Wi-Fi host configuration string:\n" + obscuredSettingsBuilder);
        }
        return hostapdContents.toString();
    }

    public static void wifiNetCfgToWifiSettings(BWifiSettings wifiSettings, InputStream inputStream) throws Exception {
        String[] sections;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        Objects.requireNonNull(inputStream, "inputStream argument cannot be null");
        String wifiNetCfgFile = FileUtil.readString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("wifiNetCfgToWifiSettings creating Wi-Fi settings from string:\n" + wifiNetCfgFile);
        }
        for (String section : sections = wifiNetCfgFile.split(NET_CFG_SECTION_REGEX)) {
            if (section.indexOf(TRIDIUM_LEGACY_WIFI_SAP_ADAPTER) > 0) {
                String[] lines;
                wifiSettings.setSapAdapterName(TRIDIUM_LEGACY_WIFI_SAP_ADAPTER);
                for (String line : lines = section.split(NEWLINE)) {
                    if (line.startsWith(NET_CFG_MANUAL_IP)) {
                        wifiSettings.setSapAdapterIp(line.split(SPACE)[1]);
                        continue;
                    }
                    if (line.startsWith(NET_CFG_MANUAL_NETMASK)) {
                        wifiSettings.setSapAdapterNetmask(line.split(SPACE)[1]);
                        continue;
                    }
                    if (!line.startsWith("mode dhcp")) continue;
                    wifiSettings.setSapAdapterIp(NET_CFG_DHCP);
                    wifiSettings.setSapAdapterNetmask(NET_CFG_DHCP);
                }
                continue;
            }
            if (section.indexOf(TRIDIUM_LEGACY_WIFI_STA_ADAPTER) <= 0) continue;
            wifiSettings.setStaAdapterName(TRIDIUM_LEGACY_WIFI_STA_ADAPTER);
        }
    }

    public static String wifiSettingsToWifiNetCfg(BWifiSettings wifiSettings) {
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        StringBuilder netCfgContent = new StringBuilder();
        netCfgContent.append(TRIDIUM_LEGACY_WIFI_CLIENT_ADAPTER_ID).append(NEWLINE);
        netCfgContent.append(NET_CFG_TYPE).append(SPACE).append(NET_CFG_WIFI).append(NEWLINE);
        netCfgContent.append(NET_CFG_OSNAME).append(SPACE).append(wifiSettings.getStaAdapterName()).append(NEWLINE);
        netCfgContent.append(NET_CFG_MODE).append(SPACE).append(NET_CFG_DHCP).append(NEWLINE);
        netCfgContent.append(NET_CFG_MODE6).append(SPACE).append(NET_CFG_AUTO).append(NEWLINE);
        netCfgContent.append(NEWLINE);
        netCfgContent.append(TRIDIUM_LEGACY_WIFI_HOST_ADAPTER_ID).append(NEWLINE);
        netCfgContent.append(NET_CFG_TYPE).append(SPACE).append(NET_CFG_WIFI).append(NEWLINE);
        netCfgContent.append(NET_CFG_OSNAME).append(SPACE).append(wifiSettings.getSapAdapterName()).append(NEWLINE);
        netCfgContent.append(NET_CFG_MODE).append(SPACE).append(NET_CFG_MANUAL).append(NEWLINE);
        netCfgContent.append(NET_CFG_MANUAL_IP).append(SPACE).append(wifiSettings.getSapAdapterIp()).append(NEWLINE);
        netCfgContent.append(NET_CFG_MANUAL_NETMASK).append(SPACE).append(wifiSettings.getSapAdapterNetmask()).append(NEWLINE);
        netCfgContent.append(NET_CFG_MODE6).append(SPACE).append(NET_CFG_AUTO).append(NEWLINE);
        netCfgContent.append(NEWLINE);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("wifiSettingsToWifiNetCfg created Wi-Fi network configuration string:\n" + netCfgContent);
        }
        return netCfgContent.toString();
    }

    public static void legacyDhcpdConfToDhcpdHostSettings(BDhcpdHostSettings dhcpdHostSettings, String accessPointAdapterSlotName, InputStream inputStream) throws Exception {
        Objects.requireNonNull(dhcpdHostSettings, "dhcpdHostSettings argument cannot be null");
        Objects.requireNonNull(accessPointAdapterSlotName, "accessPointAdapterSlotName argument cannot be null");
        Objects.requireNonNull(inputStream, "inputStream argument cannot be null");
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(accessPointAdapterSlotName);
        if (dhcpdAdapterSettings == null) {
            return;
        }
        String dhcpdLinesAsString = FileUtil.readString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String[] dhcpdLines = TextUtil.split((String)dhcpdLinesAsString, (char)'\n');
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("legacyDhcpdConfToDhcpdHostSettings creating dhcpd settings from string:\n" + dhcpdLinesAsString);
        }
        for (int currentLineNumber = 0; currentLineNumber < dhcpdLines.length; ++currentLineNumber) {
            String intStr;
            String currentLine = dhcpdLines[currentLineNumber].trim();
            if (currentLine.startsWith(DHCPD_CONF_DEFAULT_LEASE_TIME) && currentLine.endsWith(SEMICOLON)) {
                String defaultLeaseLine = currentLine.substring(0, currentLine.indexOf(SEMICOLON));
                intStr = defaultLeaseLine.split(SPACE)[1];
                dhcpdAdapterSettings.setDefaultLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
                continue;
            }
            if (currentLine.startsWith(DHCPD_CONF_MAX_LEASE_TIME) && currentLine.endsWith(SEMICOLON)) {
                String maxLeaseLine = currentLine.substring(0, currentLine.indexOf(SEMICOLON));
                intStr = maxLeaseLine.split(SPACE)[1];
                dhcpdAdapterSettings.setMaxLeaseTime(BRelTime.makeSeconds((int)Integer.parseInt(intStr)));
                continue;
            }
            if (!currentLine.startsWith(DHCPD_CONF_SUBNET) || !currentLine.endsWith(OPEN_BRACE)) continue;
            currentLineNumber = DhcpdUtil.stringToDhcpdSettingsDhcpdSubnet((BDhcpdAdapterSettings)dhcpdAdapterSettings, (String[])dhcpdLines, (String)currentLine, (int)currentLineNumber);
            ++currentLineNumber;
        }
    }

    public static void allowListFromSession(BWifiMacAddressVector wifiMacAddressVector, BDaemonSession daemonSession, String allowListPath) throws Exception {
        Objects.requireNonNull(wifiMacAddressVector, "wifiMacAddressVector argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        Objects.requireNonNull(allowListPath, "allowListPath argument cannot be null");
        long start = 0L;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Loading Wi-Fi allow list file from daemon session...");
            start = Clock.ticks();
        }
        try (PBEEncodingKey pbeEncodingKey = PBEEncodingKey.random();
             BCachedDaemonFileSpace space = BCachedDaemonFileSpace.make((BDaemonSession)daemonSession, (PBEEncodingKey)pbeEncodingKey);){
            BIFile allowListFile;
            FilePath allowListFilePath = new FilePath(allowListPath);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Retrieving Wi-Fi allow list file at '" + allowListFilePath + "'");
            }
            if ((allowListFile = space.findFile(allowListFilePath)) != null) {
                PBEDecryptingInputStream decryptedAllowListInputStream = new PBEDecryptingInputStream(allowListFile.getInputStream(), pbeEncodingKey);
                WifiUtil.allowListToWifiSettings(wifiMacAddressVector, (InputStream)decryptedAllowListInputStream);
            } else if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Wi-Fi allow list file '" + allowListFilePath + "' not found, using defaults");
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Load of Wi-Fi allow list file from daemon session complete (" + (Clock.ticks() - start) + "ms)");
        }
    }

    public static void allowListToSession(BWifiMacAddressVector wifiMacAddressVector, BDaemonSession daemonSession, String allowListPath) throws Exception {
        Objects.requireNonNull(wifiMacAddressVector, "wifiMacAddressVector argument cannot be null");
        Objects.requireNonNull(daemonSession, "daemonSession argument cannot be null");
        Objects.requireNonNull(allowListPath, "allowListPath argument cannot be null");
        try (PBEEncodingKey pbeEncodingKey = PBEEncodingKey.random();){
            FileTransferMessage fileTransferMessage = DaemonClientEncodingInfo.makeMessage((BDaemonSession)daemonSession, (PBEEncodingKey)pbeEncodingKey);
            String fileContents = WifiUtil.wifiSettingsToAllowList(wifiMacAddressVector);
            try (ByteArrayInputStream allowListInputStream = new ByteArrayInputStream(fileContents.getBytes(StandardCharsets.UTF_8));){
                FilePath allowListFilePath = new FilePath(allowListPath);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Saving Wi-Fi allow list file to path '" + allowListFilePath + "'");
                }
                fileTransferMessage.addPBEEncryptedElement((InputStream)allowListInputStream, allowListFilePath);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Starting allow list file transfer for host...");
            }
            if (!DaemonFileUtil.transfer((BDaemonSession)daemonSession, (FileTransferMessage)fileTransferMessage, null)) {
                throw new BajaRuntimeException("Failed to save new Wi-Fi allow list");
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("File transfer for host complete");
            }
        }
    }

    public static void allowListToWifiSettings(BWifiMacAddressVector wifiMacAddressVector, InputStream inputStream) throws Exception {
        Objects.requireNonNull(wifiMacAddressVector, "wifiMacAddressVector argument cannot be null");
        Objects.requireNonNull(inputStream, "inputStream argument cannot be null");
        wifiMacAddressVector.removeAll();
        String allowListLinesAsString = FileUtil.readString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        String[] allowListLines = FileUtil.readLines((Reader)new StringReader(allowListLinesAsString));
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("allowListToWifiSettings creating Wi-Fi settings from string:\n" + allowListLinesAsString);
        }
        for (String allowListLine : allowListLines) {
            String mac = allowListLine.trim();
            BWifiMacAddress entry = new BWifiMacAddress(mac);
            wifiMacAddressVector.add("mac?", (BValue)entry, 3, BFacets.make((String)"fieldEditor", (BIDataValue)BString.make((String)"platWifi:MacAddressFE")), null);
        }
    }

    public static String wifiSettingsToAllowList(BWifiMacAddressVector wifiMacAddressVector) {
        BWifiMacAddress[] wifiMacAddresses;
        Objects.requireNonNull(wifiMacAddressVector, "wifiMacAddressVector argument cannot be null");
        StringBuilder allowListContents = new StringBuilder();
        for (BWifiMacAddress wifiMacAddress : wifiMacAddresses = (BWifiMacAddress[])wifiMacAddressVector.getChildren(BWifiMacAddress.class)) {
            allowListContents.append(wifiMacAddress.getMac()).append(NEWLINE);
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("wifiSettingsToAllowList created Wi-Fi allow list string:\n" + allowListContents);
        }
        return allowListContents.toString();
    }

    private static void channelListEntryFromString(BWifiChannelListVector wifiChannelListVector, String bandConfigLine, String countryCode) {
        Objects.requireNonNull(wifiChannelListVector, "wifiChannelListVector argument cannot be null");
        Objects.requireNonNull(bandConfigLine, "bandConfigLine argument cannot be null");
        Objects.requireNonNull(countryCode, "countryCode argument cannot be null");
        StringTokenizer tokenizer = new StringTokenizer(bandConfigLine);
        int tokenCount = tokenizer.countTokens();
        if (tokenCount != 20) {
            LOG.warning("Band config entry '" + bandConfigLine + "' has invalid token count (" + tokenCount + " != " + 20 + "), skipping entry");
            return;
        }
        String region = WIFI_BAND_CONFIG_REGION_NONE_NAME;
        String token = tokenizer.nextToken();
        switch (Integer.parseInt(token)) {
            case 1: {
                region = WIFI_BAND_CONFIG_REGION_FCC_NAME;
                break;
            }
            case 2: {
                region = WIFI_BAND_CONFIG_REGION_ETSI_NAME;
                break;
            }
            case 3: {
                region = WIFI_BAND_CONFIG_REGION_JP_NAME;
                break;
            }
            default: {
                LOG.warning("Band config entry '" + bandConfigLine + "' has unrecognized region ordinal " + token + ", defaulting to " + WIFI_BAND_CONFIG_REGION_NONE_NAME);
            }
        }
        BWifiFreqBandEnum band = BWifiFreqBandEnum.band24;
        token = tokenizer.nextToken();
        switch (Integer.parseInt(token)) {
            case 0: {
                band = BWifiFreqBandEnum.band24;
                break;
            }
            case 1: {
                band = BWifiFreqBandEnum.band50;
                break;
            }
            case 2: {
                band = BWifiFreqBandEnum.band49;
                break;
            }
            default: {
                LOG.warning("Band config entry '" + bandConfigLine + "' has unrecognized band ordinal " + token + ", defaulting to " + (Object)((Object)BWifiFreqBandEnum.band24));
            }
        }
        token = tokenizer.nextToken();
        int dBm = Integer.parseInt(token);
        token = tokenizer.nextToken();
        boolean DFS = !"0".equals(token);
        token = tokenizer.nextToken();
        int numChannels = Integer.parseInt(token);
        for (int currentChannel = 0; currentChannel < numChannels && tokenizer.hasMoreTokens(); ++currentChannel) {
            token = tokenizer.nextToken();
            int channel = Integer.parseInt(token);
            BWifiChannelListEntry entry = new BWifiChannelListEntry();
            entry.setCountryCode(countryCode);
            entry.setBand(band);
            entry.setTxPower(dBm);
            entry.setDynamicFrequencySelection(DFS);
            entry.setRegion(region);
            entry.setChannel(channel);
            wifiChannelListVector.add(String.format(CHANNEL_SLOT_NAME_FORMAT, band.getOrdinal(), channel), (BValue)entry);
        }
    }

    private static boolean facetsHasWiFiSaveType(BFacets facets) {
        if (facets == null || facets.isEmpty()) {
            return false;
        }
        boolean facetsHasWiFiSaveType = false;
        facetsHasWiFiSaveType |= facets.get(SAVE_TYPE_ALL) != null;
        facetsHasWiFiSaveType |= facets.get(SAVE_TYPE_NONE) != null;
        facetsHasWiFiSaveType |= facets.get(SAVE_TYPE_SUPPLICANT) != null;
        facetsHasWiFiSaveType |= facets.get(SAVE_TYPE_HOSTAPD) != null;
        facetsHasWiFiSaveType |= facets.get(SAVE_TYPE_WIFINETCFG) != null;
        return facetsHasWiFiSaveType |= facets.get(SAVE_TYPE_DHCPD) != null;
    }

    private static boolean fixSapIpAddress(BWifiSettings wifiSettings, String defaultIp, String defaultNetmask) {
        String sapAdapterDhcpSubnet;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        if (!IPAddressUtil.isIpv4Address((String)defaultIp)) {
            throw new IllegalArgumentException("Invalid default IP address " + defaultIp);
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)defaultNetmask)) {
            throw new IllegalArgumentException("Invalid default netmask " + defaultNetmask);
        }
        if (IPAddressUtil.isIpv4Address((String)wifiSettings.getSapAdapterIp())) {
            return false;
        }
        String newSapAdapterIp = defaultIp;
        String newSapAdapterNetmask = defaultNetmask;
        BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(SlotPath.escape((String)wifiSettings.getSapAdapterName()));
        if (dhcpdAdapterSettings != null && IPAddressUtil.isIpv4Address((String)(sapAdapterDhcpSubnet = dhcpdAdapterSettings.getSubnet()))) {
            newSapAdapterIp = DhcpdUtil.getNextIpAddress((String)sapAdapterDhcpSubnet);
            newSapAdapterNetmask = dhcpdAdapterSettings.getSubnetMask();
        }
        wifiSettings.setSapAdapterIp(newSapAdapterIp);
        wifiSettings.setSapAdapterNetmask(newSapAdapterNetmask);
        return true;
    }

    private static boolean fixDhcpdWifiSettings(BWifiSettings wifiSettings, int minClients, int maxClients, boolean isTridiumQNX) {
        String endClientAddress;
        String dhcpEndAddressPrefix;
        String adjustedStartIpAddress;
        String startIpAddress;
        int dhcpdRange;
        int adjustedDhcpdRange;
        String sapAdapterSubnet;
        Objects.requireNonNull(wifiSettings, "wifiSettings argument cannot be null");
        if (minClients < 1) {
            throw new IllegalArgumentException("Cannot fix DHCP server Wi-Fi settings, provided minClients < 1");
        }
        if (maxClients < 1) {
            throw new IllegalArgumentException("Cannot fix DHCP server Wi-Fi settings, provided maxClients < 1");
        }
        if (minClients > maxClients) {
            throw new IllegalArgumentException("Cannot fix DHCP server Wi-Fi settings, provided minClients > maxClients");
        }
        BDhcpdHostSettings dhcpdHostSettings = wifiSettings.getDhcpdHostSettings();
        BDhcpdAdapterSettings dhcpdAdapterSettings = (BDhcpdAdapterSettings)dhcpdHostSettings.getDhcpdSubnets().get(SlotPath.escape((String)wifiSettings.getSapAdapterName()));
        if (dhcpdAdapterSettings == null) {
            return false;
        }
        String sapAdapterIpAddress = wifiSettings.getSapAdapterIp();
        String sapAdapterNetmask = wifiSettings.getSapAdapterNetmask();
        if (!IPAddressUtil.isIpv4Address((String)sapAdapterIpAddress) || !IPAddressUtil.isIpv4SubnetMask((String)sapAdapterNetmask)) {
            return false;
        }
        boolean dhcpdAdapterSettingsModified = false;
        if (!dhcpdAdapterSettings.getIsDhcpdIpv4Supported()) {
            dhcpdAdapterSettings.setIsDhcpdIpv4Supported(true);
            dhcpdAdapterSettingsModified = true;
        }
        if (!isTridiumQNX && !dhcpdAdapterSettings.getIsDhcpdIpv4Enabled()) {
            dhcpdAdapterSettings.setIsDhcpdIpv4Enabled(true);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)(sapAdapterSubnet = IPAddressUtil.getIPv4NetworkPrefix((String)sapAdapterIpAddress, (String)sapAdapterNetmask)), (Object)dhcpdAdapterSettings.getSubnet()) != 0) {
            dhcpdAdapterSettings.setSubnet(sapAdapterSubnet);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)sapAdapterNetmask, (Object)dhcpdAdapterSettings.getSubnetMask()) != 0) {
            dhcpdAdapterSettings.setSubnetMask(sapAdapterNetmask);
            dhcpdAdapterSettingsModified = true;
        }
        if ((adjustedDhcpdRange = DhcpdUtil.fixDhcpdAdapterSettingsRange((int)(dhcpdRange = dhcpdAdapterSettings.getRange()), (int)minClients, (int)maxClients, (String)dhcpdAdapterSettings.getSubnetMask())) != dhcpdRange) {
            dhcpdRange = adjustedDhcpdRange;
            dhcpdAdapterSettings.setRange(adjustedDhcpdRange);
            dhcpdAdapterSettingsModified = true;
        }
        if ((startIpAddress = dhcpdAdapterSettings.getStartClientAddress()).isEmpty()) {
            startIpAddress = DhcpdUtil.getNextIpAddress((String)sapAdapterIpAddress);
            dhcpdAdapterSettings.setStartClientAddress(startIpAddress);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)(adjustedStartIpAddress = DhcpdUtil.fixDhcpdAdapterSettingsStartAddress((String)startIpAddress, (String)sapAdapterSubnet, (String)sapAdapterNetmask)), (Object)startIpAddress) != 0) {
            startIpAddress = adjustedStartIpAddress;
            dhcpdAdapterSettings.setStartClientAddress(adjustedStartIpAddress);
            dhcpdAdapterSettingsModified = true;
        }
        if (IPAddressUtil.compare((Object)(dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)(endClientAddress = DhcpdUtil.getEndIpAddress((String)startIpAddress, (int)dhcpdRange)), (String)sapAdapterNetmask)), (Object)sapAdapterSubnet) != 0) {
            adjustedDhcpdRange = dhcpdRange;
            while (adjustedDhcpdRange >= minClients && IPAddressUtil.compare((Object)dhcpEndAddressPrefix, (Object)sapAdapterSubnet) != 0) {
                endClientAddress = DhcpdUtil.getEndIpAddress((String)startIpAddress, (int)(--adjustedDhcpdRange));
                dhcpEndAddressPrefix = IPAddressUtil.getIPv4NetworkPrefix((String)endClientAddress, (String)sapAdapterNetmask);
            }
            if (adjustedDhcpdRange != dhcpdRange && adjustedDhcpdRange > minClients) {
                dhcpdAdapterSettings.setRange(--adjustedDhcpdRange);
                dhcpdAdapterSettingsModified = true;
            }
        }
        return dhcpdAdapterSettingsModified;
    }

    private static void writeLineUnquoted(StringBuilder content, String linePrefix, String key, String value) {
        Objects.requireNonNull(content, "content argument cannot be null");
        Objects.requireNonNull(linePrefix, "linePrefix argument cannot be null");
        Objects.requireNonNull(key, "key argument cannot be null");
        Objects.requireNonNull(value, "value argument cannot be null");
        content.append(linePrefix).append(key).append(EQUALS).append(value).append(NEWLINE);
    }

    private static void writeLineQuoted(StringBuilder content, String linePrefix, String key, String value) {
        Objects.requireNonNull(content, "content argument cannot be null");
        Objects.requireNonNull(linePrefix, "linePrefix argument cannot be null");
        Objects.requireNonNull(key, "key argument cannot be null");
        Objects.requireNonNull(value, "value argument cannot be null");
        content.append(linePrefix).append(key).append(EQUALS).append(QUOTE).append(value).append(QUOTE).append(NEWLINE);
    }

    private static String unquote(String value) {
        Objects.requireNonNull(value, "value argument cannot be null");
        return TextUtil.replace((String)value, (String)QUOTE, (String)"");
    }

    private static String ipAddressAndSubnetMaskToCIDR(String ipAddress, String subnetMask) {
        Objects.requireNonNull(ipAddress, "ipAddress argument cannot be null");
        Objects.requireNonNull(subnetMask, "subnetMask argument cannot be null");
        if (!IPAddressUtil.isIpv4Address((String)ipAddress)) {
            throw new IllegalArgumentException("Invalid IP address " + ipAddress);
        }
        if (!IPAddressUtil.isIpv4SubnetMask((String)subnetMask)) {
            throw new IllegalArgumentException("Invalid netmask " + subnetMask);
        }
        byte[] subnetMaskBytes = IPAddressUtil.numericStringToByteArray((String)subnetMask);
        int netmaskBits = (subnetMaskBytes[0] & 0xFF) << 24;
        netmaskBits |= (subnetMaskBytes[1] & 0xFF) << 16;
        netmaskBits |= (subnetMaskBytes[2] & 0xFF) << 8;
        netmaskBits |= subnetMaskBytes[3] & 0xFF;
        netmaskBits = Integer.bitCount(netmaskBits);
        return ipAddress + "/" + netmaskBits;
    }

    private static String[] cidrToIpAddressAndSubnetMask(String cidrIpAddress) {
        Objects.requireNonNull(cidrIpAddress, "cidrIpAddress argument cannot be null");
        String[] ipAddressAndNetmaskArray = TextUtil.split((String)cidrIpAddress, (char)'/');
        if (ipAddressAndNetmaskArray.length != 2) {
            throw new IllegalArgumentException("Invalid CIDR address: " + cidrIpAddress);
        }
        if (!IPAddressUtil.isIpv4Address((String)ipAddressAndNetmaskArray[0])) {
            throw new IllegalArgumentException("Invalid CIDR address: " + cidrIpAddress);
        }
        int netmaskInt = Integer.parseInt(ipAddressAndNetmaskArray[1]);
        if (netmaskInt < 0 || netmaskInt > 32) {
            throw new IllegalArgumentException("Invalid CIDR address: " + cidrIpAddress);
        }
        long netmask = 0xFFFFFFFFL << 32 - netmaskInt;
        StringBuilder subnetMaskBuilder = new StringBuilder();
        subnetMaskBuilder.insert(0, (netmask &= 0xFFFFFFFFL) & 0xFFL).insert(0, ".");
        subnetMaskBuilder.insert(0, netmask >> 8 & 0xFFL).insert(0, ".");
        subnetMaskBuilder.insert(0, netmask >> 16 & 0xFFL).insert(0, ".");
        subnetMaskBuilder.insert(0, netmask >> 24 & 0xFFL);
        return new String[]{ipAddressAndNetmaskArray[0], subnetMaskBuilder.toString()};
    }
}

