/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.platwifi.BWifiNetworkMode;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiNoneSettings;
import com.tridium.platwifi.security.BWifiProtocol;
import com.tridium.platwifi.security.BWifiSecurityPolicy;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWPA2PSKSettings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import java.util.Objects;
import java.util.StringTokenizer;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BUnit;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="bssid", type="String", defaultValue="00:00:00:00:00:00", flags=1), @NiagaraProperty(name="ssid", type="String", defaultValue="New_Wireless_Network", flags=1), @NiagaraProperty(name="ssidBroadcasted", type="boolean", defaultValue="true", flags=1), @NiagaraProperty(name="priority", type="int", defaultValue="1", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH }, new BIDataValue[] { BInteger.make(1), BInteger.make(10), BInteger.make(3) })")}), @NiagaraProperty(name="scanResultFlags", type="String", defaultValue="", flags=3), @NiagaraProperty(name="mode", type="BWifiNetworkMode", defaultValue="BWifiNetworkMode.managed", flags=1), @NiagaraProperty(name="frequency", type="int", defaultValue="0", flags=3), @NiagaraProperty(name="channel", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH }, new BIDataValue[] { BInteger.make(1), BInteger.make(11), BInteger.make(3) })")}), @NiagaraProperty(name="protocols", type="BWifiProtocol", defaultValue="BWifiProtocol.wpa_rsn", flags=1), @NiagaraProperty(name="securityPolicies", type="BWifiSecurityPolicy", defaultValue="BWifiSecurityPolicy.none", flags=1), @NiagaraProperty(name="securitySettings", type="BWifiSecuritySettings", defaultValue="new BWifiNoneSettings()", flags=1), @NiagaraProperty(name="networkState", type="BWifiNetworkStateEnum", defaultValue="BWifiNetworkStateEnum.unknown", flags=3), @NiagaraProperty(name="signalStrength", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH, BFacets.UNITS }, new BIDataValue[] { BInteger.make(0), BInteger.make(100), BInteger.make(3), BUnit.getUnit(\"percent\") })")})})
public class BWifiNetwork
extends BComponent {
    @Generated
    public static final Property bssid = BWifiNetwork.newProperty((int)1, (String)"00:00:00:00:00:00", null);
    @Generated
    public static final Property ssid = BWifiNetwork.newProperty((int)1, (String)"New_Wireless_Network", null);
    @Generated
    public static final Property ssidBroadcasted = BWifiNetwork.newProperty((int)1, (boolean)true, null);
    @Generated
    public static final Property priority = BWifiNetwork.newProperty((int)1, (int)1, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)10), BInteger.make((int)3)}));
    @Generated
    public static final Property scanResultFlags = BWifiNetwork.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property mode = BWifiNetwork.newProperty((int)1, (BValue)BWifiNetworkMode.managed, null);
    @Generated
    public static final Property frequency = BWifiNetwork.newProperty((int)3, (int)0, null);
    @Generated
    public static final Property channel = BWifiNetwork.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)1), BInteger.make((int)11), BInteger.make((int)3)}));
    @Generated
    public static final Property protocols = BWifiNetwork.newProperty((int)1, (BValue)BWifiProtocol.wpa_rsn, null);
    @Generated
    public static final Property securityPolicies = BWifiNetwork.newProperty((int)1, (BValue)BWifiSecurityPolicy.none, null);
    @Generated
    public static final Property securitySettings = BWifiNetwork.newProperty((int)1, (BValue)new BWifiNoneSettings(), null);
    @Generated
    public static final Property networkState = BWifiNetwork.newProperty((int)3, (BValue)BWifiNetworkStateEnum.unknown, null);
    @Generated
    public static final Property signalStrength = BWifiNetwork.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth", "units"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)100), BInteger.make((int)3), BUnit.getUnit((String)"percent")}));
    @Generated
    public static final Type TYPE = Sys.loadType(BWifiNetwork.class);
    private static final int MINIMUM_SCAN_RESULTS_LENGTH = 24;
    private static final int MAXIMUM_SCAN_RESULTS_LENGTH = 512;
    private static final int REQUIRED_SCAN_RESULTS_TOKENS = 5;
    private static final int BSSID_FIELD = 0;
    private static final int FREQUENCY_FIELD = 1;
    private static final int SIGNAL_LEVEL_FIELD = 2;
    private static final int FLAGS_FIELD = 3;
    private static final int SSID_FIELD = 4;
    private static final int MINIMUM_SSID_LENGTH = 0;
    private static final int MAXIMUM_SSID_LENGTH = 32;

    @Generated
    public String getBssid() {
        return this.getString(bssid);
    }

    @Generated
    public void setBssid(String v) {
        this.setString(bssid, v, null);
    }

    @Generated
    public String getSsid() {
        return this.getString(ssid);
    }

    @Generated
    public void setSsid(String v) {
        this.setString(ssid, v, null);
    }

    @Generated
    public boolean getSsidBroadcasted() {
        return this.getBoolean(ssidBroadcasted);
    }

    @Generated
    public void setSsidBroadcasted(boolean v) {
        this.setBoolean(ssidBroadcasted, v, null);
    }

    @Generated
    public int getPriority() {
        return this.getInt(priority);
    }

    @Generated
    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    @Generated
    public String getScanResultFlags() {
        return this.getString(scanResultFlags);
    }

    @Generated
    public void setScanResultFlags(String v) {
        this.setString(scanResultFlags, v, null);
    }

    @Generated
    public BWifiNetworkMode getMode() {
        return (BWifiNetworkMode)this.get(mode);
    }

    @Generated
    public void setMode(BWifiNetworkMode v) {
        this.set(mode, (BValue)v, null);
    }

    @Generated
    public int getFrequency() {
        return this.getInt(frequency);
    }

    @Generated
    public void setFrequency(int v) {
        this.setInt(frequency, v, null);
    }

    @Generated
    public int getChannel() {
        return this.getInt(channel);
    }

    @Generated
    public void setChannel(int v) {
        this.setInt(channel, v, null);
    }

    @Generated
    public BWifiProtocol getProtocols() {
        return (BWifiProtocol)this.get(protocols);
    }

    @Generated
    public void setProtocols(BWifiProtocol v) {
        this.set(protocols, (BValue)v, null);
    }

    @Generated
    public BWifiSecurityPolicy getSecurityPolicies() {
        return (BWifiSecurityPolicy)this.get(securityPolicies);
    }

    @Generated
    public void setSecurityPolicies(BWifiSecurityPolicy v) {
        this.set(securityPolicies, (BValue)v, null);
    }

    @Generated
    public BWifiSecuritySettings getSecuritySettings() {
        return (BWifiSecuritySettings)this.get(securitySettings);
    }

    @Generated
    public void setSecuritySettings(BWifiSecuritySettings v) {
        this.set(securitySettings, (BValue)v, null);
    }

    @Generated
    public BWifiNetworkStateEnum getNetworkState() {
        return (BWifiNetworkStateEnum)this.get(networkState);
    }

    @Generated
    public void setNetworkState(BWifiNetworkStateEnum v) {
        this.set(networkState, (BValue)v, null);
    }

    @Generated
    public int getSignalStrength() {
        return this.getInt(signalStrength);
    }

    @Generated
    public void setSignalStrength(int v) {
        this.setInt(signalStrength, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BWifiNetwork() {
    }

    private BWifiNetwork(String networkAsString) {
        this.updateNetworkFromScanResultsLine(networkAsString);
    }

    public static BWifiNetwork makeNetwork(String networkAsString) {
        return new BWifiNetwork(networkAsString);
    }

    public void updateNetworkFromScanResultsLine(String scanResultsLine) {
        int RSSI;
        int frequency;
        Objects.requireNonNull(scanResultsLine, "scanResultsLine argument cannot be null");
        int length = scanResultsLine.length();
        if (length < 24 || length > 512) {
            throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, illegal length " + length);
        }
        if (new StringTokenizer(scanResultsLine, "\n\r\f", true).countTokens() > 1) {
            throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, illegal newline character present");
        }
        String[] resultFields = TextUtil.split((String)scanResultsLine, (char)'\t');
        int tokenCount = resultFields.length;
        if (tokenCount != 5) {
            throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, invalid token count " + tokenCount);
        }
        String token = resultFields[0];
        if (token.length() <= 1) {
            throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, invalid bssid token '" + token + "'");
        }
        this.setBssid(token);
        token = resultFields[1];
        try {
            frequency = Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, invalid frequency token '" + token + "'");
        }
        this.setFrequency(frequency);
        switch (frequency) {
            case 2412: {
                this.setChannel(1);
                break;
            }
            case 2417: {
                this.setChannel(2);
                break;
            }
            case 2422: {
                this.setChannel(3);
                break;
            }
            case 2427: {
                this.setChannel(4);
                break;
            }
            case 2432: {
                this.setChannel(5);
                break;
            }
            case 2437: {
                this.setChannel(6);
                break;
            }
            case 2442: {
                this.setChannel(7);
                break;
            }
            case 2447: {
                this.setChannel(8);
                break;
            }
            case 2452: {
                this.setChannel(9);
                break;
            }
            case 2457: {
                this.setChannel(10);
                break;
            }
            case 2462: {
                this.setChannel(11);
                break;
            }
            case 2467: {
                this.setChannel(12);
                break;
            }
            case 2472: {
                this.setChannel(13);
                break;
            }
            case 2484: {
                this.setChannel(14);
                break;
            }
            case 4915: {
                this.setChannel(183);
                break;
            }
            case 4920: {
                this.setChannel(184);
                break;
            }
            case 4925: {
                this.setChannel(185);
                break;
            }
            case 4935: {
                this.setChannel(187);
                break;
            }
            case 4940: {
                this.setChannel(188);
                break;
            }
            case 4945: {
                this.setChannel(189);
                break;
            }
            case 4960: {
                this.setChannel(192);
                break;
            }
            case 4980: {
                this.setChannel(196);
                break;
            }
            case 5035: {
                this.setChannel(7);
                break;
            }
            case 5040: {
                this.setChannel(8);
                break;
            }
            case 5045: {
                this.setChannel(9);
                break;
            }
            case 5055: {
                this.setChannel(11);
                break;
            }
            case 5170: {
                this.setChannel(34);
                break;
            }
            case 5180: {
                this.setChannel(36);
                break;
            }
            case 5190: {
                this.setChannel(38);
                break;
            }
            case 5200: {
                this.setChannel(40);
                break;
            }
            case 5210: {
                this.setChannel(42);
                break;
            }
            case 5220: {
                this.setChannel(44);
                break;
            }
            case 5230: {
                this.setChannel(46);
                break;
            }
            case 5240: {
                this.setChannel(48);
                break;
            }
            case 5260: {
                this.setChannel(52);
                break;
            }
            case 5280: {
                this.setChannel(56);
                break;
            }
            case 5300: {
                this.setChannel(60);
                break;
            }
            case 5320: {
                this.setChannel(64);
                break;
            }
            case 5500: {
                this.setChannel(100);
                break;
            }
            case 5520: {
                this.setChannel(104);
                break;
            }
            case 5540: {
                this.setChannel(108);
                break;
            }
            case 5560: {
                this.setChannel(112);
                break;
            }
            case 5580: {
                this.setChannel(116);
                break;
            }
            case 5600: {
                this.setChannel(120);
                break;
            }
            case 5620: {
                this.setChannel(124);
                break;
            }
            case 5640: {
                this.setChannel(128);
                break;
            }
            case 5660: {
                this.setChannel(132);
                break;
            }
            case 5680: {
                this.setChannel(136);
                break;
            }
            case 5700: {
                this.setChannel(140);
                break;
            }
            case 5745: {
                this.setChannel(149);
                break;
            }
            case 5765: {
                this.setChannel(153);
                break;
            }
            case 5785: {
                this.setChannel(157);
                break;
            }
            case 5805: {
                this.setChannel(161);
                break;
            }
            case 5825: {
                this.setChannel(165);
                break;
            }
            default: {
                this.setChannel(0);
            }
        }
        token = resultFields[2];
        try {
            RSSI = Integer.parseInt(token);
        }
        catch (NumberFormatException numberFormatException) {
            throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, invalid signal level token '" + token + "'");
        }
        int signalQuality = RSSI < 0 ? (RSSI <= -100 ? 0 : (RSSI >= -50 ? 100 : Math.max(0, Math.min(100, 2 * (RSSI + 100))))) : (RSSI <= 160 ? 0 : (RSSI >= 210 ? 100 : Math.max(0, Math.min(100, 2 * (RSSI - 160)))));
        this.setSignalStrength(signalQuality);
        this.setScanResultFlags("");
        this.setMode(BWifiNetworkMode.managed);
        this.setProtocols(BWifiProtocol.wpa_rsn);
        this.setSecurityPolicies(BWifiSecurityPolicy.none);
        boolean disableNetwork = true;
        token = resultFields[3];
        if (!token.isEmpty()) {
            if (!token.startsWith("[") || !token.endsWith("]")) {
                throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, invalid flags token '" + token + "'");
            }
            this.setScanResultFlags(token);
            if (token.contains("[IBSS]") || token.contains("[PBSS]")) {
                this.setMode(BWifiNetworkMode.ad_hoc);
            }
            if (token.contains("[WPA-PSK") && token.contains("[WPA2-PSK")) {
                this.setProtocols(BWifiProtocol.wpa_rsn);
                this.setSecurityPolicies(BWifiSecurityPolicy.wpapsk_wpa2psk);
                this.setSecuritySettings(new BWifiWPA2PSKSettings());
                disableNetwork = false;
            } else if (token.contains("[WPA-PSK")) {
                this.setProtocols(BWifiProtocol.wpa);
                this.setSecurityPolicies(BWifiSecurityPolicy.wpa_psk);
                BWifiWPAPSKSettings wifiWPAPSKSettings = new BWifiWPAPSKSettings();
                if (token.contains("-CCMP]")) {
                    wifiWPAPSKSettings.setGroupCipher(BWifiEncryptionMethod.ccmp);
                    wifiWPAPSKSettings.setPairwiseCipher(BWifiEncryptionMethod.ccmp);
                }
                this.setSecuritySettings(wifiWPAPSKSettings);
                disableNetwork = false;
            } else if (token.contains("[WPA2-PSK")) {
                this.setProtocols(BWifiProtocol.rsn);
                this.setSecurityPolicies(BWifiSecurityPolicy.wpa_2_psk);
                BWifiWPA2PSKSettings wifiWPA2PSKSettings = new BWifiWPA2PSKSettings();
                if (token.contains("-CCMP]")) {
                    wifiWPA2PSKSettings.setGroupCipher(BWifiEncryptionMethod.ccmp);
                    wifiWPA2PSKSettings.setPairwiseCipher(BWifiEncryptionMethod.ccmp);
                }
                this.setSecuritySettings(wifiWPA2PSKSettings);
                disableNetwork = false;
            } else if (token.contains("[WPA2-SAE")) {
                this.setSecurityPolicies(BWifiSecurityPolicy.unsupported);
            } else if (token.contains("[WPA") || token.contains("[WEP")) {
                this.setSecurityPolicies(BWifiSecurityPolicy.unsupported);
            } else {
                this.setSecurityPolicies(BWifiSecurityPolicy.none);
            }
        }
        token = resultFields[4];
        this.setSsid("");
        this.setSsidBroadcasted(false);
        if (!token.isEmpty()) {
            if (token.length() > 32 || token.startsWith(" ") || token.endsWith(" ")) {
                throw new IllegalArgumentException("scanResultsLine argument must be valid 'scan_results' entry, invalid ssid token '" + token + "'");
            }
            this.setSsid(token);
            this.setSsidBroadcasted(true);
        }
        BWifiNetworkStateEnum status = disableNetwork ? BWifiNetworkStateEnum.disabled : BWifiNetworkStateEnum.disconnected;
        this.setNetworkState(status);
    }

    public boolean isNetworkSupported() {
        int ordinal = this.getSecurityPolicies().getOrdinal();
        return ordinal == 6 || ordinal == 5 || ordinal == 3;
    }
}

