/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platwifi;

import com.tridium.platwifi.BWifiNetwork;
import com.tridium.platwifi.security.BWifiEncryptionMethod;
import com.tridium.platwifi.security.BWifiKeyManagementEnum;
import com.tridium.platwifi.security.BWifiProtocol;
import com.tridium.platwifi.security.BWifiSecuritySettings;
import com.tridium.platwifi.security.BWifiWPAPSKSettings;
import com.tridium.platwifi.status.BWifiNetworkStateEnum;
import java.util.Objects;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPassword;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BInteger;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="ssid", type="String", defaultValue="New_Wireless_Network", flags=1), @NiagaraProperty(name="proto", type="String", defaultValue="WPA RSN", flags=1), @NiagaraProperty(name="key_mgmt", type="String", defaultValue="WPA-PSK WPA-EAP", flags=1), @NiagaraProperty(name="pairwise", type="String", defaultValue="CCMP TKIP", flags=1), @NiagaraProperty(name="group", type="String", defaultValue="CCMP TKIP", flags=1), @NiagaraProperty(name="psk", type="BPassword", defaultValue="BPassword.DEFAULT", flags=1), @NiagaraProperty(name="scan_ssid", type="int", defaultValue="0", flags=1, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH }, new BIDataValue[] { BInteger.make(0), BInteger.make(1), BInteger.make(3) })")}), @NiagaraProperty(name="priority", type="int", defaultValue="0", flags=3, facets={@Facet(value="BFacets.make(new String[] { BFacets.MIN, BFacets.MAX, BFacets.FIELD_WIDTH }, new BIDataValue[] { BInteger.make(0), BInteger.make(10), BInteger.make(3) })")}), @NiagaraProperty(name="disabled", type="boolean", defaultValue="false", flags=3)})
public class BSupplicantNetBlock
extends BComponent {
    @Generated
    public static final Property ssid = BSupplicantNetBlock.newProperty((int)1, (String)"New_Wireless_Network", null);
    @Generated
    public static final Property proto = BSupplicantNetBlock.newProperty((int)1, (String)"WPA RSN", null);
    @Generated
    public static final Property key_mgmt = BSupplicantNetBlock.newProperty((int)1, (String)"WPA-PSK WPA-EAP", null);
    @Generated
    public static final Property pairwise = BSupplicantNetBlock.newProperty((int)1, (String)"CCMP TKIP", null);
    @Generated
    public static final Property group = BSupplicantNetBlock.newProperty((int)1, (String)"CCMP TKIP", null);
    @Generated
    public static final Property psk = BSupplicantNetBlock.newProperty((int)1, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property scan_ssid = BSupplicantNetBlock.newProperty((int)1, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)1), BInteger.make((int)3)}));
    @Generated
    public static final Property priority = BSupplicantNetBlock.newProperty((int)3, (int)0, (BFacets)BFacets.make((String[])new String[]{"min", "max", "fieldWidth"}, (BIDataValue[])new BIDataValue[]{BInteger.make((int)0), BInteger.make((int)10), BInteger.make((int)3)}));
    @Generated
    public static final Property disabled = BSupplicantNetBlock.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSupplicantNetBlock.class);

    @Generated
    public String getSsid() {
        return this.getString(ssid);
    }

    @Generated
    public void setSsid(String v) {
        this.setString(ssid, v, null);
    }

    @Generated
    public String getProto() {
        return this.getString(proto);
    }

    @Generated
    public void setProto(String v) {
        this.setString(proto, v, null);
    }

    @Generated
    public String getKey_mgmt() {
        return this.getString(key_mgmt);
    }

    @Generated
    public void setKey_mgmt(String v) {
        this.setString(key_mgmt, v, null);
    }

    @Generated
    public String getPairwise() {
        return this.getString(pairwise);
    }

    @Generated
    public void setPairwise(String v) {
        this.setString(pairwise, v, null);
    }

    @Generated
    public String getGroup() {
        return this.getString(group);
    }

    @Generated
    public void setGroup(String v) {
        this.setString(group, v, null);
    }

    @Generated
    public BPassword getPsk() {
        return (BPassword)this.get(psk);
    }

    @Generated
    public void setPsk(BPassword v) {
        this.set(psk, (BValue)v, null);
    }

    @Generated
    public int getScan_ssid() {
        return this.getInt(scan_ssid);
    }

    @Generated
    public void setScan_ssid(int v) {
        this.setInt(scan_ssid, v, null);
    }

    @Generated
    public int getPriority() {
        return this.getInt(priority);
    }

    @Generated
    public void setPriority(int v) {
        this.setInt(priority, v, null);
    }

    @Generated
    public boolean getDisabled() {
        return this.getBoolean(disabled);
    }

    @Generated
    public void setDisabled(boolean v) {
        this.setBoolean(disabled, v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public static BSupplicantNetBlock make(BWifiNetwork wifiNetwork) {
        Objects.requireNonNull(wifiNetwork, "wifiNetwork argument cannot be null");
        BSupplicantNetBlock supplicantNetBlock = new BSupplicantNetBlock();
        supplicantNetBlock.setSsid(wifiNetwork.getSsid());
        supplicantNetBlock.setProto(BWifiProtocol.toProtocolString(wifiNetwork.getProtocols()));
        supplicantNetBlock.setPriority(wifiNetwork.getPriority());
        supplicantNetBlock.setScan_ssid(wifiNetwork.getSsidBroadcasted() ? 0 : 1);
        supplicantNetBlock.setDisabled(wifiNetwork.getNetworkState().equals((Object)BWifiNetworkStateEnum.disabled));
        BWifiSecuritySettings wifiSecuritySettings = wifiNetwork.getSecuritySettings();
        if (!(wifiSecuritySettings instanceof BWifiWPAPSKSettings)) {
            throw new IllegalArgumentException("Unsupported Wi-Fi network security type: " + (Object)((Object)wifiSecuritySettings));
        }
        BWifiWPAPSKSettings wifiWPAPSKSettings = (BWifiWPAPSKSettings)wifiSecuritySettings;
        supplicantNetBlock.setKey_mgmt(BWifiKeyManagementEnum.toKeyManagementString(wifiWPAPSKSettings.getKeyManagement()));
        supplicantNetBlock.setGroup(BWifiEncryptionMethod.toCipherString(wifiWPAPSKSettings.getGroupCipher()));
        supplicantNetBlock.setPairwise(BWifiEncryptionMethod.toCipherString(wifiWPAPSKSettings.getPairwiseCipher()));
        supplicantNetBlock.setPsk(wifiWPAPSKSettings.getNetworkKey());
        return supplicantNetBlock;
    }
}

