/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.util;

import com.tridium.aaphp.util.AaPhpTextUtil;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpOrdParser {
    final OrdQuery[] aaphpOrdPieces;
    boolean channelAttr = false;
    boolean pointObject = false;
    boolean pointAttr = false;
    boolean fileDrive = false;
    boolean filePath = false;
    public static final String SCHEME_AAPHP = "aaphp";
    public static final String SCHEME_CHANNEL = "channel";
    public static final String SCHEME_POINT = "point";
    public static final String SCHEME_FILE = "file";
    public static final String SCHEME_OBJECT = "object";
    public static final String SCHEME_ATTR = "attr";
    public static final String SCHEME_DRV = "drv";
    public static final String SCHEME_PATH = "path";
    public static final String SCHEME_FNAME = "fname";
    public static final String SCHEME_EXT = "ext";
    public static final String SCHEME_N = "n";
    static final String AAPHP_ITEM = "AaPhp Item";

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AaPhpOrdParser(String aaphpOrd) {
        this.aaphpOrdPieces = BOrd.make((String)aaphpOrd).parse();
        if (this.aaphpOrdPieces == null || this.aaphpOrdPieces.length < 3) throw new BajaRuntimeException("AaPhp ords cannot be empty. They must contain at least three ord queries.");
        if (!this.aaphpOrdPieces[0].getScheme().equals(SCHEME_AAPHP)) throw new BajaRuntimeException("The first schema of aaphp ords must be 'aaphp'!");
        if (this.aaphpOrdPieces[0].getBody().trim().length() != 0) throw new BajaRuntimeException("The aaphp body of aaphp ords must be empty!");
        String scheme2 = this.aaphpOrdPieces[1].getScheme();
        String scheme3 = this.aaphpOrdPieces[2].getScheme();
        if (scheme2.equals(SCHEME_CHANNEL)) {
            if (!scheme3.equals(SCHEME_ATTR)) throw new BajaRuntimeException("The third schem of aaphp-channel ords must be 'attr'!");
            this.channelAttr = true;
            return;
        } else if (scheme2.equals(SCHEME_POINT)) {
            if (scheme3.equals(SCHEME_OBJECT)) {
                this.pointObject = true;
                return;
            } else {
                if (!scheme3.equals(SCHEME_ATTR)) throw new BajaRuntimeException("The third scheme of aaphp-point ords must either be 'object' or 'attr'!");
                this.pointAttr = true;
            }
            return;
        } else {
            if (!scheme2.equals(SCHEME_FILE)) throw new BajaRuntimeException("The second scheme of aaphp ords must either be 'channel','point', or 'file'");
            if (scheme3.equals(SCHEME_DRV)) {
                if (this.aaphpOrdPieces.length != 6) throw new BajaRuntimeException("AaPhp-file-drv must have six parts: 'aaphp','file','drv','fname','ext',and'n'!");
                String scheme4 = this.aaphpOrdPieces[3].getScheme();
                String scheme5 = this.aaphpOrdPieces[4].getScheme();
                String scheme6 = this.aaphpOrdPieces[5].getScheme();
                if (!scheme4.equals(SCHEME_FNAME)) throw new BajaRuntimeException("The fourth part of a aaphp-file-drv ord must be 'fname'!");
                if (!scheme5.equals(SCHEME_EXT)) throw new BajaRuntimeException("The fifth part of a aaphp-file-drv-fname ord must be 'ext', not " + scheme5);
                if (!scheme6.equals(SCHEME_N)) throw new BajaRuntimeException("The sixth part of a aaphp-file-drv-fname-ext ord must be 'n'!");
                this.fileDrive = true;
                this.getDrive();
                this.getFName();
                this.getExt();
                this.getFileNum();
                return;
            } else {
                if (!scheme3.equals(SCHEME_PATH)) throw new BajaRuntimeException("The third scheme of aaphp-file ords must either be 'drv' or 'path'!");
                if (this.aaphpOrdPieces.length != 4) throw new BajaRuntimeException("AaPhp-file-path must have four parts: 'aaphp','file','path','n'!");
                if (!this.aaphpOrdPieces[3].getScheme().equals(SCHEME_N)) throw new BajaRuntimeException("The fourth part of a aaphp-file-path ord must be 'n'!");
                this.filePath = true;
                this.getFilePath();
                this.getFileNum();
            }
        }
    }

    public char getDrive() {
        if (this.isFileDrive()) {
            String sdrive = this.aaphpOrdPieces[2].getBody();
            if (sdrive != null && sdrive.length() > 0) {
                if (sdrive.length() > 1) {
                    throw new BajaRuntimeException("The 'drv' must be exactly one character, not " + sdrive + " which is " + sdrive.length() + " characters.");
                }
                char cdrive = Character.toUpperCase(sdrive.charAt(0));
                if (cdrive >= '0' && cdrive <= '9' || cdrive >= 'A' && cdrive <= 'Z') {
                    return cdrive;
                }
                throw new BajaRuntimeException("The 'drv' must be 0-9 or A-Z, not " + cdrive);
            }
            throw new BajaRuntimeException("The 'drv' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get drive for a aaphp ord that is not a aaphp-fileDrive ord!");
    }

    public String getFName() {
        if (this.isFileDrive()) {
            String fname = this.aaphpOrdPieces[3].getBody();
            if (fname != null && fname.length() > 0) {
                if (fname.length() > 8) {
                    throw new BajaRuntimeException("The 'fname' must be no more than eight characters in length, not " + fname + " which is " + fname.length() + " long.");
                }
                return AaPhpTextUtil.padRight((String)fname, (int)8);
            }
            throw new BajaRuntimeException("The 'fname' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get fname for a aaphp ord that is not a aaphp-fileDrive ord!");
    }

    public String getExt() {
        if (this.isFileDrive()) {
            String eee = this.aaphpOrdPieces[4].getBody();
            if (eee != null && eee.length() > 0) {
                if (eee.length() > 3) {
                    throw new BajaRuntimeException("The 'ext' must be no more than three characters in length, not " + eee + " which is " + eee.length() + " long.");
                }
                return AaPhpTextUtil.padLeft((String)eee, (int)3);
            }
            throw new BajaRuntimeException("The 'ext' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get ext for a aaphp ord that is not a aaphp-fileDrive ord!");
    }

    private char validateFileNum(String n) {
        if (n != null && n.length() > 0) {
            if (n.length() > 1) {
                throw new BajaRuntimeException("The 'n' must be exactly one character, not " + n + " which is " + n.length() + " characters!");
            }
            char charN = Character.toUpperCase(n.charAt(0));
            if (charN >= '0' && charN <= '9' || charN >= 'A' && charN <= 'F') {
                return charN;
            }
            throw new BajaRuntimeException("The 'n' must be 0-9 or A-Z, not " + charN);
        }
        throw new BajaRuntimeException("The 'n' must not be empty!");
    }

    public char getFileNum() {
        if (this.isFileDrive()) {
            return this.validateFileNum(this.aaphpOrdPieces[5].getBody());
        }
        if (this.isFilePath()) {
            return this.validateFileNum(this.aaphpOrdPieces[3].getBody());
        }
        throw new BajaRuntimeException("Cannot get fileNum for a aaphp ord that is niether a aaphp-fileDrive nor a aaphp-filePath ord!");
    }

    public String getFilePath() {
        if (this.isFilePath()) {
            String path = this.aaphpOrdPieces[2].getBody();
            if (path != null && path.length() > 0) {
                return path;
            }
            throw new BajaRuntimeException("The 'path' must not be empty.");
        }
        throw new BajaRuntimeException("Cannot get filePath for a aaphp ord that is not a aaphp-file-path ord!");
    }

    public String getChannel() {
        if (this.isChannelAttr()) {
            return this.aaphpOrdPieces[1].getBody();
        }
        throw new BajaRuntimeException("Cannot get channel for a aaphp ord that is not a aaphp-channel ord!");
    }

    public String getAttr() {
        if (this.isChannelAttr() || this.isPointAttr()) {
            return this.aaphpOrdPieces[2].getBody();
        }
        throw new BajaRuntimeException("Cannot get attr for a aaphp ord that is neither a aaphp-channel nor aaphp-point-attr ord!");
    }

    public String getPoint() {
        if (this.isPointAttr()) {
            return this.aaphpOrdPieces[1].getBody();
        }
        throw new BajaRuntimeException("Cannot get name of point for a aaphp ord that is not a aaphp-point-attr ord!");
    }

    public String getObject() {
        if (this.isPointObject()) {
            return this.aaphpOrdPieces[2].getBody();
        }
        throw new BajaRuntimeException("Cannot get object for a aaphp ord that is not a aaphp-point-object ord!");
    }

    public String getObjectNoAttr() {
        String obj = this.getObject();
        int lastColon = obj.lastIndexOf(58);
        if (lastColon < 0) {
            return obj;
        }
        return obj.substring(0, lastColon);
    }

    public String getObjectAttr() {
        String obj = this.getObject();
        int lastColon = obj.lastIndexOf(58);
        if (lastColon < 0) {
            return "  ";
        }
        return AaPhpTextUtil.truncate((String)obj.substring(lastColon + 1), (int)2);
    }

    public boolean isChannelAttr() {
        return this.channelAttr;
    }

    public boolean isPointAttr() {
        return this.pointAttr;
    }

    public boolean isPointObject() {
        return this.pointObject;
    }

    public boolean isFileDrive() {
        return this.fileDrive;
    }

    public boolean isFilePath() {
        return this.filePath;
    }

    public String getNextAaPhpOrd(String attr) {
        attr = AaPhpTextUtil.truncate((String)attr, (int)2);
        StringBuilder buf = new StringBuilder(SCHEME_AAPHP).append(':').append('|');
        if (this.isChannelAttr()) {
            buf.append(SCHEME_CHANNEL).append(':').append(this.getChannel()).append('|');
        } else if (this.isPointObject()) {
            buf.append(SCHEME_POINT).append(':').append('|').append(SCHEME_OBJECT).append(':').append(this.getObjectNoAttr()).append(':').append(attr);
        } else if (this.isPointAttr()) {
            buf.append(SCHEME_POINT).append(':').append(this.getPoint()).append('|').append(SCHEME_ATTR).append(':').append(attr);
        } else {
            throw new IllegalStateException("Cannot get next aaphp ord from this ord. Please have my program fixed!");
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        if (this.isFileDrive()) {
            ret.append(this.getDrive()).append(':').append(this.getFName().trim()).append('.').append(this.getExt().trim()).append('#').append(this.getFileNum());
        } else if (this.isFilePath()) {
            ret.append(this.getFilePath()).append('#').append(this.getFileNum());
        } else if (this.isChannelAttr()) {
            ret.append(SCHEME_CHANNEL).append(' ').append(this.getChannel()).append(' ').append(SCHEME_ATTR).append(' ').append(this.getAttr());
        } else if (this.isPointAttr()) {
            ret.append(SCHEME_POINT).append(' ').append(this.getPoint()).append(' ').append(SCHEME_ATTR).append(' ').append(this.getAttr());
        } else if (this.isPointObject()) {
            ret.append(SCHEME_OBJECT).append(' ').append(this.getObject());
        } else {
            ret.append(AAPHP_ITEM);
        }
        return ret.toString();
    }

    public static void main(String[] argv) {
        System.out.println("Integer.MAX_VALUE=2147483647");
        System.out.println("Integer.MIN_VALUE=-2147483648");
        if (argv == null || argv.length == 0) {
            argv = new String[]{"aaphp:|file:|path:pp..pp|n:n"};
        }
        for (int x = 0; x < argv.length; ++x) {
            BOrd aaphpProxyOrd = BOrd.make((String)argv[x]);
            OrdQuery[] pieces = aaphpProxyOrd.parse();
            for (int i = 0; i < pieces.length; ++i) {
                System.out.println("Scheme = " + pieces[i].getScheme());
                System.out.println("Body   = " + pieces[i].getBody());
            }
            AaPhpOrdParser pop = new AaPhpOrdParser(argv[x]);
            if (pop.isChannelAttr()) {
                System.out.println("Ord is a aaphp-channel ord");
            }
            if (pop.isFileDrive()) {
                System.out.println("Ord is a aaphp-file-drv ord");
            }
            if (pop.isFilePath()) {
                System.out.println("Ord is a aaphp-file-path ord");
            }
            if (pop.isPointAttr()) {
                System.out.println("Ord is a aaphp-point-attr ord");
            }
            if (!pop.isPointObject()) continue;
            System.out.println("Ord is a aaphp-point-object ord");
        }
    }
}

