/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.point;

import com.tridium.aaphp.datatypes.BAaPhpOrd;
import com.tridium.aaphp.datatypes.BAaPhpStarAttribute;
import com.tridium.aaphp.enums.BAaPhpPrewriteAttributeEnum;
import com.tridium.aaphp.messages.AaPhpReadAttributeRequest;
import com.tridium.aaphp.messages.AaPhpReadAttributeResponse;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import com.tridium.aaphp.messages.AaPhpWriteAttributeRequest;
import com.tridium.aaphp.messages.AaPhpWriteAttributeResponse;
import com.tridium.aaphp.point.AaPhpCvOverrideRequest;
import com.tridium.aaphp.point.AaPhpSetDateRequest;
import com.tridium.aaphp.point.AaPhpSetTimeRequest;
import com.tridium.aaphp.point.BAaPhpAttributeProxyExt;
import com.tridium.aaphp.point.BAaPhpCvOverrideAction;
import com.tridium.aaphp.point.BAaPhpCvResetOverrideAction;
import com.tridium.aaphp.point.BAaPhpSetDateAction;
import com.tridium.aaphp.point.BAaPhpSetTimeAction;
import javax.baja.data.BIDataValue;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BFacets;
import javax.baja.sys.BTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="aaPhpOrd", type="BAaPhpOrd", defaultValue="new BAaPhpStarAttribute()", override=true), @NiagaraProperty(name="prewriteAttribute", type="BAaPhpPrewriteAttributeEnum", defaultValue="BAaPhpPrewriteAttributeEnum.none", flags=4)})
public class BAaPhpStarProxyExt
extends BAaPhpAttributeProxyExt {
    @Generated
    public static final Property aaPhpOrd = BAaPhpStarProxyExt.newProperty((int)0, (BValue)new BAaPhpStarAttribute(), null);
    @Generated
    public static final Property prewriteAttribute = BAaPhpStarProxyExt.newProperty((int)4, (BValue)BAaPhpPrewriteAttributeEnum.none, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAaPhpStarProxyExt.class);

    @Generated
    public BAaPhpPrewriteAttributeEnum getPrewriteAttribute() {
        return (BAaPhpPrewriteAttributeEnum)this.get(prewriteAttribute);
    }

    @Generated
    public void setPrewriteAttribute(BAaPhpPrewriteAttributeEnum v) {
        this.set(prewriteAttribute, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.checkCvOverrideAction();
        this.checkTimeAction();
        this.checkDateAction();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p.equals(prewriteAttribute)) {
            this.checkCvOverrideAction();
            this.readReset();
            this.writeOk(this.getReadValue());
        }
        if (p.equals(aaPhpOrd)) {
            this.setStale(true, null);
            if (this.getParentPoint().isWritablePoint()) {
                this.getTuning().writeDesired();
            }
            this.checkTimeAction();
            this.checkDateAction();
            this.checkCvOverrideAction();
            this.doForceRead();
        }
    }

    @Override
    void processResponseData(AaPhpReadAttributeResponse rsp) {
        this.attrConv = rsp.getAttrConv();
        ((BAaPhpStarAttribute)this.getAaPhpOrd()).setNumericEncodingType(this.attrConv.getAaPhpType());
        super.processResponseData(rsp);
    }

    public void checkTimeAction() {
        BAaPhpSetTimeAction[] a = (BAaPhpSetTimeAction[])this.getParentPoint().getChildren(BAaPhpSetTimeAction.class);
        int attributeType = ((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType();
        switch (attributeType) {
            case 24: {
                if (a.length == 0) {
                    BAaPhpSetTimeAction setpt = new BAaPhpSetTimeAction();
                    this.getParentPoint().add("AdjustTime", (BValue)setpt, 2);
                }
                return;
            }
        }
        for (int i = 0; i < a.length; ++i) {
            this.getParentPoint().remove((BComplex)a[i]);
        }
    }

    public void setTimeAttribute(BValue arg, Context cx) {
        if (arg instanceof BTime) {
            this.getLog().trace("Set Time Attribute on " + this + ":value=" + arg);
            switch (((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType()) {
                case 24: {
                    this.getAaPhpNetwork().postWrite(new AaPhpSetTimeRequest(this, (BTime)arg));
                    return;
                }
            }
            return;
        }
    }

    public boolean setTimeAttribute(BTime outTime) {
        this.getLog().trace("setTimeAttribute:" + outTime + " " + outTime.getHour() + ":" + outTime.getMinute() + ":" + outTime.getSecond());
        int hours = outTime.getHour();
        int minutes = outTime.getMinute();
        long formatted = minutes / 10 << 12 | minutes % 10 << 8 | hours / 10 << 4 | hours % 10;
        AaPhpWriteAttributeRequest req = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), this.getAaPhpOrd().getAaPhpOrd(), formatted);
        AaPhpWriteAttributeResponse rsp = (AaPhpWriteAttributeResponse)this.getAaPhpNetwork().sendSync(req);
        if (rsp == null) {
            this.writeFail("device time out while setting time value");
            this.getDevice().pingFail("timeout");
            return false;
        }
        if (rsp.isError()) {
            this.writeFail("error while setting time value:" + rsp.getErrorMsg());
            return false;
        }
        this.writeOk((BStatusValue)new BStatusString(outTime.toString((Context)BFacets.make((String)"showDate", (BIDataValue)BBoolean.make((boolean)false)))));
        return true;
    }

    public void checkDateAction() {
        BAaPhpSetDateAction[] a = (BAaPhpSetDateAction[])this.getParentPoint().getChildren(BAaPhpSetDateAction.class);
        int attributeType = ((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType();
        switch (attributeType) {
            case 49: {
                if (a.length == 0) {
                    BAaPhpSetDateAction setpt = new BAaPhpSetDateAction();
                    this.getParentPoint().add("AdjustDate", (BValue)setpt, 2);
                }
                return;
            }
        }
        for (int i = 0; i < a.length; ++i) {
            this.getParentPoint().remove((BComplex)a[i]);
        }
    }

    public void setDateAttribute(BValue arg, Context cx) {
        if (arg instanceof BAbsTime) {
            this.getLog().trace("Set Date Attribute on " + this + ":value=" + (BAbsTime)arg);
            switch (((BAaPhpStarAttribute)this.getAaPhpOrd()).getNumericEncodingType()) {
                case 49: {
                    this.getAaPhpNetwork().postWrite(new AaPhpSetDateRequest(this, (BAbsTime)arg));
                    return;
                }
            }
            return;
        }
    }

    public boolean setDateAttribute(BAbsTime outTime) {
        int year = outTime.getYear();
        int month = outTime.getMonth().getMonthOfYear();
        int day = outTime.getDay();
        long bcdDate = year / 1000 << 28 | year % 1000 / 100 << 24 | year % 100 / 10 << 20 | year % 10 << 16 | month / 10 << 12 | month % 10 << 8 | day / 10 << 4 | day % 10;
        AaPhpWriteAttributeRequest req = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), this.getAaPhpOrd().getAaPhpOrd(), bcdDate);
        AaPhpWriteAttributeResponse rsp = (AaPhpWriteAttributeResponse)this.getAaPhpNetwork().sendSync(req);
        if (rsp == null) {
            this.writeFail("device time out while setting date value");
            this.getDevice().pingFail("timeout");
            return false;
        }
        if (rsp.isError()) {
            this.writeFail("error while setting date value:" + rsp.getErrorMsg());
            return false;
        }
        this.writeOk((BStatusValue)new BStatusString(outTime.toString((Context)BFacets.make((String)"showTime", (BIDataValue)BBoolean.make((boolean)false)))));
        return true;
    }

    public void checkCvOverrideAction() {
        if (((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && !this.getParentPoint().isWritablePoint()) {
            this.setFlags((Slot)prewriteAttribute, this.getFlags((Slot)prewriteAttribute) & 0xFFFFFFFB);
        }
        BAaPhpCvOverrideAction[] a = (BAaPhpCvOverrideAction[])this.getParentPoint().getChildren(BAaPhpCvOverrideAction.class);
        BAaPhpCvResetOverrideAction[] b = (BAaPhpCvResetOverrideAction[])this.getParentPoint().getChildren(BAaPhpCvResetOverrideAction.class);
        for (int i = 0; i < a.length; ++i) {
            this.getParentPoint().remove((BComplex)a[i]);
        }
        for (int j = 0; j < b.length; ++j) {
            this.getParentPoint().remove((BComplex)b[j]);
        }
        if (!this.getParentPoint().isWritablePoint() && ((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            BAaPhpCvOverrideAction setpt = new BAaPhpCvOverrideAction();
            setpt.setParameterTypeSpec(this.getParentPoint().getStatusValue().getValueValue().getType().getTypeSpec());
            if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                this.getParentPoint().add("Override", (BValue)setpt, 2);
            } else {
                this.getParentPoint().add("Manual", (BValue)setpt, 2);
            }
            BAaPhpCvResetOverrideAction resetpt = new BAaPhpCvResetOverrideAction();
            if (this.getPrewriteAttribute().getAttribute().equals("OI")) {
                this.getParentPoint().add("CancelOverride", (BValue)resetpt, 2);
            } else {
                this.getParentPoint().add("Auto", (BValue)resetpt, 2);
            }
        }
    }

    public void setCvOverride(BValue arg, Context cx) {
        this.getLog().trace("Set CV override on " + this + ":value=" + arg);
        if (!this.getParentPoint().isWritablePoint() && ((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.getAaPhpNetwork().postWrite(new AaPhpCvOverrideRequest(this, arg));
        }
    }

    public void resetCvOverride(BValue arg, Context cx) {
        this.getLog().trace("Reset CV override on " + this);
        if (!this.getParentPoint().isWritablePoint() && ((BAaPhpStarAttribute)this.getAaPhpOrd()).getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            this.getAaPhpNetwork().postAsync(new Runnable(){

                @Override
                public void run() {
                    BAaPhpStarAttribute prewriteOrd = (BAaPhpStarAttribute)BAaPhpStarProxyExt.this.getAaPhpOrd().newCopy();
                    prewriteOrd.setAttr(BAaPhpStarProxyExt.this.getPrewriteAttribute().getAttribute());
                    AaPhpWriteAttributeRequest req = new AaPhpWriteAttributeRequest(BAaPhpStarProxyExt.this.getDeviceAddress(), prewriteOrd.getAaPhpOrd(), BAaPhpStarProxyExt.this.getPrewriteAttribute().getMakeUnwritableValue());
                    AaPhpWriteAttributeResponse rsp = (AaPhpWriteAttributeResponse)BAaPhpStarProxyExt.this.getAaPhpNetwork().sendSync(req);
                    if (rsp == null) {
                        BAaPhpStarProxyExt.this.writeFail("device time out while clearing override");
                        BAaPhpStarProxyExt.this.getDevice().pingFail("timeout");
                    } else if (rsp.isError()) {
                        BAaPhpStarProxyExt.this.writeFail("error clearing override:" + rsp.getErrorMsg());
                    }
                }
            });
        }
    }

    @Override
    boolean updateOutput(BStatusValue out) {
        if (!this.prewriteAttribute()) {
            this.writeFail("unable to set override or manual");
            return false;
        }
        return super.updateOutput(out);
    }

    boolean prewriteAttribute() {
        if (!this.getPrewriteAttribute().prewriteRequired()) {
            return true;
        }
        String attribute = this.getPrewriteAttribute().getAttribute();
        BAaPhpStarAttribute prewriteOrd = (BAaPhpStarAttribute)this.getAaPhpOrd().newCopy();
        prewriteOrd.setAttr(attribute);
        long dataOut = this.getPrewriteAttribute().getMakeWritableValue();
        String ordString = prewriteOrd.getAaPhpOrd();
        AaPhpWriteAttributeRequest msg = new AaPhpWriteAttributeRequest(this.getDeviceAddress(), ordString, dataOut);
        AaPhpSimpleAckResponse rsp = (AaPhpSimpleAckResponse)this.getAaPhpNetwork().sendSync(msg);
        if (rsp == null) {
            return false;
        }
        return !rsp.isError();
    }

    @Override
    protected void pollForData() {
        BAaPhpStarAttribute aaphpOrd = (BAaPhpStarAttribute)this.getAaPhpOrd();
        if (aaphpOrd.getAttr().equals("CV") && this.getPrewriteAttribute().prewriteRequired()) {
            BAaPhpStarAttribute ovrOrd = (BAaPhpStarAttribute)aaphpOrd.newCopy();
            ovrOrd.setAttr(this.getPrewriteAttribute().getAttribute());
            this.overriddenState = this.discoverOverriddenState(ovrOrd);
        } else {
            this.overriddenState = false;
        }
        super.pollForData();
    }

    @Override
    protected boolean discoverOverriddenState(BAaPhpOrd ovrOrd) {
        AaPhpReadAttributeRequest req = null;
        AaPhpReadAttributeResponse rsp = null;
        boolean overridden = false;
        try {
            String aaphpOrdString = ovrOrd.getAaPhpOrd();
            req = new AaPhpReadAttributeRequest(this.getDeviceAddress(), aaphpOrdString);
            rsp = (AaPhpReadAttributeResponse)this.getAaPhpNetwork().sendSync(req);
            if (rsp == null) {
                this.readFail("device timeout");
            } else if (rsp.isError()) {
                this.readFail("AaPhpError reading override attribute:" + rsp.getErrorMsg());
            } else {
                overridden = this.getPrewriteAttribute().isOverridden(rsp.getBooleanValue(null));
            }
        }
        catch (Exception e) {
            this.readFail("" + e);
            e.printStackTrace();
        }
        return overridden;
    }
}

