/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpMessage;
import com.tridium.aaphp.messages.AaPhpOutputStream;
import com.tridium.aaphp.messages.AaPhpReceivedMessage;
import com.tridium.aaphp.messages.AaPhpWriteAttributeResponse;
import com.tridium.aaphp.util.AaPhpOrdParser;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import java.io.IOException;
import java.io.OutputStream;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpWriteAttributeRequest
extends AaPhpMessage {
    final AaPhpOrdParser aaphpOrdParser;
    final String aaphpOrd;
    final long rawData;

    public AaPhpWriteAttributeRequest(int unitNumberAddress, String aaphpOrd, long rawData) {
        super(unitNumberAddress);
        this.aaphpOrd = aaphpOrd;
        this.aaphpOrdParser = new AaPhpOrdParser(aaphpOrd);
        this.rawData = rawData;
    }

    public void write(OutputStream out) {
        AaPhpOutputStream aaphpOutStream = new AaPhpOutputStream();
        aaphpOutStream.write(59);
        aaphpOutStream.write(this.getUnitNumberAddress());
        if (this.aaphpOrdParser.isChannelAttr()) {
            aaphpOutStream.writeCmdCode("01");
            aaphpOutStream.writeChannel(this.aaphpOrdParser.getChannel());
            aaphpOutStream.writeAttribute(this.aaphpOrdParser.getAttr());
        } else if (this.aaphpOrdParser.isPointAttr()) {
            aaphpOutStream.writeCmdCode("03");
            aaphpOutStream.writePointName(this.aaphpOrdParser.getPoint());
            aaphpOutStream.writeAttribute(this.aaphpOrdParser.getAttr());
        } else if (this.aaphpOrdParser.isPointObject()) {
            aaphpOutStream.writeCmdCode("03");
            aaphpOutStream.write(39);
            aaphpOutStream.writeObjectName(this.aaphpOrdParser.getObject());
            aaphpOutStream.write(39);
        } else {
            throw new BajaRuntimeException("Unrecognized aaphp ord:" + this.aaphpOrd);
        }
        aaphpOutStream.writeRawDataHex32(this.rawData);
        aaphpOutStream.writeCrc();
        aaphpOutStream.write(13);
        try {
            out.write(aaphpOutStream.toByteArray());
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException((Throwable)ioe);
        }
    }

    public Message toResponse(ReceivedMessage resp) {
        return new AaPhpWriteAttributeResponse(this.getUnitNumberAddress(), new AaPhpInputStream(((AaPhpReceivedMessage)resp).getBytes()));
    }
}

