/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpInputStream;
import com.tridium.aaphp.messages.AaPhpSimpleAckResponse;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;
import javax.baja.sys.BajaRuntimeException;

public class AaPhpReadMessageTextResponse
extends AaPhpSimpleAckResponse {
    final char firstChar;
    private String messageText;

    public AaPhpReadMessageTextResponse(int unitNumber, AaPhpInputStream inStream) {
        super(unitNumber, inStream);
        if (inStream.available() > 1) {
            this.messageText = inStream.readMessageText();
            this.firstChar = this.messageText.charAt(0);
        } else {
            this.messageText = "";
            this.firstChar = '\u0000';
        }
    }

    public boolean isEmpty() {
        return this.firstChar == '\u0000' && this.messageText.length() == 0;
    }

    public boolean isContinuation() {
        return this.firstChar == '-';
    }

    public boolean isUnrestricted() {
        return !Character.isDigit(this.firstChar) && this.firstChar != '-';
    }

    public boolean isUnstructuredTransaction() {
        return Character.isDigit(this.firstChar) && this.messageText.charAt(5) != '/';
    }

    public boolean isStructuredTransaction() {
        return Character.isDigit(this.firstChar) && this.messageText.charAt(5) == '/';
    }

    public boolean isTransaction() {
        return Character.isDigit(this.firstChar);
    }

    public int getTransactionId() {
        if (this.isTransaction()) {
            return Integer.parseInt(this.messageText.substring(0, 5));
        }
        throw new BajaRuntimeException("Sorry, this is not a transaction message!");
    }

    public int getTransactionSource() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(6, 11));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public String getAaPhpMsgClassName() {
        if (this.isStructuredTransaction() || this.isContinuation()) {
            return this.messageText.substring(12, 15).trim();
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public String getDayOfWeek() {
        if (this.isStructuredTransaction()) {
            return this.messageText.substring(16, 19).trim();
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getDayOfMonth() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(20, 22).trim());
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public String getMonthOfYear() {
        if (this.isStructuredTransaction()) {
            return this.messageText.substring(23, 26).trim();
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public BMonth getBMonth() {
        String aaphpMonth = this.getMonthOfYear().toUpperCase();
        if (aaphpMonth.equals("JAN")) {
            return BMonth.january;
        }
        if (aaphpMonth.equals("FEB")) {
            return BMonth.february;
        }
        if (aaphpMonth.equals("MAR")) {
            return BMonth.march;
        }
        if (aaphpMonth.equals("APR")) {
            return BMonth.april;
        }
        if (aaphpMonth.equals("MAY")) {
            return BMonth.may;
        }
        if (aaphpMonth.equals("JUN")) {
            return BMonth.june;
        }
        if (aaphpMonth.equals("JUL")) {
            return BMonth.july;
        }
        if (aaphpMonth.equals("AUG")) {
            return BMonth.august;
        }
        if (aaphpMonth.equals("SEP")) {
            return BMonth.september;
        }
        if (aaphpMonth.equals("OCT")) {
            return BMonth.october;
        }
        if (aaphpMonth.equals("NOV")) {
            return BMonth.november;
        }
        if (aaphpMonth.equals("DEC")) {
            return BMonth.december;
        }
        throw new BajaRuntimeException("Unrecognized aaphp month: " + aaphpMonth + ". Please have my program fixed!");
    }

    public int getYear() {
        if (this.isStructuredTransaction()) {
            int yy = Integer.parseInt(this.messageText.substring(27, 29));
            return yy >= 80 ? 1900 + yy : 2000 + yy;
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getHour() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(30, 32));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getMinute() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(33, 35));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public int getSecond() {
        if (this.isStructuredTransaction()) {
            return Integer.parseInt(this.messageText.substring(36, 38));
        }
        throw new BajaRuntimeException("Sorry, this is not a structured transaction message!");
    }

    public BAbsTime getAbsTime() {
        return BAbsTime.make((int)this.getYear(), (BMonth)this.getBMonth(), (int)this.getDayOfMonth(), (int)this.getHour(), (int)this.getMinute(), (int)this.getSecond(), (int)0);
    }

    public String getText() {
        if (this.isStructuredTransaction()) {
            return this.messageText.substring(37);
        }
        if (this.isUnstructuredTransaction()) {
            return this.messageText.substring(6);
        }
        if (this.isUnstructuredTransaction()) {
            return this.messageText;
        }
        if (this.isContinuation()) {
            return this.messageText.substring(16);
        }
        throw new BajaRuntimeException("Unsupported message type - please have my program fixed.");
    }

    public String getMessageText() {
        return this.messageText;
    }

    public void appendText(String text) {
        this.messageText = this.messageText + text;
    }
}

