/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.util.AaPhpTextUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.baja.nre.util.TextUtil;
import javax.baja.sys.BAbsTime;

public class AaPhpOutputStream
extends ByteArrayOutputStream {
    static final String FOUR_ZEROS = "0000";

    public AaPhpOutputStream() {
    }

    public AaPhpOutputStream(int size) {
        super(size);
    }

    @Override
    public synchronized void write(int b) {
        super.write(b);
    }

    public void writeAttribute(String a) {
        a = TextUtil.padLeft((String)a, (int)2);
        a = TextUtil.truncate((String)a, (int)2);
        this.writeString(a);
    }

    public void writeCmdCode(String c) {
        c = TextUtil.padLeft((String)c, (int)2);
        c = TextUtil.truncate((String)c, (int)2);
        this.writeString(c);
    }

    private void writeString(String s) {
        try {
            this.write(s.getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeVirtualTerminal(String s) {
        byte[] bytes = s.getBytes();
        for (int i = 0; i < bytes.length; ++i) {
            int b = bytes[i] & 0xFF;
            if (b < 32 || b == 59 || b == 127) {
                this.write(27);
                this.writeString(AaPhpTextUtil.byteToHexString(b).toUpperCase());
                continue;
            }
            this.write(b);
        }
    }

    public void writeTimeDate(BAbsTime newTime) {
        if (newTime.getHour() < 10) {
            this.writeString("0");
        }
        this.writeString(Integer.toString(newTime.getHour()));
        if (newTime.getMinute() < 10) {
            this.writeString("0");
        }
        this.writeString(Integer.toString(newTime.getMinute()));
        if (newTime.getSecond() < 10) {
            this.writeString("0");
        }
        this.writeString(Integer.toString(newTime.getSecond()));
        if (newTime.getDay() < 16) {
            this.writeString("0");
        }
        this.writeString(Integer.toHexString(newTime.getDay()).toUpperCase());
        int month = newTime.getMonth().getMonthOfYear();
        this.writeString("0");
        this.writeString(Integer.toHexString(month).toUpperCase());
        int year = newTime.getYear() % 100;
        if (year < 16) {
            this.writeString("0");
        }
        this.writeString(Integer.toHexString(year).toUpperCase());
    }

    public void writePointName(String pointName) {
        pointName = TextUtil.padRight((String)pointName, (int)12);
        pointName = TextUtil.truncate((String)pointName, (int)12);
        this.writeString(pointName);
    }

    public void writeObjectName(String objectName) {
        objectName = TextUtil.truncate((String)objectName, (int)32);
        this.writeString(objectName);
    }

    public void writeChannel(String c) {
        this.writeString(c);
    }

    public void writeFName(String f) {
        System.out.println(".." + f + "..");
        f = AaPhpTextUtil.padRight((String)f, (int)8);
        f = AaPhpTextUtil.truncate((String)f, (int)8);
        this.writeString(f);
    }

    public void writeExt(String e) {
        e = AaPhpTextUtil.padLeft((String)e, (int)3);
        e = AaPhpTextUtil.truncate((String)e, (int)3);
        this.writeString(e);
    }

    public void writeFileNum(char n) {
        this.write(n);
    }

    public void writeFilePath(String p) {
        this.writeString(p);
    }

    public void writeUnitNumber(int u) {
        this.write(u & 0xFF);
    }

    public void writeCrc() {
        this.writeRawDataHex16(AaPhpOutputStream.makeCrc(this.toByteArray()));
    }

    public void writeRawDataHex16(int rawData) {
        this.writeString(AaPhpTextUtil.byteToHexString((rawData & 0xFF) >> 0));
        this.writeString(AaPhpTextUtil.byteToHexString((rawData & 0xFF00) >> 8));
    }

    public void writeRawDataHex32(long rawData) {
        this.writeString(AaPhpTextUtil.byteToHexString((int)((rawData & 0xFFL) >> 0)));
        this.writeString(AaPhpTextUtil.byteToHexString((int)((rawData & 0xFF00L) >> 8)));
        this.writeString(AaPhpTextUtil.byteToHexString((int)((rawData & 0xFF0000L) >> 16)));
        this.writeString(AaPhpTextUtil.byteToHexString((int)((rawData & 0xFFFFFFFFFF000000L) >> 24)));
    }

    public void writeHexBytes(byte[] d, int a, int b) {
        if (b - a > 128) {
            throw new IllegalArgumentException("The number of bytes must be less than or equal to 128, not " + (b - a) + '!');
        }
        StringBuilder buf = new StringBuilder();
        for (int i = a; i < b && i < d.length; ++i) {
            buf.append(TextUtil.byteToHexString((int)(d[i] & 0xFF)).toUpperCase());
        }
        try {
            this.write(buf.toString().getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeHexBytes(byte[] d) {
        if (d.length > 128) {
            throw new IllegalArgumentException("The length of the given byte array must be less than or equal to 128, not " + d.length + '!');
        }
        try {
            this.write(AaPhpTextUtil.bytesToHex(d).getBytes());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static boolean checkCrc(byte[] fullMessage) {
        return new CrcComputer().crcCheck(fullMessage);
    }

    static int makeCrc(byte[] messageData) {
        return new CrcComputer().crcMake(messageData);
    }

    static class CrcComputer {
        int crc;

        CrcComputer() {
        }

        void crcInit() {
            this.crc = 0;
        }

        void eachByte(byte data) {
            int count = 8;
            do {
                int c;
                if ((c = data & 1 ^ this.crc & 1) != 0) {
                    this.crc ^= 0x4002;
                }
                int conglomerate = c << 24 | (this.crc & 0xFFFF) << 8 | data & 0xFF;
                this.crc = ((conglomerate >>= 1) & 0xFFFF00) >> 8;
                data = (byte)(conglomerate & 0xFF);
            } while (--count > 0);
        }

        boolean crcCheck(byte[] dataBytes) {
            this.crcInit();
            for (int i = 0; i < dataBytes.length - 4; ++i) {
                this.eachByte(dataBytes[i]);
            }
            int dlen = dataBytes.length;
            byte[] bXmitCrcLo = new byte[]{dataBytes[dlen - 4], dataBytes[dlen - 3]};
            byte[] bXmitCrcHi = new byte[]{dataBytes[dlen - 2], dataBytes[dlen - 1]};
            String sXmitCrcLo = new String(bXmitCrcLo);
            String sXmitCrcHi = new String(bXmitCrcHi);
            int xmitCrcLo = Integer.parseInt(sXmitCrcLo, 16);
            int xmitCrcHi = Integer.parseInt(sXmitCrcHi, 16);
            this.eachByte((byte)xmitCrcLo);
            this.eachByte((byte)xmitCrcHi);
            return this.crc == 0;
        }

        int crcMake(byte[] dataBytes) {
            this.crcInit();
            for (int i = 0; i < dataBytes.length; ++i) {
                this.eachByte(dataBytes[i]);
            }
            return this.crc;
        }
    }
}

