/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.aaphp.messages;

import com.tridium.aaphp.messages.AaPhpOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.LocalizableRuntimeException;

public class AaPhpInputStream
extends ByteArrayInputStream {
    public AaPhpInputStream(byte[] buf) {
        this(buf, true);
    }

    public AaPhpInputStream(byte[] buf, boolean checkCrc) {
        super(buf);
        if (checkCrc && buf[0] != 42 && !AaPhpOutputStream.checkCrc(buf)) {
            throw new LocalizableRuntimeException("aaphp", "crcError");
        }
    }

    public AaPhpInputStream(byte[] buf, int offset, int length) {
        super(buf, offset, length);
    }

    public char readResponseType() {
        return (char)this.read();
    }

    public String readAttributeName() {
        return this.readString(2);
    }

    public int readEncodingType() {
        int encoding;
        try {
            encoding = Integer.parseInt(this.readString(2), 16);
        }
        catch (NumberFormatException e) {
            encoding = 255;
        }
        return encoding;
    }

    public String readString(int size) {
        byte[] asciiBytes = new byte[size];
        try {
            this.read(asciiBytes);
        }
        catch (IOException ioe) {
            throw new BajaRuntimeException("Cannot parse attribute name from bytes.", (Throwable)ioe);
        }
        return new String(asciiBytes);
    }

    public long readRawDataHex32() {
        return this.readRawDataHex8() << 0 | this.readRawDataHex8() << 8 | this.readRawDataHex8() << 16 | this.readRawDataHex8() << 24;
    }

    public int readRawDataHex16() {
        return this.readRawDataHex8() << 0 | this.readRawDataHex8() << 8;
    }

    public int readRawDataHex8() {
        String sByte = this.readString(2);
        return Integer.parseInt(sByte, 16);
    }

    public String readMessageText() {
        return this.readString(this.available() - 4);
    }

    public String readErrorClass() {
        return this.readString(2);
    }

    public String readErrorNumber() {
        return this.readString(2);
    }

    public String readErrorMessage() {
        return this.readString(this.available() - 4);
    }

    public void readHexBytes(byte[] d, int a, int b) {
        if (b - a > 128) {
            throw new IllegalArgumentException("The number of bytes must be less than or equal to 128, not " + (b - a) + '!');
        }
        for (int i = a; i < b && i < d.length; ++i) {
            d[i] = (byte)this.readRawDataHex8();
        }
    }

    public byte[] readHexBytes() {
        int numHexBytes = (this.available() - 4) / 2;
        byte[] ret = new byte[numHexBytes];
        this.readHexBytes(ret, 0, numHexBytes);
        return ret;
    }
}

