/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history.ext;

import com.tridium.util.PxUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.agent.AgentList;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.data.BIDataValue;
import javax.baja.history.BCollectionInterval;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.BTrendRecord;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.history.ext.BActivePeriod;
import javax.baja.history.ext.BBasicActivePeriod;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusValue;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Localizable;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BFormat;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=3), @NiagaraProperty(name="faultCause", type="String", defaultValue="", flags=3), @NiagaraProperty(name="enabled", type="boolean", defaultValue="false", flags=64), @NiagaraProperty(name="activePeriod", type="BActivePeriod", defaultValue="new BBasicActivePeriod()", facets={@Facet(value="BFacets.make(\"alwaysExpand\", BBoolean.make(true))")}), @NiagaraProperty(name="active", type="boolean", defaultValue="false", flags=3), @NiagaraProperty(name="historyName", type="BFormat", defaultValue="BFormat.make(\"%parent.name%\")"), @NiagaraProperty(name="historyNameFormat", type="BFormat", defaultValue="BFormat.make(\"%parent.name%\")", flags=6), @NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig()"), @NiagaraProperty(name="lastRecord", type="BHistoryRecord", defaultValue="new BStringTrendRecord()", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="updateHistoryId", flags=16), @NiagaraAction(name="syncConfig", flags=20), @NiagaraAction(name="activate", flags=20), @NiagaraAction(name="deactivate", flags=20)})
public abstract class BHistoryExt
extends BPointExtension
implements BIHistorySource {
    @Generated
    public static final Property status = BHistoryExt.newProperty((int)3, (BValue)BStatus.ok, null);
    @Generated
    public static final Property faultCause = BHistoryExt.newProperty((int)3, (String)"", null);
    @Generated
    public static final Property enabled = BHistoryExt.newProperty((int)64, (boolean)false, null);
    @Generated
    public static final Property activePeriod = BHistoryExt.newProperty((int)0, (BValue)new BBasicActivePeriod(), (BFacets)BFacets.make((String)"alwaysExpand", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property active = BHistoryExt.newProperty((int)3, (boolean)false, null);
    @Generated
    public static final Property historyName = BHistoryExt.newProperty((int)0, (BValue)BFormat.make((String)"%parent.name%"), null);
    @Generated
    public static final Property historyNameFormat = BHistoryExt.newProperty((int)6, (BValue)BFormat.make((String)"%parent.name%"), null);
    @Generated
    public static final Property historyConfig = BHistoryExt.newProperty((int)0, (BValue)new BHistoryConfig(), null);
    @Generated
    public static final Property lastRecord = BHistoryExt.newProperty((int)3, (BValue)new BStringTrendRecord(), null);
    @Generated
    public static final Action updateHistoryId = BHistoryExt.newAction((int)16, null);
    @Generated
    public static final Action syncConfig = BHistoryExt.newAction((int)20, null);
    @Generated
    public static final Action activate = BHistoryExt.newAction((int)20, null);
    @Generated
    public static final Action deactivate = BHistoryExt.newAction((int)20, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryExt.class);
    public static final Logger log = Logger.getLogger("history.ext");
    private static final ThreadLocal<Boolean> DISABLED_ON_ACTIVATION = new ThreadLocal();
    private boolean start = true;
    private BIHistory history;
    private Clock.Ticket ticket;
    private boolean initHistorySuccessful = false;
    private BFacets localFacets;
    private boolean inInit = false;
    private BAbsTime nextValidThreshold = null;

    @Generated
    public BStatus getStatus() {
        return (BStatus)this.get(status);
    }

    @Generated
    public void setStatus(BStatus v) {
        this.set(status, (BValue)v, null);
    }

    @Generated
    public String getFaultCause() {
        return this.getString(faultCause);
    }

    @Generated
    public void setFaultCause(String v) {
        this.setString(faultCause, v, null);
    }

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BActivePeriod getActivePeriod() {
        return (BActivePeriod)this.get(activePeriod);
    }

    @Generated
    public void setActivePeriod(BActivePeriod v) {
        this.set(activePeriod, (BValue)v, null);
    }

    @Generated
    public boolean getActive() {
        return this.getBoolean(active);
    }

    @Generated
    public void setActive(boolean v) {
        this.setBoolean(active, v, null);
    }

    @Generated
    public BFormat getHistoryName() {
        return (BFormat)this.get(historyName);
    }

    @Generated
    public void setHistoryName(BFormat v) {
        this.set(historyName, (BValue)v, null);
    }

    @Generated
    public BFormat getHistoryNameFormat() {
        return (BFormat)this.get(historyNameFormat);
    }

    @Generated
    public void setHistoryNameFormat(BFormat v) {
        this.set(historyNameFormat, (BValue)v, null);
    }

    @Generated
    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    @Generated
    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    @Generated
    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    @Generated
    public void setLastRecord(BHistoryRecord v) {
        this.set(lastRecord, (BValue)v, null);
    }

    @Generated
    public void updateHistoryId() {
        this.invoke(updateHistoryId, null, null);
    }

    @Generated
    public void syncConfig() {
        this.invoke(syncConfig, null, null);
    }

    @Generated
    public void activate() {
        this.invoke(activate, null, null);
    }

    @Generated
    public void deactivate() {
        this.invoke(deactivate, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getSlotPathOrd());
    }

    protected boolean isSiblingLegal(BComponent sibling) {
        return true;
    }

    public void started() throws Exception {
        super.started();
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        this.setActive(this.getActivePeriod().isActive(BAbsTime.make()));
        Type recType = this.getRecordType();
        if (!recType.is(BTrendRecord.TYPE)) {
            throw new HistoryException("Record type must be a trend record. (actual type = " + recType.getTypeSpec() + ")");
        }
        BHistoryConfig config = this.getHistoryConfig();
        if (!config.getRecordType().equals((Object)recType.getTypeSpec())) {
            config.setRecordType(recType.getTypeSpec());
        }
        this.syncFacets();
    }

    public void descendantsStarted() throws Exception {
        super.descendantsStarted();
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        this.init();
    }

    private void init() {
        this.syncFacets();
        if (this.getEnabled()) {
            try {
                this.initHistory();
                this.checkPointSubscription();
            }
            catch (Exception ex) {
                this.setFault(ex);
                return;
            }
        }
        this.updateStatus();
        try {
            this.scheduleActivation();
        }
        catch (HistoryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HistoryException(ex);
        }
    }

    public void stopped() throws Exception {
        super.stopped();
        this.history = null;
    }

    public void changed(Property p, Context c) {
        if (c == Context.decoding) {
            return;
        }
        if (!this.isRunning()) {
            return;
        }
        try {
            Sys.getService((Type)BHistoryService.TYPE);
        }
        catch (ServiceNotFoundException e) {
            return;
        }
        if (p.equals(enabled)) {
            if (this.getEnabled()) {
                this.init();
            } else {
                if (this.ticket != null) {
                    this.ticket.cancel();
                    this.ticket = null;
                }
                this.history = null;
                this.checkPointSubscription();
                this.updateStatus();
            }
        } else if (p.equals(historyName)) {
            if (this.inInit) {
                return;
            }
            this.initHistory();
        } else if (p.equals(activePeriod)) {
            boolean oldActive = this.getActive();
            boolean newActive = this.getActivePeriod().isActive(BAbsTime.make());
            try {
                if (oldActive != newActive) {
                    if (this.ticket != null) {
                        this.ticket.cancel();
                        this.ticket = null;
                    }
                    if (newActive) {
                        this.processActivate();
                    }
                    this.deactivate();
                }
                this.scheduleActivation();
            }
            catch (HistoryException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new HistoryException(ex);
            }
        } else if (!p.equals(status) && !p.equals(faultCause)) {
            this.updateStatus();
        }
    }

    public void onExecute(BStatusValue out, Context cx) {
        this.syncFacets();
        if (!this.getEnabled() || !Sys.atSteadyState()) {
            return;
        }
        if (this.isRunning() && this.getActive()) {
            BAbsTime now = BAbsTime.make();
            try {
                this.pointChanged(now, out);
            }
            catch (HistoryException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw new HistoryException(ex);
            }
        }
    }

    public abstract void pointChanged(BAbsTime var1, BStatusValue var2) throws Exception;

    public boolean requiresPointSubscription() {
        return this.getEnabled();
    }

    public void checkPointSubscription() {
        BControlPoint point = this.getParentPoint();
        if (point != null) {
            point.checkExtensionsRequireSubscription();
        }
    }

    public void updateStatus() {
        if (!this.getEnabled()) {
            this.setStatus(BStatus.disabled);
            this.setFaultCause("");
        } else {
            boolean validName = this.getHistoryConfig().getId().isValid();
            if (!validName) {
                this.setStatus(BStatus.fault);
                this.setFaultCause("Invalid history name.");
            } else if (this.initHistorySuccessful) {
                if (this.nextValidThreshold != null) {
                    this.setStatus(BStatus.fault);
                    this.setFaultCause("Cannot append out-of-order or duplicate record. This could occur on a backwards system clock change. Next append can occur after " + this.nextValidThreshold);
                } else {
                    this.setStatus(BStatus.ok);
                    this.setFaultCause("");
                }
            } else {
                this.setStatus(BStatus.makeDisabled((BStatus)this.getStatus(), (boolean)false));
            }
        }
    }

    private void scheduleActivation() throws IOException {
        BActivePeriod activePeriod;
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if ((activePeriod = this.getActivePeriod()).isNeverActive()) {
            return;
        }
        BAbsTime now = BAbsTime.make();
        if (activePeriod.isActive(now)) {
            this.processActivate();
        } else {
            BAbsTime next = activePeriod.getNextActive(now);
            if (next != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getSlotPath() + ": next active " + next.toString((Context)BHistoryRecord.TIMESTAMP_FACETS));
                }
                this.ticket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)activate, null);
            }
        }
    }

    private void processActivate() {
        if (!this.getEnabled()) {
            DISABLED_ON_ACTIVATION.set(Boolean.TRUE);
            try {
                this.doActivate();
            }
            finally {
                DISABLED_ON_ACTIVATION.remove();
            }
        } else {
            this.activate();
        }
    }

    public void doActivate() {
        this.start = true;
        try {
            BAbsTime now = BAbsTime.make();
            this.setActive(true);
            if (this.getActivePeriod().isAlwaysActive()) {
                this.activated(now.timeOfDay(0, 0, 0, 0), now, this.getParentPoint().getStatusValue());
            } else {
                BAbsTime activeStart = this.getActivePeriod().getActiveStart(now);
                this.activated(activeStart, now, this.getParentPoint().getStatusValue());
            }
            this.scheduleDeactivation();
        }
        catch (HistoryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HistoryException(ex);
        }
    }

    protected abstract void activated(BAbsTime var1, BAbsTime var2, BStatusValue var3) throws IOException;

    private void scheduleDeactivation() throws IOException {
        BActivePeriod activePeriod;
        if (this.ticket != null) {
            this.ticket.cancel();
            this.ticket = null;
        }
        if ((activePeriod = this.getActivePeriod()).isNeverActive()) {
            return;
        }
        BAbsTime now = BAbsTime.make();
        if (activePeriod.isActive(now)) {
            BAbsTime next = activePeriod.getNextInactive(now);
            if (next != null) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this.getSlotPath() + ": next inactive " + next.toString((Context)BHistoryRecord.TIMESTAMP_FACETS));
                }
                this.ticket = Clock.schedule((BComponent)this, (BAbsTime)next, (Action)deactivate, null);
            }
        } else {
            this.deactivate();
        }
    }

    public void doDeactivate() {
        try {
            this.setActive(false);
            this.deactivated(BAbsTime.make(), this.getParentPoint().getStatusValue());
            this.scheduleActivation();
        }
        catch (HistoryException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new HistoryException(ex);
        }
    }

    protected abstract void deactivated(BAbsTime var1, BStatusValue var2) throws IOException;

    public BIHistory getHistory() {
        return this.history;
    }

    public String resolveHistoryName() {
        BFormat pattern = this.getHistoryName();
        return SlotPath.escape((String)SlotPath.unescape((String)pattern.format((Object)this)));
    }

    private synchronized void initHistory() throws ServiceNotFoundException {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            this.initHistory(conn);
        }
    }

    private synchronized void initHistory(HistoryDatabaseConnection conn) throws ServiceNotFoundException {
        block25: {
            this.initHistorySuccessful = false;
            if (!this.getEnabled()) {
                return;
            }
            try {
                this.inInit = true;
                BFormat oldFormat = this.getHistoryNameFormat();
                String oldName = this.getHistoryConfig().getHistoryName();
                if (oldName.length() != 0) {
                    this.getHistoryConfig().setHistoryName("");
                    this.setHistoryNameFormat(BFormat.DEFAULT);
                    String oldResolved = oldFormat.format((Object)this);
                    if (!oldName.equals(oldResolved)) {
                        this.setHistoryName(BFormat.make((String)oldName));
                    } else {
                        this.setHistoryName(oldFormat);
                    }
                }
                this.inInit = false;
                BHistoryConfig config = this.getHistoryConfig();
                BOrdList source = BOrdList.make((BOrd)this.getSourceOrd());
                BOrd handleOrd = this.getHandleOrd();
                if (!config.getSource().equals((Object)source)) {
                    config.setSource(source);
                }
                if (!config.getSourceHandle().equals((Object)handleOrd)) {
                    config.setSourceHandle(handleOrd);
                }
                if (!config.getTimeZone().equals((Object)BTimeZone.getLocal())) {
                    config.setTimeZone(BTimeZone.getLocal());
                }
                String historyName = this.resolveHistoryName();
                BHistoryId.validateName(historyName);
                BHistoryId newId = BHistoryId.make(Sys.getStation().getStationName(), historyName);
                BHistoryId id = config.getId();
                if (!id.getHistoryName().equals(newId.getHistoryName()) && !id.isNull()) {
                    this.renameAttachedHistory(conn, id, newId);
                }
                if (!id.equals((Object)newId)) {
                    config.setId(newId);
                    id = newId;
                }
                BControlPoint point = this.getParentPoint();
                BFacets facets = point.getFacets();
                BTrendRecord rec = (BTrendRecord)config.makeRecord();
                Property valueProp = rec.getValueProperty();
                String facetsName = valueProp.getName() + "Facets";
                Property prop = config.loadSlots().getProperty(facetsName);
                if (prop == null) {
                    config.add(facetsName, (BValue)facets);
                } else {
                    BFacets oldFacets = (BFacets)config.get(prop);
                    if (!oldFacets.equals((Object)facets)) {
                        config.set(prop, (BValue)facets);
                    }
                }
                this.initConfig(config);
                if (!conn.exists(id) && this.getEnabled()) {
                    conn.createHistory(config);
                    break block25;
                }
                if (!conn.exists(id)) break block25;
                BIHistory existing = conn.getHistory(id);
                BHistoryConfig existingCfg = existing.getConfig();
                BOrdList historySrc = existingCfg.getSource();
                if (historySrc.size() != 1) {
                    throw new HistoryException("Duplicate history id: " + (Object)((Object)config.getId()) + ". Source mismatch.");
                }
                BOrd extOrd = historySrc.get(0);
                BObject src = null;
                try {
                    src = extOrd.resolve((BObject)this).get();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (src != null && src != this) {
                    throw new HistoryException("Duplicate history id: " + (Object)((Object)config.getId()));
                }
                conn.reconfigureHistory(config);
                try {
                    existing = conn.getHistory(id);
                    BHistoryRecord lastRec = conn.getLastRecord(existing);
                    if (lastRec != null) {
                        this.setLastRecord(lastRec);
                    }
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Could not initialize 'Last Record' property for history ext " + this.toPathString(), e);
                }
                if (this.getEnabled()) {
                    this.history = conn.getHistory(id);
                    if (this.history == null) {
                        throw new HistoryException("Cannot open history: " + (Object)((Object)id));
                    }
                }
            }
            catch (Exception ex) {
                this.setFault(ex);
                return;
            }
        }
        this.setFault(false, "");
        if (this.getEnabled()) {
            this.initHistorySuccessful = true;
        }
    }

    protected void initConfig(BHistoryConfig config) {
    }

    @Override
    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        if (config != this.getHistoryConfig()) {
            return;
        }
        this.updateStatus();
        this.syncConfig();
    }

    private void renameAttachedHistory(HistorySpaceConnection conn, BHistoryId oldId, BHistoryId newId) {
        BIHistory newHistory = conn.getHistory(newId);
        if (newHistory != null) {
            BHistoryConfig newCfg = newHistory.getConfig();
            BOrdList newSrc = newCfg.getSource();
            BOrd newHandle = newCfg.getSourceHandle();
            if (newSrc.size() != 1 || !newHandle.isNull() && !newHandle.equals((Object)this.getHandleOrd())) {
                throw new HistoryException("Cannot rename attached history.  The target id is already in use.");
            }
            log.warning("Rename failed for " + (Object)((Object)oldId) + ".  New data will be written to " + (Object)((Object)newId));
            return;
        }
        BIHistory oldHistory = conn.getHistory(oldId);
        if (oldHistory == null) {
            return;
        }
        BHistoryConfig config = oldHistory.getConfig();
        BOrdList src = config.getSource();
        BOrd handle = config.getSourceHandle();
        if (src.size() != 1) {
            return;
        }
        if (!handle.isNull() && !handle.equals((Object)this.getHandleOrd())) {
            return;
        }
        conn.renameHistory(oldId, newId.getHistoryName());
    }

    public void doUpdateHistoryId() {
        BHistoryId newId;
        String newName = this.resolveHistoryName();
        BHistoryId id = this.getHistoryConfig().getId();
        if (!id.equals((Object)(newId = BHistoryId.make(Sys.getStation().getStationName(), newName)))) {
            this.initHistory();
        }
    }

    public synchronized void doSyncConfig() {
        if (this.initHistorySuccessful) {
            BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
            BHistoryDatabase db = service.getDatabase();
            try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                conn.reconfigureHistory(this.getHistoryConfig());
            }
        }
    }

    public abstract Type getRecordType();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void append(BTrendRecord record) throws IOException, HistoryException {
        if (!this.getEnabled() || DISABLED_ON_ACTIVATION.get() == Boolean.TRUE) {
            return;
        }
        if (this.isRunning() && Sys.atSteadyState()) {
            if (this.start) {
                record.setTrendFlags(record.getTrendFlags().set(1, true));
            }
            for (int i = 0; i < 2; ++i) {
                BHistoryDatabase db = ((BHistoryService)Sys.getService((Type)BHistoryService.TYPE)).getDatabase();
                try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                    BHistoryExt bHistoryExt = this;
                    synchronized (bHistoryExt) {
                        if (this.history == null) {
                            this.initHistory(conn);
                        }
                        if (this.history != null) {
                            BCollectionInterval cInterval = this.getHistoryConfig().getInterval();
                            BRelTime tolerance = null;
                            tolerance = cInterval.isIrregular() ? BRelTime.make((long)0L) : BRelTime.make((long)(cInterval.getInterval().getMillis() / 2L));
                            BAbsTime recTimestamp = record.getTimestamp();
                            BAbsTime lastTimestamp = conn.getLastTimestamp(this.history);
                            this.nextValidThreshold = lastTimestamp != null && !lastTimestamp.isNull() && recTimestamp.getMillis() <= lastTimestamp.getMillis() + tolerance.getMillis() ? lastTimestamp : null;
                            if (this.nextValidThreshold == null) {
                                conn.append(this.history, record);
                                this.start = false;
                                this.setLastRecord((BHistoryRecord)record.newCopy());
                            }
                        }
                    }
                    if (this.history != null) {
                        this.updateStatus();
                    }
                    break;
                }
                catch (HistoryNotFoundException ex) {
                    if (i == 0) {
                        this.initHistory();
                        continue;
                    }
                    boolean wasFault = this.getStatus().isFault();
                    this.setFault((Throwable)((Object)ex));
                    if (wasFault) break;
                    throw ex;
                }
                catch (Exception ex) {
                    boolean wasFault = this.getStatus().isFault();
                    this.setFault(ex);
                    if (wasFault) break;
                    if (ex instanceof HistoryException) {
                        throw (HistoryException)((Object)ex);
                    }
                    throw new HistoryException(ex);
                }
            }
        }
    }

    private void syncFacets() {
        BControlPoint point = this.getParentPoint();
        BFacets facets = point.getFacets();
        if (this.localFacets != null && facets == this.localFacets) {
            return;
        }
        this.localFacets = facets;
        BHistoryConfig config = this.getHistoryConfig();
        if (config.getRecordType().isNull()) {
            return;
        }
        BTrendRecord rec = (BTrendRecord)config.makeRecord();
        Property valueProp = rec.getValueProperty();
        String facetsName = valueProp.getName() + "Facets";
        Property prop = config.loadSlots().getProperty(facetsName);
        if (prop == null) {
            config.add(facetsName, (BValue)facets);
        } else {
            BFacets configFacets = (BFacets)config.get(prop);
            if (!configFacets.equals((Object)facets)) {
                config.set(prop, (BValue)facets);
            }
        }
    }

    private void setFault(boolean fault, String cause) {
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)fault));
        this.setFaultCause(cause);
    }

    private void setFault(Throwable ex) {
        String faultCause;
        if (!(ex instanceof HistoryException)) {
            log.log(Level.SEVERE, this.getHistoryConfig().getId().toString(), ex);
        }
        if (ex instanceof LocalizableException || ex instanceof LocalizableRuntimeException) {
            faultCause = ((Localizable)ex).toString(null);
        } else {
            Throwable cause;
            Throwable currentException = ex;
            while (null != (cause = currentException.getCause()) && currentException != cause) {
                currentException = cause;
            }
            faultCause = currentException.getMessage();
            if (currentException instanceof FileNotFoundException) {
                faultCause = faultCause.substring(faultCause.lastIndexOf(File.separatorChar) + 1);
            }
        }
        if (faultCause == null || faultCause.isEmpty()) {
            faultCause = ex.getClass().getName();
        }
        this.setStatus(BStatus.makeFault((BStatus)this.getStatus(), (boolean)true));
        this.setFaultCause(faultCause);
    }

    public AgentList getAgents(Context cx) {
        AgentList list = super.getAgents(cx);
        list.toTop("workbench:PropertySheet");
        return PxUtil.movePxViewsToTop((AgentList)list);
    }
}

