/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.history.BTrendFlags;
import javax.baja.history.BTrendRecord;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.status.BIStatus;
import javax.baja.status.BStatus;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BFacets;
import javax.baja.sys.BINumeric;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
@NiagaraProperty(name="value", type="double", defaultValue="0d", flags=8)
public class BNumericTrendRecord
extends BTrendRecord
implements BINumeric,
BIStatus {
    @Generated
    public static final Property value = BNumericTrendRecord.newProperty((int)8, (double)0.0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BNumericTrendRecord.class);

    @Generated
    public double getValue() {
        return this.getDouble(value);
    }

    @Generated
    public void setValue(double v) {
        this.setDouble(value, v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    BNumericTrendRecord(BAbsTime timestamp, double value, BStatus status) {
        super(timestamp, status);
        this.setValue(value);
    }

    public BNumericTrendRecord() {
    }

    @Override
    public Property getValueProperty() {
        return value;
    }

    public double getNumeric() {
        return this.getValue();
    }

    public BFacets getNumericFacets() {
        return BFacets.NULL;
    }

    @Override
    public boolean isFixedSize() {
        return true;
    }

    public BNumericTrendRecord set(BAbsTime timestamp, double value, BStatus status) {
        this.setTimestamp(timestamp);
        this.setTrendFlags(BTrendFlags.DEFAULT);
        this.setValue(value);
        this.setStatus(status);
        return this;
    }

    @Override
    protected void doReadTrend(DataInput in) throws IOException {
        this.setValue(in.readFloat());
    }

    @Override
    protected void doWriteTrend(DataOutput out) throws IOException {
        out.writeFloat((float)this.getValue());
    }

    @Override
    public String toString(Context ctx) {
        StringBuilder s = new StringBuilder(32);
        s.append(super.toString(ctx));
        s.append(" ");
        s.append(this.getValue());
        s.append(' ');
        s.append(this.getStatus());
        return s.toString();
    }
}

