/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import com.tridium.fox.sys.NiagaraStation;
import com.tridium.history.BHistoryDeltaQuery;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.UnresolvedException;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraSingleton;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BSpace;
import javax.baja.space.BSpaceScheme;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.LexiconModule;

@NiagaraType(ordScheme="history")
@NiagaraSingleton
public class BHistoryScheme
extends BSpaceScheme {
    @Generated
    public static final BHistoryScheme INSTANCE = new BHistoryScheme();
    @Generated
    public static final Type TYPE = Sys.loadType(BHistoryScheme.class);
    private static final LexiconModule LEX = LexiconModule.make((String)"history");

    @Generated
    public Type getType() {
        return TYPE;
    }

    protected BHistoryScheme() {
        super("history");
    }

    public Type getSpaceType() {
        return BHistorySpace.TYPE;
    }

    public OrdQuery parse(String queryBody) {
        return new HistoryQuery(this.getId(), queryBody);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OrdTarget resolve(OrdTarget base, OrdQuery query, BSpace space) {
        String devName;
        BHistorySpace hspace;
        block34: {
            block35: {
                HistoryQuery hq;
                block32: {
                    BObject baseObj;
                    block33: {
                        hq = (HistoryQuery)query;
                        hspace = (BHistorySpace)space;
                        if (hq.isHistoryFolderQuery()) {
                            String[] folderNames = hq.getHistoryFolderPath();
                            BINavNode child = null;
                            StringBuilder navName = null;
                            if (folderNames != null && folderNames.length > 0) {
                                navName = new StringBuilder();
                                navName.append("history://").append(folderNames[0]);
                                child = hspace.getNavChild(navName.toString());
                                for (int idx = 1; child != null && idx < folderNames.length; child = child.getNavChild(navName.toString()), ++idx) {
                                    navName.append('/').append(folderNames[idx]);
                                }
                            }
                            if (child != null) return new OrdTarget(base, (BObject)child);
                            throw new UnresolvedException(LEX.getText("historyScheme.historyFolderNotFound", (Context)base, new Object[]{navName != null ? navName.toString() : "unspecified"}));
                        }
                        if (hq.isSpaceQuery()) {
                            return new OrdTarget(base, (BObject)hspace);
                        }
                        if (!hq.isDeviceQuery()) break block32;
                        devName = hq.getDeviceName();
                        if (!"^".equals(devName)) break block33;
                        devName = hspace.getDeviceName();
                        break block34;
                    }
                    if (!"@".equals(devName) || !(baseObj = base.get()).isComplex()) break block34;
                    break block35;
                }
                BHistoryId id = null;
                try {
                    BObject baseObj;
                    String devName2 = hq.getDeviceName();
                    String histName = hq.getHistoryName();
                    if ("^".equals(devName2)) {
                        devName2 = hspace.getDeviceName();
                    } else if ("@".equals(devName2) && (baseObj = base.get()).isComplex()) {
                        for (BComplex comp = (BComplex)baseObj; comp != null; comp = comp.getParent()) {
                            if (!(comp instanceof NiagaraStation)) continue;
                            devName2 = ((NiagaraStation)comp).getStationName();
                            break;
                        }
                    }
                    id = BHistoryId.make(devName2, histName);
                    try (HistorySpaceConnection conn = hspace.getConnection((Context)base);){
                        BIHistory history = conn.getHistory(id);
                        if (history == null) {
                            throw new HistoryNotFoundException();
                        }
                        if (hq.hasTimeRange()) {
                            BAbsTime now = BAbsTime.make((long)System.currentTimeMillis(), (BTimeZone)history.getConfig().getTimeZone());
                            BAbsTime start = hq.getStartTime(now);
                            BAbsTime end = hq.getEndTime(now);
                            BHistoryDeltaQuery result = hq.isDelta() ? new BHistoryDeltaQuery(history, start, end, (Context)base) : (BObject)conn.timeQuery(history, start, end, false);
                            OrdTarget ordTarget = new OrdTarget(base, (BObject)result);
                            return ordTarget;
                        }
                        if (hq.isDelta()) {
                            BHistoryDeltaQuery deltaCollection = new BHistoryDeltaQuery(history, null, null, (Context)base);
                            OrdTarget ordTarget = new OrdTarget(base, (BObject)deltaCollection);
                            return ordTarget;
                        }
                        OrdTarget ordTarget = new OrdTarget(base, (BObject)history);
                        return ordTarget;
                    }
                }
                catch (Exception e) {
                    String msg = id != null ? id.toString() : hq.toString();
                    throw new UnresolvedException(LEX.getText("historyScheme.cannotResolveHistory", (Context)base, new Object[]{msg}), (Throwable)e);
                }
            }
            for (BComplex comp = (BComplex)baseObj; comp != null; comp = comp.getParent()) {
                if (!(comp instanceof NiagaraStation)) continue;
                devName = ((NiagaraStation)comp).getStationName();
                break;
            }
        }
        BHistoryDevice device = hspace.getDevice(devName);
        if (device != null) return new OrdTarget(base, (BObject)device);
        throw new UnresolvedException(LEX.getText("historyScheme.historyDeviceNotFound", (Context)base, new Object[]{devName}));
    }
}

