/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.history;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Lexicon;

@NiagaraType
public final class BCollectionInterval
extends BSimple {
    public static final BCollectionInterval DEFAULT;
    public static final BCollectionInterval REGULAR_1_MIN;
    public static final BCollectionInterval REGULAR_5_MIN;
    public static final BCollectionInterval REGULAR_15_MIN;
    public static final BCollectionInterval REGULAR_30_MIN;
    public static final BCollectionInterval REGULAR_1_HOUR;
    public static final BCollectionInterval IRREGULAR;
    public static final Type TYPE;
    private boolean irregular = false;
    private BRelTime interval = BRelTime.DEFAULT;
    private int hashCode = -1;

    public static BCollectionInterval make(BRelTime interval) {
        if (interval == REGULAR_1_MIN.getInterval()) {
            return REGULAR_1_MIN;
        }
        if (interval == REGULAR_5_MIN.getInterval()) {
            return REGULAR_5_MIN;
        }
        if (interval == REGULAR_15_MIN.getInterval()) {
            return REGULAR_15_MIN;
        }
        if (interval == REGULAR_30_MIN.getInterval()) {
            return REGULAR_30_MIN;
        }
        if (interval == REGULAR_1_HOUR.getInterval()) {
            return REGULAR_1_HOUR;
        }
        return (BCollectionInterval)new BCollectionInterval(interval).intern();
    }

    public static BCollectionInterval makeIrregular() {
        BCollectionInterval result = new BCollectionInterval(BRelTime.MINUTE);
        result.irregular = true;
        return (BCollectionInterval)result.intern();
    }

    private BCollectionInterval(BRelTime interval) {
        this.interval = interval;
    }

    public boolean isIrregular() {
        return this.irregular;
    }

    public BRelTime getInterval() {
        return this.interval;
    }

    public int hashCode() {
        if (this.hashCode == -1) {
            long hash = 23L + (this.irregular ? 1L : 0L);
            hash = hash * 37L + (long)this.interval.hashCode();
            this.hashCode = (int)(hash >>> 32) ^ (int)hash;
        }
        return this.hashCode;
    }

    public boolean equals(Object o) {
        if (!(o instanceof BCollectionInterval)) {
            return false;
        }
        BCollectionInterval other = (BCollectionInterval)((Object)o);
        return this.irregular == other.irregular && this.interval.equals((Object)other.interval);
    }

    public void encode(DataOutput out) throws IOException {
        out.writeBoolean(this.irregular);
        this.interval.encode(out);
    }

    public BObject decode(DataInput in) throws IOException {
        boolean irregular = in.readBoolean();
        BRelTime interval = (BRelTime)BRelTime.DEFAULT.decode(in);
        BCollectionInterval result = new BCollectionInterval(interval);
        result.irregular = irregular;
        return result.intern();
    }

    public String encodeToString() {
        StringBuilder s = new StringBuilder(16);
        s.append(this.irregular ? "true" : "false");
        s.append(':');
        s.append(this.interval.encodeToString());
        return s.toString();
    }

    public BObject decodeFromString(String s) throws IOException {
        int colon = s.indexOf(58);
        String boolStr = s.substring(0, colon);
        boolean irregular = boolStr.equals("true");
        BRelTime interval = (BRelTime)BRelTime.DEFAULT.decodeFromString(s.substring(colon + 1));
        BCollectionInterval result = new BCollectionInterval(interval);
        result.irregular = irregular;
        return result.intern();
    }

    public String toString(Context cx) {
        if (this.irregular) {
            return Lexicon.make((String)"history").getText("irregular");
        }
        return this.interval.toString(cx);
    }

    public Type getType() {
        return TYPE;
    }

    static {
        REGULAR_1_MIN = DEFAULT = new BCollectionInterval(BRelTime.MINUTE);
        REGULAR_5_MIN = new BCollectionInterval(BRelTime.makeMinutes((int)5));
        REGULAR_15_MIN = new BCollectionInterval(BRelTime.makeMinutes((int)15));
        REGULAR_30_MIN = new BCollectionInterval(BRelTime.makeMinutes((int)30));
        REGULAR_1_HOUR = new BCollectionInterval(BRelTime.makeHours((int)1));
        IRREGULAR = BCollectionInterval.makeIrregular();
        TYPE = Sys.loadType(BCollectionInterval.class);
    }
}

