/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.util;

import com.tridium.bql.util.BDynamicTimeRange;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryDeltaQuery;
import com.tridium.history.BHistoryTimeQuery;
import com.tridium.json.JSONObject;
import com.tridium.json.JSONWriter;
import com.tridium.json.quick.QuickJSONWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BIHistory;
import javax.baja.naming.BOrdList;
import javax.baja.naming.OrdTarget;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BInterface;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.LexiconText;

public final class HistoryUtil {
    private static final Logger logger = Logger.getLogger("history");
    private static final LexiconText EPOCH_LEX_TEXT = LexiconText.make((String)"bql", (String)"dynamicTimeRangeFE.epoch");
    private static final LexiconText TO_LEX_TEXT = LexiconText.make((String)"bql", (String)"dynamicTimeRangeFE.to");
    private static final LexiconText NOW_LEX_TEXT = LexiconText.make((String)"bql", (String)"dynamicTimeRangeFE.now");

    private HistoryUtil() {
    }

    public static BComponent getSourceComponent(BIHistory history, Context cx) {
        BComponent newSourceComponent;
        block3: {
            newSourceComponent = null;
            try {
                BObject obj;
                OrdTarget target;
                BOrdList sourceOrds;
                int len;
                int i;
                BHistoryConfig config = history.getConfig();
                if (config != null && (i = (len = (sourceOrds = config.getSource()).size()) - 1) > -1 && (target = sourceOrds.get(i).resolve((BObject)history, cx)).canRead() && (obj = target.get()) instanceof BComponent) {
                    newSourceComponent = (BComponent)obj;
                }
            }
            catch (Exception e) {
                if (!logger.isLoggable(Level.FINE)) break block3;
                logger.log(Level.FINE, "Cannot obtain source for BIHistory:" + history, e);
            }
        }
        return newSourceComponent;
    }

    public static void updateSubscriptionCounter(BInterface src, BComponent historySource, int change, Map<BInterface, HistorySourceSubscriptionCount> subscriptionCounter) {
        HistoryUtil.updateSubscriptionCounter(src, historySource, change, subscriptionCounter, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateSubscriptionCounter(BInterface src, BComponent historySource, int change, Map<BInterface, HistorySourceSubscriptionCount> subscriptionCounter, boolean subscribeHistory) {
        Map<BInterface, HistorySourceSubscriptionCount> map = subscriptionCounter;
        synchronized (map) {
            BInterface originalSrc = src;
            Subscriber subscriber = null;
            HistorySourceSubscriptionCount info = subscriptionCounter.get(src);
            int newCount = change;
            if (info != null) {
                originalSrc = info.originalSrc;
                subscriber = info.subscriber;
                if ((newCount = info.count + newCount) <= 0) {
                    if (subscriber != null && originalSrc instanceof BHistory) {
                        BHistory history = (BHistory)originalSrc;
                        history.unsubscribe(subscriber, null);
                    }
                    subscriptionCounter.remove(src);
                    return;
                }
            }
            if (newCount < 0) {
                return;
            }
            if (subscribeHistory && src instanceof BHistory && subscriber == null) {
                BHistory history = (BHistory)src;
                subscriber = new HistoryUtilSubscriber();
                history.subscribe(subscriber, null);
            }
            subscriptionCounter.put(src, new HistorySourceSubscriptionCount(originalSrc, historySource, newCount, subscriber));
        }
    }

    public static String getRangeStr(BDynamicTimeRange range, Context cx) {
        BAbsTime now = BAbsTime.now();
        BTimeZone timeZone = range.getFixedStartTime().getTimeZone();
        BAbsTime start = range.getStartTime(now, timeZone);
        BAbsTime end = range.getEndTime(now, timeZone);
        StringBuilder s = new StringBuilder();
        if (start == null || start.isNull()) {
            s.append(EPOCH_LEX_TEXT.getText(cx));
        } else {
            s.append(start.toString(cx));
        }
        s.append("  ").append(TO_LEX_TEXT.getText(cx)).append("  ");
        if (end == null || end.isNull()) {
            s.append(NOW_LEX_TEXT.getText(cx));
        } else {
            s.append(end.toString(cx));
        }
        return s.toString();
    }

    public static void writeArchiveLimitExceededWarning(Writer out, BObject historyObject) throws IOException {
        JSONWriter jsonWriter = QuickJSONWriter.make((Appendable)out);
        jsonWriter.object();
        JSONObject warningDetails = new JSONObject();
        warningDetails.put("module", (Object)"history");
        warningDetails.put("title", (Object)"archiveHistoryProvider.limitNotificationTitle");
        warningDetails.put("titleArgs", (Object)(Sys.getStation() != null ? Sys.getStation().getStationName() : ""));
        warningDetails.put("msg", (Object)"archiveHistoryProvider.limitNotificationMessage");
        warningDetails.put("msgArgs", (Object)HistoryUtil.retrieveHistoryId(historyObject));
        warningDetails.put("coaleseable", (Object)"\n");
        jsonWriter.key("w").value((Object)warningDetails);
        jsonWriter.endObject();
        out.append('\n');
    }

    private static BHistoryId retrieveHistoryId(BObject o) {
        if (o instanceof BIHistory) {
            return ((BIHistory)o).getId();
        }
        if (o instanceof BHistoryTimeQuery) {
            return ((BHistoryTimeQuery)o).getHistory().getId();
        }
        if (o instanceof BHistoryDeltaQuery) {
            return ((BHistoryDeltaQuery)o).getHistory().getId();
        }
        return null;
    }

    static class HistoryUtilSubscriber
    extends Subscriber {
        HistoryUtilSubscriber() {
        }

        public void event(BComponentEvent event) {
        }
    }

    public static class HistorySourceSubscriptionCount {
        BInterface originalSrc;
        BComponent historySource;
        int count;
        Subscriber subscriber;

        HistorySourceSubscriptionCount(BInterface originalSrc, BComponent historySource, int count, Subscriber subscriber) {
            this.historySource = historySource;
            this.count = count;
            this.originalSrc = originalSrc;
            this.subscriber = subscriber;
        }

        public BComponent getHistorySource() {
            return this.historySource;
        }

        public int getCount() {
            return this.count;
        }
    }
}

