/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.log;

import com.tridium.history.log.BLogRecord;
import com.tridium.history.log.BSeverity;
import java.util.Locale;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.baja.data.BIDataValue;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistorySource;
import javax.baja.history.BStringTrendRecord;
import javax.baja.history.HistoryDeletedException;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryNotFoundException;
import javax.baja.history.db.BHistoryDatabase;
import javax.baja.history.db.HistoryDatabaseConnection;
import javax.baja.naming.BOrd;
import javax.baja.naming.BOrdList;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraActions;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.space.BComponentSpace;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="enabled", type="boolean", defaultValue="true"), @NiagaraProperty(name="minimumSeverity", type="BSeverity", defaultValue="BSeverity.info"), @NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig(BHistoryId.make(\"station\", \"LogHistory\"), BTypeSpec.make(\"history\", \"LogRecord\"))"), @NiagaraProperty(name="lastRecord", type="BHistoryRecord", defaultValue="new BStringTrendRecord()", flags=3)})
@NiagaraActions(value={@NiagaraAction(name="testError"), @NiagaraAction(name="testErrorEx"), @NiagaraAction(name="testWarning"), @NiagaraAction(name="testMessage"), @NiagaraAction(name="testTrace")})
public class BLogHistoryService
extends BComponent
implements BIService,
BIHistorySource,
BIRestrictedComponent {
    @Generated
    public static final Property enabled = BLogHistoryService.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property minimumSeverity = BLogHistoryService.newProperty((int)0, (BValue)BSeverity.info, null);
    @Generated
    public static final Property historyConfig = BLogHistoryService.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.make("station", "LogHistory"), BTypeSpec.make((String)"history", (String)"LogRecord")), null);
    @Generated
    public static final Property lastRecord = BLogHistoryService.newProperty((int)3, (BValue)new BStringTrendRecord(), null);
    @Generated
    public static final Action testError = BLogHistoryService.newAction((int)0, null);
    @Generated
    public static final Action testErrorEx = BLogHistoryService.newAction((int)0, null);
    @Generated
    public static final Action testWarning = BLogHistoryService.newAction((int)0, null);
    @Generated
    public static final Action testMessage = BLogHistoryService.newAction((int)0, null);
    @Generated
    public static final Action testTrace = BLogHistoryService.newAction((int)0, null);
    @Generated
    public static final Type TYPE = Sys.loadType(BLogHistoryService.class);
    private static final Logger testLogger = Logger.getLogger("test.logHistory");
    private static final BIcon icon;
    private static Lexicon lex;
    private boolean serviceStarted = false;
    private static Type[] serviceTypes;
    private BLogRecord rec;
    private final LogHistoryHandler historyHandler = new LogHistoryHandler();
    private BIHistory history;

    @Generated
    public boolean getEnabled() {
        return this.getBoolean(enabled);
    }

    @Generated
    public void setEnabled(boolean v) {
        this.setBoolean(enabled, v, null);
    }

    @Generated
    public BSeverity getMinimumSeverity() {
        return (BSeverity)this.get(minimumSeverity);
    }

    @Generated
    public void setMinimumSeverity(BSeverity v) {
        this.set(minimumSeverity, (BValue)v, null);
    }

    @Generated
    public BHistoryConfig getHistoryConfig() {
        return (BHistoryConfig)this.get(historyConfig);
    }

    @Generated
    public void setHistoryConfig(BHistoryConfig v) {
        this.set(historyConfig, (BValue)v, null);
    }

    @Generated
    public BHistoryRecord getLastRecord() {
        return (BHistoryRecord)this.get(lastRecord);
    }

    @Generated
    public void setLastRecord(BHistoryRecord v) {
        this.set(lastRecord, (BValue)v, null);
    }

    @Generated
    public void testError() {
        this.invoke(testError, null, null);
    }

    @Generated
    public void testErrorEx() {
        this.invoke(testErrorEx, null, null);
    }

    @Generated
    public void testWarning() {
        this.invoke(testWarning, null, null);
    }

    @Generated
    public void testMessage() {
        this.invoke(testMessage, null, null);
    }

    @Generated
    public void testTrace() {
        this.invoke(testTrace, null, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void serviceStarted() {
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
    }

    public synchronized void started() {
        if (this.serviceStarted) {
            return;
        }
        this.serviceStarted = true;
        this.setFlags((Slot)lastRecord, this.getFlags((Slot)lastRecord) | 2);
        BHistoryConfig config = this.getHistoryConfig();
        config.setRecordType(BTypeSpec.make((String)"history", (String)"LogRecord"));
        BHistoryId id = BHistoryId.make(Sys.getStation().getStationName(), "LogHistory");
        config.setId(id);
        this.startCollecting();
    }

    private BOrd getSourceOrd() {
        BComponentSpace cs = this.getComponentSpace();
        if (cs == null) {
            return null;
        }
        BOrd base = cs.getOrdInSession();
        if (base == null) {
            return null;
        }
        return BOrd.make((BOrd)base, (BOrd)this.getHandleOrd());
    }

    private void initHistory() throws ServiceNotFoundException {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            this.initHistory(conn);
        }
    }

    private void initHistory(HistoryDatabaseConnection conn) throws ServiceNotFoundException {
        BHistoryConfig config = this.getHistoryConfig();
        config.setSource(BOrdList.make((BOrd)this.getSourceOrd()));
        config.setTimeZone(BTimeZone.getLocal());
        BHistoryId id = config.getId();
        if (!conn.exists(id)) {
            conn.createHistory(this.getHistoryConfig());
        } else {
            conn.reconfigureHistory(this.getHistoryConfig());
        }
        this.history = conn.getHistory(id);
        try {
            BHistoryRecord lastRec = conn.getLastRecord(this.history);
            if (lastRec != null) {
                this.setLastRecord(lastRec);
            }
        }
        catch (Exception e) {
            BHistoryService.logger.log(Level.SEVERE, "Could not initialize 'Last Record' property for LogHistoryService.", e);
        }
    }

    private synchronized void startCollecting() {
        try {
            this.initHistory();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.updateHandlerSeverity();
        Logger.getLogger("").addHandler(this.historyHandler);
    }

    public synchronized void serviceStopped() {
        this.serviceStarted = false;
        this.stopCollecting();
    }

    private synchronized void stopCollecting() {
        Logger.getLogger("").removeHandler(this.historyHandler);
        this.history = null;
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void doTestError() {
        testLogger.severe("LogHistoryService: Test Error");
    }

    public void doTestErrorEx() {
        try {
            throw new IllegalStateException("Test Test Test");
        }
        catch (Exception e) {
            testLogger.log(Level.SEVERE, "LogHistoryService: Test Error w/Exception", e);
            return;
        }
    }

    public void doTestWarning() {
        testLogger.warning("LogHistoryService: Test Warning");
    }

    public void doTestMessage() {
        testLogger.info("LogHistoryService: Test Message");
    }

    public void doTestTrace() {
        testLogger.fine("LogHistoryService: Test Trace");
    }

    @Override
    public void historyConfigChanged(BHistoryConfig config, Property p) {
        if (!this.isRunning()) {
            return;
        }
        if (config != this.getHistoryConfig()) {
            return;
        }
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            conn.reconfigureHistory(this.getHistoryConfig());
        }
    }

    public void changed(Property property, Context context) {
        if (!this.isRunning()) {
            return;
        }
        if (property == enabled) {
            if (this.getEnabled()) {
                this.startCollecting();
            } else {
                this.stopCollecting();
            }
        } else if (property == minimumSeverity) {
            this.updateHandlerSeverity();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean outOfOrderCheck(BLogRecord logRec) {
        BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        BHistoryDatabase db = service.getDatabase();
        try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
            BAbsTime lastTimestamp = conn.getLastTimestamp(this.history);
            BAbsTime recTimestamp = logRec.getTimestamp();
            if (lastTimestamp == null) return false;
            if (lastTimestamp.isNull()) return false;
            if (!recTimestamp.isBefore(lastTimestamp)) return false;
            StringBuilder sb = new StringBuilder();
            sb.append(logRec.getMessage()).append(" ");
            BHistoryConfig config = this.getHistoryConfig();
            BFacets facets = null;
            try {
                facets = (BFacets)config.get("timestampFacets");
                BTimeZone timeZone = config.getTimeZone();
                facets = facets != null ? BFacets.make((BFacets)facets, (String)"TimeZone", (BIDataValue)timeZone) : BFacets.make((String)"TimeZone", (BIDataValue)timeZone);
                facets = BFacets.make((BFacets)facets, (String)"showSeconds", (BIDataValue)BBoolean.TRUE);
            }
            catch (Exception exception) {
                // empty catch block
            }
            sb.append(lex.getText("log.append.outOfOrder", new Object[]{recTimestamp.toString((Context)facets)}));
            logRec.setMessage(sb.toString());
            logRec.setTimestamp(lastTimestamp);
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable7) {
            // empty catch block
        }
        return false;
    }

    public BIcon getIcon() {
        return icon;
    }

    private void updateHandlerSeverity() {
        BSeverity severity = this.getMinimumSeverity();
        this.historyHandler.setLevel(Level.parse(severity.getTag().toUpperCase(Locale.ENGLISH)));
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    static {
        testLogger.setLevel(Level.ALL);
        icon = BIcon.std((String)"navOnly/histories.png");
        lex = Lexicon.make((String)"history");
        serviceTypes = new Type[]{TYPE};
    }

    class LogHistoryHandler
    extends Handler {
        @Override
        public void publish(LogRecord record) {
            boolean appended;
            block26: {
                if (!this.isLoggable(record)) {
                    return;
                }
                if (!BLogHistoryService.this.getEnabled() || !BLogHistoryService.this.serviceStarted || BLogHistoryService.this.history == null) {
                    return;
                }
                if (record.getLoggerName() != null && (record.getLoggerName().startsWith("platDataRecovery") || record.getLoggerName().equals("platform.engineMonitor"))) {
                    return;
                }
                BHistoryService service = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
                BHistoryDatabase db = service.getDatabase();
                if (db == null) {
                    return;
                }
                if (BLogHistoryService.this.rec == null) {
                    BLogHistoryService.this.rec = BLogRecord.fromRecord(record);
                } else {
                    BLogHistoryService.this.rec.setFromRecord(record);
                }
                appended = false;
                boolean outOfOrder = false;
                if (db == null) {
                    return;
                }
                try (HistoryDatabaseConnection conn = db.getDbConnection(null);){
                    try {
                        outOfOrder = BLogHistoryService.this.outOfOrderCheck(BLogHistoryService.this.rec);
                        conn.append(BLogHistoryService.this.history, BLogHistoryService.this.rec);
                        appended = true;
                    }
                    catch (HistoryException e) {
                        if (e instanceof HistoryDeletedException || e instanceof HistoryNotFoundException) {
                            try {
                                BLogHistoryService.this.initHistory(conn);
                                if (!outOfOrder) {
                                    BLogHistoryService.this.outOfOrderCheck(BLogHistoryService.this.rec);
                                }
                                conn.append(BLogHistoryService.this.history, BLogHistoryService.this.rec);
                                appended = true;
                            }
                            catch (Exception ex) {
                                ex.printStackTrace();
                            }
                            break block26;
                        }
                        e.printStackTrace();
                    }
                }
            }
            if (appended) {
                BLogHistoryService.this.setLastRecord((BHistoryRecord)BLogHistoryService.this.rec.newCopy());
            }
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws SecurityException {
        }
    }
}

