/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.fox;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.BIFoxProxySpace;
import com.tridium.history.BHistory;
import com.tridium.history.BHistoryFolder;
import com.tridium.history.BHistoryMirror;
import com.tridium.history.BRootHistoryFolder;
import com.tridium.history.fox.BHistoryChannel;
import com.tridium.history.fox.FoxHistoryException;
import com.tridium.history.fox.FoxHistorySpaceConnection;
import com.tridium.nav.BINavSupport;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.baja.bql.RemoteQueryable;
import javax.baja.category.BCategoryMask;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryDevice;
import javax.baja.history.BHistoryGroup;
import javax.baja.history.BHistoryGroupings;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BHistorySpace;
import javax.baja.history.BIHistory;
import javax.baja.history.HistoryException;
import javax.baja.history.HistoryQuery;
import javax.baja.history.HistorySpaceConnection;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.SlotPath;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.BPermissions;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Subscriber;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType(agent={@AgentOn(types={"fox:FoxSession"})})
public class BFoxHistorySpace
extends BHistorySpace
implements BIFoxProxySpace,
RemoteQueryable,
NavListener {
    @Generated
    public static final Type TYPE = Sys.loadType(BFoxHistorySpace.class);
    private BOrd ord;
    private String deviceName;
    private BPermissions permissions = null;
    private MySubscriber subscriber = null;
    private Object subscriberLock = new Object();
    private HashMap<BHistoryId, BIHistory> cache = new HashMap(37);
    private WeakHashMap<NavListener, Object> weakNavListeners = new WeakHashMap();
    static Logger log = Logger.getLogger("history");

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    public BOrd getNavOrd() {
        if (this.ord == null) {
            this.ord = BOrd.make((String)(this.getFoxSession().getNavOrd() + "|history:"));
        }
        return this.ord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void navEvent(NavEvent event) {
        block63: {
            BasicContext cx;
            Map folderCache;
            HistoryQuery query;
            block68: {
                String devName;
                BHistoryDevice dev;
                Map myFolders;
                BHistoryFolder folder;
                Map historyFolders;
                block69: {
                    block64: {
                        String devName2;
                        BHistoryDevice dev2;
                        BRootHistoryFolder folder2;
                        block67: {
                            block65: {
                                String devName3;
                                BHistoryDevice dev3;
                                BRootHistoryFolder folder3;
                                block66: {
                                    String[] groupNames;
                                    if (event.getFacets().getb("skipHistorySpaceNavEvent", false)) {
                                        return;
                                    }
                                    try {
                                        if (!event.getParentOrd().toString().startsWith(this.getNavOrd().toString())) {
                                            return;
                                        }
                                    }
                                    catch (Throwable t) {
                                        return;
                                    }
                                    NavListener[] navListeners = null;
                                    WeakHashMap<NavListener, Object> weakHashMap = this.weakNavListeners;
                                    synchronized (weakHashMap) {
                                        navListeners = this.weakNavListeners.keySet().toArray(new NavListener[0]);
                                    }
                                    int navLen = navListeners != null ? navListeners.length : 0;
                                    for (int i = 0; i < navLen; ++i) {
                                        try {
                                            if (!(navListeners[i] instanceof NavListener)) continue;
                                            navListeners[i].navEvent(event);
                                            continue;
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                    }
                                    OrdQuery[] list = event.getParentOrd().parse();
                                    OrdQuery leaf = list[list.length - 1];
                                    if (!(leaf instanceof HistoryQuery)) {
                                        return;
                                    }
                                    query = (HistoryQuery)leaf;
                                    if (event.getId() == 2 || event.getId() == 3 || event.getId() == 5) {
                                        BIHistory removedHistory = null;
                                        if (query.isHistoryQuery()) {
                                            removedHistory = this.cache.remove((Object)query.getHistoryId());
                                        } else if (query.isDeviceQuery()) {
                                            String historyName = event.getOldChildName();
                                            BHistoryId id = BHistoryId.make(query.getDeviceName(), historyName);
                                            removedHistory = this.cache.remove((Object)id);
                                        }
                                        if (removedHistory instanceof BHistory) {
                                            ((BHistory)removedHistory).unsubscribeAll((Context)BFacets.make((String)"skipSubscribeCount", (boolean)true));
                                        }
                                    }
                                    if ((groupNames = BHistoryService.getHistoryGroupNames((BObject)this)) == null || groupNames.length <= 0) break block63;
                                    folderCache = (Map)this.fw(9904);
                                    historyFolders = null;
                                    if (folderCache != null) {
                                        historyFolders = (Map)folderCache.get((Object)this);
                                    }
                                    if (historyFolders == null) break block63;
                                    cx = new BasicContext(event.getContext(), BFacets.make((String)"skipHistorySpaceNavEvent", (boolean)true));
                                    if (event.getId() != 1) break block64;
                                    if (!query.isDeviceQuery()) break block65;
                                    BIHistory newHistory = null;
                                    try (HistorySpaceConnection conn2 = this.getConnection((Context)cx);){
                                        newHistory = conn2.getHistory(BHistoryId.make(query.getDeviceName(), event.getNewChildName()));
                                    }
                                    catch (Exception conn2) {
                                        // empty catch block
                                    }
                                    if (newHistory == null) {
                                        return;
                                    }
                                    block30: for (int i = 0; i < groupNames.length; ++i) {
                                        int len;
                                        String[] aNames = BHistoryService.getSortPropertiesForGroup((BObject)this, groupNames[i]);
                                        int n = len = aNames != null ? aNames.length : 0;
                                        if (len == 0) continue;
                                        String[] aVals = new String[len];
                                        for (int j = 0; j < len; ++j) {
                                            String str;
                                            BValue val = newHistory.get(aNames[j]);
                                            aVals[j] = null;
                                            if (val == null || (str = val.toString()) == null || str.length() <= 0) continue;
                                            aVals[j] = str;
                                        }
                                        if (aVals[0] == null) continue;
                                        StringBuilder sb = new StringBuilder();
                                        sb.append("history://").append(SlotPath.escape((String)groupNames[i]));
                                        String folderId = sb.toString();
                                        BHistoryFolder folder4 = (BHistoryFolder)((Object)historyFolders.get(folderId));
                                        ArrayList<String> folderPath = new ArrayList<String>(len);
                                        folderPath.add(groupNames[i]);
                                        if (folder4 == null) {
                                            BRootHistoryFolder rootFolder = new BRootHistoryFolder(this, folderPath.toArray(new String[0]), (BINavNode)this);
                                            if (!rootFolder.getPermissions(null).hasOperatorRead()) continue;
                                            historyFolders.put(rootFolder.getNavName(), rootFolder);
                                            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)this.getNavOrd(), (String)folderId, (Context)cx));
                                            continue;
                                        }
                                        BHistoryFolder parentFolder = folder4;
                                        Map myFolders2 = (Map)folderCache.get((Object)parentFolder);
                                        if (myFolders2 == null) continue;
                                        for (int j = 0; j < len; ++j) {
                                            if (aVals[j] == null) {
                                                BHistoryMirror histMirror = new BHistoryMirror(newHistory, (BINavNode)parentFolder);
                                                String navName = histMirror.getNavName();
                                                myFolders2.put(navName, histMirror);
                                                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)parentFolder.getNavOrd(), (String)navName, (Context)cx));
                                                continue block30;
                                            }
                                            sb.append("/").append(SlotPath.escape((String)aVals[j]));
                                            folderId = sb.toString();
                                            BHistoryFolder myFolder = (BHistoryFolder)((Object)myFolders2.get(folderId));
                                            folderPath.add(aVals[j]);
                                            if (myFolder == null) {
                                                myFolder = new BHistoryFolder(this, folderPath.toArray(new String[0]), (BINavNode)parentFolder);
                                                myFolders2.put(myFolder.getNavName(), myFolder);
                                                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)parentFolder.getNavOrd(), (String)folderId, (Context)cx));
                                                continue block30;
                                            }
                                            parentFolder = myFolder;
                                            myFolders2 = (Map)folderCache.get((Object)parentFolder);
                                            if (myFolders2 == null) continue block30;
                                            if (j != len - 1) continue;
                                            BHistoryMirror histMirror = new BHistoryMirror(newHistory, (BINavNode)parentFolder);
                                            String navName = histMirror.getNavName();
                                            myFolders2.put(navName, histMirror);
                                            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)parentFolder.getNavOrd(), (String)navName, (Context)cx));
                                            continue block30;
                                        }
                                    }
                                    folder3 = (BRootHistoryFolder)((Object)historyFolders.get("history:///"));
                                    if (folder3 != null) break block66;
                                    folder3 = new BRootHistoryFolder(this, null, (BINavNode)this);
                                    if (!folder3.getPermissions(null).hasOperatorRead()) break block63;
                                    historyFolders.put(folder3.getNavName(), folder3);
                                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)this.getNavOrd(), (String)"history:///", (Context)cx));
                                    break block63;
                                }
                                Map myFolders3 = (Map)folderCache.get((Object)folder3);
                                if (myFolders3 == null || (dev3 = (BHistoryDevice)((Object)myFolders3.get(devName3 = query.getDeviceName()))) != null) break block63;
                                dev3 = new BHistoryDevice(this, devName3);
                                myFolders3.put(devName3, dev3);
                                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)folder3.getNavOrd(), (String)devName3, (Context)cx));
                                break block63;
                            }
                            if (!query.isSpaceQuery()) break block63;
                            folder2 = (BRootHistoryFolder)((Object)historyFolders.get("history:///"));
                            if (folder2 != null) break block67;
                            folder2 = new BRootHistoryFolder(this, null, (BINavNode)this);
                            if (!folder2.getPermissions(null).hasOperatorRead()) break block63;
                            historyFolders.put(folder2.getNavName(), folder2);
                            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)this.getNavOrd(), (String)"history:///", (Context)cx));
                            break block63;
                        }
                        Map myFolders4 = (Map)folderCache.get((Object)folder2);
                        if (myFolders4 == null || (dev2 = (BHistoryDevice)((Object)myFolders4.get(devName2 = event.getNewChildName()))) != null) break block63;
                        dev2 = new BHistoryDevice(this, devName2);
                        myFolders4.put(devName2, dev2);
                        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeAdded((BOrd)folder2.getNavOrd(), (String)devName2, (Context)cx));
                        break block63;
                    }
                    if (event.getId() != 2) break block68;
                    if (!query.isDeviceQuery()) break block69;
                    BHistoryId id = BHistoryId.make(query.getDeviceName(), event.getOldChildName());
                    Object[] keys = folderCache.keySet().toArray();
                    int len = keys != null ? keys.length : 0;
                    for (int i = 0; i < len; ++i) {
                        BHistoryFolder key;
                        Map map;
                        if (!(keys[i] instanceof BHistoryFolder) || (map = (Map)folderCache.get((Object)(key = (BHistoryFolder)((Object)keys[i])))) == null) continue;
                        Object[] navNodes = map.values().toArray();
                        int nlen = navNodes != null ? navNodes.length : 0;
                        for (int j = 0; j < nlen; ++j) {
                            BIHistory history;
                            if (!(navNodes[j] instanceof BIHistory) || !(history = (BIHistory)navNodes[j]).getId().equals((Object)id)) continue;
                            map.remove(history.getNavName());
                            BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)history.getNavParent().getNavOrd(), (String)history.getNavName(), (Context)cx));
                            while (map != null && map.isEmpty()) {
                                BINavNode parent = key.getNavParent();
                                if (parent instanceof BHistoryFolder) {
                                    folderCache.remove((Object)key);
                                    map = (Map)folderCache.get(parent);
                                    if (map != null) {
                                        map.remove(key.getNavName());
                                    }
                                    BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)parent.getNavOrd(), (String)key.getNavName(), (Context)cx));
                                    key = (BHistoryFolder)parent;
                                    continue;
                                }
                                map = null;
                            }
                        }
                    }
                    break block63;
                }
                if (!query.isSpaceQuery() || (folder = (BHistoryFolder)((Object)historyFolders.get("history:///"))) == null || (myFolders = (Map)folderCache.get((Object)folder)) == null || (dev = (BHistoryDevice)((Object)myFolders.get(devName = event.getOldChildName()))) == null) break block63;
                myFolders.remove(devName);
                BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRemoved((BOrd)folder.getNavOrd(), (String)devName, (Context)cx));
                break block63;
            }
            if (event.getId() == 3 && query.isDeviceQuery()) {
                String devName = query.getDeviceName();
                BHistoryId oldId = BHistoryId.make(devName, event.getOldChildName());
                BIHistory newHistory = null;
                try (HistorySpaceConnection conn3 = this.getConnection(null);){
                    newHistory = conn3.getHistory(BHistoryId.make(devName, event.getNewChildName()));
                }
                catch (Exception conn3) {
                    // empty catch block
                }
                if (newHistory == null) {
                    return;
                }
                Object[] keys = folderCache.keySet().toArray();
                int len = keys != null ? keys.length : 0;
                for (int i = 0; i < len; ++i) {
                    BHistoryFolder key;
                    Map map;
                    if (!(keys[i] instanceof BHistoryFolder) || (map = (Map)folderCache.get((Object)(key = (BHistoryFolder)((Object)keys[i])))) == null) continue;
                    Object[] navNodes = map.values().toArray();
                    int nlen = navNodes != null ? navNodes.length : 0;
                    for (int j = 0; j < nlen; ++j) {
                        BIHistory history;
                        if (!(navNodes[j] instanceof BHistoryMirror) || !(history = (BIHistory)navNodes[j]).getId().equals((Object)oldId)) continue;
                        map.remove(history.getNavName());
                        BHistoryMirror histMirror = new BHistoryMirror(newHistory, history.getNavParent());
                        String navName = histMirror.getNavName();
                        map.put(navName, histMirror);
                        BNavRoot.INSTANCE.fireNavEvent(NavEvent.makeRenamed((BINavNode)history.getNavParent(), (String)history.getNavName(), (String)navName, (Context)cx));
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(BFoxSession foxSession) {
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
        try {
            BHistoryService service = (BHistoryService)foxSession.getService(BHistoryService.TYPE);
            service.lease(1);
            Object object = this.subscriberLock;
            synchronized (object) {
                if (this.subscriber == null) {
                    this.subscriber = new MySubscriber();
                    this.subscriber.space = this;
                }
                this.subscriber.subscribe(service.getHistoryGroupings(), 1);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup(BFoxSession foxSession) {
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
        this.ord = null;
        this.cache.clear();
        Map folderCache = (Map)this.fw(9904);
        if (folderCache != null) {
            folderCache.clear();
        }
        Object object = this.subscriberLock;
        synchronized (object) {
            if (this.subscriber != null) {
                this.subscriber.unsubscribeAll();
                this.subscriber = null;
            }
        }
    }

    @Override
    public BPermissions getPermissions(Context cx) {
        if (this.permissions != null) {
            return this.permissions;
        }
        try {
            this.permissions = this.channel().getPermissionsByOrd(this.getOrdInSession());
        }
        catch (Exception e) {
            log.warning(() -> "BFoxHistorySpace could not get permissions from station.");
            return BPermissions.none;
        }
        return this.permissions;
    }

    @Override
    public BCategoryMask getAppliedCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public BCategoryMask getCategoryMask() {
        throw new BajaRuntimeException("Categories are unavailable in a remote VM.");
    }

    @Override
    public HistorySpaceConnection getConnection(Context cx) {
        return new FoxHistorySpaceConnection(this, cx);
    }

    @Override
    public String getDeviceName() {
        BISession session;
        if (this.deviceName == null && (session = this.getSession()) instanceof BFoxSession) {
            this.deviceName = ((BFoxSession)session).getStationName();
        }
        return this.deviceName;
    }

    @Override
    public BHistoryDevice[] listDevices() {
        try {
            return this.channel().listDevices(this);
        }
        catch (Exception e) {
            throw new FoxHistoryException("Cannot list devices.", e);
        }
    }

    @Override
    public BIHistory[] listHistories(BHistoryDevice device) {
        try {
            return this.channel().listHistories(this, device);
        }
        catch (Exception e) {
            throw new FoxHistoryException("Cannot list histories for " + this.deviceName + ".", e);
        }
    }

    @Override
    public boolean deviceExists(String deviceName) {
        try {
            return this.channel().deviceExists(deviceName);
        }
        catch (Exception e) {
            throw new FoxHistoryException(deviceName, e);
        }
    }

    @Override
    public BHistoryDevice getDevice(String deviceName) {
        try {
            return this.channel().getDevice(this, deviceName);
        }
        catch (Exception e) {
            throw new FoxHistoryException(deviceName, e);
        }
    }

    BIHistory get(BHistoryId id) {
        return this.cache.get((Object)id);
    }

    void add(BHistoryId id, BIHistory history) {
        this.cache.put(id, history);
    }

    @Override
    public BHistoryConfig getConfig(BHistoryId id) throws HistoryException {
        try {
            BHistoryConfig result = this.channel().getConfig(id);
            return result;
        }
        catch (Exception e) {
            throw new FoxHistoryException(id.toString(), e);
        }
    }

    @Override
    public boolean canRead(OrdTarget cx) {
        return true;
    }

    @Override
    public boolean canWrite(OrdTarget cx) {
        return true;
    }

    @Override
    public boolean canInvoke(OrdTarget cx) {
        return false;
    }

    public BObject bqlQuery(BOrd ord) {
        return this.bqlQuery(ord, null);
    }

    public BObject bqlQuery(BOrd ord, Context cx) {
        try {
            return this.channel().resolve(ord, cx);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new FoxHistoryException("Unresolved: " + ord.toString(), e);
        }
    }

    public BFoxSession getFoxSession() {
        return (BFoxSession)this.getNavParent();
    }

    public synchronized BHistoryChannel channel() {
        return (BHistoryChannel)this.getFoxSession().getConnection().getChannels().get("history", BHistoryChannel.TYPE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object fw(int x, Object a, Object b, Object c, Object d) {
        if (x == 9903 && a instanceof NavListener) {
            boolean unregister = b instanceof BBoolean && ((BBoolean)b).getBoolean();
            WeakHashMap<NavListener, Object> weakHashMap = this.weakNavListeners;
            synchronized (weakHashMap) {
                if (unregister) {
                    this.weakNavListeners.remove(a);
                } else {
                    this.weakNavListeners.put((NavListener)a, null);
                }
            }
        }
        return super.fw(x, a, b, c, d);
    }

    static class MySubscriber
    extends Subscriber {
        BFoxHistorySpace space;

        MySubscriber() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void event(BComponentEvent event) {
            BComponent comp = event.getSourceComponent();
            Type propType = null;
            Slot slot = event.getSlot();
            if (slot != null && slot.isProperty()) {
                propType = slot.asProperty().getType();
            }
            if (comp instanceof BHistoryGroupings && (event.getId() == 4 || (event.getId() == 0 || event.getId() == 1 || event.getId() == 2 || event.getId() == 3) && propType != null && propType.is(BHistoryGroup.TYPE))) {
                BINavSupport support;
                Object folderCache;
                if ((event.getId() == 0 || event.getId() == 2 || event.getId() == 3) && (folderCache = (Map)this.space.fw(9904)) != null) {
                    folderCache.clear();
                }
                if (event.getId() == 1) {
                    folderCache = this.space.subscriberLock;
                    synchronized (folderCache) {
                        if (this.space.subscriber != null) {
                            this.space.subscriber.subscribe((BComponent)comp.get(slot.asProperty()));
                        }
                    }
                }
                if ((support = BINavSupport.getNavSupport()) != null) {
                    support.runNavTreeWork(support.makeNavTreeWork((BINavNode)this.space));
                }
            } else if (comp instanceof BHistoryGroup && event.getId() == 0 && slot != null && slot.isFrozen()) {
                BINavSupport support;
                Map folderCache = (Map)this.space.fw(9904);
                if (folderCache != null) {
                    folderCache.clear();
                }
                if ((support = BINavSupport.getNavSupport()) != null) {
                    support.runNavTreeWork(support.makeNavTreeWork((BINavNode)this.space));
                }
            }
        }
    }
}

