/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.recstore;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.nre.util.ByteBuffer;

public class RecordStoreHeader {
    private static int MAGIC = 182299393;
    private static int HEADER_SIZE = 256;
    private int blockSize;
    private int pageBlocks;
    private int firstPage = -1;
    private int lastPage = -1;
    private int recordCount = 0;
    private ByteBuffer buf = new ByteBuffer(HEADER_SIZE);
    private boolean dirty;

    public RecordStoreHeader() {
        this.dirty = true;
    }

    public RecordStoreHeader(int blockSize, int pageBlocks) {
        this.blockSize = blockSize;
        this.pageBlocks = pageBlocks;
        this.dirty = true;
    }

    public int getBlockSize() {
        return this.blockSize;
    }

    public int getPageBlocks() {
        return this.pageBlocks;
    }

    public int getSize() {
        return HEADER_SIZE;
    }

    public int getFirstPage() {
        return this.firstPage;
    }

    public void setFirstPage(int first) {
        if (this.firstPage == first) {
            return;
        }
        this.firstPage = first;
        this.dirty = true;
    }

    public int getLastPage() {
        return this.lastPage;
    }

    public void setLastPage(int last) {
        if (this.lastPage == last) {
            return;
        }
        this.lastPage = last;
        this.dirty = true;
    }

    public int getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(int count) {
        if (this.recordCount == count) {
            return;
        }
        this.recordCount = count;
        this.dirty = true;
    }

    public void incrementRecordCount() {
        ++this.recordCount;
        this.dirty = true;
    }

    public void decrementRecordCount() {
        --this.recordCount;
        this.dirty = true;
    }

    public void read(DataInput in) throws IOException {
        int magic = in.readInt();
        if (magic != MAGIC) {
            throw new IOException("Invalid or corrupt record store.");
        }
        int version = in.readInt();
        this.blockSize = in.readInt();
        this.pageBlocks = in.readInt();
        this.firstPage = in.readInt();
        this.lastPage = in.readInt();
        this.recordCount = in.readInt();
    }

    public void write(DataOutput out) throws IOException {
        if (!this.dirty) {
            return;
        }
        this.buf.reset();
        this.buf.writeInt(MAGIC);
        this.buf.writeInt(1);
        this.buf.writeInt(this.blockSize);
        this.buf.writeInt(this.pageBlocks);
        this.buf.writeInt(this.firstPage);
        this.buf.writeInt(this.lastPage);
        this.buf.writeInt(this.recordCount);
        byte[] bytes = this.buf.getBytes();
        if (bytes.length > HEADER_SIZE) {
            throw new IOException("Header overflow: " + bytes.length + " > " + HEADER_SIZE);
        }
        out.write(bytes, 0, HEADER_SIZE);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public String toString() {
        return "first=" + this.firstPage + ", last=" + this.lastPage + ", recordCount= " + this.recordCount;
    }
}

