/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.file.fixed;

import com.tridium.history.file.fixed.RecordSpec;
import java.io.IOException;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.HistoryCursor;
import javax.baja.sys.Context;

public class PageHistoryDescendingCursor
extends HistoryCursor {
    private boolean first;
    private RecordSpec startSpec;
    private RecordSpec endSpec;

    public PageHistoryDescendingCursor(BHistoryConfig config, BHistoryRecord iteratorRec, RecordSpec startSpec, RecordSpec endSpec, Context context) {
        super(config, iteratorRec, context);
        this.startSpec = startSpec;
        this.endSpec = endSpec;
        this.first = true;
        try {
            config.makeRecord();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected boolean doNext(BHistoryRecord iteratorRec) {
        try {
            if (this.startSpec == null || this.endSpec == null) {
                return false;
            }
            if (this.first) {
                this.startSpec.getRecord(iteratorRec);
                this.first = false;
                if (this.startSpec.equals(this.endSpec)) {
                    this.startSpec = null;
                }
                return true;
            }
            if (this.startSpec.equals(this.endSpec)) {
                return false;
            }
            if (!this.startSpec.prev()) {
                return false;
            }
            this.startSpec.getRecord(iteratorRec);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

