/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.collection;

import com.tridium.bql.collection.BqlColumn;
import com.tridium.bql.expression.BPath;
import com.tridium.bql.expression.ExprEngine;
import com.tridium.history.collection.HistoryColumn;
import javax.baja.query.BExpression;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BDouble;
import javax.baja.sys.BFacets;
import javax.baja.sys.BFloat;
import javax.baja.sys.BInteger;
import javax.baja.sys.BLong;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Type;

public class PathColumn
extends BqlColumn
implements HistoryColumn {
    private BObject base;
    private String pathString;
    private BPath expr;
    private BFacets facets;
    private Type type;
    private String displayName;

    public PathColumn(BObject base, String pathString, String displayName, BFacets facets) {
        this.displayName = displayName;
        this.base = base;
        this.pathString = pathString;
        this.facets = facets;
        this.expr = new BPath(pathString);
        BObject o = ExprEngine.instantEval((BExpression)this.expr, (BObject)base, null);
        if (o == null) {
            throw new BajaRuntimeException("Invalid path: " + pathString);
        }
        this.type = o.getType();
    }

    public String getName() {
        return this.pathString;
    }

    public String getDisplayName(Context cx) {
        if (this.displayName != null) {
            return this.displayName;
        }
        return this.getDefaultDisplayName(cx);
    }

    @Override
    public String getDefaultDisplayName(Context cx) {
        return this.expr.getPath().getDisplayName((Object)this.base, cx);
    }

    public Type getType() {
        return this.type;
    }

    public int getFlags() {
        return 0;
    }

    public BFacets getFacets() {
        return this.facets == null ? BFacets.NULL : this.facets;
    }

    @Override
    public BObject get(BObject target) {
        return this.expr.evaluate(target, null);
    }

    @Override
    public String getString(BObject target) {
        BObject o = this.get(target);
        return ((BString)o).getString();
    }

    @Override
    public double getDouble(BObject target) {
        BObject o = this.get(target);
        return ((BDouble)o).getDouble();
    }

    @Override
    public float getFloat(BObject target) {
        BObject o = this.get(target);
        return ((BFloat)o).getFloat();
    }

    @Override
    public boolean getBoolean(BObject target) {
        BObject o = this.get(target);
        return ((BBoolean)o).getBoolean();
    }

    @Override
    public int getInt(BObject target) {
        BObject o = this.get(target);
        return ((BInteger)o).getInt();
    }

    @Override
    public long getLong(BObject target) {
        BObject o = this.get(target);
        return ((BLong)o).getLong();
    }

    @Override
    public int getFlags(BObject target) {
        return 0;
    }

    @Override
    public BFacets getFacets(BObject target) {
        return BFacets.NULL;
    }
}

