/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.history.audit;

import com.tridium.history.audit.BAbstractAuditHistorySource;
import com.tridium.history.audit.BAuditRecord;
import com.tridium.history.audit.BSecurityAuditHistorySource;
import com.tridium.syslog.SyslogAuditHandler;
import java.util.StringJoiner;
import java.util.logging.Level;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistorySource;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuditEvent;
import javax.baja.security.Auditor;
import javax.baja.security.SecurityAuditEvent;
import javax.baja.security.SecurityAuditor;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BIRestrictedComponent;
import javax.baja.util.BTypeSpec;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="historyConfig", type="BHistoryConfig", defaultValue="new BHistoryConfig(BHistoryId.make(\"station\", \"AuditHistory\"), BTypeSpec.make(\"history\", \"AuditRecord\"))", override=true), @NiagaraProperty(name="SecurityAuditHistorySource", type="BSecurityAuditHistorySource", defaultValue="new BSecurityAuditHistorySource()")})
public class BAuditHistoryService
extends BAbstractAuditHistorySource
implements BIService,
Auditor,
BIHistorySource,
BIRestrictedComponent {
    @Generated
    public static final Property historyConfig = BAuditHistoryService.newProperty((int)0, (BValue)new BHistoryConfig(BHistoryId.make("station", "AuditHistory"), BTypeSpec.make((String)"history", (String)"AuditRecord")), null);
    @Generated
    public static final Property SecurityAuditHistorySource = BAuditHistoryService.newProperty((int)0, (BValue)new BSecurityAuditHistorySource(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BAuditHistoryService.class);
    private static final Type[] serviceTypes = new Type[]{TYPE};
    private static final Lexicon LEX = Lexicon.make((String)"history");
    private static final SyslogAuditHandler syslogAuditHandler = new SyslogAuditHandler();

    @Generated
    public BSecurityAuditHistorySource getSecurityAuditHistorySource() {
        return (BSecurityAuditHistorySource)this.get(SecurityAuditHistorySource);
    }

    @Generated
    public void setSecurityAuditHistorySource(BSecurityAuditHistorySource v) {
        this.set(SecurityAuditHistorySource, (BValue)v, null);
    }

    @Override
    @Generated
    public Type getType() {
        return TYPE;
    }

    @Override
    protected BTypeSpec getRecordType() {
        return BTypeSpec.make((String)"history", (String)"AuditRecord");
    }

    @Override
    protected BHistoryId getHistoryId() {
        return BHistoryId.make(Sys.getStation().getStationName(), "AuditHistory");
    }

    @Override
    protected void auditStarted() {
        Sys.setAuditor((Auditor)this);
    }

    @Override
    protected void auditStopped() {
        Sys.setAuditor(null);
    }

    public Type[] getServiceTypes() {
        return serviceTypes;
    }

    public void serviceStarted() throws Exception {
    }

    public void serviceStopped() throws Exception {
        this.stopAudit();
    }

    public final void checkParentForRestrictedComponent(BComponent parent, Context cx) {
        BIRestrictedComponent.checkParentForRestrictedComponent((BComponent)parent, (BIRestrictedComponent)this);
    }

    public void audit(AuditEvent event) {
        boolean shouldAudit = BAuditHistoryService.checkSecurityAudit(event);
        if (shouldAudit) {
            this.audit(BAuditRecord.fromEvent(event));
            syslogAuditHandler.publish(event, false);
        }
    }

    private static boolean checkSecurityAudit(AuditEvent event) {
        SecurityAuditor securityAuditor = Sys.getSecurityAuditor();
        if (event.getOperation().equals("Login") || event.getOperation().equals("Logout") || event.getOperation().equals("Login Failure") || event.getOperation().equals("Logout (Timeout)")) {
            if (securityAuditor != null) {
                String message = event.getTarget() + " | " + event.getSlotName();
                String oldValue = event.getOldValue();
                if (oldValue != null && !oldValue.isEmpty()) {
                    message = message + " | " + event.getOldValue();
                }
                SecurityAuditEvent securityEvent = new SecurityAuditEvent(event.getOperation(), event.getUserName(), message);
                securityAuditor.audit(securityEvent);
                syslogAuditHandler.publish(event, true);
            }
            return false;
        }
        if (event.getOperation().equals("Recategorized")) {
            if (securityAuditor != null) {
                String message = LEX.getText("securityHistory.recategorizedMessage", new Object[]{event.getTarget(), event.getOldValue(), event.getValue()});
                SecurityAuditEvent securityEvent = new SecurityAuditEvent(event.getOperation(), event.getUserName(), message);
                securityAuditor.audit(securityEvent);
                syslogAuditHandler.publish(event, true);
            }
            return false;
        }
        if (event.getOperation().equals("Changed")) {
            block19: {
                try {
                    boolean securityProperty = false;
                    BComplex target = (BComplex)BOrd.make((String)("station:|slot:" + event.getTarget())).get();
                    String[] slots = event.getSlotName().split("/");
                    StringJoiner targetJoiner = new StringJoiner("/");
                    targetJoiner.add(event.getTarget());
                    for (int i = 0; i < slots.length; ++i) {
                        String slot = slots[i];
                        if (!securityProperty) {
                            if (target.getSlotFacets(target.getSlot(slot)).getb("security", false)) {
                                securityProperty = true;
                            } else if (i < slots.length - 1) {
                                target = (BComplex)target.get(slot);
                            }
                        }
                        if (i >= slots.length - 1) continue;
                        targetJoiner.add(slot);
                    }
                    if (securityProperty && securityAuditor != null) {
                        String message = LEX.getText("securityHistory.changedMessage", new Object[]{targetJoiner.toString(), slots[slots.length - 1], event.getOldValue(), event.getValue()});
                        SecurityAuditEvent securityEvent = new SecurityAuditEvent("Changed", event.getUserName(), message);
                        securityAuditor.audit(securityEvent);
                        syslogAuditHandler.publish(event, true);
                    }
                }
                catch (Exception e) {
                    if (!BHistoryService.logger.isLoggable(Level.FINE)) break block19;
                    BHistoryService.logger.log(Level.FINE, "Failed to check AuditEvent target for security property.", e);
                }
            }
            return true;
        }
        if (event.getOperation().equals("Invoked")) {
            block20: {
                if (securityAuditor != null) {
                    try {
                        BComplex target = (BComplex)BOrd.make((String)("station:|slot:" + event.getTarget())).get();
                        if (target.getSlotFacets(target.getSlot(event.getSlotName())).getb("security", false)) {
                            boolean invocationHasValue = target.getAction(event.getSlotName()).getParameterType() != null;
                            String message = invocationHasValue ? LEX.getText("securityHistory.invokedWithValueMessage", new Object[]{event.getTarget(), event.getSlotName(), event.getValue()}) : LEX.getText("securityHistory.invokedMessage", new Object[]{event.getTarget(), event.getSlotName()});
                            SecurityAuditEvent securityEvent = new SecurityAuditEvent("Invoked", event.getUserName(), message);
                            securityAuditor.audit(securityEvent);
                        }
                    }
                    catch (Exception e) {
                        if (!BHistoryService.logger.isLoggable(Level.FINE)) break block20;
                        BHistoryService.logger.log(Level.FINE, "Failed to check AuditEvent target for security action " + event.getTarget() + "." + event.getSlotName(), e);
                    }
                }
            }
            return true;
        }
        return true;
    }
}

