/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.vacm;

import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.messages.SnmpV3AlarmTrap;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.util.SnmpUtil;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.vacm.BVacmAccess;
import com.tridium.nSnmp.version3.vacm.BVacmAccessTable;
import com.tridium.nSnmp.version3.vacm.BVacmContext;
import com.tridium.nSnmp.version3.vacm.BVacmContextTable;
import com.tridium.nSnmp.version3.vacm.BVacmGroup;
import com.tridium.nSnmp.version3.vacm.BVacmGroupTable;
import com.tridium.nSnmp.version3.vacm.BVacmViewTree;
import com.tridium.nSnmp.version3.vacm.BVacmViewTreeTable;
import com.tridium.nSnmp.version3.vacm.VacmException;
import com.tridium.nSnmp.version3.vacm.ViewType;

public class SnmpVACM {
    private static SnmpVACM snmpVACMInstance = new SnmpVACM();

    private SnmpVACM() {
    }

    public static SnmpVACM getBSnmpVACMinstance() {
        return snmpVACMInstance;
    }

    public boolean isAccessAllowed(SnmpPDU message, SnmpOID oid, boolean accessToSet) {
        if (message instanceof SnmpV3AlarmTrap) {
            SnmpV3AlarmTrap v3Message = (SnmpV3AlarmTrap)message;
            try {
                return this.isAccessAllowed(v3Message, oid, accessToSet);
            }
            catch (VacmException e) {
                return false;
            }
        }
        return false;
    }

    public boolean isAccessAllowed(SnmpV3AlarmTrap message, SnmpOID oid, boolean accessToSet) throws VacmException {
        boolean accessAllowed = false;
        String variableName = oid.toString();
        String securityName = message.getUserSecurityName();
        String contextName = message.getContextName();
        int securityLevel = message.getSecurityLevel();
        int securityModel = message.getMsgSecurityModel();
        ViewType viewType = this.getViewTypeFromCommand(message.getCommand());
        VacmException exceptionObject = new VacmException(message, variableName);
        if (this.isVariableAllowableWithoutVACM(variableName)) {
            return true;
        }
        String groupName = this.fetchGroupNameFromSecurityTable(securityName, securityModel, exceptionObject);
        boolean isContextNameFound = this.isContextNameFound(contextName, exceptionObject);
        if (isContextNameFound) {
            BVacmAccess vacmAccessEntry = this.getVacmAccessEntryInAccessTable(securityModel, securityLevel, securityName, groupName, contextName, exceptionObject);
            String viewName = this.fetchViewName(vacmAccessEntry, viewType, exceptionObject);
            BVacmViewTree vacmViewTree = this.getVacmViewTree(viewName, exceptionObject);
            accessAllowed = this.isVariablePesentInMibView(vacmViewTree, variableName, exceptionObject);
        }
        return accessAllowed;
    }

    public boolean isAccessAllowed(SnmpV3Message message, SnmpOID oid, boolean accessToSet) throws VacmException {
        boolean accessAllowed = false;
        String variableName = oid.toString();
        String securityName = message.getUserSecurityName();
        String contextName = message.getContextName();
        int securityLevel = message.getMsgFlag() & 3;
        int securityModel = message.getMsgSecurityModel();
        ViewType viewType = this.getViewTypeFromCommand(message.getCommand());
        VacmException exceptionObject = new VacmException(message, variableName);
        if (this.isVariableAllowableWithoutVACM(variableName)) {
            return true;
        }
        String groupName = this.fetchGroupNameFromSecurityTable(securityName, securityModel, exceptionObject);
        boolean isContextNameFound = this.isContextNameFound(contextName, exceptionObject);
        if (isContextNameFound) {
            BVacmAccess vacmAccessEntry = this.getVacmAccessEntryInAccessTable(securityModel, securityLevel, securityName, groupName, contextName, exceptionObject);
            String viewName = this.fetchViewName(vacmAccessEntry, viewType, exceptionObject);
            BVacmViewTree vacmViewTree = this.getVacmViewTree(viewName, exceptionObject);
            accessAllowed = this.isVariablePesentInMibView(vacmViewTree, variableName, exceptionObject);
        }
        return accessAllowed;
    }

    private String fetchGroupNameFromSecurityTable(String securityName, int securityModel, VacmException exceptionObject) throws VacmException {
        String groupName = null;
        BVacmGroup vacmGroup = BVacmGroupTable.getVacmGroup(securityModel, securityName);
        if (vacmGroup != null) {
            groupName = vacmGroup.getVacmGroupName();
        }
        if (groupName == null) {
            exceptionObject.setErrorCode(102);
            throw exceptionObject;
        }
        return groupName;
    }

    private boolean isContextNameFound(String contextName, VacmException exceptionObject) throws VacmException {
        boolean contextNameFound = false;
        BVacmContext vacmContext = BVacmContextTable.getBVacmContext(contextName);
        if (vacmContext != null) {
            contextNameFound = true;
        }
        if (!contextNameFound) {
            exceptionObject.setErrorCode(103);
            throw exceptionObject;
        }
        return contextNameFound;
    }

    private BVacmAccess getVacmAccessEntryInAccessTable(int securityModel, int securityLevel, String securityName, String groupName, String contextName, VacmException exceptionObject) throws VacmException {
        BVacmAccess vacmAccess = null;
        vacmAccess = BVacmAccessTable.getVacmAccessEntry(groupName, contextName, securityModel, securityLevel);
        if (vacmAccess == null) {
            exceptionObject.setGroupName(groupName);
            exceptionObject.setErrorCode(104);
            throw exceptionObject;
        }
        return vacmAccess;
    }

    private String fetchViewName(BVacmAccess vacmAccess, ViewType viewType, VacmException exceptionObject) throws VacmException {
        switch (viewType) {
            case READ_VIEW: {
                return vacmAccess.getReadView();
            }
            case WRITE_VIEW: {
                return vacmAccess.getWriteView();
            }
            case NOTIFY_VIEW: {
                return vacmAccess.getNotifyView();
            }
        }
        exceptionObject.setViewType(viewType);
        exceptionObject.setErrorCode(105);
        throw exceptionObject;
    }

    private BVacmViewTree getVacmViewTree(String viewName, VacmException exceptionObject) throws VacmException {
        BVacmViewTree vacmViewTree = null;
        vacmViewTree = BVacmViewTreeTable.getBVacmViewTree(viewName);
        if (vacmViewTree == null) {
            exceptionObject.setViewName(viewName);
            exceptionObject.setErrorCode(106);
            throw exceptionObject;
        }
        return vacmViewTree;
    }

    private boolean isVariablePesentInMibView(BVacmViewTree vacmViewTree, String variableName, VacmException exceptionObject) throws VacmException {
        boolean variableFound = false;
        String subtree = vacmViewTree.getSubtree();
        if (subtree.length() <= variableName.length()) {
            long[] subtreeLongArray = SnmpUtil.getLongArray(subtree);
            long[] variableLongArray = SnmpUtil.getLongArray(variableName);
            variableFound = true;
            for (int index = 0; index < subtreeLongArray.length; ++index) {
                if (subtreeLongArray[index] == variableLongArray[index]) continue;
                variableFound = false;
                break;
            }
        }
        if (!variableFound) {
            exceptionObject.setErrorCode(107);
            throw exceptionObject;
        }
        return variableFound;
    }

    private ViewType getViewTypeFromCommand(int messageCommand) {
        ViewType viewType = ViewType.INVALID_VIEW_TYPE;
        int command = messageCommand & 0xFF;
        switch (command) {
            case 160: 
            case 161: 
            case 165: {
                viewType = ViewType.READ_VIEW;
                break;
            }
            case 163: {
                viewType = ViewType.WRITE_VIEW;
                break;
            }
            case 164: 
            case 167: 
            case 169: {
                viewType = ViewType.NOTIFY_VIEW;
            }
        }
        return viewType;
    }

    private boolean isVariableAllowableWithoutVACM(String variableName) {
        if ("1.3.6.1.2.1.1.1.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.1.2.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.1.3.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.1.4.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.1.5.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.1.6.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.1.7.0".equalsIgnoreCase(variableName)) {
            return true;
        }
        if ("1.3.6.1.2.1.11".equalsIgnoreCase(variableName)) {
            return true;
        }
        return "1.3.6.1.6.3.1.1.4.1.0".equalsIgnoreCase(variableName);
    }
}

