/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.version3.dispatcher;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.comm.SnmpListener;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.version3.dispatcher.SnmpTransportMapping;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.messageProcessingModel.SnmpMessageProcessingModel;
import com.tridium.nSnmp.version3.securityModel.usm.USMException;
import com.tridium.ndriver.datatypes.BIpAddress;
import java.security.SecureRandom;
import java.util.Vector;

public class SnmpDispatcher {
    private SnmpMessageProcessingModel messageProcessingModel = null;
    private SnmpTransportMapping transportMapping = null;
    public static final int MAX_MESSAGE_ID = Integer.MAX_VALUE;

    private SnmpDispatcher(SnmpMessageProcessingModel messageProcessingModel, BSnmpNetwork snmpNet) {
        this.messageProcessingModel = messageProcessingModel;
        this.transportMapping = new SnmpTransportMapping(snmpNet);
    }

    public static SnmpDispatcher getBSnmpDispatcherInstance(SnmpMessageProcessingModel messageProcessingModel, BSnmpNetwork snmpNet) {
        return new SnmpDispatcher(messageProcessingModel, snmpNet);
    }

    public SnmpPDU sendPDU(BIpAddress address, String contextEngineID, String contextName, SnmpV3Message message, boolean expectedResponse) throws Exception {
        SnmpV3Message returnedMessage = this.sendSNMPMessage(message, false);
        SnmpPDU returnedPDU = this.messageProcessingModel.prepareDataElement(contextEngineID, contextName, returnedMessage, address);
        return returnedPDU;
    }

    public SnmpV3Message sendPDU(SnmpV3Message message) throws Exception {
        SnmpV3Message returnedMessage = this.sendSNMPMessage(message, false);
        return returnedMessage;
    }

    public void returnResponsePDU(SnmpV3Message receivedMessage, SnmpV3Message responseMessage) {
        this.messageProcessingModel.prepareResponseMessage(receivedMessage, responseMessage);
        this.sendSNMPMessage(responseMessage, true);
    }

    public boolean registerContextEngineID(String contextEngineID, String pduType) {
        boolean status = false;
        return status;
    }

    public boolean unRegisterContextEngineID(String contextEngineID, String pduType) {
        boolean status = false;
        return status;
    }

    public void listenAndRespondSNMPMessage(SnmpV3Message receivedMessage, SnmpListener listener) {
        if (this.isResponseToRequest()) {
            try {
                SnmpV3Message preparedRequest = this.messageProcessingModel.prepareDataElement(receivedMessage);
                SnmpV3Message returnedMessage = (SnmpV3Message)listener.prepareResponse(preparedRequest, 2);
                this.returnResponsePDU(receivedMessage, returnedMessage);
            }
            catch (USMException e) {
                e.printStackTrace();
            }
        }
    }

    private SnmpV3Message sendSNMPMessage(SnmpV3Message message, boolean isResponseToRequest) {
        SnmpV3Message returnedMessage = null;
        try {
            if (isResponseToRequest) {
                if (message.getVariableBindings() == null || message.getVariableBindings().size() == 0 || "".equals(message.getUserSecurityName())) {
                    message.setCommand(168);
                }
                this.transportMapping.sendAsyncResponseMessageByUDP(message);
            } else {
                int currentMsgID = new SecureRandom().nextInt(Integer.MAX_VALUE);
                String userName = message.getUserSecurityName();
                Vector<SnmpVarBind> variableBindings = message.getVariableBindings();
                byte msgFlag = message.getMsgFlag();
                int securityLevel = msgFlag & 3;
                message.setMsgID(currentMsgID);
                message.setReqid(currentMsgID);
                message.setDiscoveryMode(true);
                message.setUserSecurityName("");
                message.setMsgFlag((byte)0);
                message.setVariableBindings(new Vector<SnmpVarBind>());
                returnedMessage = this.transportMapping.sendSyncMessageByUDP(message);
                message.setDiscoveryMode(false);
                byte[] msgAuthoritativeEngineID = returnedMessage.getMsgAuthoritativeEngineID();
                int msgAuthoritativeEngineBoots = returnedMessage.getMsgAuthoritativeEngineBoots();
                int msgAuthoritativeEngineTime = returnedMessage.getMsgAuthoritativeEngineTime();
                int requestId = returnedMessage.getReqid();
                message.setMsgID(requestId - 1);
                message.setReqid(requestId - 1);
                message.setUserSecurityName(userName);
                message.setSecurityLevel(securityLevel);
                message.setMsgFlag(msgFlag);
                message.setMsgAuthoritativeEngineID(msgAuthoritativeEngineID);
                message.setMsgAuthoritativeEngineBoots(msgAuthoritativeEngineBoots);
                message.setMsgAuthoritativeEngineTime(msgAuthoritativeEngineTime);
                message.setVariableBindings(variableBindings);
                if (message.getContextId() == null || message.getContextId().length == 0) {
                    message.setContextId(msgAuthoritativeEngineID);
                }
                this.messageProcessingModel.prepareOutgoingMessage(message);
                returnedMessage = this.transportMapping.sendSyncMessageByUDP(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            returnedMessage = null;
        }
        return returnedMessage;
    }

    private boolean isResponseToRequest() {
        boolean isResponse = true;
        return isResponse;
    }
}

