/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.snmptypes;

import com.tridium.nSnmp.snmptypes.ASNException;
import com.tridium.nSnmp.snmptypes.ASNInput;
import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpCounter;
import com.tridium.nSnmp.snmptypes.SnmpExceptionVar;
import com.tridium.nSnmp.snmptypes.SnmpGauge;
import com.tridium.nSnmp.snmptypes.SnmpInt;
import com.tridium.nSnmp.snmptypes.SnmpIpAddress;
import com.tridium.nSnmp.snmptypes.SnmpNull;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpOpaque;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpTimeticks;

public abstract class SnmpVar
implements SnmpConst {
    public int type;

    public static SnmpVar getSnmpVar(ASNInput in) throws ASNException {
        int type = in.peekTag();
        switch (type) {
            case 2: {
                SnmpInt snmpVar = new SnmpInt(in.getInt());
                snmpVar.type = type;
                return snmpVar;
            }
            case 4: {
                byte[] value = in.getOctetString();
                SnmpString snmpVar = new SnmpString(value);
                snmpVar.type = type;
                return snmpVar;
            }
            case 5: {
                in.getNull();
                SnmpNull snmpVar = new SnmpNull();
                snmpVar.type = type;
                return snmpVar;
            }
            case 6: {
                SnmpOID snmpVar = new SnmpOID(in.getObjectID());
                snmpVar.type = type;
                return snmpVar;
            }
            case 64: {
                SnmpIpAddress snmpVar = new SnmpIpAddress(in.getIpAddress());
                snmpVar.type = type;
                return snmpVar;
            }
            case 67: {
                SnmpTimeticks snmpVar = new SnmpTimeticks(in.getTimetick());
                snmpVar.type = type;
                return snmpVar;
            }
            case 65: {
                SnmpCounter snmpVar = new SnmpCounter(in.getCounter());
                snmpVar.type = type;
                return snmpVar;
            }
            case 70: {
                SnmpCounter snmpVar = new SnmpCounter(in.getCounter64());
                snmpVar.type = type;
                return snmpVar;
            }
            case 66: {
                SnmpGauge snmpVar = new SnmpGauge(in.getGauge());
                snmpVar.type = type;
                return snmpVar;
            }
            case 68: {
                SnmpOpaque snmpVar = new SnmpOpaque(in.getOpaque());
                return snmpVar;
            }
            case 128: 
            case 129: 
            case 130: {
                in.read();
                in.readBytes();
                SnmpExceptionVar snmpVar = new SnmpExceptionVar();
                snmpVar.type = type;
                return snmpVar;
            }
        }
        throw new ASNException();
    }

    public String toTagString() {
        return "SNMP VAR";
    }

    public String toStringValue() {
        return "";
    }

    public abstract void encode(ASNOutput var1);
}

