/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.mib;

import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.mib.MibTable;
import com.tridium.nSnmp.mib.table.PointContainer;
import com.tridium.nSnmp.mib.table.PointEntry;
import com.tridium.nSnmp.mib.table.TableEntry;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpInt;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpString;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.util.SnmpUtil;

public class MibPointTable
extends MibTable
implements SnmpConst {
    public static final int INDEX = 1;
    public static final int NAME = 2;
    public static final int VALUE = 3;
    public static final int LAST_ID = 3;
    private String firstOid;
    private boolean input;
    private int level;
    PointContainer cntr;

    public MibPointTable(PointContainer cntr, String oid, boolean input) {
        this.cntr = cntr;
        this.firstOid = oid + ".1.1";
        this.input = input;
        this.level = SnmpUtil.getLongArray(this.firstOid).length - 1;
    }

    @Override
    public SnmpVar getValue(SnmpOID oid) {
        long[] aOid = oid.toLongArray();
        PointEntry entry = this.getEntry(aOid);
        if (entry == null) {
            return null;
        }
        SnmpVar var = null;
        try {
            switch ((int)aOid[this.level]) {
                case 1: {
                    var = new SnmpInt(entry.getIndex());
                    break;
                }
                case 2: {
                    var = new SnmpString(entry.getPointName());
                    break;
                }
                case 3: {
                    var = entry.getValue();
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return var;
    }

    private PointEntry getEntry(long[] aOid) {
        if (aOid.length <= this.level + 1) {
            return null;
        }
        return (PointEntry)this.cntr.getTable(this.input).getObject((int)aOid[this.level + 1]);
    }

    @Override
    public int validateForSet(SnmpVarBind varbind) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        switch ((int)aOid[this.level]) {
            case 1: 
            case 2: {
                return 17;
            }
            case 3: {
                PointEntry entry = this.getEntry(aOid);
                if (entry == null) {
                    return 6;
                }
                if (!entry.isSettablePoint()) {
                    return 17;
                }
                try {
                    entry.tryDecodeForSet(varbind.getVariable());
                    break;
                }
                catch (Throwable e) {
                    return 7;
                }
            }
            default: {
                return 6;
            }
        }
        return 0;
    }

    @Override
    public int setValue(SnmpVarBind varbind, SnmpPDU resp) {
        SnmpOID oid = varbind.getObjectID();
        long[] aOid = oid.toLongArray();
        switch ((int)aOid[this.level]) {
            case 1: 
            case 2: {
                return 4;
            }
            case 3: {
                PointEntry entry = this.getEntry(aOid);
                if (entry == null) {
                    return 2;
                }
                if (!entry.isSettablePoint()) {
                    return 4;
                }
                SnmpVar s = entry.setValue(varbind.getVariable());
                if (s == null) {
                    return 3;
                }
                resp.addVariableBinding(new SnmpVarBind(oid, s));
                break;
            }
            default: {
                return 2;
            }
        }
        return 0;
    }

    @Override
    public int getObjectLevel() {
        return this.level;
    }

    @Override
    public int getLastId() {
        return 3;
    }

    @Override
    public TableEntry getNextEntry(int index) {
        return this.cntr.getTable(this.input).getNextEntry(index);
    }

    @Override
    public String getFirstOid() {
        return this.firstOid;
    }
}

