/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp.messages;

import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.snmptypes.ASNException;
import com.tridium.nSnmp.snmptypes.ASNInput;
import com.tridium.nSnmp.snmptypes.ASNOutput;
import com.tridium.nSnmp.snmptypes.SnmpConst;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.util.SnmpUtil;
import com.tridium.nSnmp.version3.vacm.SnmpVACM;
import com.tridium.ndriver.comm.NMessage;
import java.io.OutputStream;
import java.net.InetAddress;
import java.util.Vector;
import javax.baja.sys.BAbsTime;

public class SnmpPDU
extends NMessage
implements SnmpConst {
    private InetAddress destAddr = null;
    protected InetAddress srcAddr = null;
    protected int version = -1;
    private String community = null;
    protected int pduType = 0;
    protected int nonRepeaters = 0;
    protected int maxRepetitions = 0;
    protected int errIndex = 0;
    protected int errStat = 0;
    private int remotePort = 0;
    protected int reqId = 0;
    protected long upTime = 0L;
    protected int trapType = 0;
    protected int specificType = 0;
    protected SnmpOID enterprise;
    private Vector<SnmpVarBind> vars;
    private boolean full = false;
    private long[] trapEnterprise = null;
    private byte[] trapAgentAddr = null;
    private int trapGeneric = 0;
    private int trapSpecific = 0;
    private long trapTimeStamp = System.currentTimeMillis();
    private BSnmpNetwork snmpNet = null;

    public SnmpPDU() {
        this.vars = new Vector();
    }

    public SnmpPDU(int version) {
        this.version = version;
    }

    public SnmpPDU(BSnmpDevice dev, int cmd) {
        this.snmpNet = dev.snmpNet();
        this.setVersion(dev.getVersion());
        this.setReqid(dev.snmpNet().getNextReqid(dev.getInetAddress()));
        this.setCommand(cmd);
        this.setRemotePort(dev.getPort());
        this.setDestinationIp(dev.getInetAddress());
        this.setCommunity(dev.getCommunity());
        this.vars = new Vector();
    }

    public void setFull(boolean full) {
        this.full = full;
    }

    public boolean isFull() {
        return this.full;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void setCommand(int command) {
        this.pduType = command;
    }

    public void setCommunity(String community) {
        this.community = community;
    }

    public void setReqid(int reqId) {
        this.reqId = reqId;
    }

    public void setRemotePort(int remotePort) {
        this.remotePort = remotePort;
    }

    public void setErrindex(int errIndex) {
        this.errIndex = errIndex;
    }

    public void setErrstat(int errStat) {
        this.errStat = errStat;
    }

    public void setNonRepeaters(int nonRepeaters) {
        this.nonRepeaters = nonRepeaters;
    }

    public void setMaxRepetitions(int maxRepetitions) {
        this.maxRepetitions = maxRepetitions;
    }

    public void setTrapType(int trapType) {
        this.trapType = trapType;
    }

    public int getTrapType() {
        return this.trapType;
    }

    public void setSpecificType(int specificType) {
        this.specificType = specificType;
    }

    public int getSpecificType() {
        return this.specificType;
    }

    public void setUpTime(long upTime) {
        this.upTime = upTime;
    }

    public long getUpTime() {
        return this.upTime;
    }

    public void setEnterprise(SnmpOID enterprise) {
        this.enterprise = enterprise;
    }

    public SnmpOID getEnterprise() {
        return this.enterprise;
    }

    public void setDestinationIp(InetAddress destAddr) {
        this.destAddr = destAddr;
    }

    public void setSourceIp(InetAddress srcAddr) {
        this.srcAddr = srcAddr;
    }

    public int getRemotePort() {
        return this.remotePort;
    }

    public int getCommand() {
        return this.pduType;
    }

    public int getVersion() {
        return this.version;
    }

    public int getReqid() {
        return this.reqId;
    }

    public int getErrstat() {
        return this.errStat;
    }

    public int getNonRepeaters() {
        return this.nonRepeaters;
    }

    public int getMaxRepetitions() {
        return this.maxRepetitions;
    }

    public int getErrindex() {
        return this.errIndex;
    }

    public InetAddress getSourceIp() {
        return this.srcAddr;
    }

    public InetAddress getDestinationIp() {
        return this.destAddr;
    }

    public String getCommunity() {
        return this.community != null ? this.community : "public";
    }

    public byte[] getData() {
        return this.encodeData();
    }

    public Vector<SnmpVarBind> getVariableBindings() {
        return this.vars;
    }

    public void setVariableBindings(Vector<SnmpVarBind> v) {
        this.vars = v;
    }

    public void clearVariableBindings() {
        this.vars.clear();
    }

    public void addVariableBinding(SnmpVarBind varBind) {
        this.vars.addElement(varBind);
    }

    public String getTrapEnterprise() {
        if (this.trapEnterprise == null) {
            return "null";
        }
        return SnmpUtil.longArrayToString(this.trapEnterprise);
    }

    public void setTrapEnterprise(long[] trapEnterprise) {
        this.trapEnterprise = trapEnterprise;
    }

    public long[] getToSetTrapEnterprise() {
        return this.trapEnterprise;
    }

    public String getAgentAddr() {
        if (this.trapAgentAddr == null) {
            return "null";
        }
        return SnmpUtil.byteArrayToString(this.trapAgentAddr);
    }

    public byte[] getTrapAgentAddr() {
        return this.trapAgentAddr;
    }

    public void setTrapAgentAddr(byte[] trapAgentAddr) {
        this.trapAgentAddr = trapAgentAddr;
    }

    public String getGenericTrap() {
        return Integer.toString(this.trapGeneric);
    }

    public int getTrapGeneric() {
        return this.trapGeneric;
    }

    public void setTrapGeneric(int trapGeneric) {
        this.trapGeneric = trapGeneric;
    }

    public String getSpecificTrap() {
        return Integer.toString(this.trapSpecific);
    }

    public int getTrapSpecific() {
        return this.trapSpecific;
    }

    public void setTrapSpecific(int trapSpecific) {
        this.trapSpecific = trapSpecific;
    }

    public int getGenericTrapAsInt() {
        return this.trapGeneric;
    }

    public int getSpecificTrapAsInt() {
        return this.trapSpecific;
    }

    public String getTrapTimeStamp() {
        return Long.toString(this.trapTimeStamp) + "(" + BAbsTime.make((long)this.trapTimeStamp) + ")";
    }

    public long getRawTrapTimeStamp() {
        return this.trapTimeStamp;
    }

    public void setTrapTimeStamp(long trapTimeStamp) {
        this.trapTimeStamp = trapTimeStamp;
    }

    public Object getTag() {
        TagObject tagObj = this.isResponse() ? new TagObject(this.getSourceIp(), this.reqId) : new TagObject(this.getDestinationIp(), this.reqId);
        return tagObj;
    }

    public boolean toOutputStream(OutputStream out) throws Exception {
        byte[] sendData = this.encodeData();
        out.write(sendData);
        return false;
    }

    public void fromInputStream(ASNInput in) {
        this.decodeData(in);
    }

    protected void decodeData(ASNInput in) {
        try {
            if (this.version != 3) {
                this.community = in.getString();
            }
            this.pduType = in.getCommand();
            this.decodeCommandBasedData(in);
            this.decodeVariableBindingList(in);
        }
        catch (ASNException e) {
            e.printStackTrace();
        }
    }

    private void decodeCommandBasedData(ASNInput in) throws ASNException {
        in.readLength();
        if (this.pduType == 164) {
            this.trapEnterprise = in.getObjectID();
            this.trapAgentAddr = in.getIpAddress();
            this.trapGeneric = in.getInt();
            this.trapSpecific = in.getInt();
            this.trapTimeStamp = in.getTimetick();
        } else {
            this.reqId = in.getInt();
            if (this.pduType == 165) {
                this.nonRepeaters = in.getInt();
                if (this.nonRepeaters < 0) {
                    this.nonRepeaters = 0;
                }
                this.maxRepetitions = in.getInt();
            } else {
                this.errStat = in.getInt();
                this.errIndex = in.getInt();
            }
        }
    }

    private void decodeVariableBindingList(ASNInput in) throws ASNException {
        int varLen = in.getSequenceLength();
        int maxPos = varLen + in.getPosition();
        this.vars = new Vector();
        while (maxPos > in.getPosition()) {
            in.getSequenceLength();
            this.vars.addElement(new SnmpVarBind(in));
        }
    }

    protected byte[] encodeData() {
        ASNOutput out = new ASNOutput();
        out.addInt(this.version);
        out.addString(this.community);
        int pduPos = out.getPosition();
        this.insertCommandBasedData(out);
        this.insertEndTags(out, pduPos);
        return out.getBytes();
    }

    public boolean isDiscoveryMode() {
        return false;
    }

    protected void insertCommandBasedData(ASNOutput out) {
        if (this.pduType == 164) {
            out.addObjectId(this.enterprise.toValue());
            out.addIpAddress(this.srcAddr.getAddress());
            out.addInt(this.trapType);
            out.addInt(this.specificType);
            out.addTimeticks(this.upTime);
        } else {
            out.addInt(this.reqId);
            if (this.pduType == 165) {
                out.addInt(this.nonRepeaters);
                out.addInt(this.maxRepetitions);
            } else {
                out.addInt(this.errStat);
                out.addInt(this.errIndex);
            }
        }
        this.insertVariableBindings(out);
    }

    private void insertEndTags(ASNOutput out, int pduPos) {
        out.insertTag(this.pduType, pduPos);
        out.insertTag(48, 0);
    }

    protected void insertVariableBindings(ASNOutput out) {
        boolean hasAtleastOneVariableBinding = false;
        try {
            int varBindListPos = out.getPosition();
            Object[] a = new SnmpVarBind[this.vars.size()];
            this.vars.copyInto(a);
            SnmpVACM vacm = SnmpVACM.getBSnmpVACMinstance();
            for (int i = 0; i < a.length; ++i) {
                boolean access;
                if (this.version == 3 && (this.pduType == 167 || this.pduType == 169) && !(access = vacm.isAccessAllowed(this, ((SnmpVarBind)a[i]).getObjectID(), false))) continue;
                int varBindPos = out.getPosition();
                if (a[i] == null || ((SnmpVarBind)a[i]).getObjectID() == null || ((SnmpVarBind)a[i]).getVariable() == null) continue;
                out.addObjectId(((SnmpVarBind)a[i]).getObjectID().toValue());
                ((SnmpVarBind)a[i]).getVariable().encode(out);
                out.insertTag(48, varBindPos);
            }
            out.insertTag(48, varBindListPos);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("version: ").append(this.version);
        sb.append("\ncommunity: ").append(this.community);
        sb.append("\npdu type: ").append(SnmpPDU.translatePduType(this.pduType));
        if (this.pduType == 164) {
            sb.append("\nenterprise: ").append(this.enterprise);
            sb.append("\nsrcAddr: ").append(this.srcAddr);
            sb.append("\ntrapType: ").append(this.trapType);
            sb.append("\nspecificType: ").append(this.specificType);
            sb.append("\nupTime: ").append(this.upTime);
        } else {
            sb.append("\nreqId: ").append(this.reqId);
            if (this.pduType == 165) {
                sb.append("\nnonRepeaters: ").append(this.nonRepeaters);
                sb.append("\nmaxRepetitions: ").append(this.maxRepetitions);
            } else if (this.errStat != 0) {
                sb.append("\nerrStat: ").append(SnmpPDU.translateErrorStatus(this.errStat));
                sb.append("\nerrIndex: ").append(this.errIndex);
            }
        }
        sb.append("\nvariables:\n");
        this.scanVarBinds(sb);
        return sb.toString();
    }

    public String printVarBinds() {
        StringBuilder sb = new StringBuilder();
        this.scanVarBinds(sb);
        return sb.toString();
    }

    public SnmpVarBind[] getVaribleBindingArray() {
        Object[] vbs = new SnmpVarBind[this.vars.size()];
        this.vars.copyInto(vbs);
        return vbs;
    }

    public boolean isResponse() {
        return this.pduType == 162 || this.pduType == 168;
    }

    private void scanVarBinds(StringBuilder sb) {
        if (this.vars != null) {
            for (int i = 0; i < this.vars.size(); ++i) {
                if (this.vars.elementAt(i) == null) continue;
                sb.append(this.vars.elementAt(i)).append("\n");
            }
        }
    }

    public static String translatePduType(int typ) {
        switch (typ) {
            case 160: {
                return "GET_REQUEST";
            }
            case 161: {
                return "GET_NEXT_REQUEST";
            }
            case 162: {
                return "GET_RESPONSE";
            }
            case 163: {
                return "SET_REQUEST";
            }
            case 164: {
                return "TRAP_V1";
            }
            case 165: {
                return "GET_BULK_REQUEST";
            }
            case 166: {
                return "INFORM_REQUEST";
            }
            case 167: {
                return "TRAP_V2";
            }
            case 168: {
                return "REPORT";
            }
        }
        return "Unknown 0x" + Integer.toString(typ & 0xFF, 16);
    }

    public String toTraceString() {
        String pduData = "\n ReqID ==> " + this.reqId + "\n Var Bind ==> " + this.getVariableBindings();
        pduData = pduData + "\n pduType ==> " + this.getCommand();
        pduData = pduData + "\n isResponse ==> " + this.isResponse();
        pduData = pduData + "\n source IP ==> " + this.getSourceIp();
        pduData = pduData + "\n destination IP ==> " + this.getDestinationIp();
        pduData = pduData + "\n Remote Port ==> " + this.getRemotePort();
        pduData = pduData + "\n Remote Port ==> ";
        return pduData;
    }

    public static String translateErrorStatus(int errStat) {
        switch (errStat) {
            case 0: {
                return "no error";
            }
            case 1: {
                return "too big";
            }
            case 2: {
                return "no such name";
            }
            case 3: {
                return "bad value";
            }
            case 4: {
                return "readonly";
            }
            case 5: {
                return "general error";
            }
            case 6: {
                return "no access";
            }
            case 7: {
                return "wrong type";
            }
            case 8: {
                return "wrong length";
            }
            case 9: {
                return "wrong encoding";
            }
            case 10: {
                return "wrong value";
            }
            case 11: {
                return "no creation";
            }
            case 12: {
                return "inconsistent value";
            }
            case 13: {
                return "resource unavailable";
            }
            case 14: {
                return "commit failed";
            }
            case 15: {
                return "undo failed";
            }
            case 16: {
                return "authorization error";
            }
            case 17: {
                return "not writable";
            }
            case 18: {
                return "inconsistent name";
            }
            case 128: {
                return "no such object";
            }
            case 129: {
                return "no such instance";
            }
            case 130: {
                return "end of mib view";
            }
        }
        return "unknown";
    }

    private static class TagObject {
        private InetAddress address;
        private int reqId;

        public TagObject(InetAddress address, int reqId) {
            this.address = address;
            this.reqId = reqId;
        }

        public boolean equals(Object obj) {
            return this.address.equals(((TagObject)obj).address) && this.reqId == ((TagObject)obj).reqId;
        }

        public int hashCode() {
            return this.address.hashCode() + this.reqId;
        }

        public String toString() {
            return "IPAddress ==> " + this.address.toString() + ", ReqId ==> " + this.reqId;
        }
    }
}

