/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp;

import com.tridium.nSnmp.BSnmpAgent;
import com.tridium.nSnmp.BSnmpDevice;
import com.tridium.nSnmp.BSnmpDeviceFolder;
import com.tridium.nSnmp.comm.BSnmpUdpCommConfig;
import com.tridium.nSnmp.comm.SnmpListener;
import com.tridium.nSnmp.datatypes.BNetworkManagerList;
import com.tridium.nSnmp.messages.GenericTrap;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.messages.SnmpV3AlarmTrap;
import com.tridium.nSnmp.mib.TridiumMib;
import com.tridium.nSnmp.mib.table.AlarmTable;
import com.tridium.nSnmp.mib.table.PointContainer;
import com.tridium.nSnmp.mib.table.PointEntry;
import com.tridium.nSnmp.mib.table.PointTable;
import com.tridium.nSnmp.util.SnmpUtil;
import com.tridium.ndriver.BNNetwork;
import com.tridium.ndriver.comm.NComm;
import com.tridium.ndriver.comm.NCommTimeoutException;
import com.tridium.ndriver.comm.NMessage;
import com.tridium.ndriver.datatypes.BAddress;
import com.tridium.ndriver.datatypes.BIpAddress;
import com.tridium.ndriver.poll.BNPollScheduler;
import com.tridium.nre.firewall.IpProtocol;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.driver.BDevice;
import javax.baja.firewall.BServerPort;
import javax.baja.license.Feature;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.dashboard.BISecurityDashboardProviderAgent;
import javax.baja.security.dashboard.LexiconFormatInfo;
import javax.baja.security.dashboard.SecurityDashboardItem;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIService;
import javax.baja.sys.BValue;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.units.BDimension;
import javax.baja.units.BUnit;
import javax.baja.util.Lexicon;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="pollScheduler", type="BNPollScheduler", defaultValue="new BNPollScheduler()"), @NiagaraProperty(name="enterprise", type="String", defaultValue="TridiumMib.TRIDIUM", flags=1), @NiagaraProperty(name="contact", type="String", defaultValue="lex.getText(\"network.strings.contact\")"), @NiagaraProperty(name="systemName", type="String", defaultValue="lex.getText(\"network.strings.name\")"), @NiagaraProperty(name="location", type="String", defaultValue="lex.getText(\"network.strings.location\")"), @NiagaraProperty(name="snmpReceiveRequests", type="boolean", defaultValue="false", facets={@Facet(value="BFacets.makeBoolean(lex.getText(\"network.enableReceive\"), lex.getText(\"network.disableReceive\"))")}), @NiagaraProperty(name="receiveConfig", type="BSnmpUdpCommConfig", defaultValue="new BSnmpUdpCommConfig(initSnmpPort(\"req\"))"), @NiagaraProperty(name="sendConfig", type="BSnmpUdpCommConfig", defaultValue="new BSnmpUdpCommConfig(initSnmpPort(\"send\"))"), @NiagaraProperty(name="ignoreRequestsFromUnrecognizedSources", type="boolean", defaultValue="false"), @NiagaraProperty(name="recognizedSources", type="BNetworkManagerList", defaultValue=" new BNetworkManagerList()"), @NiagaraProperty(name="checkCommunityOnRequests", type="boolean", defaultValue="true"), @NiagaraProperty(name="readOnlyCommunity", type="String", defaultValue="public"), @NiagaraProperty(name="readWriteCommunity", type="String", defaultValue="public"), @NiagaraProperty(name="snmpReceiveTraps", type="boolean", defaultValue="false"), @NiagaraProperty(name="trapConfig", type="BSnmpUdpCommConfig", defaultValue="new BSnmpUdpCommConfig(initSnmpPort(\"traps\"))"), @NiagaraProperty(name="defaultNetworkManagerIpAddress", type="String", defaultValue=""), @NiagaraProperty(name="defaultNetworkManagerTrapsPort", type="int", defaultValue="SnmpConst.DEFAULT_SNMP_TRAP_PORT", facets={@Facet(value="BFacets.makeInt(null, 0, 65535)")}), @NiagaraProperty(name="defaultNetworkManagerSnmpVersion", type="int", defaultValue="1", facets={@Facet(value="BFacets.makeInt(null, 1, 3)")}), @NiagaraProperty(name="defaultNetworkManagerTrapsCommunity", type="String", defaultValue="public"), @NiagaraProperty(name="snmpAlarmTableCapacity", type="int", defaultValue="500", facets={@Facet(value="BFacets.makeInt(BUnit.make(\"records\", BDimension.DEFAULT), 0, 250000)")}), @NiagaraProperty(name="localDevice", type="BSnmpAgent", defaultValue="new BSnmpAgent()")})
public class BSnmpNetwork
extends BNNetwork
implements BIService,
PointContainer,
BISecurityDashboardProviderAgent {
    public static final Lexicon lex = Lexicon.make((String)"nSnmp");
    @Generated
    public static final Property pollScheduler = BSnmpNetwork.newProperty((int)0, (BValue)new BNPollScheduler(), null);
    @Generated
    public static final Property enterprise = BSnmpNetwork.newProperty((int)1, (String)"1.3.6.1.4.1.4131", null);
    @Generated
    public static final Property contact = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.contact"), null);
    @Generated
    public static final Property systemName = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.name"), null);
    @Generated
    public static final Property location = BSnmpNetwork.newProperty((int)0, (String)lex.getText("network.strings.location"), null);
    @Generated
    public static final Property snmpReceiveRequests = BSnmpNetwork.newProperty((int)0, (boolean)false, (BFacets)BFacets.makeBoolean((String)lex.getText("network.enableReceive"), (String)lex.getText("network.disableReceive")));
    @Generated
    public static final Property receiveConfig = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpUdpCommConfig(BSnmpNetwork.initSnmpPort("req")), null);
    @Generated
    public static final Property sendConfig = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpUdpCommConfig(BSnmpNetwork.initSnmpPort("send")), null);
    @Generated
    public static final Property ignoreRequestsFromUnrecognizedSources = BSnmpNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property recognizedSources = BSnmpNetwork.newProperty((int)0, (BValue)new BNetworkManagerList(), null);
    @Generated
    public static final Property checkCommunityOnRequests = BSnmpNetwork.newProperty((int)0, (boolean)true, null);
    @Generated
    public static final Property readOnlyCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    @Generated
    public static final Property readWriteCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    @Generated
    public static final Property snmpReceiveTraps = BSnmpNetwork.newProperty((int)0, (boolean)false, null);
    @Generated
    public static final Property trapConfig = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpUdpCommConfig(BSnmpNetwork.initSnmpPort("traps")), null);
    @Generated
    public static final Property defaultNetworkManagerIpAddress = BSnmpNetwork.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property defaultNetworkManagerTrapsPort = BSnmpNetwork.newProperty((int)0, (int)162, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Property defaultNetworkManagerSnmpVersion = BSnmpNetwork.newProperty((int)0, (int)1, (BFacets)BFacets.makeInt(null, (int)1, (int)3));
    @Generated
    public static final Property defaultNetworkManagerTrapsCommunity = BSnmpNetwork.newProperty((int)0, (String)"public", null);
    @Generated
    public static final Property snmpAlarmTableCapacity = BSnmpNetwork.newProperty((int)0, (int)500, (BFacets)BFacets.makeInt((BUnit)BUnit.make((String)"records", (BDimension)BDimension.DEFAULT), (int)0, (int)250000));
    @Generated
    public static final Property localDevice = BSnmpNetwork.newProperty((int)0, (BValue)new BSnmpAgent(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpNetwork.class);
    private AlarmTable alarms;
    private PointTable inputs;
    private PointTable outputs;
    private PointTable objects;
    private Object reqIdSync = new Object();
    private long startupTime = 0L;
    private static TridiumMib mib = null;
    private int reqId = 0;
    public static final String PUBLIC_COMMUNITY = "public";

    @Generated
    public BNPollScheduler getPollScheduler() {
        return (BNPollScheduler)this.get(pollScheduler);
    }

    @Generated
    public void setPollScheduler(BNPollScheduler v) {
        this.set(pollScheduler, (BValue)v, null);
    }

    @Generated
    public String getEnterprise() {
        return this.getString(enterprise);
    }

    @Generated
    public void setEnterprise(String v) {
        this.setString(enterprise, v, null);
    }

    @Generated
    public String getContact() {
        return this.getString(contact);
    }

    @Generated
    public void setContact(String v) {
        this.setString(contact, v, null);
    }

    @Generated
    public String getSystemName() {
        return this.getString(systemName);
    }

    @Generated
    public void setSystemName(String v) {
        this.setString(systemName, v, null);
    }

    @Generated
    public String getLocation() {
        return this.getString(location);
    }

    @Generated
    public void setLocation(String v) {
        this.setString(location, v, null);
    }

    @Generated
    public boolean getSnmpReceiveRequests() {
        return this.getBoolean(snmpReceiveRequests);
    }

    @Generated
    public void setSnmpReceiveRequests(boolean v) {
        this.setBoolean(snmpReceiveRequests, v, null);
    }

    @Generated
    public BSnmpUdpCommConfig getReceiveConfig() {
        return (BSnmpUdpCommConfig)this.get(receiveConfig);
    }

    @Generated
    public void setReceiveConfig(BSnmpUdpCommConfig v) {
        this.set(receiveConfig, (BValue)v, null);
    }

    @Generated
    public BSnmpUdpCommConfig getSendConfig() {
        return (BSnmpUdpCommConfig)this.get(sendConfig);
    }

    @Generated
    public void setSendConfig(BSnmpUdpCommConfig v) {
        this.set(sendConfig, (BValue)v, null);
    }

    @Generated
    public boolean getIgnoreRequestsFromUnrecognizedSources() {
        return this.getBoolean(ignoreRequestsFromUnrecognizedSources);
    }

    @Generated
    public void setIgnoreRequestsFromUnrecognizedSources(boolean v) {
        this.setBoolean(ignoreRequestsFromUnrecognizedSources, v, null);
    }

    @Generated
    public BNetworkManagerList getRecognizedSources() {
        return (BNetworkManagerList)this.get(recognizedSources);
    }

    @Generated
    public void setRecognizedSources(BNetworkManagerList v) {
        this.set(recognizedSources, (BValue)v, null);
    }

    @Generated
    public boolean getCheckCommunityOnRequests() {
        return this.getBoolean(checkCommunityOnRequests);
    }

    @Generated
    public void setCheckCommunityOnRequests(boolean v) {
        this.setBoolean(checkCommunityOnRequests, v, null);
    }

    @Generated
    public String getReadOnlyCommunity() {
        return this.getString(readOnlyCommunity);
    }

    @Generated
    public void setReadOnlyCommunity(String v) {
        this.setString(readOnlyCommunity, v, null);
    }

    @Generated
    public String getReadWriteCommunity() {
        return this.getString(readWriteCommunity);
    }

    @Generated
    public void setReadWriteCommunity(String v) {
        this.setString(readWriteCommunity, v, null);
    }

    @Generated
    public boolean getSnmpReceiveTraps() {
        return this.getBoolean(snmpReceiveTraps);
    }

    @Generated
    public void setSnmpReceiveTraps(boolean v) {
        this.setBoolean(snmpReceiveTraps, v, null);
    }

    @Generated
    public BSnmpUdpCommConfig getTrapConfig() {
        return (BSnmpUdpCommConfig)this.get(trapConfig);
    }

    @Generated
    public void setTrapConfig(BSnmpUdpCommConfig v) {
        this.set(trapConfig, (BValue)v, null);
    }

    @Generated
    public String getDefaultNetworkManagerIpAddress() {
        return this.getString(defaultNetworkManagerIpAddress);
    }

    @Generated
    public void setDefaultNetworkManagerIpAddress(String v) {
        this.setString(defaultNetworkManagerIpAddress, v, null);
    }

    @Generated
    public int getDefaultNetworkManagerTrapsPort() {
        return this.getInt(defaultNetworkManagerTrapsPort);
    }

    @Generated
    public void setDefaultNetworkManagerTrapsPort(int v) {
        this.setInt(defaultNetworkManagerTrapsPort, v, null);
    }

    @Generated
    public int getDefaultNetworkManagerSnmpVersion() {
        return this.getInt(defaultNetworkManagerSnmpVersion);
    }

    @Generated
    public void setDefaultNetworkManagerSnmpVersion(int v) {
        this.setInt(defaultNetworkManagerSnmpVersion, v, null);
    }

    @Generated
    public String getDefaultNetworkManagerTrapsCommunity() {
        return this.getString(defaultNetworkManagerTrapsCommunity);
    }

    @Generated
    public void setDefaultNetworkManagerTrapsCommunity(String v) {
        this.setString(defaultNetworkManagerTrapsCommunity, v, null);
    }

    @Generated
    public int getSnmpAlarmTableCapacity() {
        return this.getInt(snmpAlarmTableCapacity);
    }

    @Generated
    public void setSnmpAlarmTableCapacity(int v) {
        this.setInt(snmpAlarmTableCapacity, v, null);
    }

    @Generated
    public BSnmpAgent getLocalDevice() {
        return (BSnmpAgent)this.get(localDevice);
    }

    @Generated
    public void setLocalDevice(BSnmpAgent v) {
        this.set(localDevice, (BValue)v, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getReceiveConfig().setAddress(new BIpAddress("local", this.getReceiveConfig().getReceivePort().getBindingPort()));
        this.getReceiveConfig().setDefaultListener(new SnmpListener(this));
        this.getTrapConfig().setAddress(new BIpAddress("local", this.getTrapConfig().getReceivePort().getBindingPort()));
        this.getTrapConfig().setDefaultListener(new SnmpListener(this));
        if (this.getSnmpReceiveRequests()) {
            this.resUcomm();
        } else {
            this.getReceiveConfig().comm().stop();
        }
        if (this.getSnmpReceiveTraps()) {
            this.trapUcomm();
        } else {
            this.getTrapConfig().comm().stop();
        }
        BComponent[] networks = Sys.getServices((Type)TYPE);
        if (networks.length > 1) {
            for (int i = 0; i < networks.length; ++i) {
                ((BSnmpNetwork)networks[i]).configFatal("Only one SNMP Network is allowed per station. Remove duplicate SNMP network(s) and restart station.");
            }
        }
        if (!(this.isDisabled() || this.isDown() || this.isFatalFault())) {
            if (this.log().isLoggable(Level.FINE)) {
                this.log().log(Level.FINE, this + " *** Starting SNMP communication ***");
            }
            this.inputs.start();
            this.outputs.start();
            this.objects.start();
        }
    }

    public boolean useAutoManager() {
        return false;
    }

    public void serviceStarted() throws Exception {
        this.alarms = new AlarmTable(this);
        this.inputs = new PointTable();
        this.outputs = new PointTable();
        this.objects = new PointTable();
    }

    public void checkAdd(String name, BValue value, int flags, BFacets facets, Context context) {
        if (value instanceof BSnmpAgent) {
            throw new LocalizableRuntimeException("snmp", "addLocalDeviceError");
        }
    }

    public BINavNode[] getNavChildren() {
        BINavNode[] kids = super.getNavChildren();
        Array acc = new Array(BINavNode.class);
        acc.add((Object)this.getLocalDevice());
        for (int i = 0; i < kids.length; ++i) {
            acc.add((Object)kids[i]);
        }
        return (BINavNode[])acc.trim();
    }

    public void postRequest(Runnable req) {
        this.getAsync().post(req);
    }

    public String getNetworkName() {
        return "snmp";
    }

    public Type getDeviceFolderType() {
        return BSnmpDeviceFolder.TYPE;
    }

    public Type getDeviceType() {
        return BSnmpDevice.TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "snmp");
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (!this.isRunning()) {
            return;
        }
        if (p == status) {
            this.getReceiveConfig().statusUpdate();
            this.getTrapConfig().statusUpdate();
        }
        if (p == snmpReceiveRequests) {
            if (this.getSnmpReceiveRequests()) {
                try {
                    this.getReceiveConfig().comm().start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.getReceiveConfig().comm().stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (p == snmpReceiveTraps) {
            if (this.getSnmpReceiveTraps()) {
                try {
                    this.getTrapConfig().comm().start();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    this.getTrapConfig().comm().stop();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        if (p == snmpAlarmTableCapacity) {
            this.alarms.setCapacity(this.getSnmpAlarmTableCapacity());
        }
    }

    public BSnmpDevice findDevice(InetAddress address) {
        if (address == null) {
            return null;
        }
        BDevice[] devices = this.getDevices();
        if (devices == null) {
            return null;
        }
        for (int i = 0; i < devices.length; ++i) {
            InetAddress devAddr;
            if (devices[i] == null || !(devices[i] instanceof BSnmpDevice) || (devAddr = ((BSnmpDevice)devices[i]).getInetAddress()) == null || !devAddr.equals(address)) continue;
            return (BSnmpDevice)devices[i];
        }
        return null;
    }

    public AlarmTable alarms() {
        return this.alarms;
    }

    public PointTable inputs() {
        return this.inputs;
    }

    public PointTable outputs() {
        return this.outputs;
    }

    public PointTable objects() {
        return this.objects;
    }

    public synchronized TridiumMib getMib() {
        if (mib == null) {
            mib = new TridiumMib(this);
        }
        return mib;
    }

    public synchronized void mibChanged() {
        mib = null;
    }

    @Override
    public PointTable getTable(boolean input) {
        return input ? this.inputs() : this.outputs();
    }

    @Override
    public String getObjectIdentifier() {
        return "1.3.6.1.4.1.4131.1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNextReqid(InetAddress reqGenDeviceAddr) {
        Object object = this.reqIdSync;
        synchronized (object) {
            return this.reqId++;
        }
    }

    public InetAddress getManagerIp() {
        try {
            return InetAddress.getByName(this.getDefaultNetworkManagerIpAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean isCommActive() {
        return this.getSendConfig().comm() != null;
    }

    @Override
    public void registerIoObject(PointEntry ioObj) {
        if (ioObj.isSettablePoint()) {
            this.inputs.registerIoObject(ioObj);
        } else {
            this.outputs.registerIoObject(ioObj);
        }
    }

    @Override
    public void unregisterIoObject(PointEntry ioObj) {
        if (ioObj.isSettablePoint()) {
            this.inputs.unregisterIoObject(ioObj);
        } else {
            this.outputs.unregisterIoObject(ioObj);
        }
    }

    public long getTimeTick() {
        long elapsedTime = (Clock.ticks() - this.startupTime) / 10L;
        if (elapsedTime < 0L) {
            elapsedTime = Clock.ticks();
        }
        while (elapsedTime > 0xFFFFFFFFL) {
            elapsedTime -= 0xFFFFFFFFL;
        }
        return elapsedTime;
    }

    private NComm reqUcomm() {
        return (NComm)this.getSendConfig().comm();
    }

    private NComm resUcomm() {
        return (NComm)this.getReceiveConfig().comm();
    }

    private NComm trapUcomm() {
        return (NComm)this.getTrapConfig().comm();
    }

    public NMessage sendSyncMessage(SnmpPDU requestMessage) throws Exception {
        requestMessage.setAddress((BAddress)new BIpAddress(requestMessage.getDestinationIp(), requestMessage.getRemotePort()));
        SnmpPDU respMessage = null;
        try {
            respMessage = (SnmpPDU)this.reqUcomm().sendRequest((NMessage)requestMessage);
            respMessage.setSourceIp(requestMessage.getDestinationIp());
        }
        catch (NCommTimeoutException e) {
            if (this.getSnmpLog().isLoggable(Level.FINE)) {
                this.getSnmpLog().log(Level.SEVERE, "Exception occurred in sendSyncMessage", e);
            }
            this.getSnmpLog().severe("Exception occurred in sendSyncMessage (Timed out waiting for response)");
        }
        return respMessage;
    }

    public void sendAsyncMessage(SnmpPDU requestMessage) throws Exception {
        requestMessage.setAddress((BAddress)new BIpAddress(requestMessage.getDestinationIp(), requestMessage.getRemotePort()));
        this.reqUcomm().sendMessage((NMessage)requestMessage);
    }

    public void sendAsyncResponseMessage(SnmpPDU responseMessage) throws Exception {
        responseMessage.setAddress((BAddress)new BIpAddress(responseMessage.getDestinationIp(), responseMessage.getRemotePort()));
        this.resUcomm().sendMessage((NMessage)responseMessage);
    }

    public void sendTraps(SnmpPDU trapMessage) {
        try {
            if (this.getSnmpReceiveRequests()) {
                trapMessage.setAddress((BAddress)new BIpAddress(trapMessage.getDestinationIp(), trapMessage.getRemotePort()));
                this.reqUcomm().sendMessage((NMessage)trapMessage);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void atSteadyState() {
        this.startupTime = Clock.ticks();
        if (this.isCommActive() && this.getDefaultNetworkManagerIpAddress().length() > 0) {
            if (this.getDefaultNetworkManagerSnmpVersion() != 3) {
                GenericTrap.sendColdStart(this);
            } else {
                SnmpV3AlarmTrap.sendColdStart(this);
            }
        }
    }

    public void spy(SpyWriter out) throws Exception {
        super.spy(out);
        if (!this.isRunning()) {
            return;
        }
        out.startProps();
        out.trTitle((Object)("Snmp Alarm Table " + this.getEnterprise() + ".1.3"), 2);
        out.endProps();
        this.alarms.spy(out);
        out.startProps();
        out.trTitle((Object)("Snmp Input Table" + this.getEnterprise() + ".1.4"), 2);
        out.endProps();
        this.inputs.spy(out);
        out.startProps();
        out.trTitle((Object)("Snmp Output Table" + this.getEnterprise() + ".1.5"), 2);
        out.endProps();
        this.outputs.spy(out);
        PointContainer[] pcs = (PointContainer[])SnmpUtil.getDecendantsByClass((BComponent)this, PointContainer.class);
        for (int i = 0; i < pcs.length; ++i) {
            this.spyExport(out, pcs[i]);
        }
        if (this.objects.getArray().length > 0) {
            out.startProps();
            out.trTitle((Object)"Snmp Objects 1.3.6.1.4.1.4131.1.7", 2);
            out.endProps();
            this.objects.spy(out);
        }
        out.startProps();
        out.trTitle((Object)"Current Mib representation for this station", 4);
        out.endProps();
        this.getMib().spy(out);
    }

    public void spyExport(SpyWriter out, PointContainer pc) throws Exception {
        String name = ((BComponent)pc).getName();
        out.startProps();
        out.trTitle((Object)(name + " Input Table " + pc.getObjectIdentifier() + ".1"), 2);
        out.endProps();
        pc.getTable(true).spy(out);
        out.startProps();
        out.trTitle((Object)(name + " Output Table" + pc.getObjectIdentifier() + ".2"), 2);
        out.endProps();
        pc.getTable(false).spy(out);
    }

    public int getSecurityDashboardItemsVersion() {
        return 1;
    }

    public List<SecurityDashboardItem> getSecurityDashboardItems(Context cx) {
        ArrayList<SecurityDashboardItem> items = new ArrayList<SecurityDashboardItem>();
        if (this.getReadOnlyCommunity().equals(PUBLIC_COMMUNITY)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.readCommunity.default.title"), (String)"securityDashboard.readCommunity.default.description"));
        }
        if (this.getReadWriteCommunity().equals(PUBLIC_COMMUNITY)) {
            items.add(SecurityDashboardItem.makeWarning((Type)TYPE, (LexiconFormatInfo)LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.readWriteCommunity.default.title"), (String)"securityDashboard.readWriteCommunity.default.description"));
        }
        return items;
    }

    public LexiconFormatInfo getSecurityDashboardSectionHeader(Context cx) {
        return LexiconFormatInfo.make((Type)TYPE, (String)"securityDashboard.sectionHeader");
    }

    public BOrd getSecurityDashboardSectionHyperlinkOrd() {
        return this.getNavOrd().relativizeToSession();
    }

    private static BServerPort initSnmpPort(String type) {
        BServerPort port;
        switch (type) {
            case "req": {
                port = new BServerPort(161, IpProtocol.UDP);
                break;
            }
            case "traps": {
                port = new BServerPort(162, IpProtocol.UDP);
                break;
            }
            default: {
                port = new BServerPort(0, IpProtocol.UDP);
            }
        }
        Property slot = port.getProperty("publicServerPort");
        port.setFacets((Slot)slot, BFacets.makeInt(null, (int)0, (int)65535, (int)10));
        slot = port.getProperty("localServerPort");
        port.setFacets((Slot)slot, BFacets.makeInt(null, (int)0, (int)65535, (int)10));
        return port;
    }

    public Logger getSnmpLog() {
        return this.log();
    }
}

