/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.nSnmp;

import com.tridium.nSnmp.BSnmpNetwork;
import com.tridium.nSnmp.IAccessNetwork;
import com.tridium.nSnmp.alarm.BSnmpAlarmDeviceExt;
import com.tridium.nSnmp.datatypes.BMibListTable;
import com.tridium.nSnmp.messages.SnmpPDU;
import com.tridium.nSnmp.point.BSnmpPointDeviceExt;
import com.tridium.nSnmp.point.BSnmpProxyExt;
import com.tridium.nSnmp.point.agent.BSnmpAgentPointDeviceExt;
import com.tridium.nSnmp.snmptypes.SnmpNull;
import com.tridium.nSnmp.snmptypes.SnmpOID;
import com.tridium.nSnmp.snmptypes.SnmpVar;
import com.tridium.nSnmp.snmptypes.SnmpVarBind;
import com.tridium.nSnmp.table.BSnmpTable;
import com.tridium.nSnmp.util.BSnmpWalkMibJob;
import com.tridium.nSnmp.version3.SnmpV3Communicator;
import com.tridium.nSnmp.version3.dto.SnmpV3Message;
import com.tridium.nSnmp.version3.securityModel.usm.BUsmSecurityLevel;
import com.tridium.nSnmp.version3.securityModel.usm.authentication.BUsmAuthenticationProtocol;
import com.tridium.nSnmp.version3.securityModel.usm.privacy.UsmPrivacyProtocol;
import com.tridium.ndriver.BNDevice;
import com.tridium.ndriver.poll.BINPollable;
import com.tridium.ndriver.util.SfUtil;
import com.tridium.util.ArrayUtil;
import java.net.InetAddress;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import javax.baja.control.BControlPoint;
import javax.baja.data.BIDataValue;
import javax.baja.driver.BDevice;
import javax.baja.driver.util.BIPollable;
import javax.baja.driver.util.BPollFrequency;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.Facet;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraAction;
import javax.baja.nre.annotations.NiagaraProperties;
import javax.baja.nre.annotations.NiagaraProperty;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.nre.util.Array;
import javax.baja.security.BPassword;
import javax.baja.status.BStatus;
import javax.baja.sys.Action;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;
import javax.baja.util.Invocation;

@NiagaraType
@NiagaraProperties(value={@NiagaraProperty(name="status", type="BStatus", defaultValue="BStatus.ok", flags=75, facets={@Facet(value="SfUtil.incl(SfUtil.MGR_EDIT_READONLY)")}, override=true), @NiagaraProperty(name="pollFrequency", type="BPollFrequency", defaultValue="BPollFrequency.normal"), @NiagaraProperty(name="points", type="BSnmpPointDeviceExt", defaultValue="new BSnmpPointDeviceExt()"), @NiagaraProperty(name="traps", type="BSnmpAlarmDeviceExt", defaultValue="new BSnmpAlarmDeviceExt()"), @NiagaraProperty(name="snmpVersion", type="int", defaultValue="2", facets={@Facet(value="BFacets.makeInt(null, 1, 3)")}), @NiagaraProperty(name="retryCount", type="int", defaultValue="2"), @NiagaraProperty(name="responseTimeout", type="BRelTime", defaultValue="BRelTime.make(2000)", facets={@Facet(value="BFacets.make(BFacets.SHOW_MILLISECONDS, BBoolean.make(true))")}), @NiagaraProperty(name="maxVariableBindingsPerRequest", type="int", defaultValue="10", facets={@Facet(value="BFacets.makeInt(null, 0, Integer.MAX_VALUE)")}), @NiagaraProperty(name="ipAddress", type="String", defaultValue=""), @NiagaraProperty(name="port", type="int", defaultValue="SnmpConst.DEFAULT_SNMP_PORT", facets={@Facet(value="BFacets.makeInt(null, 0, 65535)")}), @NiagaraProperty(name="community", type="String", defaultValue="public"), @NiagaraProperty(name="mib", type="String", defaultValue=""), @NiagaraProperty(name="userName", type="String", defaultValue="", flags=4), @NiagaraProperty(name="securityLevel", type="BUsmSecurityLevel", defaultValue="BUsmSecurityLevel.noAuthNoPriv", flags=4), @NiagaraProperty(name="authenticationProtocol", type="BUsmAuthenticationProtocol", defaultValue="BUsmAuthenticationProtocol.sha", flags=4), @NiagaraProperty(name="authenticationPassphrase", type="BPassword", defaultValue="BPassword.DEFAULT", flags=4), @NiagaraProperty(name="privacyProtocol", type="UsmPrivacyProtocol", defaultValue="UsmPrivacyProtocol.aes128", flags=4), @NiagaraProperty(name="privacyPassphrase", type="BPassword", defaultValue="BPassword.DEFAULT", flags=4), @NiagaraProperty(name="contextName", type="String", defaultValue="", flags=4), @NiagaraProperty(name="engineID", type="String", defaultValue="", flags=5)})
@NiagaraAction(name="walkMib", parameterType="BMibListTable", defaultValue="new BMibListTable()", returnType="BOrd", flags=4)
public class BSnmpDevice
extends BNDevice
implements BINPollable,
IAccessNetwork {
    @Generated
    public static final Property status = BSnmpDevice.newProperty((int)75, (BValue)BStatus.ok, (BFacets)SfUtil.incl((String)"ed.ro"));
    @Generated
    public static final Property pollFrequency = BSnmpDevice.newProperty((int)0, (BValue)BPollFrequency.normal, null);
    @Generated
    public static final Property points = BSnmpDevice.newProperty((int)0, (BValue)new BSnmpPointDeviceExt(), null);
    @Generated
    public static final Property traps = BSnmpDevice.newProperty((int)0, (BValue)new BSnmpAlarmDeviceExt(), null);
    @Generated
    public static final Property snmpVersion = BSnmpDevice.newProperty((int)0, (int)2, (BFacets)BFacets.makeInt(null, (int)1, (int)3));
    @Generated
    public static final Property retryCount = BSnmpDevice.newProperty((int)0, (int)2, null);
    @Generated
    public static final Property responseTimeout = BSnmpDevice.newProperty((int)0, (BValue)BRelTime.make((long)2000L), (BFacets)BFacets.make((String)"showMilliseconds", (BIDataValue)BBoolean.make((boolean)true)));
    @Generated
    public static final Property maxVariableBindingsPerRequest = BSnmpDevice.newProperty((int)0, (int)10, (BFacets)BFacets.makeInt(null, (int)0, (int)Integer.MAX_VALUE));
    @Generated
    public static final Property ipAddress = BSnmpDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property port = BSnmpDevice.newProperty((int)0, (int)161, (BFacets)BFacets.makeInt(null, (int)0, (int)65535));
    @Generated
    public static final Property community = BSnmpDevice.newProperty((int)0, (String)"public", null);
    @Generated
    public static final Property mib = BSnmpDevice.newProperty((int)0, (String)"", null);
    @Generated
    public static final Property userName = BSnmpDevice.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property securityLevel = BSnmpDevice.newProperty((int)4, (BValue)BUsmSecurityLevel.noAuthNoPriv, null);
    @Generated
    public static final Property authenticationProtocol = BSnmpDevice.newProperty((int)4, (BValue)BUsmAuthenticationProtocol.sha, null);
    @Generated
    public static final Property authenticationPassphrase = BSnmpDevice.newProperty((int)4, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property privacyProtocol = BSnmpDevice.newProperty((int)4, (BValue)UsmPrivacyProtocol.aes128, null);
    @Generated
    public static final Property privacyPassphrase = BSnmpDevice.newProperty((int)4, (BValue)BPassword.DEFAULT, null);
    @Generated
    public static final Property contextName = BSnmpDevice.newProperty((int)4, (String)"", null);
    @Generated
    public static final Property engineID = BSnmpDevice.newProperty((int)5, (String)"", null);
    @Generated
    public static final Action walkMib = BSnmpDevice.newAction((int)4, (BValue)new BMibListTable(), null);
    @Generated
    public static final Type TYPE = Sys.loadType(BSnmpDevice.class);
    Vector<BSnmpTable> tables = null;
    BSnmpNetwork net = null;
    public static Map<String, User> userTable = new HashMap<String, User>();

    @Generated
    public BPollFrequency getPollFrequency() {
        return (BPollFrequency)this.get(pollFrequency);
    }

    @Generated
    public void setPollFrequency(BPollFrequency v) {
        this.set(pollFrequency, (BValue)v, null);
    }

    @Generated
    public BSnmpPointDeviceExt getPoints() {
        return (BSnmpPointDeviceExt)this.get(points);
    }

    @Generated
    public void setPoints(BSnmpPointDeviceExt v) {
        this.set(points, (BValue)v, null);
    }

    @Generated
    public BSnmpAlarmDeviceExt getTraps() {
        return (BSnmpAlarmDeviceExt)this.get(traps);
    }

    @Generated
    public void setTraps(BSnmpAlarmDeviceExt v) {
        this.set(traps, (BValue)v, null);
    }

    @Generated
    public int getSnmpVersion() {
        return this.getInt(snmpVersion);
    }

    @Generated
    public void setSnmpVersion(int v) {
        this.setInt(snmpVersion, v, null);
    }

    @Generated
    public int getRetryCount() {
        return this.getInt(retryCount);
    }

    @Generated
    public void setRetryCount(int v) {
        this.setInt(retryCount, v, null);
    }

    @Generated
    public BRelTime getResponseTimeout() {
        return (BRelTime)this.get(responseTimeout);
    }

    @Generated
    public void setResponseTimeout(BRelTime v) {
        this.set(responseTimeout, (BValue)v, null);
    }

    @Generated
    public int getMaxVariableBindingsPerRequest() {
        return this.getInt(maxVariableBindingsPerRequest);
    }

    @Generated
    public void setMaxVariableBindingsPerRequest(int v) {
        this.setInt(maxVariableBindingsPerRequest, v, null);
    }

    @Generated
    public String getIpAddress() {
        return this.getString(ipAddress);
    }

    @Generated
    public void setIpAddress(String v) {
        this.setString(ipAddress, v, null);
    }

    @Generated
    public int getPort() {
        return this.getInt(port);
    }

    @Generated
    public void setPort(int v) {
        this.setInt(port, v, null);
    }

    @Generated
    public String getCommunity() {
        return this.getString(community);
    }

    @Generated
    public void setCommunity(String v) {
        this.setString(community, v, null);
    }

    @Generated
    public String getMib() {
        return this.getString(mib);
    }

    @Generated
    public void setMib(String v) {
        this.setString(mib, v, null);
    }

    @Generated
    public String getUserName() {
        return this.getString(userName);
    }

    @Generated
    public void setUserName(String v) {
        this.setString(userName, v, null);
    }

    @Generated
    public BUsmSecurityLevel getSecurityLevel() {
        return (BUsmSecurityLevel)this.get(securityLevel);
    }

    @Generated
    public void setSecurityLevel(BUsmSecurityLevel v) {
        this.set(securityLevel, (BValue)v, null);
    }

    @Generated
    public BUsmAuthenticationProtocol getAuthenticationProtocol() {
        return (BUsmAuthenticationProtocol)this.get(authenticationProtocol);
    }

    @Generated
    public void setAuthenticationProtocol(BUsmAuthenticationProtocol v) {
        this.set(authenticationProtocol, (BValue)v, null);
    }

    @Generated
    public BPassword getAuthenticationPassphrase() {
        return (BPassword)this.get(authenticationPassphrase);
    }

    @Generated
    public void setAuthenticationPassphrase(BPassword v) {
        this.set(authenticationPassphrase, (BValue)v, null);
    }

    @Generated
    public UsmPrivacyProtocol getPrivacyProtocol() {
        return (UsmPrivacyProtocol)this.get(privacyProtocol);
    }

    @Generated
    public void setPrivacyProtocol(UsmPrivacyProtocol v) {
        this.set(privacyProtocol, (BValue)v, null);
    }

    @Generated
    public BPassword getPrivacyPassphrase() {
        return (BPassword)this.get(privacyPassphrase);
    }

    @Generated
    public void setPrivacyPassphrase(BPassword v) {
        this.set(privacyPassphrase, (BValue)v, null);
    }

    @Generated
    public String getContextName() {
        return this.getString(contextName);
    }

    @Generated
    public void setContextName(String v) {
        this.setString(contextName, v, null);
    }

    @Generated
    public String getEngineID() {
        return this.getString(engineID);
    }

    @Generated
    public void setEngineID(String v) {
        this.setString(engineID, v, null);
    }

    @Generated
    public BOrd walkMib(BMibListTable parameter) {
        return (BOrd)this.invoke(walkMib, (BValue)parameter, null);
    }

    @Generated
    public Type getType() {
        return TYPE;
    }

    public Type getNetworkType() {
        return BSnmpNetwork.TYPE;
    }

    public void started() throws Exception {
        super.started();
        this.getSnmpNetwork().getPollScheduler().subscribe((BIPollable)this);
    }

    public void stopped() throws Exception {
        this.getSnmpNetwork().getPollScheduler().unsubscribe((BIPollable)this);
        super.stopped();
    }

    public void changed(Property p, Context cx) {
        super.changed(p, cx);
        if (p == status) {
            this.updateMyStatus();
        }
        if (p == snmpVersion) {
            if (this.getSnmpVersion() > 2) {
                this.setFlags((Slot)userName, 0, cx);
                this.setFlags((Slot)securityLevel, 0, cx);
                this.setFlags((Slot)contextName, 0, cx);
                this.setFlags((Slot)engineID, 1, cx);
            } else {
                this.setFlags((Slot)userName, 4, cx);
                this.setFlags((Slot)securityLevel, 4, cx);
                this.setFlags((Slot)contextName, 4, cx);
                this.setFlags((Slot)engineID, 5, cx);
                this.setFlags((Slot)authenticationProtocol, 4, cx);
                this.setFlags((Slot)authenticationPassphrase, 4, cx);
                this.setFlags((Slot)privacyProtocol, 4, cx);
                this.setFlags((Slot)privacyPassphrase, 4, cx);
            }
        }
        if (p == securityLevel) {
            if (this.getSecurityLevel() == BUsmSecurityLevel.noAuthNoPriv) {
                this.setFlags((Slot)authenticationProtocol, 4, cx);
                this.setFlags((Slot)authenticationPassphrase, 4, cx);
                this.setFlags((Slot)privacyProtocol, 4, cx);
                this.setFlags((Slot)privacyPassphrase, 4, cx);
            }
            if (this.getSecurityLevel() == BUsmSecurityLevel.authNoPriv) {
                this.setFlags((Slot)authenticationProtocol, 0, cx);
                this.setFlags((Slot)authenticationPassphrase, 0, cx);
                this.setFlags((Slot)privacyProtocol, 4, cx);
                this.setFlags((Slot)privacyPassphrase, 4, cx);
                this.setPrivacyPassphrase(BPassword.DEFAULT);
                this.setAuthenticationPassphrase(BPassword.DEFAULT);
            }
            if (this.getSecurityLevel() == BUsmSecurityLevel.authPriv) {
                this.setFlags((Slot)authenticationProtocol, 0, cx);
                this.setFlags((Slot)authenticationPassphrase, 0, cx);
                this.setFlags((Slot)privacyProtocol, 0, cx);
                this.setFlags((Slot)privacyPassphrase, 0, cx);
                this.setPrivacyPassphrase(BPassword.DEFAULT);
                this.setAuthenticationPassphrase(BPassword.DEFAULT);
            }
        }
        super.changed(p, cx);
    }

    private void updateMyStatus() {
        if (this.tables != null) {
            for (int i = 0; i < this.tables.size(); ++i) {
                this.tables.elementAt(i).updateStatus();
            }
        }
    }

    protected IFuture postPing() {
        if (this.snmpNet() != null) {
            this.snmpNet().postRequest((Runnable)new Invocation((BComponent)this, ping, null, null));
        }
        return null;
    }

    private String discoveryEngineId(SnmpV3Message message) {
        message.setMsgID(0);
        message.setReqid(0);
        message.setDiscoveryMode(true);
        message.setUserSecurityName("");
        message.setMsgFlag((byte)0);
        message.setVariableBindings(new Vector<SnmpVarBind>());
        SnmpV3Message returnedMessage = null;
        String engineId = "";
        try {
            returnedMessage = (SnmpV3Message)this.snmpNet().sendSyncMessage(message);
            if (returnedMessage != null) {
                engineId = BSnmpDevice.engineIdDisplay(returnedMessage.getMsgAuthoritativeEngineID());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return engineId;
    }

    public void doPing() {
        if (this.isDisabled() || this.isFault()) {
            return;
        }
        if (this.snmpNet() == null) {
            this.pingFail("No snmp network found");
            return;
        }
        SnmpPDU msg = null;
        if (this.getVersion() != 3) {
            msg = new SnmpPDU(this, 160);
        } else {
            SnmpV3Message discoveryMsg = new SnmpV3Message(this, 160);
            String enginId = this.discoveryEngineId(discoveryMsg);
            this.setEngineID(enginId);
            if (this.getEngineID() != null) {
                userTable.put(this.getEngineID(), new User());
            }
            msg = new SnmpV3Message(this, 160);
        }
        SnmpOID oid = new SnmpOID("1.3.6.1.2.1.1.1.0");
        SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
        msg.addVariableBinding(varBind);
        msg.setResponseTimeOut(this.getResponseTimeout().getSeconds() * 1000);
        msg.setRetryCount(this.getRetryCount());
        SnmpPDU pdu = null;
        try {
            if (this.getVersion() != 3) {
                pdu = (SnmpPDU)this.snmpNet().sendSyncMessage(msg);
            } else {
                SnmpV3Communicator snmpCommunicator = SnmpV3Communicator.getBSnmpV3CommunicatorInstance(this.snmpNet());
                pdu = snmpCommunicator.sendMessage((SnmpV3Message)msg);
                if (pdu != null && pdu.getErrindex() != 0) {
                    pdu = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pingFail(this.getLexicon().getText("pingFail"));
        }
        if (this.snmpNet().getSnmpLog().isLoggable(Level.FINE)) {
            this.snmpNet().getSnmpLog().fine("ping(): SnmpDevice " + this.getName() + "[" + this.getIpAddress() + "] is " + (pdu == null ? "down" : "up"));
        }
        if (pdu != null) {
            this.pingOk();
        } else {
            this.pingFail(this.getLexicon().getText("pingFail"));
        }
    }

    public void doPoll() {
        int i;
        if (!this.isActive() || !Sys.atSteadyState()) {
            return;
        }
        BControlPoint[] points = this.getPoints().getPoints();
        Array a = new Array(BSnmpProxyExt.class);
        for (i = 0; i < points.length; ++i) {
            BSnmpProxyExt pext;
            if (!(points[i].getProxyExt() instanceof BSnmpProxyExt) || !(pext = (BSnmpProxyExt)points[i].getProxyExt()).isCurrentlySubscribed() || pext.isConfigFault()) continue;
            a.add((Object)pext);
        }
        if (a.size() > 0) {
            this.updateInputs((BSnmpProxyExt[])a.trim());
        }
        if (this.tables != null) {
            for (i = 0; i < this.tables.size(); ++i) {
                this.tables.elementAt(i).poll();
            }
        }
    }

    public boolean isActive() {
        return !this.isDisabled() && !this.isDown() && !this.isFault() && this.snmpNet().isCommActive();
    }

    public final BSnmpNetwork getSnmpNetwork() {
        return (BSnmpNetwork)this.getNetwork();
    }

    public void registerTable(BSnmpTable tab) {
        if (this.tables == null) {
            this.tables = new Vector();
        }
        if (this.tables.contains((Object)tab)) {
            return;
        }
        this.tables.add(tab);
    }

    public void unregisterTable(BSnmpTable tab) {
        if (this.tables == null) {
            return;
        }
        this.tables.removeElement((Object)tab);
    }

    public BDevice getAssociatedDevice(BSnmpAgentPointDeviceExt pointDeviceExt) {
        return pointDeviceExt.getDevice();
    }

    private void updateInputs(BSnmpProxyExt[] a) {
        int maxBindings = this.getMaxVariableBindingsPerRequest();
        int curNdx = 0;
        while (curNdx < a.length) {
            SnmpPDU msg = null;
            msg = this.getVersion() != 3 ? new SnmpPDU(this, 160) : new SnmpV3Message(this, 160);
            int firstNdx = curNdx;
            for (int i = 0; i < maxBindings && curNdx < a.length; ++i) {
                BSnmpProxyExt ai = a[curNdx++];
                SnmpOID oid = new SnmpOID(ai.getObjectIdentifier());
                SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
                msg.addVariableBinding(varBind);
            }
            msg.setRetryCount(this.getRetryCount());
            msg.setResponseTimeOut(this.getResponseTimeout().getSeconds() * 1000);
            SnmpPDU pdu = null;
            try {
                if (this.getVersion() != 3) {
                    pdu = (SnmpPDU)this.snmpNet().sendSyncMessage(msg);
                } else {
                    SnmpV3Communicator snmpCommunicator = SnmpV3Communicator.getBSnmpV3CommunicatorInstance(this.snmpNet());
                    pdu = snmpCommunicator.sendMessage((SnmpV3Message)msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.snmpNet().log().severe("poll failed in " + this.getName());
                return;
            }
            if (pdu == null) {
                this.snmpNet().log().severe("poll failed in " + this.getName());
                return;
            }
            int errorStatus = pdu.getErrstat();
            int errorIndex = pdu.getErrindex();
            if (errorIndex != 0) {
                int ndx = firstNdx + errorIndex - 1;
                a[ndx].readFail(SnmpPDU.translateErrorStatus(errorStatus));
                a = (BSnmpProxyExt[])ArrayUtil.removeOne((Object[])a, (int)ndx);
                curNdx = firstNdx;
                continue;
            }
            Vector<SnmpVarBind> vars = pdu.getVariableBindings();
            for (int i = 0; i < vars.size(); ++i) {
                BSnmpProxyExt ai = a[firstNdx + i];
                SnmpVarBind varBind = vars.elementAt(i);
                String oid = varBind.getObjectID().toString();
                if (oid.lastIndexOf(ai.getObjectIdentifier()) == -1) {
                    this.snmpNet().log().severe("poll error: " + oid + "!=" + ai.getObjectIdentifier());
                    continue;
                }
                ai.setValue(varBind.getVariable());
            }
        }
    }

    public SnmpPDU updateGetNext(String oidEntry) throws Exception {
        InetAddress inetAddr = this.getInetAddress();
        if (inetAddr == null) {
            return null;
        }
        SnmpPDU msg = null;
        msg = this.getVersion() != 3 ? new SnmpPDU(this, 161) : new SnmpV3Message(this, 161);
        msg.setVersion(this.getVersion());
        msg.setReqid(this.snmpNet().getNextReqid(inetAddr));
        msg.setCommand(161);
        msg.setRemotePort(this.getPort());
        msg.setDestinationIp(inetAddr);
        msg.setCommunity(this.getCommunity());
        msg.setRetryCount(this.getRetryCount());
        msg.setResponseTimeOut(this.getResponseTimeout().getSeconds() * 1000);
        SnmpOID oid = new SnmpOID(oidEntry);
        SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
        msg.addVariableBinding(varBind);
        SnmpPDU pdu = null;
        if (this.getVersion() != 3) {
            pdu = (SnmpPDU)this.snmpNet().sendSyncMessage(msg);
        } else {
            SnmpV3Communicator snmpCommunicator = SnmpV3Communicator.getBSnmpV3CommunicatorInstance(this.snmpNet());
            pdu = snmpCommunicator.sendMessage((SnmpV3Message)msg);
            if (pdu != null && pdu.getErrindex() != 0) {
                pdu = null;
            }
        }
        return pdu;
    }

    public synchronized SnmpPDU updateGet(String oidEntry) {
        InetAddress inetAddr = this.getInetAddress();
        if (inetAddr == null) {
            return null;
        }
        SnmpPDU msg = null;
        msg = this.getVersion() != 3 ? new SnmpPDU(this, 160) : new SnmpV3Message(this, 160);
        msg.setVersion(this.getVersion());
        msg.setReqid(this.snmpNet().getNextReqid(inetAddr));
        msg.setCommand(160);
        msg.setRemotePort(this.getPort());
        msg.setDestinationIp(inetAddr);
        msg.setCommunity(this.getCommunity());
        SnmpOID oid = new SnmpOID(oidEntry);
        SnmpVarBind varBind = new SnmpVarBind(oid, new SnmpNull());
        msg.addVariableBinding(varBind);
        SnmpPDU pdu = null;
        try {
            if (this.getVersion() != 3) {
                pdu = (SnmpPDU)this.snmpNet().sendSyncMessage(msg);
            } else {
                SnmpV3Communicator snmpCommunicator = SnmpV3Communicator.getBSnmpV3CommunicatorInstance(this.snmpNet());
                pdu = snmpCommunicator.sendMessage((SnmpV3Message)msg);
                if (pdu != null && pdu.getErrindex() != 0) {
                    pdu = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return pdu;
    }

    public synchronized int setVar(SnmpVar var, String oid) {
        BSnmpNetwork network = this.snmpNet();
        SnmpPDU msg = null;
        msg = this.getVersion() != 3 ? new SnmpPDU(this, 163) : new SnmpV3Message(this, 163);
        msg.setVersion(this.getVersion());
        msg.setReqid(network.getNextReqid(this.getInetAddress()));
        msg.setCommand(163);
        msg.setRemotePort(this.getPort());
        msg.setDestinationIp(this.getInetAddress());
        msg.setCommunity(this.getCommunity());
        SnmpVarBind varBind = new SnmpVarBind(new SnmpOID(oid), var);
        msg.addVariableBinding(varBind);
        msg.setResponseTimeOut(this.getResponseTimeout().getSeconds() * 1000);
        msg.setRetryCount(this.getRetryCount());
        SnmpPDU pdu = null;
        try {
            if (this.getVersion() != 3) {
                pdu = (SnmpPDU)this.snmpNet().sendSyncMessage(msg);
            } else {
                SnmpV3Communicator snmpCommunicator = SnmpV3Communicator.getBSnmpV3CommunicatorInstance(this.snmpNet());
                pdu = snmpCommunicator.sendMessage((SnmpV3Message)msg);
                if (pdu != null && pdu.getErrindex() != 0) {
                    pdu = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (pdu == null) {
            return -1;
        }
        return pdu.getErrstat();
    }

    @Override
    public BSnmpNetwork snmpNet() {
        if (this.net == null) {
            BComplex c = this.getParent();
            while (!(c instanceof BSnmpNetwork)) {
                c = c.getParent();
            }
            this.net = (BSnmpNetwork)c;
        }
        return this.net;
    }

    public InetAddress getInetAddress() {
        try {
            return InetAddress.getByName(this.getIpAddress());
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getVersion() {
        if (this.getSnmpVersion() == 1) {
            return 0;
        }
        if (this.getSnmpVersion() == 2) {
            return 1;
        }
        if (this.getSnmpVersion() == 3) {
            return 3;
        }
        this.setSnmpVersion(2);
        return 1;
    }

    public BOrd doWalkMib(BMibListTable mibList) {
        return new BSnmpWalkMibJob(this, mibList).submit(null);
    }

    private static String engineIdDisplay(byte[] paramArrayOfByte) {
        StringBuilder sb = new StringBuilder("");
        for (int i = 0; i < paramArrayOfByte.length; ++i) {
            sb.append(String.format("%02X", 0xFF & paramArrayOfByte[i]));
        }
        return sb.toString().trim();
    }

    public class User {
        private String userName = this.getUserName();
        private String authProtocol;
        private String privProtocol;
        private String authPass;
        private String privPass;

        User() {
            this.authProtocol = BSnmpDevice.this.getAuthenticationProtocol().getTag();
            this.authPass = AccessController.doPrivileged(() -> ((BPassword)BSnmpDevice.this.getAuthenticationPassphrase()).getValue());
            this.privProtocol = BSnmpDevice.this.getPrivacyProtocol().getTag();
            this.privPass = AccessController.doPrivileged(() -> ((BPassword)BSnmpDevice.this.getPrivacyPassphrase()).getValue());
        }

        public String getUserName() {
            return this.userName;
        }

        public String getAuthProtocol() {
            return this.authProtocol;
        }

        public String getPrivProtocol() {
            return this.privProtocol;
        }

        public String getAuthPass() {
            return this.authPass;
        }

        public String getPrivPass() {
            return this.privPass;
        }

        public int hashCode() {
            int result = 31;
            result = result * 7 + this.userName.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof User)) {
                return false;
            }
            User other = (User)obj;
            return other.userName.equalsIgnoreCase(this.userName);
        }
    }
}

