/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X.ui;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platIEEE8021X.BIEEE8021XAdapterSettings;
import com.tridium.platIEEE8021X.BIEEE8021XHostSettings;
import com.tridium.platIEEE8021X.BIEEE8021XPlatformService;
import com.tridium.platIEEE8021X.ui.BIEEE8021XHostSettingsEditor;
import com.tridium.platcrypto.core.BCertManagerService;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.qnx.BSystemPlatformServiceQnx;
import com.tridium.platform.ui.util.BButtonPane;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaException;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platIEEE8021X:IEEE8021XPlatformService"}, requiredPermissions="W")})
public class BIEEE8021XPlatformServicePlugin
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BIEEE8021XPlatformServicePlugin.class);
    private static final Logger log = Logger.getLogger("platIEEE8021X.service.plugin");
    private final BIEEE8021XHostSettingsEditor hostEditor;
    private final BScrollPane scrollPane;
    protected static final LexiconModule LEXICON = LexiconModule.make((Type)TYPE);
    private static final int PARENT_BORDER_PANE_TOP = 10;
    private static final int PARENT_BORDER_PANE_RIGHT = 10;
    private static final int PARENT_BORDER_PANE_BOTTOM = 10;
    private static final int PARENT_BORDER_PANE_LEFT = 10;
    private static final int SUB_BORDER_PANE_TOP = 5;
    private static final int SUB_BORDER_PANE_RIGHT = 0;
    private static final int SUB_BORDER_PANE_BOTTOM = 0;
    private static final int SUB_BORDER_PANE_LEFT = 0;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIEEE8021XPlatformServicePlugin() {
        this.autoRegisterForComponentEvents = false;
        this.hostEditor = new BIEEE8021XHostSettingsEditor();
        this.scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.hostEditor, 10.0, 10.0, 10.0, 10.0));
        this.linkTo(null, (BComponent)this.hostEditor, (Slot)BIEEE8021XHostSettingsEditor.pluginModified, (Slot)setModified);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        boolean readonly;
        int rc;
        ICoreCryptoManager coreCryptoManager;
        BIEEE8021XPlatformService service = (BIEEE8021XPlatformService)value;
        service.poll();
        try {
            this.registerForComponentEvents((BComponent)service, Integer.MAX_VALUE);
        }
        catch (Throwable t) {
            log.log(Level.WARNING, "Exception occurred registering for component events", t);
        }
        BIEEE8021XHostSettings hostSettings = service.getSettings();
        hostSettings.lease(Integer.MAX_VALUE);
        Optional.ofNullable(hostSettings.getComponentSpace()).orElseThrow(() -> new BajaRuntimeException("Component space unavailable")).sync();
        try {
            BCertManagerService certService = (BCertManagerService)BOrd.make((String)"service:platCrypto:CertManagerService").get((BObject)service);
            certService.poll();
            certService.lease(Integer.MAX_VALUE);
            coreCryptoManager = certService.getCoreCryptoManager();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LEXICON.getText("IEEE8021XHostSettingsEditor.crypto.failure.msg", cx), e);
            throw new BajaException(LEXICON.getText("IEEE8021XHostSettingsEditor.crypto.failure.msg", cx), (Throwable)e);
        }
        if (!coreCryptoManager.isSecure() && (rc = BDialog.open((BWidget)this, (String)LEXICON.getText("IEEE8021XHostSettingsEditor.warning.dialog.title", cx), (Object)LEXICON.getText("IEEE8021XHostSettingsEditor.warning.dialog.msg", cx), (int)12, (BImage)BDialog.WARNING_ICON, (String)null)) == 8) {
            log.log(Level.SEVERE, LEXICON.getText("IEEE8021XHostSettingsEditor.warning.terminated.msg", cx));
            throw new BajaException(LEXICON.getText("IEEE8021XHostSettingsEditor.warning.terminated.msg", cx));
        }
        this.hostEditor.setCryptoManager(coreCryptoManager);
        this.hostEditor.loadValue((BObject)service.getSettings());
        BSystemPlatformService sys = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        sys.lease();
        this.hostEditor.isTridiumQNX = sys instanceof BSystemPlatformServiceQnx;
        BWbShell shell = this.getWbShell();
        if (shell != null) {
            BButtonPane buttons = new BButtonPane();
            buttons.add(shell.getRefreshCommand(), true, true);
            buttons.add(shell.getSaveCommand(), true, true);
            this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)new BEdgePane(null, (BWidget)new BBorderPane((BWidget)buttons, 5.0, 0.0, 0.0, 0.0), null, null, (BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT))));
        } else {
            this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT)));
        }
        boolean hostReadonly = service.getSettings().getIeee8021XReadonly();
        boolean bl = readonly = hostReadonly || sys.getIsServiceReadonly() || this.isReadonly();
        if (this.isReadonly() == readonly) {
            this.doSetReadonly(readonly);
        } else {
            this.setReadonly(readonly);
        }
    }

    protected BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (this.isReadonly()) {
            return value;
        }
        BIEEE8021XPlatformService service = (BIEEE8021XPlatformService)value;
        this.hostEditor.saveValue(cx);
        BSystemPlatformService system = (BSystemPlatformService)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)service);
        system.lease();
        if (!service.getSettings().getIeee8021XReadonly()) {
            try {
                service.savePlatformServiceProperties();
                if (system.getLocalDaemonAccess().atLeast(BDaemonAccessLevel.full)) {
                    if (4 == BDialog.confirm((BWidget)this, (String)LEXICON.getText("IEEE8021XPlatformServicePlugin.reboot.dlgTitle", cx), (Object)LEXICON.getText("IEEE8021XPlatformServicePlugin.reboot.dlgMessage", cx), (int)12)) {
                        system.reboot();
                    }
                } else {
                    BDialog.message((BWidget)this, (String)this.getLexicon().getText("IEEE8021XPlatformServicePlugin.rebootRequired.title"), (Object)this.getLexicon().getText("IEEE8021XPlatformServicePlugin.rebootRequired.message"));
                }
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Failed to save IEEE8021X platform service session view", e);
                throw new CannotSaveException("Failed to save IEEE8021X platform service session view", (Throwable)e);
            }
        }
        return value;
    }

    protected void doSetReadonly(boolean readonly) {
        this.hostEditor.setReadonly(readonly);
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BIEEE8021XHostSettings || evt.getSourceComponent() instanceof BIEEE8021XAdapterSettings) {
            this.hostEditor.handleComponentEvent(evt);
        } else {
            super.handleComponentEvent(evt);
        }
    }
}

