/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X.ui;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platIEEE8021X.BIEEE8021XAdapterSettings;
import com.tridium.platIEEE8021X.BIEEE8021XHostSettings;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import com.tridium.platIEEE8021X.ui.BIEEE8021XAdapterSettingsEditor;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.HashMap;
import java.util.logging.Logger;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BTabbedPane;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType
public class BIEEE8021XHostSettingsEditor
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BIEEE8021XHostSettingsEditor.class);
    protected static final LexiconModule LEXICON = LexiconModule.make((Type)TYPE);
    private BTabbedPane tabbedPane;
    private HashMap<String, BIEEE8021XAdapterSettingsEditor> ieee8021XAdapterSettingsEditors;
    private static final int DEFAULT_GRID_PANE_COLUMN_GAP = 10;
    private static final int DEFAULT_GRID_PANE_ROW_GAP = 6;
    private ICoreCryptoManager cryptoManager;
    protected static final Logger LOG = Logger.getLogger("platIEEE8021X.editor");
    public boolean isTridiumQNX;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public void setCryptoManager(ICoreCryptoManager cryptoManager) {
        this.cryptoManager = cryptoManager;
    }

    protected void doLoadValue(BObject value, Context cx) {
        boolean readonly;
        if (this.tabbedPane != null) {
            this.tabbedPane.removeAll();
        }
        if (this.ieee8021XAdapterSettingsEditors != null) {
            this.ieee8021XAdapterSettingsEditors.clear();
        }
        if (this.cryptoManager == null) {
            LOG.warning("IEEE 802.1X Host Settings Editor was created without crypto manager interface, certificate enumeration unavailable");
        }
        this.tabbedPane = new BTabbedPane();
        this.ieee8021XAdapterSettingsEditors = new HashMap();
        boolean foundAtLeastOne = false;
        BIEEE8021XHostSettings hostSettings = (BIEEE8021XHostSettings)value;
        SlotCursor c = hostSettings.getAdapterSettings().loadSlots().getProperties();
        while (c.next()) {
            foundAtLeastOne = true;
            BIEEE8021XAdapterSettings adapterSettings = (BIEEE8021XAdapterSettings)c.get();
            String adapterOsName = SlotPath.unescape((String)c.property().getName());
            BIEEE8021XAdapterSettingsEditor editor = new BIEEE8021XAdapterSettingsEditor(this.cryptoManager);
            BGridPane authenticationPane = new BGridPane(1);
            authenticationPane.setHalign(BHalign.left);
            authenticationPane.setValign(BValign.top);
            authenticationPane.setRowAlign(BValign.top);
            authenticationPane.setColumnGap(10.0);
            authenticationPane.setRowGap(6.0);
            authenticationPane.setColorRows(false);
            editor.loadValue((BObject)adapterSettings);
            this.ieee8021XAdapterSettingsEditors.put(adapterOsName, editor);
            editor.setReadonly(this.isReadonly());
            this.linkTo(null, (BComponent)editor, (Slot)BIEEE8021XAdapterSettingsEditor.pluginModified, (Slot)setModified);
            authenticationPane.add(null, (BValue)editor);
            this.tabbedPane.addPane(new BLabel(BImage.make((BIcon)BIcon.std((String)"connection.png")), LEXICON.getText("IEEE8021XAdapterSettingsEditor.adapter.label", cx) + " " + IEEE8021XUtil.getAdapterIdFromOsName((String)adapterOsName, (boolean)this.isTridiumQNX), Theme.widget().getBoldText()), (BWidget)new BBorderPane((BWidget)authenticationPane));
        }
        boolean bl = readonly = hostSettings.getIeee8021XReadonly() || this.isReadonly();
        if (this.isReadonly() == readonly) {
            this.doSetReadonly(readonly);
        } else {
            this.setReadonly(readonly);
        }
        this.setContent((BWidget)new BBorderPane((BWidget)(foundAtLeastOne ? this.tabbedPane : new BLabel(LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XEditor.noAdapters", cx))), new BLabel(LEXICON.getText("IEEE8021XAdapterSettingsEditor.ieee8021XEditor.border", cx), Theme.widget().getBoldText()), BBorder.inset));
    }

    protected void doSetReadonly(boolean readonly) {
        if (this.ieee8021XAdapterSettingsEditors != null) {
            for (BIEEE8021XAdapterSettingsEditor plugin : this.ieee8021XAdapterSettingsEditors.values()) {
                plugin.setReadonly(readonly);
            }
        }
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        BIEEE8021XHostSettings hostSettings = (BIEEE8021XHostSettings)value;
        if (this.isReadonly()) {
            return value;
        }
        if (hostSettings.getIeee8021XReadonly()) {
            return value;
        }
        if (!this.isModified()) {
            return value;
        }
        if (this.ieee8021XAdapterSettingsEditors != null) {
            for (BIEEE8021XAdapterSettingsEditor plugin : this.ieee8021XAdapterSettingsEditors.values()) {
                plugin.saveValue(cx);
            }
        }
        return value;
    }

    public final void handleComponentEvent(BComponentEvent evt) {
        if (evt.getSourceComponent() instanceof BIEEE8021XAdapterSettings) {
            WbViewEventWorker.getInstance().invokeLater(() -> {
                BIEEE8021XAdapterSettings adapterSettings = (BIEEE8021XAdapterSettings)evt.getSourceComponent();
                if (this.ieee8021XAdapterSettingsEditors != null) {
                    for (BIEEE8021XAdapterSettingsEditor adapterEditor : this.ieee8021XAdapterSettingsEditors.values()) {
                        if (!adapterSettings.equals((Object)adapterEditor.getAdapterSettings())) continue;
                        adapterEditor.processComponentEvent(evt);
                        break;
                    }
                }
            });
        } else {
            super.handleComponentEvent(evt);
        }
    }
}

