/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.platIEEE8021X.ui;

import com.tridium.crypto.core.io.ICoreCryptoManager;
import com.tridium.platIEEE8021X.BIEEE8021XHostSettings;
import com.tridium.platIEEE8021X.IEEE8021XUtil;
import com.tridium.platIEEE8021X.ui.BIEEE8021XHostSettingsEditor;
import com.tridium.platcrypto.daemon.BPlatCryptoManager;
import com.tridium.platform.daemon.BDaemonAccessLevel;
import com.tridium.platform.daemon.BDaemonSession;
import com.tridium.platform.daemon.BHostProperties;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.ui.theme.Theme;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.nre.annotations.AgentOn;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.security.AuthenticationException;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.LexiconModule;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

@NiagaraType(agent={@AgentOn(types={"platform:DaemonSession"})})
public class BIEEE8021XDaemonSessionPlugin
extends BWbComponentView {
    @Generated
    public static final Type TYPE = Sys.loadType(BIEEE8021XDaemonSessionPlugin.class);
    private BDaemonSession session;
    private ICoreCryptoManager coreCryptoManager;
    private final BIEEE8021XHostSettingsEditor hostEditor = new BIEEE8021XHostSettingsEditor();
    private final BScrollPane scrollPane;
    private static final LexiconModule LEXICON = LexiconModule.make((Type)TYPE);
    private static final Logger LOG = Logger.getLogger("platIEEE8021X.daemon.plugin");
    private static final int PARENT_BORDER_PANE_TOP = 10;
    private static final int PARENT_BORDER_PANE_RIGHT = 10;
    private static final int PARENT_BORDER_PANE_BOTTOM = 5;
    private static final int PARENT_BORDER_PANE_LEFT = 10;
    private static final int SUB_BORDER_PANE_TOP = 5;
    private static final int SUB_BORDER_PANE_RIGHT = 10;
    private static final int SUB_BORDER_PANE_BOTTOM = 0;
    private static final int SUB_BORDER_PANE_LEFT = 10;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BIEEE8021XDaemonSessionPlugin() {
        BBrush bgColor = Theme.scrollPane().getControlBackground();
        this.scrollPane = new BScrollPane((BWidget)new BBorderPane((BWidget)this.hostEditor, 10.0, 10.0, 5.0, 10.0));
        this.scrollPane.setViewportBackground(bgColor);
        this.linkTo(null, (BComponent)this.hostEditor, (Slot)BIEEE8021XHostSettingsEditor.pluginModified, (Slot)setModified);
    }

    protected void doLoadValue(BObject value, Context cx) throws Exception {
        int rc;
        this.session = (BDaemonSession)value;
        if (!IEEE8021XUtil.supportsIEEE8021x((BDaemonSession)this.session)) {
            throw new UnsupportedOperationException("IEEE 802.1X is not supported on platform");
        }
        if (!this.session.isSecure() && (rc = BDialog.open((BWidget)this, (String)LEXICON.getText("IEEE8021XHostSettingsEditor.warning.dialog.title", cx), (Object)LEXICON.getText("IEEE8021XHostSettingsEditor.warning.dialog.msg", cx), (int)12, (BImage)BDialog.WARNING_ICON, (String)null)) == 8) {
            LOG.log(Level.SEVERE, LEXICON.getText("IEEE8021XHostSettingsEditor.warning.terminated.msg", cx));
            throw new LocalizableException("platIEEE8021X", "IEEE8021XHostSettingsEditor.warning.terminated.msg");
        }
        try {
            this.coreCryptoManager = new BPlatCryptoManager(this.session);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, LEXICON.getText("IEEE8021XHostSettingsEditor.crypto.failure.msg", cx), exception);
            throw new LocalizableException("platIEEE8021X", "IEEE8021XHostSettingsEditor.crypto.failure.msg", (Throwable)exception);
        }
        this.hostEditor.setCryptoManager(this.coreCryptoManager);
        BHostProperties hostProperties = this.session.getHostProperties();
        this.hostEditor.isTridiumQNX = !hostProperties.getIsNpsdk() && hostProperties.getOsName().toLowerCase().contains("qnx");
        try {
            BIEEE8021XHostSettings hostSettings = new BIEEE8021XHostSettings();
            IEEE8021XUtil.loadFromSession((BIEEE8021XHostSettings)hostSettings, (BDaemonSession)this.session);
            BWbShell shell = this.getWbShell();
            if (shell != null) {
                BButtonPane buttons = new BButtonPane();
                buttons.addWorkbenchButtons((BWidget)this);
                BEdgePane edge = new BEdgePane();
                edge.setCenter((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT));
                edge.setBottom((BWidget)new BBorderPane((BWidget)buttons, 5.0, 10.0, 0.0, 10.0));
                this.setContent((BWidget)new BTitlePane(this.getTypeDisplayName(cx), (BWidget)edge));
            } else {
                this.setContent((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.DEFAULT));
            }
            this.hostEditor.loadValue((BObject)hostSettings);
            boolean readonly = hostSettings.getIeee8021XReadonly();
            if (this.isReadonly() == readonly) {
                this.doSetReadonly(readonly);
            } else {
                this.setReadonly(readonly);
            }
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.SEVERE, "Failed to load IEEE8021X daemon session view", runtimeException);
            throw new LocalizableRuntimeException("platIEEE8021X", "IEEE8021XDaemonSessionPlugin.parseError", (Throwable)runtimeException);
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to load IEEE8021X daemon session view", exception);
            throw new LocalizableException("platIEEE8021X", "IEEE8021XDaemonSessionPlugin.parseError", (Throwable)exception);
        }
    }

    protected final BObject doSaveValue(BObject value, Context cx) throws Exception {
        if (!this.isModified()) {
            return value;
        }
        if (this.isReadonly()) {
            return value;
        }
        if (this.session == null || this.coreCryptoManager == null || this.hostEditor == null || this.scrollPane == null) {
            return value;
        }
        BIEEE8021XHostSettings newSettings = (BIEEE8021XHostSettings)this.hostEditor.saveValue();
        try {
            IEEE8021XUtil.saveToSession((BIEEE8021XHostSettings)newSettings, (BDaemonSession)this.session, (ICoreCryptoManager)this.coreCryptoManager);
            if (this.session.getHostProperties().getAccessLevel().atLeast(BDaemonAccessLevel.full)) {
                this.promptForReboot(true);
            } else {
                BDialog.message((BWidget)this, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.rebootRequired.title", cx), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.rebootRequired.message", cx));
            }
        }
        catch (Exception exception) {
            LOG.log(Level.SEVERE, "Failed to save IEEE8021X daemon session view", exception);
            throw new CannotSaveException("Failed to save IEEE8021X daemon session view", (Throwable)exception);
        }
        return value;
    }

    protected void doSetReadonly(boolean readonly) {
        if (this.hostEditor != null) {
            this.hostEditor.setReadonly(readonly);
        }
    }

    private void promptForReboot(boolean optional) {
        block5: {
            if (optional && !this.session.usesLocalNiagaraHome() && 4 != BDialog.confirm((BWidget)this, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.promptTitle", null, new Object[]{this.session.getRemoteAddressString()}), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.promptMessage", null, new Object[]{this.session.getRemoteAddressString()}), (int)12)) {
                return;
            }
            if (this.session.usesLocalNiagaraHome()) {
                BDialog.message((BWidget)this, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.rebootLocal.title", null), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.rebootLocal.message", null));
                return;
            }
            try {
                BWidgetShell shell = this.getShell();
                this.session.sendRebootRequest();
                if (shell != null) {
                    BDialog.message((BWidget)shell, (String)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.notifyTitle", null, new Object[]{this.session.getRemoteAddressString()}), (Object)LEXICON.getText("IEEE8021XDaemonSessionPlugin.reboot.notifyMessage", null, new Object[]{this.session.getRemoteAddressString()}));
                }
            }
            catch (AuthenticationException authenticationException) {
                if (!LOG.isLoggable(Level.FINEST)) break block5;
                LOG.finest("Authentication exception occurred while sending reboot request (" + (Object)((Object)authenticationException) + ")");
            }
        }
    }
}

