/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.utils;

import com.tridium.mbus.enums.BMbusCommandCodes;
import com.tridium.mbus.utils.MbusLogInputOutput;
import com.tridium.mbus.utils.MbusToolkit;
import javax.baja.nre.util.TextUtil;
import javax.baja.status.BStatus;
import javax.baja.status.BStatusNumeric;
import javax.baja.status.BStatusString;
import javax.baja.status.BStatusValue;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BMonth;

public final class MbusDataDecoderIEC870 {
    private MbusDataDecoderIEC870() {
    }

    public static ValueData decode(int index, int[] inputArray, int inputCode, boolean noValueFlag, boolean mode2Active) {
        if (MbusToolkit.isTraceOn()) {
            MbusToolkit.trace("In MbusDataDecoderIEC870(), Index = " + index + "  Code= " + inputCode + "  Value= " + inputArray[index]);
        }
        int increment = 0;
        BStatusNumeric valueHold = new BStatusNumeric(0.0, BStatus.fault);
        switch (inputCode) {
            case 0: {
                increment = 0;
                if (!MbusToolkit.isTraceOn()) break;
                MbusToolkit.trace("NO DATA");
                break;
            }
            case 1: 
            case 9: {
                increment = 1;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "INT_8BIT || BCD_2DIGIT", inputArray, index);
                break;
            }
            case 2: 
            case 10: 
            case 18: {
                increment = 2;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "INT_16BIT || BCD_4DIGIT || CP_16DATE", inputArray, index);
                break;
            }
            case 3: 
            case 11: 
            case 21: {
                increment = 3;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "INT_24BIT || BCD_6DIGIT || TIME_OF_DAY", inputArray, index);
                break;
            }
            case 4: 
            case 5: 
            case 12: 
            case 19: 
            case 22: {
                increment = 4;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "INT_32BIT || REAL_32DIGIT || BCD_8DIGIT || CP_32DATE || DAYLIGHT_SAVING", inputArray, index);
                break;
            }
            case 6: 
            case 14: 
            case 20: {
                increment = 6;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "INT_48BIT || BCD_12DIGIT || YEAR_TO_SECOND", inputArray, index);
                break;
            }
            case 7: {
                increment = 8;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "INT_64BIT", inputArray, index);
                break;
            }
            case 8: {
                increment = 1;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "READOUT_SELECTION", inputArray, index);
                break;
            }
            case 13: 
            case 16: {
                increment = inputArray[index] + 1;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "VAR_LENGTH || STRING", inputArray, index);
                break;
            }
            case 15: {
                increment = inputArray.length - index;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "SPECIAL FUNCTIONS", inputArray, index);
                break;
            }
            case 17: {
                increment = inputArray.length - index;
                if (!MbusToolkit.isTraceOn()) break;
                MbusDataDecoderIEC870.traceRawData(increment, "CP_16UNITS_AND_INFO", inputArray, index);
                break;
            }
            default: {
                increment = 1;
            }
        }
        if (index + increment > inputArray.length) {
            valueHold = new BStatusString("Number Out of bounds", BStatus.fault);
        } else if (!noValueFlag) {
            if (mode2Active) {
                if (MbusToolkit.isTraceOn()) {
                    MbusToolkit.trace("Apply MODE 2 ACTIVE during decode");
                }
                MbusDataDecoderIEC870.mode2Swap(inputArray, index, increment);
            }
            double multiplier = 1.0;
            int hold = 0;
            int hold1 = 0;
            int hold2 = 0;
            int hold3 = 0;
            int hold4 = 0;
            int hold5 = 0;
            int hold6 = 0;
            int hold7 = 0;
            int hold8 = 0;
            long lhold = 0L;
            long lhold1 = 0L;
            long lhold2 = 0L;
            long lhold3 = 0L;
            long lhold4 = 0L;
            long lhold5 = 0L;
            long lhold6 = 0L;
            long lhold7 = 0L;
            long lhold8 = 0L;
            long lhold9 = 0L;
            long lhold10 = 0L;
            long lhold11 = 0L;
            int second = 0;
            int minute = 0;
            int hour = 0;
            int day = 0;
            int month = 0;
            int year = 0;
            switch (inputCode) {
                case 0: {
                    valueHold = new BStatusNumeric(0.0, BStatus.ok);
                    break;
                }
                case 1: {
                    valueHold = new BStatusNumeric((double)((byte)inputArray[index]), BStatus.ok);
                    break;
                }
                case 2: {
                    hold = inputArray[index + 1] << 8 | inputArray[index];
                    valueHold = new BStatusNumeric((double)((short)hold), BStatus.ok);
                    break;
                }
                case 3: {
                    hold = inputArray[index + 2] << 16 | inputArray[index + 1] << 8 | inputArray[index];
                    if ((hold & 0x800000) != 0) {
                        hold |= 0xFF000000;
                    }
                    valueHold = new BStatusNumeric((double)hold, BStatus.ok);
                    break;
                }
                case 4: {
                    hold = inputArray[index + 3] << 24 | inputArray[index + 2] << 16 | inputArray[index + 1] << 8 | inputArray[index];
                    valueHold = new BStatusNumeric((double)hold, BStatus.ok);
                    break;
                }
                case 5: {
                    hold = inputArray[index + 3] << 24 | inputArray[index + 2] << 16 | inputArray[index + 1] << 8 | inputArray[index];
                    float dhold = Float.intBitsToFloat(hold);
                    valueHold = new BStatusNumeric((double)dhold, BStatus.ok);
                    break;
                }
                case 6: {
                    lhold1 = inputArray[index];
                    lhold2 = inputArray[index + 1];
                    lhold3 = inputArray[index + 2];
                    lhold4 = inputArray[index + 3];
                    lhold5 = inputArray[index + 4];
                    lhold6 = inputArray[index + 5];
                    lhold = lhold1 | lhold2 << 8 | lhold3 << 16 | lhold4 << 24 | lhold5 << 32 | lhold6 << 40;
                    if ((lhold & 0x800000000000L) != 0L) {
                        lhold |= 0xFFFF000000000000L;
                    }
                    valueHold = new BStatusNumeric((double)lhold, BStatus.ok);
                    break;
                }
                case 7: {
                    lhold1 = inputArray[index];
                    lhold2 = inputArray[index + 1];
                    lhold3 = inputArray[index + 2];
                    lhold4 = inputArray[index + 3];
                    lhold5 = inputArray[index + 4];
                    lhold6 = inputArray[index + 5];
                    lhold7 = inputArray[index + 6];
                    lhold8 = inputArray[index + 7];
                    lhold = lhold1 | lhold2 << 8 | lhold3 << 16 | lhold4 << 24 | lhold5 << 32 | lhold6 << 40 | lhold7 << 48 | lhold8 << 56;
                    valueHold = new BStatusNumeric((double)lhold, BStatus.ok);
                    break;
                }
                case 8: {
                    valueHold = new BStatusNumeric(0.0, BStatus.ok);
                    break;
                }
                case 9: {
                    hold = inputArray[index] & 0xF;
                    hold1 = inputArray[index] >> 4 & 0xF;
                    if (hold1 == 15) {
                        multiplier = -1.0;
                        hold1 = 0;
                    }
                    valueHold = new BStatusNumeric((double)(hold1 * 10 + hold) * multiplier, BStatus.ok);
                    break;
                }
                case 10: {
                    hold = inputArray[index] & 0xF;
                    hold1 = inputArray[index] >> 4 & 0xF;
                    hold2 = inputArray[index + 1] & 0xF;
                    hold3 = inputArray[index + 1] >> 4 & 0xF;
                    if (hold3 == 15) {
                        multiplier = -1.0;
                        hold3 = 0;
                    }
                    hold4 = hold + hold1 * 10 + hold2 * 100 + hold3 * 1000;
                    valueHold = new BStatusNumeric((double)hold4 * multiplier, BStatus.ok);
                    break;
                }
                case 11: {
                    hold = inputArray[index] & 0xF;
                    hold1 = inputArray[index] >> 4 & 0xF;
                    hold2 = inputArray[index + 1] & 0xF;
                    hold3 = inputArray[index + 1] >> 4 & 0xF;
                    hold4 = inputArray[index + 2] & 0xF;
                    hold5 = inputArray[index + 2] >> 4 & 0xF;
                    if (hold5 == 15) {
                        multiplier = -1.0;
                        hold5 = 0;
                    }
                    hold6 = hold + hold1 * 10 + hold2 * 100 + hold3 * 1000 + hold4 * 10000 + hold5 * 100000;
                    valueHold = new BStatusNumeric((double)hold6 * multiplier, BStatus.ok);
                    break;
                }
                case 12: {
                    hold = inputArray[index] & 0xF;
                    hold1 = inputArray[index] >> 4 & 0xF;
                    hold2 = inputArray[index + 1] & 0xF;
                    hold3 = inputArray[index + 1] >> 4 & 0xF;
                    hold4 = inputArray[index + 2] & 0xF;
                    hold5 = inputArray[index + 2] >> 4 & 0xF;
                    hold6 = inputArray[index + 3] & 0xF;
                    hold7 = inputArray[index + 3] >> 4 & 0xF;
                    if (hold7 == 15) {
                        multiplier = -1.0;
                        hold7 = 0;
                    }
                    hold8 = hold + hold1 * 10 + hold2 * 100 + hold3 * 1000 + hold4 * 10000 + hold5 * 100000 + hold6 * 1000000 + hold7 * 10000000;
                    valueHold = new BStatusNumeric((double)hold8 * multiplier, BStatus.ok);
                    break;
                }
                case 13: {
                    int lvar = inputArray[index] & 0xFF;
                    int lvarIndex = 0;
                    int intFlag = 0;
                    if (lvar < 192) {
                        char[] charHold = new char[lvar];
                        for (lvarIndex = 0; lvarIndex < lvar; ++lvarIndex) {
                            charHold[lvar - lvarIndex - 1] = (char)inputArray[lvarIndex + index + 1];
                        }
                        String stringHold = new String(charHold);
                        valueHold = new BStatusString(stringHold, BStatus.ok);
                        break;
                    }
                    if (lvar < 208) {
                        int intHold = 0;
                        char[] charHold = new char[lvar -= 192];
                        for (lvarIndex = 0; lvarIndex < lvar; ++lvarIndex) {
                            intFlag = lvarIndex & 1;
                            intHold = intFlag != 0 ? inputArray[index + lvarIndex / 2 + 1] >> 4 & 0xF : inputArray[index + lvarIndex / 2 + 1] & 0xF;
                            charHold[lvar - lvarIndex - 1] = (char)(intHold + 48);
                        }
                        String stringHold = new String(charHold);
                        valueHold = new BStatusString(stringHold, BStatus.ok);
                        break;
                    }
                    if (lvar < 224) {
                        int intHold = 0;
                        char[] charHold = new char[lvar -= 208];
                        for (lvarIndex = 0; lvarIndex < lvar; ++lvarIndex) {
                            intFlag = lvarIndex & 1;
                            intHold = intFlag != 0 ? inputArray[index + lvarIndex / 2 + 1] >> 4 & 0xF : inputArray[index + lvarIndex / 2 + 1] & 0xF;
                            charHold[lvar - lvarIndex - 1] = (char)(intHold + 48);
                        }
                        String stringHold = "-" + new String(charHold);
                        valueHold = new BStatusString(stringHold, BStatus.ok);
                        break;
                    }
                    if (lvar < 240) {
                        int intHold = 0;
                        char[] charHold = new char[lvar -= 224];
                        for (lvarIndex = 0; lvarIndex < lvar; ++lvarIndex) {
                            intFlag = lvarIndex & 1;
                            intHold = intFlag != 0 ? inputArray[index + lvarIndex / 2 + 1] >> 4 & 0xF : inputArray[index + lvarIndex / 2 + 1] & 0xF;
                            charHold[lvar - lvarIndex - 1] = (char)(intHold + 48);
                        }
                        String stringHold = new String(charHold);
                        valueHold = new BStatusString(stringHold, BStatus.ok);
                        break;
                    }
                    if (lvar != 248) break;
                    long longOutputHold = 0L;
                    long[] longHold = new long[8];
                    for (int i = 0; i < 8; ++i) {
                        longHold[i] = inputArray[i + 1];
                    }
                    longOutputHold = longHold[7] << 56 | longHold[6] << 48 | longHold[5] << 40 | longHold[4] << 32 | longHold[3] << 24 | longHold[2] << 16 | longHold[1] << 8 | longHold[0];
                    double doubleHold = Double.longBitsToDouble(longOutputHold);
                    valueHold = new BStatusNumeric(doubleHold, BStatus.ok);
                    break;
                }
                case 14: {
                    lhold = inputArray[index] & 0xF;
                    lhold1 = inputArray[index] >> 4 & 0xF;
                    lhold2 = inputArray[index + 1] & 0xF;
                    lhold3 = inputArray[index + 1] >> 4 & 0xF;
                    lhold4 = inputArray[index + 2] & 0xF;
                    lhold5 = inputArray[index + 2] >> 4 & 0xF;
                    lhold6 = inputArray[index + 3] & 0xF;
                    lhold7 = inputArray[index + 3] >> 4 & 0xF;
                    lhold8 = inputArray[index + 4] & 0xF;
                    lhold9 = inputArray[index + 4] >> 4 & 0xF;
                    lhold10 = inputArray[index + 5] & 0xF;
                    lhold11 = inputArray[index + 5] >> 4 & 0xF;
                    if (lhold11 == 15L) {
                        multiplier = -1.0;
                        lhold11 = 0L;
                    }
                    valueHold = new BStatusNumeric((double)(lhold += lhold1 * 10L + lhold2 * 100L + lhold3 * 1000L + lhold4 * 10000L + lhold5 * 100000L + lhold6 * 1000000L + lhold7 * 10000000L + lhold8 * 100000000L + lhold9 * 1000000000L + lhold10 * 10000000000L + lhold11 * 100000000000L) * multiplier, BStatus.ok);
                    break;
                }
                case 15: {
                    valueHold = new BStatusString("Special Functions Not Supported.", BStatus.fault);
                    break;
                }
                case 16: {
                    char[] charHold = new char[inputArray[index]];
                    for (int i = 0; i < inputArray[index]; ++i) {
                        charHold[index - i - 1] = (char)inputArray[i + index + 1];
                    }
                    String stringHold = new String(charHold);
                    valueHold = new BStatusString(stringHold, BStatus.ok);
                    break;
                }
                case 17: {
                    valueHold = new BStatusString("CP16 Units & Info Not Supported.", BStatus.fault);
                    break;
                }
                case 18: {
                    day = inputArray[index] & 0x1F;
                    if (day == 0 && MbusToolkit.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Every Day Detected");
                    }
                    if ((month = inputArray[index + 1] & 0xF) < 1) {
                        month = 1;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Month Not Specified, Jan is output");
                        }
                    } else if (month > 12) {
                        month = 12;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Month Detected, Dec is output");
                        }
                    }
                    BMonth monthHold = BMonth.make((int)(month - 1));
                    year = inputArray[index] >> 5 & 7 | inputArray[index + 1] >> 1 & 0x78;
                    if (year == 127) {
                        year = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Year Detected");
                        }
                    }
                    if (year < 81) {
                        year += 2000;
                    }
                    if (year > 81 && year < 2000) {
                        year += 1900;
                    }
                    BAbsTime date = BAbsTime.make((int)year, (BMonth)monthHold, (int)day);
                    valueHold = new BStatusNumeric((double)date.getMillis(), BStatus.ok);
                    break;
                }
                case 20: {
                    int invalid2 = inputArray[index] & 0x80;
                    if (invalid2 == 0) {
                        second = inputArray[index] & 0x3F;
                        minute = inputArray[index + 1] & 0x3F;
                        hour = inputArray[index + 2] & 0x1F;
                        day = inputArray[index + 3] & 0x1F;
                        month = inputArray[index + 4] & 0xF;
                        year = (inputArray[index + 3] & 0xE0) >> 5 & 0x7F | inputArray[index + 4] << 3 & 0xF;
                        if (second == 63) {
                            second = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Second");
                            }
                        }
                        if (minute == 63) {
                            minute = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Minute");
                            }
                        }
                        if (hour == 31) {
                            hour = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Hour");
                            }
                        }
                        if (day == 0 && MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Day Detected");
                        }
                        if (month < 1) {
                            month = 1;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Month Not Specified, Jan is output");
                            }
                        } else if (month > 12) {
                            month = 12;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Month Detected, Dec is output");
                            }
                        }
                        BMonth monthHold = BMonth.make((int)(month - 1));
                        if (year == 127) {
                            year = 0;
                            if (MbusToolkit.isTraceOn()) {
                                MbusLogInputOutput.log.trace("Every Year Detected");
                            }
                        }
                        if (year < 81) {
                            year += 2000;
                        }
                        if (year > 81 && year < 2000) {
                            year += 1900;
                        }
                        BAbsTime date1 = BAbsTime.make((int)year, (BMonth)monthHold, (int)day, (int)hour, (int)minute, (int)second, (int)0);
                        valueHold = new BStatusNumeric((double)date1.getMillis(), BStatus.ok);
                        break;
                    }
                    BAbsTime date2 = BAbsTime.make((long)0L);
                    valueHold = new BStatusNumeric((double)date2.getMillis(), BStatus.fault);
                    break;
                }
                case 19: {
                    int invalid = inputArray[index] & 0x80;
                    minute = inputArray[index] & 0x3F;
                    hour = inputArray[index + 1] & 0x1F;
                    day = inputArray[index + 2] & 0x1F;
                    month = inputArray[index + 3] & 0xF;
                    year = (inputArray[index + 2] & 0xE0) >> 5 & 7 | inputArray[index + 3] >> 1 & 0x78;
                    int hundredYears = inputArray[index + 1] >> 5 & 3;
                    year += 100 * hundredYears;
                    if (invalid != 0) {
                        minute = 0;
                        hour = 0;
                    }
                    if (minute == 63) {
                        minute = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Minute");
                        }
                    }
                    if (hour == 31) {
                        hour = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Hour");
                        }
                    }
                    if (day == 0 && MbusToolkit.isTraceOn()) {
                        MbusLogInputOutput.log.trace("Every Day Detected");
                    }
                    if (month < 1) {
                        month = 1;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Month Not Specified, Jan is output");
                        }
                    } else if (month > 12) {
                        month = 12;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Month Detected, Dec is output");
                        }
                    }
                    BMonth monthHold = BMonth.make((int)(month - 1));
                    if (year == 127) {
                        year = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Year Detected");
                        }
                    }
                    if (year < 81) {
                        year += 2000;
                    }
                    if (year > 81 && year < 2000) {
                        year += 1900;
                    }
                    BAbsTime date3 = BAbsTime.make((int)year, (BMonth)monthHold, (int)day, (int)hour, (int)minute);
                    valueHold = new BStatusNumeric((double)date3.getMillis(), BStatus.ok);
                    break;
                }
                case 21: {
                    BAbsTime currentTime = BAbsTime.now();
                    second = inputArray[index] & 0x3F;
                    minute = inputArray[index + 1] & 0x3F;
                    hour = inputArray[index + 2] & 0x1F;
                    if (second == 63) {
                        second = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Second");
                        }
                    }
                    if (minute == 63) {
                        minute = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Minute");
                        }
                    }
                    if (hour == 31) {
                        hour = 0;
                        if (MbusToolkit.isTraceOn()) {
                            MbusLogInputOutput.log.trace("Every Hour");
                        }
                    }
                    BMonth month4 = currentTime.getMonth().previous();
                    BAbsTime date4 = BAbsTime.make((int)currentTime.getYear(), (BMonth)month4, (int)currentTime.getDay(), (int)hour, (int)minute, (int)second, (int)0);
                    valueHold = new BStatusNumeric((double)date4.getMillis(), BStatus.ok);
                    break;
                }
                case 22: {
                    valueHold = new BStatusString("Daylight Saving Not Supported.", BStatus.fault);
                    break;
                }
                case 23: {
                    valueHold = new BStatusString("Window Management Not Supported.", BStatus.fault);
                }
            }
        } else {
            switch (inputCode) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 14: 
                case 18: 
                case 19: 
                case 20: 
                case 21: {
                    valueHold = new BStatusNumeric(0.0, BStatus.ok);
                    break;
                }
                case 16: {
                    valueHold = new BStatusString("", BStatus.ok);
                    break;
                }
                case 13: {
                    int lvar = inputArray[index] & 0xFF;
                    if (lvar == 248) {
                        valueHold = new BStatusNumeric(0.0, BStatus.ok);
                        break;
                    }
                    valueHold = new BStatusString("", BStatus.ok);
                    break;
                }
                case 15: {
                    valueHold = new BStatusString("Special Functions Not Supported.", BStatus.fault);
                    break;
                }
                case 17: {
                    valueHold = new BStatusString("CP16 Units & Info Not Supported.", BStatus.fault);
                    break;
                }
                case 22: {
                    valueHold = new BStatusString("Daylight Saving Not Supported.", BStatus.fault);
                    break;
                }
                case 23: {
                    valueHold = new BStatusString("Window Management Not Supported.", BStatus.fault);
                }
            }
        }
        int newIndex = index + increment;
        ValueData outputData = new ValueData(newIndex, (BStatusValue)valueHold);
        return outputData;
    }

    private static void traceRawData(int length, String dataTypeName, int[] inputArray, int currentIdx) {
        MbusToolkit.trace(dataTypeName);
        StringBuilder sb = new StringBuilder();
        sb.append("0x");
        for (int p = 0; p < length; ++p) {
            sb.append(TextUtil.byteToHexString((int)inputArray[currentIdx + p]));
        }
        MbusToolkit.trace("[" + sb + "]");
    }

    public static byte[] encode(BStatusValue inputValue, BMbusCommandCodes outputType) {
        int code = outputType.getOrdinal();
        byte[] output = null;
        long longHold = 0L;
        boolean negativeValue = false;
        switch (code) {
            case 0: {
                break;
            }
            case 1: 
            case 16: {
                output = new byte[]{(byte)((BStatusNumeric)inputValue).getValue()};
                break;
            }
            case 2: 
            case 18: {
                output = new byte[2];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                output[0] = (byte)(longHold & 0xFFL);
                output[1] = (byte)(longHold >> 8 & 0xFFL);
                break;
            }
            case 3: 
            case 19: {
                output = new byte[3];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                output[0] = (byte)(longHold & 0xFFL);
                output[1] = (byte)(longHold >> 8 & 0xFFL);
                output[2] = (byte)(longHold >> 16 & 0xFFL);
                break;
            }
            case 4: 
            case 20: {
                output = new byte[4];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                output[0] = (byte)(longHold & 0xFFL);
                output[1] = (byte)(longHold >> 8 & 0xFFL);
                output[2] = (byte)(longHold >> 16 & 0xFFL);
                output[3] = (byte)(longHold >> 24 & 0xFFL);
                break;
            }
            case 6: 
            case 23: {
                output = new byte[6];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                output[0] = (byte)(longHold & 0xFFL);
                output[1] = (byte)(longHold >> 8 & 0xFFL);
                output[2] = (byte)(longHold >> 16 & 0xFFL);
                output[3] = (byte)(longHold >> 24 & 0xFFL);
                output[4] = (byte)(longHold >> 32 & 0xFFL);
                output[5] = (byte)(longHold >> 40 & 0xFFL);
                break;
            }
            case 7: 
            case 24: {
                output = new byte[8];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                output[0] = (byte)(longHold & 0xFFL);
                output[1] = (byte)(longHold >> 8 & 0xFFL);
                output[2] = (byte)(longHold >> 16 & 0xFFL);
                output[3] = (byte)(longHold >> 24 & 0xFFL);
                output[4] = (byte)(longHold >> 32 & 0xFFL);
                output[5] = (byte)(longHold >> 40 & 0xFFL);
                output[6] = (byte)(longHold >> 48 & 0xFFL);
                output[7] = (byte)(longHold >> 56 & 0xFFL);
                break;
            }
            case 5: 
            case 21: {
                int inthold = Float.floatToIntBits((float)((BStatusNumeric)inputValue).getValue());
                output = new byte[]{(byte)(inthold & 0xFF), (byte)(inthold >> 8 & 0xFF), (byte)(inthold >> 16 & 0xFF), (byte)(inthold >> 24 & 0xFF)};
                break;
            }
            case 22: {
                longHold = Double.doubleToLongBits(((BStatusNumeric)inputValue).getValue());
                output = new byte[]{(byte)(longHold & 0xFFL), (byte)(longHold >> 8 & 0xFFL), (byte)(longHold >> 16 & 0xFFL), (byte)(longHold >> 24 & 0xFFL), (byte)(longHold >> 32 & 0xFFL), (byte)(longHold >> 40 & 0xFFL), (byte)(longHold >> 48 & 0xFFL), (byte)(longHold >> 56 & 0xFFL)};
                break;
            }
            case 9: 
            case 25: {
                output = new byte[1];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                if (longHold < 0L) {
                    negativeValue = true;
                    longHold = -longHold;
                }
                output[0] = (byte)(longHold & 0xFL | longHold / 10L << 4);
                if (!negativeValue) break;
                output[0] = (byte)(output[0] | 0xF);
                break;
            }
            case 10: 
            case 26: {
                output = new byte[2];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                if (longHold < 0L) {
                    negativeValue = true;
                    longHold = -longHold;
                }
                output[0] = (byte)(longHold & 0xFL | longHold / 10L << 4);
                output[1] = (byte)(longHold / 100L & 0xFL | longHold / 1000L << 4);
                if (!negativeValue) break;
                output[1] = (byte)(output[1] | 0xFFFFFFF0);
                break;
            }
            case 11: 
            case 27: {
                output = new byte[3];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                if (longHold < 0L) {
                    negativeValue = true;
                    longHold = -longHold;
                }
                output[0] = (byte)(longHold & 0xFL | longHold / 10L << 4);
                output[1] = (byte)(longHold / 100L & 0xFL | longHold / 1000L << 4);
                output[2] = (byte)(longHold / 10000L & 0xFL | longHold / 100000L << 4);
                if (!negativeValue) break;
                output[2] = (byte)(output[2] | 0xFFFFFFF0);
                break;
            }
            case 12: 
            case 28: {
                output = new byte[4];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                if (longHold < 0L) {
                    negativeValue = true;
                    longHold = -longHold;
                }
                output[0] = (byte)(longHold & 0xFL | longHold / 10L << 4);
                output[1] = (byte)(longHold / 100L & 0xFL | longHold / 1000L << 4);
                output[2] = (byte)(longHold / 10000L & 0xFL | longHold / 100000L << 4);
                output[3] = (byte)(longHold / 1000000L & 0xFL | longHold / 10000000L << 4);
                if (!negativeValue) break;
                output[3] = (byte)(output[3] | 0xFFFFFFF0);
                break;
            }
            case 14: 
            case 30: {
                output = new byte[6];
                longHold = (long)((BStatusNumeric)inputValue).getValue();
                if (longHold < 0L) {
                    negativeValue = true;
                    longHold = -longHold;
                }
                output[0] = (byte)(longHold & 0xFL | longHold / 10L << 4);
                output[1] = (byte)(longHold / 100L & 0xFL | longHold / 1000L << 4);
                output[2] = (byte)(longHold / 10000L & 0xFL | longHold / 100000L << 4);
                output[3] = (byte)(longHold / 1000000L & 0xFL | longHold / 10000000L << 4);
                output[4] = (byte)(longHold / 100000000L & 0xFL | longHold / 1000000000L << 4);
                output[5] = (byte)(longHold / 10000000000L & 0xFL | longHold / 100000000000L << 4);
                if (!negativeValue) break;
                output[5] = (byte)(output[5] | 0xFFFFFFF0);
                break;
            }
            case 32: {
                String stringHold = ((BStatusString)inputValue).getValue();
                output = new byte[stringHold.length()];
                for (int i = 0; i < output.length; ++i) {
                    output[i] = (byte)stringHold.charAt(i);
                }
                break;
            }
            case 33: 
            case 34: {
                BAbsTime timeHold = BAbsTime.make((long)((long)((BStatusNumeric)inputValue).getValue()));
                output = new byte[2];
                int yearHold = timeHold.getYear() - 1900;
                int hundredYears = yearHold / 100;
                int day = timeHold.getDay();
                int month = timeHold.getMonth().getOrdinal() + 1;
                output[0] = (byte)(day & 0x1F | ((yearHold -= hundredYears * 100) & 7) << 5);
                output[1] = (byte)(month & 0xF | (yearHold & 0x78) << 1);
                break;
            }
            case 36: {
                BAbsTime timeHold2 = BAbsTime.make((long)((long)((BStatusNumeric)inputValue).getValue()));
                output = new byte[3];
                int seconds = timeHold2.getSecond();
                int minutes = timeHold2.getMinute();
                int hours = timeHold2.getHour();
                output[0] = (byte)(seconds & 0x3F);
                output[1] = (byte)(minutes & 0x3F);
                output[2] = (byte)(hours & 0x1F);
                break;
            }
            case 35: {
                BAbsTime timeHold1 = BAbsTime.make((long)((long)((BStatusNumeric)inputValue).getValue()));
                output = new byte[4];
                int minute = timeHold1.getMinute();
                int hour = timeHold1.getHour();
                int day1 = timeHold1.getDay();
                int month1 = timeHold1.getMonth().getOrdinal() + 1;
                int yearHold = timeHold1.getYear() - 1900;
                int hundredYears = yearHold / 100;
                output[0] = (byte)(minute & 0x3F);
                output[1] = (byte)(hour & 0x1F | (hundredYears & 3) << 5);
                output[2] = (byte)(day1 & 0x1F | ((yearHold -= hundredYears * 100) & 7) << 5);
                output[3] = (byte)(month1 & 0xF | (yearHold & 0x78) << 1);
            }
        }
        return output;
    }

    private static void mode2Swap(int[] inputArray, int index, int increment) {
        int[] workingHold = new int[increment];
        for (int j = 0; j < increment; ++j) {
            workingHold[j] = inputArray[index + j];
        }
        for (int k = 0; k < increment; ++k) {
            inputArray[index + k] = workingHold[increment - k - 1];
        }
    }

    public static class ValueData {
        private int newIndex = 0;
        private BStatusValue value = null;

        public int getIndex() {
            return this.newIndex;
        }

        public BStatusValue getValue() {
            return this.value;
        }

        public ValueData(int inputIndex, BStatusValue inputValue) {
            this.newIndex = inputIndex;
            this.value = inputValue;
        }
    }
}

