/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.messages;

import com.tridium.basicdriver.message.ReceivedMessage;
import javax.baja.nre.util.ByteArrayUtil;

public final class MbusReceivedMessage
extends ReceivedMessage {
    private boolean collisionFlag = false;
    private byte[] data = null;

    public MbusReceivedMessage() {
        this.setSuccessfulResponse(false);
    }

    public MbusReceivedMessage(byte[] data) {
        this.data = data;
    }

    public byte[] getBytes() {
        return this.data;
    }

    public void setBytes(byte[] data) {
        this.data = data;
    }

    public int getLength() {
        return this.data.length;
    }

    public int getPrimaryAddress() {
        if (this.data.length == 5) {
            return this.data[2] & 0xFF;
        }
        if (this.data.length > 5) {
            return this.data[5] & 0xFF;
        }
        return 0;
    }

    public String toDebugString() {
        return ByteArrayUtil.toHexString((byte[])this.data, (int)0, (int)this.data.length);
    }

    public int getChecksum() {
        return this.data[this.data.length - 2] & 0xFF;
    }

    public void setCollisionFlag(boolean newCollisionFlag) {
        this.collisionFlag = newCollisionFlag;
    }

    public boolean getCollisionFlag() {
        return this.collisionFlag;
    }
}

