/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.jobs;

import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusDevice;
import com.tridium.mbus.comm.MBusTxTimings;
import com.tridium.mbus.enums.BMbusAddressing;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.jobs.BMbusAssignBaudRateData;
import com.tridium.mbus.messages.MbusControlFrameMessage;
import com.tridium.mbus.messages.MbusResponseMessage;
import com.tridium.mbus.messages.MbusSndUdMessage;
import com.tridium.mbus.utils.MbusToolkit;
import java.io.IOException;
import javax.baja.job.BJobState;
import javax.baja.job.BSimpleJob;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.annotations.Generated;
import javax.baja.nre.annotations.NiagaraType;
import javax.baja.serial.BBaudRate;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

@NiagaraType
public final class BMbusAssignBaudRateJob
extends BSimpleJob {
    @Generated
    public static final Type TYPE = Sys.loadType(BMbusAssignBaudRateJob.class);
    private BAbstractMbusNetwork network = null;
    private BMbusDevice[] devices = null;
    private BMbusBaudRate demanded = BMbusBaudRate.baud300;

    @Generated
    public Type getType() {
        return TYPE;
    }

    public BMbusAssignBaudRateJob() {
    }

    public BMbusAssignBaudRateJob(BAbstractMbusNetwork network, BMbusAssignBaudRateData data) {
        this.network = network;
        this.demanded = data.getDemanded();
        try {
            BatchResolve batch = new BatchResolve(data.getDeviceOrds().toArray());
            batch.resolve((BObject)network);
            BComponent[] targets = batch.getTargetComponents();
            this.devices = new BMbusDevice[targets.length];
            for (int i = 0; i < targets.length; ++i) {
                this.devices[i] = (BMbusDevice)targets[i];
            }
        }
        catch (Exception e) {
            MbusToolkit.error("Error resolving device ords for job", e);
        }
    }

    public void run(Context cx) throws Exception {
        String commLock = "assignBaudRate" + this.getHandle();
        try {
            this.commProtectedRun(commLock, cx);
            this.network.unlockSends(commLock);
        }
        catch (Exception e) {
            this.network.unlockSends(commLock);
            throw e;
        }
        catch (Throwable t) {
            this.network.unlockSends(commLock);
            throw new Exception(t.getMessage());
        }
    }

    public void commProtectedRun(Object commLock, Context cx) throws Exception {
        double progressBase = 5.0;
        double progressInc = 95.0;
        if (this.devices.length > 1) {
            progressInc = 95.0 / (double)this.devices.length;
        }
        IOException except = null;
        boolean failures = false;
        for (int i = 0; i < this.devices.length; ++i) {
            if (this.getJobState().equals((Object)BJobState.canceling)) {
                return;
            }
            this.log().message(MbusToolkit.lex.getText("MbusAssignBaudRateJob.assigningToDevice", new Object[]{this.demanded.getDisplayTag(cx), this.devices[i].getDisplayName(null)}));
            try {
                long minRxTxTimes;
                this.progress((int)progressBase);
                MbusControlFrameMessage message = new MbusControlFrameMessage();
                message.setMessageBaudRate(this.devices[i].getBaudRate());
                message.setCiField(this.demanded.getMbusCommsBaudRate());
                message.setCFieldNoFcb(67);
                message.setAField(this.devices[i].getPrimaryAddress());
                if (this.devices[i].getAddressMode() != BMbusAddressing.primary) {
                    MbusSndUdMessage message2 = new MbusSndUdMessage(this.devices[i], this.network);
                    message2.setMessageBaudRate(this.devices[i].getBaudRate());
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.devices[i].getBaudRate());
                    MbusResponseMessage selectionRsp = (MbusResponseMessage)this.network.sendMBusSync(this.devices[i].getTxTimingsReference(), commLock, message2, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message2, (BBaudRate)this.devices[i].getBaudRate()));
                    if (selectionRsp != null && selectionRsp.getCollisionDetected()) {
                        this.log().failed(MbusToolkit.getText("BMbusGeneral.busSelectionFailure"));
                        throw new Exception("Bus collision detected on secondary address selection");
                    }
                    this.devices[i].setFcBitState(true);
                    message.setAField(253);
                } else {
                    message.setAField(this.devices[i].getPrimaryAddress());
                }
                message.setFcBitInUse(this.devices[i].getFcBitInUse());
                message.setFcBitState(this.devices[i].getFcBitState());
                this.devices[i].setFcBitState(!this.devices[i].getFcBitState());
                BMbusBaudRate holdCurrentBaudRate = this.devices[i].getBaudRate();
                minRxTxTimes = MBusTxTimings.calculateTxRxTime(2L, (BBaudRate)this.devices[i].getBaudRate());
                MbusResponseMessage rsp = (MbusResponseMessage)this.network.sendMBusSync(this.devices[i].getTxTimingsReference(), commLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.devices[i].getBaudRate()));
                this.progress((int)(progressBase += 0.5 * progressInc));
                if (rsp != null && rsp.getSuccessfulResponse()) {
                    message.setMessageBaudRate(this.demanded);
                    minRxTxTimes = MBusTxTimings.calculateTxRxTime(261L, (BBaudRate)this.demanded);
                    rsp = (MbusResponseMessage)this.network.sendMBusSync(this.devices[i].getTxTimingsReference(), commLock, message, minRxTxTimes += MBusTxTimings.calculateTxRxTime(message, (BBaudRate)this.demanded));
                    this.progress((int)(progressBase += 0.5 * progressInc));
                    if (rsp == null || !rsp.getSuccessfulResponse()) {
                        this.log().failed(MbusToolkit.getText("MbusAssignBaudRateJob.failed"));
                        failures = true;
                        throw new IOException(MbusToolkit.getText("MbusAssignBaudRateJob.failed"));
                    }
                } else {
                    this.progress((int)(progressBase += 0.5 * progressInc));
                    this.devices[i].setBaudRate(holdCurrentBaudRate);
                    failures = true;
                    this.log().failed(MbusToolkit.getText("MbusAssignBaudRateJob.failedBackToOriginalValue"));
                    throw new IOException(MbusToolkit.getText("MbusAssignBaudRateJob.failedBackToOriginalValue"));
                }
                this.log().success(MbusToolkit.getText("MbusAssignBaudRateJob.success"));
                this.devices[i].setBaudRate(this.demanded);
                continue;
            }
            catch (IOException e) {
                except = e;
            }
        }
        if (except != null) {
            throw except;
        }
        this.setJobState(failures ? BJobState.failed : BJobState.success);
    }

    public void success() {
        if (this.getJobState() == BJobState.success) {
            this.log().success("Job Success");
            this.complete(BJobState.success);
        } else if (this.getJobState() == BJobState.canceling) {
            this.canceled();
        } else {
            this.complete(BJobState.failed);
        }
    }
}

