/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.comm.CommTransmitter;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.BMbusTcpIpNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusCommUtil;
import java.net.Socket;
import java.net.SocketException;
import javax.baja.net.BInternetAddress;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public class MbusSocketComm
extends Comm
implements IMbusComm {
    private final Object socketRestartLock = new Object();
    private long ticksOfLastSocketRestart = Long.MIN_VALUE;
    private Socket socket = null;
    private Thread rxThread = null;
    private ISocketAddressHolder socketAddressHolder = null;
    private long lastSentMessageTicks = 0L;
    private long lastReceiveMessageTicks = 0L;

    public MbusSocketComm(BBasicNetwork network, CommReceiver commReceiver, CommTransmitter commTransmitter, ISocketAddressHolder socketAddressHolder) {
        super(network, commReceiver, commTransmitter);
        this.socketAddressHolder = socketAddressHolder;
    }

    protected boolean started() throws Exception {
        try {
            this.reopenSocket();
            if (this.rxThread != null) {
                this.rxThread.interrupt();
            }
            this.rxThread = new Thread((Runnable)this.getCommReceiver(), "MbusTcpIpSocketRcv:" + this.getNetwork().getName());
            this.getCommReceiver().setAlive(true);
            this.rxThread.start();
            this.rxThread.setPriority(5);
        }
        catch (Exception e) {
            String errMsg = "Error opening and configuring the socket";
            this.getNetwork().getLog().error(errMsg, (Throwable)e);
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception x) {
                    this.getNetwork().getLog().error("Unable to close socket", (Throwable)x);
                }
            }
            throw e;
        }
        return true;
    }

    protected void stopped() throws Exception {
        this.getCommReceiver().setAlive(false);
        if (this.getCommReceiver() != null && this.rxThread != null) {
            this.rxThread.interrupt();
        }
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (Exception e) {
                this.getNetwork().getLog().error("Unable to close socket", (Throwable)e);
            }
            finally {
                this.socket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reopenSocket() throws BasicException {
        Object object = this.socketRestartLock;
        synchronized (object) {
            this.ticksOfLastSocketRestart = Clock.ticks();
            try {
                BInternetAddress addr = this.socketAddressHolder.getInternetAddress();
                BAbstractMbusNetwork network = (BAbstractMbusNetwork)this.getNetwork();
                if (network instanceof BMbusTcpIpNetwork && this.attemptDeviceIcmpPingAllowed()) {
                    if (((BMbusTcpIpNetwork)network).getPingPreConnect() && !MbusSocketComm.icmpPing(addr.getHost())) {
                        throw new BasicException("Could not ping TCP/IP gateway @ " + addr.getHost());
                    }
                    if (this.getNetwork().getFaultCause().startsWith("Could not ping TCP/IP gateway")) {
                        this.getNetwork().setFaultCause("");
                    }
                }
                if (this.socket != null) {
                    this.socket.close();
                }
                this.socket = new Socket(addr.getAddress(), addr.getPort());
                this.socket.setKeepAlive(true);
                this.getCommReceiver().setInputStream(this.socket.getInputStream());
                this.getCommTransmitter().setOutputStream(this.socket.getOutputStream());
                this.getNetwork().pingOk();
            }
            catch (Exception e) {
                this.getNetwork().pingFail("Error reopening/reconfiguring the socket " + e.getMessage());
                this.getNetwork().getLog().error("Error reopening/reconfiguring the socket", (Throwable)e);
                if (this.socket != null) {
                    try {
                        this.socket.close();
                    }
                    catch (Exception e2) {
                        this.getNetwork().getLog().error("Unable to close socket after reopen", (Throwable)e2);
                    }
                }
                this.getNetwork().pingFail("Could not establish TCP/IP communications");
                throw new BasicException(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void onReceiveError(Exception e) {
        this.reopenSocket();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message transmit(Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        try {
            return MbusCommUtil.transmit(this, msg, responseTimeout, retryCount);
        }
        catch (Exception e) {
            this.getNetwork().getLog().error("Error occurred during transmit", (Throwable)e);
            if (e.getCause() instanceof SocketException) {
                Object object = this.socketRestartLock;
                synchronized (object) {
                    if (Clock.ticks() - 1000L > this.ticksOfLastSocketRestart) {
                        try {
                            if (this.socket != null) {
                                this.socket.close();
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            if (e instanceof BasicException) {
                throw (BasicException)((Object)e);
            }
            return null;
        }
    }

    public void receive(ReceivedMessage msg) {
        this.lastReceiveMessageTicks = Clock.ticks();
        super.receive(msg);
    }

    @Override
    public long getLastMessageTicks() {
        return Math.max(this.lastReceiveMessageTicks, this.lastSentMessageTicks);
    }

    @Override
    public void messageSent() {
        this.lastSentMessageTicks = Clock.ticks();
    }

    @Override
    public void performNetworkInterMessageDelay() {
        MbusCommUtil.performNetworkInterMessageDelay(this);
    }

    @Override
    public Message processNetworkTransmit(Message msg, BRelTime responseTimeout) throws BasicException {
        return this.processTransmit(msg, responseTimeout);
    }

    public boolean attemptDeviceIcmpPingAllowed() {
        return false;
    }

    public boolean icmpPing() {
        BInternetAddress addr = this.socketAddressHolder.getInternetAddress();
        return MbusSocketComm.icmpPing(addr.getHost());
    }

    private static boolean icmpPing(String userIpText) {
        return true;
    }

    public static interface ISocketAddressHolder {
        public BInternetAddress getInternetAddress();
    }
}

