/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.mbus.comm;

import com.tridium.basicdriver.comm.Comm;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.serial.BSerialNetwork;
import com.tridium.basicdriver.util.BasicException;
import com.tridium.mbus.BAbstractMbusNetwork;
import com.tridium.mbus.comm.IMbusComm;
import com.tridium.mbus.comm.MbusSocketComm;
import com.tridium.mbus.enums.BMbusBaudRate;
import com.tridium.mbus.messages.MbusMessage;
import javax.baja.serial.BBaudRate;
import javax.baja.serial.BSerialHelper;
import javax.baja.sys.BRelTime;
import javax.baja.sys.Clock;

public final class MbusCommUtil {
    public static final long MIN_SLEEP_TIME = 20L;

    private MbusCommUtil() {
    }

    public static Message transmit(Comm comm, Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        if (msg == null) {
            return null;
        }
        if (msg instanceof MbusMessage && !(comm instanceof MbusSocketComm)) {
            MbusMessage internalMessage = (MbusMessage)msg;
            if (comm.isCommStarted()) {
                BSerialHelper portConfig = ((BSerialNetwork)comm.getNetwork()).getSerialPortConfig();
                BMbusBaudRate currentBaudRate = (BMbusBaudRate)portConfig.getBaudRate();
                BMbusBaudRate messageBaudRate = internalMessage.getMessageBaudRate();
                if (!messageBaudRate.equals((Object)currentBaudRate)) {
                    portConfig.setBaudRate((BBaudRate)messageBaudRate);
                }
            }
        }
        ((IMbusComm)comm).performNetworkInterMessageDelay();
        Message recMsg = MbusCommUtil.performTransmit(comm, msg, responseTimeout, retryCount);
        return recMsg;
    }

    public static void performNetworkInterMessageDelay(Comm comm) {
        MbusCommUtil.performNetworkInterMessageDelay(comm, 20L);
    }

    public static void performNetworkInterMessageDelay(Comm comm, long minSleepTime) {
        block4: {
            long minDelay = ((BAbstractMbusNetwork)comm.getNetwork()).getActiveTxTimings().intermessageDelay;
            long lastMsgTicks = ((IMbusComm)comm).getLastMessageTicks();
            if (lastMsgTicks <= 0L) {
                return;
            }
            long difference = Clock.ticks() - lastMsgTicks;
            long sleepTime = Math.max(minSleepTime - difference, minDelay - difference);
            if (sleepTime > 0L) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (Exception e) {
                    if (!comm.getNetwork().getLog().isTraceOn()) break block4;
                    comm.getNetwork().getLog().trace("Comm performNetworkInterMessageDelay exception", (Throwable)e);
                }
            }
        }
    }

    private static Message performTransmit(Comm comm, Message msg, BRelTime responseTimeout, int retryCount) throws BasicException {
        if (!msg.getResponseExpected()) {
            comm.transmitNoResponse(msg);
            return null;
        }
        BasicException e = null;
        Message respMsg = null;
        try {
            for (int i = 0; !(i >= retryCount + 1 || (respMsg = ((IMbusComm)comm).processNetworkTransmit(msg, responseTimeout)) != null && respMsg.getSuccessfulResponse()); ++i) {
            }
            if (respMsg != null && !respMsg.getSuccessfulResponse()) {
                String failMsg = "Unsuccessful response for request message sent.";
                e = new BasicException(failMsg);
            }
        }
        catch (BasicException se) {
            e = se;
        }
        if (e != null) {
            if (e instanceof BasicException) {
                if (comm.getNetwork().getLog().isTraceOn()) {
                    comm.getNetwork().getLog().trace("Comm sendRequest exception", (Throwable)e);
                }
            } else {
                throw e;
            }
        }
        return respMsg;
    }
}

