/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui.action;

import com.lynxspring.lcd.BSerialLcdNetwork;
import javax.baja.gx.BImage;
import javax.baja.gx.BTransform;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;

public class BUploadSlashImage
extends BAction {
    public static final Type TYPE = Sys.loadType(BUploadSlashImage.class);

    public Type getType() {
        return TYPE;
    }

    public BValue getParameterDefault() {
        return BImage.NULL;
    }

    public Type getParameterType() {
        return BImage.TYPE;
    }

    public Type getReturnType() {
        return null;
    }

    public BValue invoke(BComponent target, BValue arg) throws Exception {
        if (arg == null || arg.isNull() || !(arg instanceof BImage) || !(target instanceof BSerialLcdNetwork)) {
            return null;
        }
        BImage img = (BImage)arg;
        img.sync();
        int width = (int)img.getWidth();
        int height = (int)img.getHeight();
        int[] pixels = img.getPixels();
        if (width > 128 || height > 64) {
            double scale = 1.0;
            if (width > 128) {
                scale = 128.0 / (double)width;
            }
            if ((double)height * scale > 64.0) {
                scale = 64.0 / (double)height;
            }
            img = img.transform(BTransform.makeScale((double)scale, (double)scale));
            width = (int)img.getWidth();
            height = (int)img.getHeight();
            pixels = img.getPixels();
        }
        int yOffset = 32 - height / 2;
        int xOffset = 64 - width / 2;
        int[][][] ordered = new int[8][128][8];
        for (int y = 0; y < 64; ++y) {
            for (int x = 0; x < 128; ++x) {
                int pixel = y < yOffset || y >= 64 - yOffset || x < xOffset || x >= 128 - xOffset ? 0 : pixels[(y - yOffset) * width + (x - xOffset)];
                ordered[y / 8][x][y % 8] = pixel;
            }
        }
        String[] rows = new String[8];
        int[] cols = new int[8];
        for (int row = 0; row < ordered.length; ++row) {
            rows[row] = "";
            cols[row] = -1;
            for (int col = 0; col < ordered[row].length; ++col) {
                int bit = 0;
                for (int pixel = 0; pixel < ordered[row][col].length; ++pixel) {
                    if (ordered[row][col][pixel] >= -8947848) continue;
                    bit = (int)((double)bit + Math.pow(2.0, pixel));
                }
                String hex = "";
                if (bit > 0) {
                    hex = Integer.toHexString(bit);
                }
                while (hex.length() < 2) {
                    hex = "0" + hex;
                }
                if (!hex.equals("00") || rows[row].length() != 0) {
                    int n = row;
                    rows[n] = rows[n] + hex;
                }
                if (rows[row].length() == 0 || cols[row] != -1) continue;
                cols[row] = col;
            }
        }
        BSerialLcdNetwork net = (BSerialLcdNetwork)target;
        net.setLogoRowValues(rows[0] + "," + rows[1] + "," + rows[2] + "," + rows[3] + "," + rows[4] + "," + rows[5] + "," + rows[6] + "," + rows[7]);
        net.setLogoColumnValues(cols[0] + "," + cols[1] + "," + cols[2] + "," + cols[3] + "," + cols[4] + "," + cols[5] + "," + cols[6] + "," + cols[7]);
        net.rebuildSplashPage();
        return null;
    }
}

