/*
 * Decompiled with CFR 0.152.
 */
package com.lynxspring.lcd.ui;

import com.lynxspring.lcd.BSerialLcdNetwork;
import com.lynxspring.lcd.command.SerialLcdClearCommand;
import com.lynxspring.lcd.command.SerialLcdCommand;
import com.lynxspring.lcd.command.SerialLcdLineCommand;
import com.lynxspring.lcd.command.SerialLcdPrintCommand;
import com.lynxspring.lcd.ui.SerialLcdPage;
import com.tridium.platform.BSystemPlatformService;
import com.tridium.util.ArrayUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.timezone.TimeZoneDatabase;

public class SerialLcdSettingsTimezonePage
extends SerialLcdPage {
    int intNumTimeZones = 0;
    int intDisplayedTimeZoneIndex = 0;
    BTimeZone[] arrTimeZones;
    String strTimeZoneToDisplay = "";
    String strUTC_Offset = "";

    public SerialLcdSettingsTimezonePage(BSerialLcdNetwork network) {
        this.network = network;
    }

    @Override
    public void displayPage() {
        this.getNetwork().setStallOutput(false);
        if (this.arrTimeZones == null) {
            this.loadTimeZones();
            for (int t = 0; t < this.arrTimeZones.length; ++t) {
                if (!this.arrTimeZones[t].equals((Object)BTimeZone.getLocal())) continue;
                this.intDisplayedTimeZoneIndex = t;
            }
        }
        try {
            Object[] commands = new SerialLcdCommand[]{};
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[8], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[1], 0, 2, 1, 1, BSerialLcdNetwork.lex.getText("sys.zone.title")));
            commands = (SerialLcdCommand[])ArrayUtil.add((Object[])commands, (Object[])this.getSoftButtons());
            this.writeTimeZoneText((SerialLcdCommand[])commands);
        }
        catch (Exception e) {
            System.err.println("Error Displaying Page - " + e.toString());
            e.printStackTrace();
        }
    }

    @Override
    public void button1Pressed(int presses) {
        if (!this.getNetwork().getHideMainMenu()) {
            this.getNetwork().displayMenuPage();
        }
    }

    @Override
    public void button2Pressed(int presses) {
        this.getNetwork().openDialog(11, BSerialLcdNetwork.lex.getText("reboot"));
    }

    @Override
    public void button4Pressed(int presses) {
        this.getNetwork().displaySettingsPage();
    }

    @Override
    public void buttonDownPressed(int presses) {
        ++this.intDisplayedTimeZoneIndex;
        if (this.intDisplayedTimeZoneIndex > this.arrTimeZones.length - 1) {
            this.intDisplayedTimeZoneIndex = 0;
        }
        this.writeTimeZoneText(new SerialLcdCommand[0]);
    }

    @Override
    public void buttonUpPressed(int presses) {
        --this.intDisplayedTimeZoneIndex;
        if (this.intDisplayedTimeZoneIndex == 0) {
            this.intDisplayedTimeZoneIndex = this.arrTimeZones.length - 1;
        }
        this.writeTimeZoneText(new SerialLcdCommand[0]);
    }

    private void writeTimeZoneText(SerialLcdCommand[] commands) {
        try {
            this.strTimeZoneToDisplay = this.arrTimeZones[this.intDisplayedTimeZoneIndex].getId();
            if (this.strTimeZoneToDisplay.length() > 25) {
                this.strTimeZoneToDisplay = this.strTimeZoneToDisplay.substring(0, 25);
            }
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdClearCommand(ROW[3] + ROW[4], 0, 127));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[3], 0, 2, 2, 1, this.strTimeZoneToDisplay));
            commands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])commands, (Object)new SerialLcdPrintCommand(ROW[4], 0, 2, 2, 1, this.getUTCOffsetPhrase(this.intDisplayedTimeZoneIndex)));
            this.getNetwork().sendCommands(commands);
        }
        catch (Exception e) {
            System.err.println("Error getting previous timezone item - " + e.toString());
            e.printStackTrace();
        }
    }

    private SerialLcdCommand[] getSoftButtons() throws Exception {
        Object[] tmpCommands = new SerialLcdCommand[]{};
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(0, 56, 26, 56, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 57, 26, 57, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 58, 26, 58, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 59, 26, 59, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 60, 26, 60, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 61, 26, 61, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 62, 26, 62, !this.getNetwork().getHideMainMenu()), new SerialLcdLineCommand(0, 63, 26, 63, !this.getNetwork().getHideMainMenu())});
        if (!this.getNetwork().getHideMainMenu()) {
            tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 3, 2, 2, 3, "menu"));
        }
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(34, 56, 60, 56, true), new SerialLcdLineCommand(34, 57, 60, 57, true), new SerialLcdLineCommand(34, 58, 60, 58, true), new SerialLcdLineCommand(34, 59, 60, 59, true), new SerialLcdLineCommand(34, 60, 60, 60, true), new SerialLcdLineCommand(34, 61, 60, 61, true), new SerialLcdLineCommand(34, 62, 60, 62, true), new SerialLcdLineCommand(34, 63, 60, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 37, 2, 2, 3, "save"));
        tmpCommands = (SerialLcdCommand[])ArrayUtil.add((Object[])tmpCommands, (Object[])new SerialLcdCommand[]{new SerialLcdLineCommand(102, 56, 127, 56, true), new SerialLcdLineCommand(102, 57, 127, 57, true), new SerialLcdLineCommand(102, 58, 127, 58, true), new SerialLcdLineCommand(102, 59, 127, 59, true), new SerialLcdLineCommand(102, 60, 127, 60, true), new SerialLcdLineCommand(102, 61, 127, 61, true), new SerialLcdLineCommand(102, 62, 127, 62, true), new SerialLcdLineCommand(102, 63, 127, 63, true)});
        tmpCommands = (SerialLcdCommand[])ArrayUtil.addOne((Object[])tmpCommands, (Object)new SerialLcdPrintCommand(ROW[7], 105, 2, 2, 3, "canc"));
        return tmpCommands;
    }

    private String getUTCOffsetPhrase(int intNewIndex) {
        int intSavingTimeAdjustment = this.arrTimeZones[intNewIndex].getDaylightAdjustment() == -1 ? 0 : this.arrTimeZones[intNewIndex].getDaylightAdjustment() / 3600000;
        int intCurrentTimeZoneUTC = this.arrTimeZones[intNewIndex].getUtcOffset() == 0 ? 0 : this.arrTimeZones[intNewIndex].getUtcOffset() / 3600000;
        this.strUTC_Offset = "(";
        if (intSavingTimeAdjustment == 0) {
            this.strUTC_Offset = this.strUTC_Offset + intCurrentTimeZoneUTC + ")";
        } else {
            int intDSTAdjustment = intCurrentTimeZoneUTC + intSavingTimeAdjustment;
            this.strUTC_Offset = this.strUTC_Offset + intDSTAdjustment + "/" + intCurrentTimeZoneUTC + ")";
        }
        return this.strUTC_Offset;
    }

    private void loadTimeZones() {
        this.arrTimeZones = TimeZoneDatabase.get().getTimeZones();
    }

    @Override
    public void popupClosed(int popupReturn) {
        if (popupReturn == 2) {
            BSystemPlatformService service = (BSystemPlatformService)Sys.getService((Type)BSystemPlatformService.TYPE);
            service.setTimeZone(this.arrTimeZones[this.intDisplayedTimeZoneIndex]);
            this.getNetwork().displayRebootPage();
            service.reboot();
        } else {
            this.displayPage();
        }
    }
}

